/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.qualitycontrol.cobol.provider;

import com.ibm.pdp.engine.ITextProcessor;
import com.ibm.pdp.engine.ITextSegment;
import com.ibm.pdp.engine.tree.IEditTree;
import com.ibm.pdp.qualitycontrol.cobol.provider.PDPCodeReviewProvider;
import com.ibm.pdp.qualitycontrol.collector.PdpCobolData;
import com.ibm.rsar.analysis.codereview.cobol.CodeReviewResource;
import com.ibm.rsar.analysis.codereview.cobol.CodeReviewResult;
import com.ibm.rsar.analysis.codereview.cobol.rules.NameCollector;
import com.ibm.rsaz.analysis.core.element.AbstractAnalysisElement;
import com.ibm.rsaz.analysis.core.history.AnalysisHistory;
import com.ibm.rsaz.analysis.core.reporting.tabulatedmodel.SingleFileTabulatedAnalysisResult;
import com.ibm.rsaz.analysis.core.rule.AbstractAnalysisRule;
import com.ibm.systemz.cobol.editor.core.parser.Ast.ASTNode;
import com.ibm.systemz.cobol.editor.core.parser.CobolParsersym;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.List;
import lpg.runtime.IAst;
import org.eclipse.core.resources.IResource;

public abstract class AbstractRppCobolRule
extends AbstractAnalysisRule {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2021.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected CodeReviewResource resource;
    protected String fileName = "";
    protected String historyId;
    protected int realLimit = 0;

    public void analyze(AnalysisHistory history) {
        CodeReviewResource rdzData;
        this.historyId = history.getHistoryId();
        this.resource = rdzData = (CodeReviewResource)this.getProvider().getProperty(this.historyId, "rpp.codereview.cobol.resource");
        this.fileName = (String)this.getProvider().getProperty(this.historyId, NameCollector.KEYS[0]);
        if (rdzData == null) {
            return;
        }
        ASTNode node = (ASTNode)rdzData.getCompilationUnit();
        if (node == null) {
            return;
        }
        List<IAst> results = this.performRule(node);
        if (results == null || results.isEmpty()) {
            return;
        }
        if (this.isResultFiltered()) {
            this.filterResults(results);
        }
        if (results.isEmpty()) {
            return;
        }
        rdzData.generateResultsForASTNodes((AbstractAnalysisRule)this, this.historyId, results);
    }

    protected void filterResults(List<IAst> results) {
        PdpCobolData pdpCobolData = ((PDPCodeReviewProvider)this.getProvider()).getPdpCobolData(this.historyId);
        if (pdpCobolData != null) {
            this.removePureGeneratedCodeViolation(results, pdpCobolData.getEditTree());
        }
    }

    protected boolean isResultFiltered() {
        return true;
    }

    protected List<IAst> removePureGeneratedCodeViolation(List<IAst> allResults, IEditTree editTree) {
        Iterator<IAst> violations = allResults.iterator();
        while (violations.hasNext()) {
            IAst node = violations.next();
            int beginIdx = node.getLeftIToken().getStartOffset();
            int endIdx = node.getRightIToken().getEndOffset();
            String fileName = node.getLeftIToken().getILexStream().getFileName();
            if (!fileName.equals(this.fileName) || !this.isPureGeneratedCode(beginIdx, endIdx, editTree)) continue;
            violations.remove();
        }
        return allResults;
    }

    protected boolean isPureGeneratedCode(int beginIdx, int endIdx, IEditTree editTree) {
        ITextProcessor processor = editTree.getTextProcessor();
        Iterator segments = processor.segments(beginIdx, endIdx);
        while (segments.hasNext()) {
            ITextSegment segment = (ITextSegment)segments.next();
            if (!segment.isModified() || segment.beginIndex() >= endIdx || segment.endIndex() <= beginIdx) continue;
            return false;
        }
        return true;
    }

    public abstract List<IAst> performRule(ASTNode var1);

    protected CodeReviewResource getResource() {
        return this.resource;
    }

    protected String getFileName() {
        return this.fileName;
    }

    protected String getHistoryId() {
        return this.historyId;
    }

    protected int getCobolParsersymTokenFieldName(String name) {
        try {
            Field field = CobolParsersym.class.getDeclaredField(name);
            return field.getInt(CobolParsersym.class);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    protected String getExtraLabel() {
        return "";
    }

    protected void getRealLimit() {
        String limit = this.getParameter("LINE_LIMIT").getValue();
        if (limit != null) {
            int lines;
            try {
                if (limit.contains(",") || limit.contains(".")) {
                    limit = this.parseLimit(limit);
                }
                lines = Integer.parseInt(limit);
            }
            catch (NumberFormatException numberFormatException) {
                lines = -1;
            }
            this.realLimit = lines;
        }
    }

    private String parseLimit(String limit) {
        String str = limit.replaceAll("[,.]", "");
        return str;
    }

    public class CodeReviewResultWithCustomLabel
    extends CodeReviewResult {
        private String _rppExtraLabel;
        private int _lineNumber;

        public CodeReviewResultWithCustomLabel(String label, String resName, int lineNumber, int selectionStartPos, int selectionLength, IResource resource, AbstractAnalysisRule rule, String historyId) {
            super(resName, lineNumber, selectionStartPos, selectionLength, resource, rule, historyId, true);
            if (label.indexOf(":") != -1) {
                this._rppExtraLabel = label.substring(label.indexOf(":") + 1);
                this._lineNumber = label.indexOf("vs") != -1 ? 0 : lineNumber;
            } else {
                this._rppExtraLabel = label;
                this._lineNumber = lineNumber;
            }
            this.setOwner((AbstractAnalysisElement)rule);
        }

        public int getLineNumber() {
            return this._lineNumber;
        }

        public String getLabel() {
            StringBuffer sb = new StringBuffer(this.getResource().getName());
            if (this.getLineNumber() == 0) {
                sb.append(' ').append(this.getLabelWithVariables()).append(' ').append(':').append(' ').append(this._rppExtraLabel);
            } else {
                sb.append(":").append(this.getLineNumber()).append(' ').append(this.getLabelWithVariables()).append(' ').append(':').append(' ').append(this._rppExtraLabel);
            }
            return sb.toString();
        }
    }

    public class PDPSingleFileTabulatedAnalysisResult
    extends SingleFileTabulatedAnalysisResult {
        private String extra;

        public PDPSingleFileTabulatedAnalysisResult(String file, int line, boolean visible, String extra) {
            super(file, line, visible);
            this.extra = extra;
        }

        public String getExtra() {
            return this.extra;
        }
    }
}

