/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.preferences;

import com.ibm.pdp.preferences.plugin.IPTPreferencesContributor;
import com.ibm.pdp.util.Util;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class PTPreferencesManager {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2018.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String _PREFS_CONTRIBUTOR_EXTENSION_POINT = "prefsContributor";
    private static PTPreferencesManager _instance = null;
    private List<IPTPreferencesContributor> _prefsContributors = new ArrayList<IPTPreferencesContributor>(1);

    private static PTPreferencesManager getInstance() {
        if (_instance == null) {
            _instance = new PTPreferencesManager();
            _instance.loadExtensionPoints(_PREFS_CONTRIBUTOR_EXTENSION_POINT);
        }
        return _instance;
    }

    public static IPTPreferencesContributor getPrefsContributor() {
        if (PTPreferencesManager.getInstance()._prefsContributors.size() > 0) {
            return PTPreferencesManager.getInstance()._prefsContributors.get(0);
        }
        return null;
    }

    private void loadExtensionPoints(String extensionPoint) {
        IExtensionRegistry extRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extPoint = extRegistry.getExtensionPoint("com.ibm.pdp.preferences", extensionPoint);
        if (extPoint != null) {
            IExtension[] extensions = extPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    IConfigurationElement configElement = configElements[j];
                    if (configElement.getName().equals(extensionPoint)) {
                        this.processConfigElement(configElement);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private void processConfigElement(IConfigurationElement element) {
        try {
            if (element.getName().equals(_PREFS_CONTRIBUTOR_EXTENSION_POINT)) {
                this._prefsContributors.add((IPTPreferencesContributor)element.createExecutableExtension("class"));
            }
        }
        catch (CoreException e) {
            throw Util.rethrow((Throwable)e);
        }
    }
}

