/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pdppath.stateid;

import com.ibm.pdp.pdppath.stateid.FileRemovedException;
import com.ibm.pdp.util.Util;
import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.core.resources.IFile;

public class StateIDUtil {
    public static final String EMPTY_STRING = "";
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp.2011, 2015.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosurerestricted by GSA ADP Schedule Contract with IBM Corp.";

    public static String computeStateIdOfFile(IFile file) {
        String str = StateIDUtil.readFileContentsWithIFile(file);
        return StateIDUtil.computeStateIdOfString(str);
    }

    public static String computeStateIdOfString(String contents) {
        Integer hashCode = new Integer(contents.trim().hashCode());
        return hashCode.toString();
    }

    public static String readFileContentsWithIFile(IFile file) {
        if (!file.exists()) {
            throw new FileRemovedException("File " + file.getFullPath().toString() + " has been removed.");
        }
        String content = EMPTY_STRING;
        try {
            InputStream is = file.getContents();
            BufferedReader dataInStream = new BufferedReader(new InputStreamReader(is, file.getCharset()));
            CharArrayWriter baos = new CharArrayWriter();
            char[] buffer = new char[100000];
            int read = -1;
            while ((read = dataInStream.read(buffer)) != -1) {
                baos.write(buffer, 0, read);
            }
            content = baos.toString();
            is.close();
            baos.flush();
            baos.close();
        }
        catch (Exception e) {
            Util.rethrow((Throwable)e);
        }
        return content;
    }
}

