/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pdppath.service;

import com.ibm.pdp.pdppath.nature.PDPPathNature;
import com.ibm.pdp.util.Util;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;

public class PdpPathService {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2015.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String DEFAULT_RPP_ROOT = "rpp";
    public static final String _DEFAULT_GEN = "gen";
    public static final String _DEFAULT_PDP = "pdp";
    public static final String EMPTY_STRING = "";

    public static IProject buildRppProject(String defaultRppRoot, String projectName) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject(projectName);
        try {
            IProjectDescription description;
            if (!project.exists()) {
                description = workspace.newProjectDescription(projectName);
                description.setNatureIds(new String[]{"com.ibm.pdp.pdppath.PDPPathNature"});
                project.create(description, null);
                project.open(null);
                PDPPathNature nature = (PDPPathNature)project.getNature("com.ibm.pdp.pdppath.PDPPathNature");
                String _defaultRppRoot = defaultRppRoot;
                if (_defaultRppRoot == null) {
                    _defaultRppRoot = DEFAULT_RPP_ROOT;
                }
                nature.savePdpPath(_defaultRppRoot, _defaultRppRoot, _defaultRppRoot);
            }
            if (!project.isOpen()) {
                project.open(null);
            }
            if (!project.hasNature("com.ibm.pdp.pdppath.PDPPathNature")) {
                description = project.getDescription();
                String[] oldNatures = description.getNatureIds();
                String[] newNatures = new String[oldNatures.length + 1];
                System.arraycopy(oldNatures, 0, newNatures, 0, oldNatures.length);
                newNatures[newNatures.length - 1] = "com.ibm.pdp.pdppath.PDPPathNature";
                description.setNatureIds(newNatures);
                project.setDescription(description, null);
                PDPPathNature nature = (PDPPathNature)project.getNature("com.ibm.pdp.pdppath.PDPPathNature");
                String _defaultRppRoot = defaultRppRoot;
                if (_defaultRppRoot == null) {
                    _defaultRppRoot = DEFAULT_RPP_ROOT;
                }
                nature.savePdpPath(_defaultRppRoot, _defaultRppRoot, _defaultRppRoot);
            }
        }
        catch (CoreException e) {
            throw Util.rethrow((Throwable)e);
        }
        return project;
    }

    public static String getRppRootFolder(String projectName) {
        if (projectName == null || projectName.length() == 0) {
            return null;
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(projectName);
        if (!project.exists()) {
            return null;
        }
        String rppRootFolder = DEFAULT_RPP_ROOT;
        PDPPathNature nature = PDPPathNature.getNature(projectName);
        if (nature != null) {
            rppRootFolder = nature.getRppRootPath();
            if (rppRootFolder == null) {
                rppRootFolder = EMPTY_STRING;
            }
        } else {
            return null;
        }
        return rppRootFolder;
    }

    public static String getGenRootFolder(String projectName) {
        if (projectName == null || projectName.length() == 0) {
            return null;
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(projectName);
        if (!project.exists()) {
            return null;
        }
        String genRootFolder = DEFAULT_RPP_ROOT;
        PDPPathNature nature = PDPPathNature.getNature(projectName);
        if (nature != null) {
            genRootFolder = nature.getGenRootPath();
            if (genRootFolder == null) {
                return EMPTY_STRING;
            }
        } else {
            return null;
        }
        return genRootFolder;
    }

    public static String getMetaPdpRootFolder(String projectName) {
        if (projectName == null || projectName.length() == 0) {
            return null;
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(projectName);
        if (!project.exists()) {
            return null;
        }
        String metaPdpRootFolder = DEFAULT_RPP_ROOT;
        PDPPathNature nature = PDPPathNature.getNature(projectName);
        if (nature != null) {
            metaPdpRootFolder = nature.getMetaRootPath();
            if (metaPdpRootFolder == null) {
                metaPdpRootFolder = EMPTY_STRING;
            }
        } else {
            return null;
        }
        return metaPdpRootFolder;
    }

    private static String scanProjectAndUpdateProjectNature(String projectName) throws CoreException {
        IResource resource;
        IResource[] resources;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(projectName);
        if (project == null || !project.exists()) {
            return null;
        }
        String rppFolder = null;
        IResource[] iResourceArray = resources = project.members();
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IFile file;
            String fileExtension;
            resource = iResourceArray[n2];
            if (resource instanceof IFile && "designpath".equals(fileExtension = (file = (IFile)resource).getFileExtension())) {
                rppFolder = EMPTY_STRING;
                break;
            }
            ++n2;
        }
        if (rppFolder == null) {
            iResourceArray = resources;
            n = resources.length;
            n2 = 0;
            while (n2 < n) {
                IFolder folder;
                resource = iResourceArray[n2];
                if (resource instanceof IFolder && PdpPathService.containsCobolPDPFile(folder = (IFolder)resource)) {
                    rppFolder = EMPTY_STRING;
                    break;
                }
                ++n2;
            }
        }
        if (rppFolder == null) {
            rppFolder = DEFAULT_RPP_ROOT;
        }
        PdpPathService.buildRppProject(rppFolder, projectName);
        return rppFolder;
    }

    private static boolean containsCobolPDPFile(IFolder folder) throws CoreException {
        IResource[] resources;
        IResource[] iResourceArray = resources = folder.members();
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IFile file;
            String fileExtension;
            IResource resource = iResourceArray[n2];
            if (resource instanceof IFile ? "cblpdp".equals(fileExtension = (file = (IFile)resource).getFileExtension()) : resource instanceof IFolder && PdpPathService.containsCobolPDPFile((IFolder)resource)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isRppRootFolderRenamingInProgress() {
        return PDPPathNature.isRppRootFolderRenamingInProgress;
    }

    public static void createNature(IProject project) {
        try {
            if (!project.exists()) {
                return;
            }
            if (!project.isOpen()) {
                project.open(null);
            }
            if (!project.hasNature("com.ibm.pdp.pdppath.PDPPathNature")) {
                IProjectDescription description = project.getDescription();
                String[] oldNatures = description.getNatureIds();
                String[] newNatures = new String[oldNatures.length + 1];
                System.arraycopy(oldNatures, 0, newNatures, 0, oldNatures.length);
                newNatures[newNatures.length - 1] = "com.ibm.pdp.pdppath.PDPPathNature";
                description.setNatureIds(newNatures);
                project.setDescription(description, null);
                PDPPathNature nature = (PDPPathNature)project.getNature("com.ibm.pdp.pdppath.PDPPathNature");
                nature.savePdpPath(DEFAULT_RPP_ROOT, DEFAULT_RPP_ROOT, DEFAULT_RPP_ROOT);
            }
        }
        catch (CoreException e) {
            throw Util.rethrow((Throwable)e);
        }
    }

    public static String computePdpFileLocationFromSourceFileLocation(String sourceFileLocation) {
        Path path = new Path(sourceFileLocation);
        String projectName = path.segment(0);
        String genRoot = PdpPathService.getGenRootFolder(projectName);
        String pdpRoot = PdpPathService.getMetaPdpRootFolder(projectName);
        if (genRoot == null) {
            genRoot = EMPTY_STRING;
        }
        if (pdpRoot == null || pdpRoot.trim().length() == 0) {
            pdpRoot = genRoot;
        }
        if (genRoot.equals(pdpRoot)) {
            return String.valueOf(sourceFileLocation) + _DEFAULT_PDP;
        }
        if (pdpRoot.trim().length() != 0) {
            return "/" + projectName + '/' + pdpRoot + '/' + sourceFileLocation.substring(projectName.length() + 2) + _DEFAULT_PDP;
        }
        return String.valueOf(sourceFileLocation) + _DEFAULT_PDP;
    }

    public static String computeSourceFileLocationFromPdpFileLocation(String pdpSourceFilelocation) {
        Path path = new Path(pdpSourceFilelocation);
        String projectName = path.segment(0);
        String sourceFileLocation = pdpSourceFilelocation.substring(0, pdpSourceFilelocation.length() - _DEFAULT_PDP.length());
        String genRoot = PdpPathService.getGenRootFolder(projectName);
        String pdpRoot = PdpPathService.getMetaPdpRootFolder(projectName);
        if (genRoot == null) {
            genRoot = EMPTY_STRING;
        }
        if (pdpRoot == null || pdpRoot.trim().length() == 0) {
            pdpRoot = genRoot;
        }
        if (genRoot.equals(pdpRoot)) {
            return sourceFileLocation;
        }
        int index = (sourceFileLocation = sourceFileLocation.substring(projectName.length() + 2)).indexOf(pdpRoot);
        if (index == -1) {
            return EMPTY_STRING;
        }
        return "/" + projectName + '/' + sourceFileLocation.substring(index + pdpRoot.length() + 1);
    }
}

