/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pdppath.properties;

import com.ibm.pdp.pdppath.PDPPathUpdateExtensionMgr;
import com.ibm.pdp.pdppath.interfaces.IPDPPathUpdate;
import com.ibm.pdp.pdppath.nature.PDPPathNature;
import com.ibm.pdp.pdppath.nature.RppExtensions;
import com.ibm.pdp.pdppath.properties.Messages;
import com.ibm.pdp.pdppath.properties.PDPPathPropertyPage;
import com.ibm.pdp.pdppath.properties.PdpFileDesignIPackagedParser;
import com.ibm.pdp.util.Util;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class RunRenameWithProgress
implements IRunnableWithProgress {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2014.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String EMPTY_STRING = "";
    private String _oldRppRootPath;
    private String rpp;
    private String _oldGenRootPath;
    private String gen;
    private String _oldPdpRootPath;
    private String pdp;
    private IProject project;
    private PDPPathNature nature;
    private boolean projectDesynchonized;

    public RunRenameWithProgress(String oldRpp, String rpp, String oldGen, String gen, String oldPdp, String pdp, IProject project, PDPPathNature nature) {
        this._oldRppRootPath = oldRpp;
        this.rpp = rpp;
        this._oldGenRootPath = oldGen;
        this.gen = gen;
        this._oldPdpRootPath = oldPdp;
        this.pdp = pdp;
        this.project = project;
        this.nature = nature;
    }

    public boolean isProjectDesynchonized() {
        return this.projectDesynchonized;
    }

    private boolean deleteEmptyFolder(IFolder folder) throws CoreException {
        if (!folder.exists()) {
            return true;
        }
        IResource[] resources = folder.members();
        if (resources.length == 0) {
            folder.delete(true, null);
            return true;
        }
        int i = 0;
        while (i < resources.length) {
            if (resources[i] instanceof IFile) {
                return false;
            }
            if (resources[i] instanceof IFolder && !this.deleteEmptyFolder((IFolder)resources[i])) {
                return false;
            }
            ++i;
        }
        folder.delete(true, null);
        return true;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            List<IFile> pdpFiles;
            IProject container;
            if (!this.project.isSynchronized(2)) {
                this.projectDesynchonized = true;
                return;
            }
            PDPPathNature.isRppRootFolderRenamingInProgress = true;
            this.nature.savePdpPath(this.rpp, this.gen, this.pdp);
            if (this._oldRppRootPath == null) {
                return;
            }
            boolean rppFolderRenamed = false;
            if (this._oldRppRootPath.trim().length() == 0 && this.rpp != null && this.rpp.trim().length() != 0) {
                try {
                    rppFolderRenamed = this.refactorRppFolderFromEmpty(this.project, this.rpp, this._oldGenRootPath, this._oldPdpRootPath, monitor);
                }
                catch (CoreException e) {
                    throw Util.rethrow((Throwable)e);
                }
            }
            try {
                rppFolderRenamed = this.refactorRppFolder(this.project, this._oldRppRootPath, this.rpp, monitor);
            }
            catch (CoreException e) {
                throw Util.rethrow((Throwable)e);
            }
            boolean moveRPP = !this._oldRppRootPath.equals(this.rpp);
            boolean moveGen = false;
            boolean movePdP = false;
            String new_OldGenRootPath = this._oldGenRootPath;
            String new_OldPDPRootPath = this._oldPdpRootPath;
            if (!this.gen.equals(this._oldGenRootPath)) {
                if (!(moveRPP && this._oldGenRootPath.equals(this._oldRppRootPath) && this.rpp.equals(this.gen))) {
                    moveGen = true;
                    movePdP = true;
                    if (moveRPP && this._oldGenRootPath.equals(this._oldRppRootPath)) {
                        new_OldGenRootPath = this.rpp;
                    }
                } else if (!this._oldPdpRootPath.equals(this._oldRppRootPath)) {
                    movePdP = true;
                }
            }
            if (!(this.pdp.equals(this._oldPdpRootPath) || moveRPP && this._oldPdpRootPath.equals(this._oldRppRootPath) && this.rpp.equals(this.pdp))) {
                movePdP = true;
                if (moveRPP && this._oldPdpRootPath.equals(this._oldRppRootPath)) {
                    new_OldPDPRootPath = this.rpp;
                }
            }
            if (rppFolderRenamed && !moveGen) {
                Path destination = new Path("/" + this.project.getName() + "/" + this.rpp);
                container = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)destination);
                pdpFiles = PDPPathPropertyPage.getPDPFiles((IContainer)container);
                List<IPDPPathUpdate> pdpPathUpdateExtList = PDPPathUpdateExtensionMgr.getPdpPathUpdateExtensions();
                for (IFile pdpFile : pdpFiles) {
                    String generatedPath = PDPPathPropertyPage.computeSourceFileLocationFromPdpFileLocation(pdpFile.getFullPath().toString(), this.pdp, this.gen);
                    IFile generatedFile = this.project.getFile(generatedPath);
                    int i = 0;
                    while (i < pdpPathUpdateExtList.size()) {
                        IPDPPathUpdate pdpPathUpdate = pdpPathUpdateExtList.get(i);
                        pdpPathUpdate.genPathToUpdate(generatedFile.getFullPath().toString());
                        ++i;
                    }
                }
            }
            ArrayList<PDPFileInformation> pdpFilesInfo = new ArrayList<PDPFileInformation>();
            if ((moveGen || movePdP) && (container = this.project).exists()) {
                pdpFiles = PDPPathPropertyPage.getPDPFiles((IContainer)container);
                for (IFile pdpFile : pdpFiles) {
                    pdpFilesInfo.add(new PDPFileInformation(pdpFile));
                }
                this.computeGeneratedFilesForPDPFilesInfo(pdpFilesInfo);
                this.parsePDPFilesToAddMode(pdpFilesInfo);
                this.addDestinationGeneratedPaths(pdpFilesInfo, new_OldGenRootPath, this.gen);
                if (movePdP) {
                    this.addDestinationPDPPaths(pdpFilesInfo, new_OldPDPRootPath, this.pdp, new_OldGenRootPath, this.gen, this._oldRppRootPath);
                    this.reduceUnusedPDPFilesMoves(pdpFilesInfo);
                    if (!this.checkDestinationNotAlreadyExistForPDPPaths(pdpFilesInfo)) {
                        throw new RuntimeException(Messages.PDPPathPropertyPage_A_meta_destination_file);
                    }
                }
                if (moveGen) {
                    this.reduceUnusedGeneratedFilesMoves(pdpFilesInfo);
                    if (!this.checkDestinationNotAlreadyExistForGeneratedPaths(pdpFilesInfo)) {
                        throw new RuntimeException(Messages.PDPPathPropertyPage_A_generated_destination);
                    }
                } else {
                    for (PDPFileInformation pdpFileInformation : pdpFilesInfo) {
                        pdpFileInformation.setGeneratedFile(null);
                        pdpFileInformation.setDestinationGeneratedPath(null);
                    }
                }
            }
            this.moveFiles(pdpFilesInfo);
            if (this._oldGenRootPath.length() != 0) {
                try {
                    this.deleteEmptyFolder(this.project.getFolder((IPath)new Path(this._oldGenRootPath)));
                }
                catch (CoreException e) {
                    Util.rethrow((Throwable)e);
                }
            }
            if (this._oldPdpRootPath.length() != 0) {
                try {
                    this.deleteEmptyFolder(this.project.getFolder((IPath)new Path(this._oldPdpRootPath)));
                }
                catch (CoreException e) {
                    Util.rethrow((Throwable)e);
                }
            }
        }
        finally {
            PDPPathNature.isRppRootFolderRenamingInProgress = false;
        }
    }

    private void computeGeneratedFilesForPDPFilesInfo(List<PDPFileInformation> pdpFilesInfo) {
        if (pdpFilesInfo == null || pdpFilesInfo.size() == 0) {
            return;
        }
        for (PDPFileInformation pdpFileInfo : pdpFilesInfo) {
            String generatedPath = PDPPathPropertyPage.computeSourceFileLocationFromPdpFileLocation(pdpFileInfo.getPdpFile().getFullPath().toString(), this._oldPdpRootPath, this._oldGenRootPath);
            IFile generatedFile = this.project.getFile(generatedPath);
            pdpFileInfo.setGeneratedFile(generatedFile);
        }
    }

    private void reduceUnusedPDPFilesMoves(List<PDPFileInformation> pdpFilesInfo) {
        if (pdpFilesInfo == null) {
            return;
        }
        int i = pdpFilesInfo.size() - 1;
        while (i >= 0) {
            PDPFileInformation pdpFileInfo = pdpFilesInfo.get(i);
            IFile file = pdpFileInfo.getPdpFile();
            IPath path = pdpFileInfo.getDestinationPDPPath();
            if (file == null || file.getFullPath().equals((Object)path)) {
                if (pdpFileInfo.getGeneratedFile() == null && pdpFileInfo.getDestinationGeneratedPath() == null) {
                    pdpFilesInfo.remove(i);
                } else {
                    pdpFileInfo.setPdpFile(null);
                    pdpFileInfo.setDestinationPDPPath(null);
                }
            }
            --i;
        }
    }

    private void reduceUnusedGeneratedFilesMoves(List<PDPFileInformation> pdpFilesInfo) {
        if (pdpFilesInfo == null) {
            return;
        }
        int i = pdpFilesInfo.size() - 1;
        while (i >= 0) {
            PDPFileInformation pdpFileInfo = pdpFilesInfo.get(i);
            IFile file = pdpFileInfo.getGeneratedFile();
            IPath path = pdpFileInfo.getDestinationGeneratedPath();
            if (file == null || file.getFullPath().equals((Object)path)) {
                if (pdpFileInfo.getPdpFile() == null && pdpFileInfo.getDestinationGeneratedPath() == null) {
                    pdpFilesInfo.remove(i);
                } else {
                    pdpFileInfo.setGeneratedFile(null);
                    pdpFileInfo.setDestinationGeneratedPath(null);
                }
            }
            --i;
        }
    }

    private void parsePDPFilesToAddMode(List<PDPFileInformation> pdpFilesInfo) {
        int i = 0;
        while (i < pdpFilesInfo.size()) {
            PdpFileDesignIPackagedParser parser = new PdpFileDesignIPackagedParser();
            try {
                PDPFileInformation pdpFileInfo = pdpFilesInfo.get(i);
                parser.parse(pdpFileInfo.getPdpFile().getContents());
                pdpFileInfo.setAbsoluteMode(parser.getResult().equals("N"));
            }
            catch (CoreException coreException) {}
            ++i;
        }
    }

    public boolean moveFiles(List<PDPFileInformation> pdpFilesInformation) {
        for (PDPFileInformation pdpFileInformation : pdpFilesInformation) {
            IFile pdpFile = pdpFileInformation.getPdpFile();
            IPath destinationPDPPath = pdpFileInformation.getDestinationPDPPath();
            if (pdpFile == null || destinationPDPPath == null) continue;
            IFile destinationFile = ResourcesPlugin.getWorkspace().getRoot().getFile(destinationPDPPath);
            PDPPathPropertyPage.createParentFolders(destinationFile.getParent());
            try {
                pdpFile.move(destinationPDPPath, true, null);
            }
            catch (CoreException e) {
                throw Util.rethrow((Throwable)e);
            }
        }
        ArrayList<String> filesRemoved = new ArrayList<String>();
        for (PDPFileInformation pdpFileInformation : pdpFilesInformation) {
            IFile generatedFile = pdpFileInformation.getGeneratedFile();
            IPath destinationGeneratedPath = pdpFileInformation.getDestinationGeneratedPath();
            if (generatedFile == null || destinationGeneratedPath == null) continue;
            filesRemoved.add(generatedFile.getFullPath().toString());
        }
        if (filesRemoved.size() != 0) {
            List<IPDPPathUpdate> pdpPathUpdateExtList = PDPPathUpdateExtensionMgr.getPdpPathUpdateExtensions();
            int i = 0;
            while (i < pdpPathUpdateExtList.size()) {
                pdpPathUpdateExtList.get(i);
                ++i;
            }
            for (PDPFileInformation pdpFileInformation : pdpFilesInformation) {
                IFile generatedFile = pdpFileInformation.getGeneratedFile();
                IPath destinationGeneratedPath = pdpFileInformation.getDestinationGeneratedPath();
                if (generatedFile == null || destinationGeneratedPath == null) continue;
                IFile destinationFile = ResourcesPlugin.getWorkspace().getRoot().getFile(destinationGeneratedPath);
                PDPPathPropertyPage.createParentFolders(destinationFile.getParent());
                try {
                    generatedFile.move(destinationGeneratedPath, true, null);
                    int i2 = 0;
                    while (i2 < pdpPathUpdateExtList.size()) {
                        IPDPPathUpdate pdpPathUpdate = pdpPathUpdateExtList.get(i2);
                        pdpPathUpdate.genPathToUpdate(destinationGeneratedPath.toString());
                        ++i2;
                    }
                }
                catch (CoreException e) {
                    throw Util.rethrow((Throwable)e);
                }
            }
        }
        return true;
    }

    public boolean refactorRppFolder(IProject project, String oldFolderName, String newFolderName, IProgressMonitor monitor) throws CoreException {
        if (project == null) {
            return false;
        }
        if (oldFolderName == null || newFolderName == null) {
            return false;
        }
        if (oldFolderName.equals(newFolderName)) {
            return false;
        }
        if (oldFolderName.length() > 0 && newFolderName.length() > 0) {
            if (newFolderName.startsWith(oldFolderName) && (newFolderName.contains("/") || oldFolderName.contains("/"))) {
                Path tmpPath = new Path("/" + project.getName() + "/rpptmpfolder");
                IFolder tmpContainer = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)tmpPath);
                if (tmpContainer.exists()) {
                    throw new RuntimeException("rpptmpfolder already exists, move aborted");
                }
                Path sourcePath = new Path("/" + project.getName() + "/" + oldFolderName);
                IFolder sourceContainer = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)sourcePath);
                sourceContainer.move((IPath)tmpPath, true, monitor);
                Path destination = new Path("/" + project.getName() + "/" + newFolderName);
                IFolder destinationContainer = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)destination);
                PDPPathPropertyPage.createParentFolders(destinationContainer.getParent());
                tmpContainer.move((IPath)destination, true, monitor);
                return true;
            }
            Path sourcePath = new Path("/" + project.getName() + "/" + oldFolderName);
            IFolder sourceContainer = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)sourcePath);
            Path destination = new Path("/" + project.getName() + "/" + newFolderName);
            IFolder destinationContainer = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)destination);
            PDPPathPropertyPage.createParentFolders(destinationContainer.getParent());
            sourceContainer.move((IPath)destination, true, monitor);
            return true;
        }
        return false;
    }

    public boolean refactorRppFolderFromEmpty(IProject project, String newFolderName, String oldGenName, String oldPdpName, IProgressMonitor monitor) throws CoreException {
        if (project == null) {
            return false;
        }
        IResource[] resources = project.members();
        int resLenght = resources.length;
        boolean done = false;
        int i = 0;
        while (i < resLenght) {
            IPath path;
            String lastSegment;
            IResource resource = resources[i];
            if (!(resource instanceof IFolder) || !(lastSegment = (path = ((IFolder)resource).getLocation()).lastSegment()).equals(oldGenName) && !lastSegment.equals(oldPdpName)) {
                this.moveResourceFromEmptyRppFolder(resource, newFolderName, project.getName());
                done = true;
            }
            ++i;
        }
        return done;
    }

    private void moveResourceFromEmptyRppFolder(IResource resource, String newFolderName, String projectName) throws CoreException {
        if (resource instanceof IFile) {
            IFile file = (IFile)resource;
            String extension = file.getFileExtension();
            int index = Arrays.binarySearch(RppExtensions.getRppExtensions(), extension);
            if (index > 0) {
                String oldFileLocation = file.getFullPath().toString();
                String newFileLocation = oldFileLocation.substring(projectName.length() + 2);
                newFileLocation = "/" + projectName + "/" + newFolderName + "/" + newFileLocation;
                Path destinationPath = new Path(newFileLocation);
                IFile destinationFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)destinationPath);
                PDPPathPropertyPage.createParentFolders(destinationFile.getParent());
                file.move((IPath)destinationPath, true, null);
            }
            return;
        }
        if (resource instanceof IFolder) {
            IFolder folder = (IFolder)resource;
            IResource[] resources = folder.members();
            int resLenght = resources.length;
            int i = 0;
            while (i < resLenght) {
                IResource member = resources[i];
                this.moveResourceFromEmptyRppFolder(member, newFolderName, projectName);
                ++i;
            }
            if (folder.members().length == 0) {
                folder.delete(true, null);
            }
        }
    }

    protected boolean checkDestinationNotAlreadyExistForPDPPaths(List<PDPFileInformation> pdpFilesInformation) {
        if (pdpFilesInformation == null) {
            return true;
        }
        for (PDPFileInformation pdpFileInformation : pdpFilesInformation) {
            IFile file;
            IPath path = pdpFileInformation.getDestinationPDPPath();
            if (path == null || !(file = ResourcesPlugin.getWorkspace().getRoot().getFile(path)).exists()) continue;
            return false;
        }
        return true;
    }

    protected boolean checkDestinationNotAlreadyExistForGeneratedPaths(List<PDPFileInformation> pdpFilesInformation) {
        if (pdpFilesInformation == null) {
            return true;
        }
        for (PDPFileInformation pdpFileInformation : pdpFilesInformation) {
            IFile file;
            IPath path = pdpFileInformation.getDestinationGeneratedPath();
            if (path == null || !(file = ResourcesPlugin.getWorkspace().getRoot().getFile(path)).exists()) continue;
            return false;
        }
        return true;
    }

    protected void addDestinationGeneratedPaths(List<PDPFileInformation> pdpFilesInfo, String oldGenRoot, String newGenRoot) {
        if (pdpFilesInfo == null || pdpFilesInfo.size() == 0) {
            return;
        }
        new ArrayList();
        String projectName = this.project.getName();
        for (PDPFileInformation pdpFileInfo : pdpFilesInfo) {
            String oldGeneratedFileLocation;
            boolean absoluteLocation = pdpFileInfo.isAbsoluteMode();
            IFile generatedFile = pdpFileInfo.getGeneratedFile();
            if (generatedFile == null) {
                pdpFileInfo.setDestinationGeneratedPath(null);
                continue;
            }
            String newGeneratedFileLocation = oldGeneratedFileLocation = pdpFileInfo.getGeneratedFile().getFullPath().toString();
            if (absoluteLocation) {
                pdpFileInfo.setDestinationGeneratedPath((IPath)new Path(oldGeneratedFileLocation));
                continue;
            }
            newGeneratedFileLocation = newGeneratedFileLocation.substring(projectName.length() + 2);
            if (!absoluteLocation && oldGenRoot != null && oldGenRoot.length() != 0 && newGeneratedFileLocation.startsWith(oldGenRoot)) {
                newGeneratedFileLocation = newGeneratedFileLocation.substring(oldGenRoot.length() + 1);
            }
            if (!absoluteLocation && newGenRoot.length() != 0) {
                newGeneratedFileLocation = String.valueOf(newGenRoot) + "/" + newGeneratedFileLocation;
            }
            newGeneratedFileLocation = "/" + projectName + "/" + newGeneratedFileLocation;
            pdpFileInfo.setDestinationGeneratedPath((IPath)new Path(newGeneratedFileLocation));
        }
    }

    protected void addDestinationPDPPaths(List<PDPFileInformation> pdpFilesInfo, String oldPDPRoot, String newPDPRoot, String oldGenRoot, String newGenRoot, String oldRppRoot) {
        if (pdpFilesInfo == null || pdpFilesInfo.size() == 0) {
            return;
        }
        new ArrayList();
        this.project.getName();
        for (PDPFileInformation pdpFileInfo : pdpFilesInfo) {
            IPath destinationGeneratedPath = pdpFileInfo.getDestinationGeneratedPath();
            if (destinationGeneratedPath == null) continue;
            String destGenPath = destinationGeneratedPath.toOSString();
            Path destPDPPath = new Path(this.computePdpFileLocationFromSourceFileLocation(destGenPath, newGenRoot, newPDPRoot));
            pdpFileInfo.setDestinationPDPPath((IPath)destPDPPath);
        }
    }

    public String computePdpFileLocationFromSourceFileLocation(String sourceFileLocation, String gen, String pdp) {
        Path path = new Path(sourceFileLocation);
        String projectName = path.segment(0);
        String genRoot = gen;
        String pdpRoot = pdp;
        if (genRoot == null) {
            genRoot = EMPTY_STRING;
        }
        if (pdpRoot == null || pdpRoot.trim().length() == 0) {
            pdpRoot = genRoot;
        }
        if (genRoot.equals(pdpRoot)) {
            return String.valueOf(sourceFileLocation) + "pdp";
        }
        if (pdpRoot.trim().length() != 0) {
            return "/" + projectName + '/' + pdpRoot + '/' + sourceFileLocation.substring(projectName.length() + 2) + "pdp";
        }
        return String.valueOf(sourceFileLocation) + "pdp";
    }

    class PDPFileInformation {
        private IFile generatedFile;
        private IFile pdpFile;
        private boolean absoluteMode;
        private IPath destinationGeneratedPath;
        private IPath destinationPDPPath;

        PDPFileInformation(IFile pdpFile) {
            this.pdpFile = pdpFile;
        }

        public IFile getGeneratedFile() {
            return this.generatedFile;
        }

        public void setGeneratedFile(IFile generatedFile) {
            this.generatedFile = generatedFile;
        }

        public IFile getPdpFile() {
            return this.pdpFile;
        }

        public void setPdpFile(IFile pdpFile) {
            this.pdpFile = pdpFile;
        }

        public IPath getDestinationGeneratedPath() {
            return this.destinationGeneratedPath;
        }

        public void setDestinationGeneratedPath(IPath destinationGeneratedPath) {
            this.destinationGeneratedPath = destinationGeneratedPath;
        }

        public IPath getDestinationPDPPath() {
            return this.destinationPDPPath;
        }

        public void setDestinationPDPPath(IPath destinationPDPPath) {
            this.destinationPDPPath = destinationPDPPath;
        }

        public boolean isAbsoluteMode() {
            return this.absoluteMode;
        }

        public void setAbsoluteMode(boolean absoluteMode) {
            this.absoluteMode = absoluteMode;
        }
    }
}

