/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pdppath.properties;

import com.ibm.pdp.pdppath.properties.IVersionManagedTagHandler;
import com.ibm.pdp.pdppath.properties.PdpFileDesignIDPackageTagHandlerV0;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PdpFileDesignIPackagedParser
extends DefaultHandler {
    private String logicalGenerationOutput;
    private SAXParser _saxParser;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2011, 2013.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public PdpFileDesignIPackagedParser() {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(true);
        factory.setNamespaceAware(false);
        try {
            this._saxParser = factory.newSAXParser();
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    private void doCommonParsingTreatment(InputStream input) {
        block3: {
            try {
                this._saxParser.parse(input, (DefaultHandler)new TagHandler());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (SAXException e) {
                String s = e.getMessage();
                if (s.equals("stop_sax_parsing")) break block3;
                throw new RuntimeException(e);
            }
        }
    }

    public String parse(InputStream inputStream) {
        this.doCommonParsingTreatment(inputStream);
        return this.logicalGenerationOutput;
    }

    public String parse(String fileName) {
        this.doCommonParsingTreatment(this.getContentsAsInputStream(fileName));
        return this.logicalGenerationOutput;
    }

    private InputStream getContentsAsInputStream(String fileName) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(fileName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return fis;
    }

    public void setResult(String result) {
        this.logicalGenerationOutput = result;
    }

    public String getResult() {
        return this.logicalGenerationOutput;
    }

    private class TagHandler
    extends DefaultHandler {
        IVersionManagedTagHandler versionManagedTagHandler = null;

        private TagHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
            String version;
            if (this.versionManagedTagHandler != null) {
                this.versionManagedTagHandler.startElement(uri, localName, name, atts);
                return;
            }
            if (name.equals("Refs") && ((version = atts.getValue("version")).equals("0") || version.equals("1") || version.equals("2"))) {
                this.versionManagedTagHandler = new PdpFileDesignIDPackageTagHandlerV0(PdpFileDesignIPackagedParser.this);
            }
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            if (name.equals("Refs")) {
                SAXException e = new SAXException("stop_sax_parsing");
                throw e;
            }
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
        }

        @Override
        public void setDocumentLocator(Locator locator) {
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }
    }
}

