/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pdppath.properties;

import com.ibm.pdp.pdppath.nature.PDPPath;
import com.ibm.pdp.pdppath.nature.PDPPathNature;
import com.ibm.pdp.pdppath.properties.Messages;
import com.ibm.pdp.pdppath.properties.PdpFileDesignIPackagedParser;
import com.ibm.pdp.pdppath.properties.RunRenameWithProgress;
import com.ibm.pdp.pdppath.service.PdpPathService;
import com.ibm.pdp.util.Util;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;

public class PDPPathPropertyPage
extends PropertyPage {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2016.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String _HELP_PLUGIN = "com.ibm.pdp.doc.cshelp";
    private String _oldRppRootPath;
    private String _oldGenRootPath;
    private String _oldPdpRootPath;
    private Text _rppRootPathText;
    private Button _separateGenCheckBox;
    private Text _genRootPathText;
    private Button _separatePDPCheckBox;
    private Text _pdpRootPathText;
    private PDPPath pdpPath;
    private PDPPathNature nature;

    public PDPPathPropertyPage() {
        this.noDefaultAndApplyButton();
    }

    protected Control createContents(Composite parent) {
        Composite composite = PDPPathPropertyPage.createComposite(parent, 2, false);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, this.getContextId());
        PDPPathPropertyPage.createLabel(composite, Messages.PDPPathPropertyPage_RPP_root_folder);
        this._rppRootPathText = PDPPathPropertyPage.createTextField(composite, false, false);
        String separateGenFileLabel = Messages.PDPPathPropertyPage_Separate_gen;
        this._separateGenCheckBox = PDPPathPropertyPage.createCheckBox(composite, separateGenFileLabel);
        this._separateGenCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                PDPPathPropertyPage.this.updateGenRootTextState();
                if (PDPPathPropertyPage.this._separateGenCheckBox.getSelection()) {
                    String defaultValue = "gen";
                    PDPPathPropertyPage.this._genRootPathText.setText(defaultValue);
                } else {
                    PDPPathPropertyPage.this._genRootPathText.setText("");
                }
            }
        });
        this._genRootPathText = PDPPathPropertyPage.createTextField(composite, false, false);
        this._genRootPathText.setEnabled(false);
        this._genRootPathText.setEditable(false);
        Accessible accGenCheckBox = this._separateGenCheckBox.getAccessible();
        Accessible accGenRootPathText = this._genRootPathText.getAccessible();
        accGenRootPathText.addRelation(10, accGenCheckBox);
        accGenRootPathText.addRelation(9, accGenCheckBox);
        String separatedPDPFileLabel = Messages.PDPPathPropertyPage_Separate_pdp;
        this._separatePDPCheckBox = PDPPathPropertyPage.createCheckBox(composite, separatedPDPFileLabel);
        this._separatePDPCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                PDPPathPropertyPage.this.updatePDPRootTextState();
                if (PDPPathPropertyPage.this._separatePDPCheckBox.getSelection()) {
                    String defaultValue = "pdp";
                    PDPPathPropertyPage.this._pdpRootPathText.setText(defaultValue);
                } else {
                    PDPPathPropertyPage.this._pdpRootPathText.setText("");
                }
            }
        });
        this._pdpRootPathText = PDPPathPropertyPage.createTextField(composite, false, false);
        this._pdpRootPathText.setEnabled(false);
        this._pdpRootPathText.setEditable(false);
        Accessible accPDPCheckBox = this._separatePDPCheckBox.getAccessible();
        Accessible accPDPRootPathText = this._pdpRootPathText.getAccessible();
        accPDPRootPathText.addRelation(10, accPDPCheckBox);
        accPDPRootPathText.addRelation(9, accPDPCheckBox);
        this.setInput();
        return composite;
    }

    private String getContextId() {
        return "com.ibm.pdp.doc.cshelp.root_path";
    }

    private IProject getProject() {
        IProject project = null;
        IAdaptable adaptable = this.getElement();
        if (adaptable instanceof IProject) {
            project = (IProject)adaptable;
        }
        if (adaptable instanceof IProjectNature) {
            project = ((IProjectNature)adaptable).getProject();
        }
        return project;
    }

    public boolean performOk() {
        Shell shell = this.getShell();
        Cursor cursor = shell.getCursor();
        shell.setCursor(new Cursor((Device)shell.getDisplay(), 1));
        IAdaptable adaptable = this.getElement();
        String rpp = this._rppRootPathText.getText().trim();
        String gen = this._genRootPathText.getText().trim();
        String pdp = this._pdpRootPathText.getText().trim();
        if (rpp.length() == 0 && (this._oldRppRootPath != null && this._oldRppRootPath.length() != 0 || this._separateGenCheckBox.getSelection() || this._separatePDPCheckBox.getSelection())) {
            this.setErrorMessage(Messages.PDPPathPropertyPage_The_RPP_root_folder);
            shell.setCursor(cursor);
            return false;
        }
        if (rpp.length() == 0 && !this._separateGenCheckBox.getSelection() && !this._separatePDPCheckBox.getSelection()) {
            return true;
        }
        if (!rpp.equals(this._oldRppRootPath)) {
            String errorMessage;
            if (!this.checkDestination(rpp)) {
                this.setErrorMessage(Messages.PDPPathPropertyPage_Destination_already_exists);
                shell.setCursor(cursor);
                return false;
            }
            if (this._oldPdpRootPath != null && (errorMessage = this.checkAbsoluteMode(this._oldRppRootPath, this.getProject())) != null) {
                this.setErrorMessage(errorMessage);
                shell.setCursor(cursor);
                return false;
            }
        }
        if (pdp.trim().length() == 0) {
            pdp = gen;
        }
        if (this.nature == null) {
            PdpPathService.createNature(this.getProject());
        }
        boolean genSeparated = this._separateGenCheckBox.getSelection();
        boolean pdpSeparated = this._separatePDPCheckBox.getSelection();
        if (!genSeparated) {
            gen = rpp;
        }
        if (!pdpSeparated) {
            pdp = gen;
        }
        if (adaptable instanceof IProject && this.nature != null) {
            RunRenameWithProgress operation = new RunRenameWithProgress(this._oldRppRootPath, rpp, this._oldGenRootPath, gen, this._oldPdpRootPath, pdp, this.getProject(), this.nature);
            try {
                ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(this.getShell());
                progressDialog.run(true, true, (IRunnableWithProgress)operation);
                if (operation.isProjectDesynchonized()) {
                    return false;
                }
            }
            catch (InvocationTargetException e) {
                throw Util.rethrow((Throwable)e);
            }
            catch (InterruptedException e) {
                throw Util.rethrow((Throwable)e);
            }
        }
        shell.setCursor(null);
        return true;
    }

    private boolean checkDestination(String rpp) {
        Path path = new Path("/" + this.getProject().getName() + "/" + rpp);
        IFolder destinationFolder = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)path);
        return !destinationFolder.exists();
    }

    private String checkAbsoluteMode(String rpp, IProject project) {
        List<IFile> pdpFiles = PDPPathPropertyPage.getPDPFiles((IContainer)project);
        for (IFile pdpFile : pdpFiles) {
            PdpFileDesignIPackagedParser parser = new PdpFileDesignIPackagedParser();
            try {
                parser.parse(pdpFile.getContents());
                if (!parser.getResult().equals("N")) continue;
                String cobolFileName = PDPPathPropertyPage.computeSourceFileLocationFromPdpFileLocation(pdpFile.getFullPath().toOSString(), this._oldPdpRootPath, this._oldGenRootPath);
                Path sourcePath = new Path("/" + project.getName() + "/" + rpp);
                IFolder rppContainer = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)sourcePath);
                IFile cobolFile = project.getFile(cobolFileName);
                if (!rppContainer.getFullPath().isPrefixOf(cobolFile.getFullPath())) continue;
                Object[] objects = new String[]{cobolFile.getFullPath().toString()};
                String message = NLS.bind((String)Messages.PDPPathPropertyPage_The_file_does_not, (Object[])objects);
                return message;
            }
            catch (CoreException coreException) {}
        }
        return null;
    }

    private void setInput() {
        IProject project = this.getProject();
        if (project != null) {
            boolean isGenSplit;
            String projectName = project.getName();
            this._oldRppRootPath = PdpPathService.getRppRootFolder(projectName);
            this._oldGenRootPath = PdpPathService.getGenRootFolder(projectName);
            this._oldPdpRootPath = PdpPathService.getMetaPdpRootFolder(projectName);
            this.nature = PDPPathNature.getNature(project.getName());
            this.pdpPath = new PDPPath();
            this.pdpPath.setRppRootPath(this._oldRppRootPath);
            this.pdpPath.setGenRootPath(this._oldGenRootPath);
            this.pdpPath.setMetaRootPath(this._oldPdpRootPath);
            if (this._oldRppRootPath != null) {
                this._rppRootPathText.setText(this._oldRppRootPath);
            }
            boolean bl = isGenSplit = this._oldRppRootPath != null && !this._oldRppRootPath.equals(this._oldGenRootPath);
            if (isGenSplit) {
                this._separateGenCheckBox.setSelection(true);
                this._genRootPathText.setText(this._oldGenRootPath);
                this.updateGenRootTextState();
            }
            if (this._oldPdpRootPath != null && !this._oldPdpRootPath.equals(this._oldGenRootPath)) {
                this._separatePDPCheckBox.setSelection(true);
                this._pdpRootPathText.setText(this._oldPdpRootPath);
                this.updatePDPRootTextState();
            }
        }
    }

    private void updateGenRootTextState() {
        boolean enabled = this._separateGenCheckBox.getSelection();
        this._genRootPathText.setEnabled(enabled);
        this._genRootPathText.setEditable(enabled);
    }

    private void updatePDPRootTextState() {
        boolean enabled = this._separatePDPCheckBox.getSelection();
        this._pdpRootPathText.setEnabled(enabled);
        this._pdpRootPathText.setEditable(enabled);
    }

    public static Button createCheckBox(Composite parent, String label) {
        Button button = new Button(parent, 32);
        button.setText(label);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 1;
        button.setLayoutData((Object)gridData);
        return button;
    }

    public static Composite createComposite(Composite parent, int numColumns, boolean border) {
        Composite composite = border ? new Composite(parent, 2048) : new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = numColumns;
        composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)gridData);
        return composite;
    }

    public static Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 16384);
        label.setText(text);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 2;
        label.setLayoutData((Object)gridData);
        return label;
    }

    public static Group createGroup(Composite parent, String text) {
        Group label = new Group(parent, 16384);
        label.setText(text);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 2;
        label.setLayoutData((Object)gridData);
        return label;
    }

    public static Text createTextField(Composite parent, boolean isMultiline, boolean isReadOnly) {
        int style = 2112;
        style = isMultiline ? (style |= 0x202) : (style |= 4);
        if (isReadOnly) {
            style |= 8;
        }
        Text text = new Text(parent, style);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        if (isMultiline) {
            gridData.verticalAlignment = 4;
            gridData.grabExcessVerticalSpace = true;
        } else {
            gridData.verticalAlignment = 2;
            gridData.grabExcessVerticalSpace = false;
        }
        text.setLayoutData((Object)gridData);
        return text;
    }

    public static List<IFile> getPDPFiles(IContainer folder) {
        ArrayList<IFile> pdpFiles = new ArrayList<IFile>();
        try {
            PDPPathPropertyPage.computePDPFiles(folder, pdpFiles);
        }
        catch (CoreException exception) {
            Util.rethrow((Throwable)exception);
        }
        return pdpFiles;
    }

    private static void computePDPFiles(IContainer folder, List<IFile> pdpFiles) throws CoreException {
        IResource[] resources;
        IResource[] iResourceArray = resources = folder.members();
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (resource instanceof IFile) {
                IFile file = (IFile)resource;
                if (file.exists() && file.getFileExtension().endsWith("pdp")) {
                    pdpFiles.add(file);
                }
            } else if (resource instanceof IFolder) {
                IFolder childFolder = (IFolder)resource;
                PDPPathPropertyPage.computePDPFiles((IContainer)childFolder, pdpFiles);
            }
            ++n2;
        }
    }

    public static boolean createParentFolders(IContainer container) {
        if (container.exists()) {
            return true;
        }
        if (PDPPathPropertyPage.createParentFolders(container.getParent()) && container instanceof IFolder) {
            try {
                ((IFolder)container).create(true, true, null);
            }
            catch (CoreException e) {
                throw Util.rethrow((Throwable)e);
            }
            return true;
        }
        return false;
    }

    public static String computeSourceFileLocationFromPdpFileLocation(String pdpSourceFilelocation, String _oldPdpRootPath, String _oldGenRootPath) {
        Path path = new Path(pdpSourceFilelocation);
        String projectName = path.segment(0);
        String sourceFileLocation = pdpSourceFilelocation.substring(projectName.length() + 2, pdpSourceFilelocation.length() - "pdp".length());
        if (_oldGenRootPath == null && _oldPdpRootPath == null) {
            return sourceFileLocation;
        }
        String genRoot = _oldGenRootPath;
        String pdpRoot = _oldPdpRootPath;
        if (genRoot == null) {
            genRoot = "";
        }
        if (pdpRoot == null || pdpRoot.trim().length() == 0) {
            pdpRoot = genRoot;
        }
        if (genRoot.equals(pdpRoot)) {
            return sourceFileLocation;
        }
        int index = sourceFileLocation.indexOf(pdpRoot);
        return sourceFileLocation.substring(index + pdpRoot.length() + 1);
    }
}

