/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pdppath.nature;

import com.ibm.pdp.pdppath.nature.IPdpPathTag;
import com.ibm.pdp.pdppath.nature.PDPPath;
import com.ibm.pdp.util.Util;
import java.io.IOException;
import java.io.InputStream;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class PDPPathParser
extends DefaultHandler
implements IPdpPathTag {
    private PDPPath _pdppp = null;
    private XMLReader _parser;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public PDPPathParser() {
        try {
            this._parser = XMLReaderFactory.createXMLReader();
            this._parser.setContentHandler(new PDPTargetContentHandler());
            this._parser.setDTDHandler(this);
            this._parser.setEntityResolver(this);
            this._parser.setErrorHandler(this);
        }
        catch (SAXException e) {
            throw Util.rethrow((Throwable)e);
        }
    }

    public PDPPath parse(InputStream inputStream) {
        this._pdppp = new PDPPath();
        try {
            if (this._parser != null) {
                this._parser.parse(new InputSource(inputStream));
            }
        }
        catch (SAXException e) {
            throw Util.rethrow((Throwable)e);
        }
        catch (IOException e) {
            throw Util.rethrow((Throwable)e);
        }
        return this._pdppp;
    }

    private class PDPTargetContentHandler
    implements ContentHandler {
        private PDPTargetContentHandler() {
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            if (localName.equals("pdp_path")) {
                String version = atts.getValue("version");
                if (version.equals("1.0") && atts.getValue("rppRootPath") == null) {
                    PDPPathParser.this._pdppp.setRppRootPath("");
                } else {
                    PDPPathParser.this._pdppp.setRppRootPath(atts.getValue("rppRootPath"));
                }
                PDPPathParser.this._pdppp.setMetaRootPath(atts.getValue("pdpRootPath"));
                PDPPathParser.this._pdppp.setGenRootPath(atts.getValue("genRootPath"));
            }
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
        }

        @Override
        public void setDocumentLocator(Locator locator) {
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }
    }
}

