/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pdppath.nature;

import com.ibm.pdp.pdppath.nature.PDPPath;
import com.ibm.pdp.pdppath.nature.PDPPathParser;
import com.ibm.pdp.pdppath.nature.PDPPathSerializer;
import com.ibm.pdp.util.Util;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;

public class PDPPathNature
implements IProjectNature {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2014.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static boolean isRppRootFolderRenamingInProgress = false;
    public static final String _NATURE_ID = "com.ibm.pdp.pdppath.PDPPathNature";
    public static final String _PDP_TARGET_PROJECT_PROPERTIES_FILENAME = ".pdppath";
    private IProject _project;
    private PDPPath _projectProperties;

    public void configure() throws CoreException {
    }

    public void deconfigure() throws CoreException {
    }

    private String encodePdpProject(PDPPath pdppp) {
        PDPPathSerializer serializer = new PDPPathSerializer();
        return serializer.serialize(pdppp);
    }

    public static PDPPathNature getNature(String projectName) {
        PDPPathNature nature = null;
        if (projectName == null || projectName.length() == 0) {
            return null;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (project.exists()) {
            try {
                nature = (PDPPathNature)project.getNature(_NATURE_ID);
            }
            catch (CoreException coreException) {}
        }
        return nature;
    }

    PDPPath getPdpProjectProperties() {
        if (this._projectProperties == null) {
            IFile designPathFile;
            this._projectProperties = new PDPPath();
            IProject project = this.getProject();
            if (project.isAccessible() && (designPathFile = this.getProject().getFile(_PDP_TARGET_PROJECT_PROPERTIES_FILENAME)).exists()) {
                try {
                    InputStream inputStream = designPathFile.getContents();
                    PDPPathParser parser = new PDPPathParser();
                    this._projectProperties = parser.parse(inputStream);
                }
                catch (CoreException e) {
                    throw Util.rethrow((Throwable)e);
                }
            }
        }
        return this._projectProperties;
    }

    public String getGenRootPath() {
        return this.getPdpProjectProperties().getGenRootPath();
    }

    public String getMetaRootPath() {
        return this.getPdpProjectProperties().getMetaRootPath();
    }

    public String getRppRootPath() {
        return this.getPdpProjectProperties().getRppRootPath();
    }

    public IProject getProject() {
        return this._project;
    }

    public boolean savePdpPath(String rppRootPath, String genRootPath, String metaRootPath) {
        if (!this.getProject().isAccessible()) {
            return false;
        }
        PDPPath pdppp = new PDPPath();
        pdppp.setRppRootPath(rppRootPath);
        pdppp.setGenRootPath(genRootPath);
        pdppp.setMetaRootPath(metaRootPath);
        if (this.getPdpProjectProperties().isEqualsTo(pdppp)) {
            return false;
        }
        try {
            this.setSharedProperty(_PDP_TARGET_PROJECT_PROPERTIES_FILENAME, this.encodePdpProject(pdppp));
            this._projectProperties = pdppp;
        }
        catch (CoreException e) {
            throw Util.rethrow((Throwable)e);
        }
        return true;
    }

    public void setProject(IProject project) {
        this._project = project;
    }

    public void setSharedProperty(String key, String value) throws CoreException {
        IFile resourceFile = this.getProject().getFile(key);
        byte[] bytes = value.getBytes();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        if (resourceFile.exists()) {
            resourceFile.setContents((InputStream)inputStream, 1, null);
        } else {
            resourceFile.create((InputStream)inputStream, 1, null);
        }
    }
}

