/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pdppath;

import com.ibm.pdp.pdppath.interfaces.IPDPPathUpdate;
import com.ibm.pdp.util.Util;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class PDPPathUpdateExtensionMgr {
    private static final String PREFIX = "com.ibm.pdp.pdppath";
    private static final String PDP_PATH_UPDATE_EXTPOINT_ID = "pdpPathUpdate";
    private static List<IPDPPathUpdate> pdpPathUpdateExt = null;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public static List<IPDPPathUpdate> getPdpPathUpdateExtensions() {
        if (pdpPathUpdateExt == null) {
            pdpPathUpdateExt = new ArrayList<IPDPPathUpdate>();
            PDPPathUpdateExtensionMgr.loadExtensionPoints(PDP_PATH_UPDATE_EXTPOINT_ID);
        }
        return pdpPathUpdateExt;
    }

    private static void loadExtensionPoints(String extensionPoint) {
        IExtensionRegistry extRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extPoint = extRegistry.getExtensionPoint(PREFIX, extensionPoint);
        if (extPoint == null) {
            return;
        }
        IExtension[] extensions = extPoint.getExtensions();
        int extensionsNb = extensions.length;
        int i = 0;
        while (i < extensionsNb) {
            IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
            int configElementsNb = configElements.length;
            int j = 0;
            while (j < configElementsNb) {
                IConfigurationElement configElement = configElements[j];
                if (configElement.getName().equals(extensionPoint)) {
                    IPDPPathUpdate pdpPathUpdExt;
                    try {
                        pdpPathUpdExt = (IPDPPathUpdate)configElement.createExecutableExtension("class");
                    }
                    catch (CoreException e) {
                        throw Util.rethrow((Throwable)e);
                    }
                    pdpPathUpdateExt.add(pdpPathUpdExt);
                }
                ++j;
            }
            ++i;
        }
    }
}

