/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.xrefs;

import com.ibm.icu.text.SimpleDateFormat;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class RppFormatter
extends Formatter {
    SimpleDateFormat simpleFormat = new SimpleDateFormat();
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2015.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    @Override
    public String format(LogRecord r) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.simpleFormat.format(new Date(r.getMillis()))).append(" ");
        sb.append(r.getLevel().getName()).append(" : ");
        sb.append(this.formatMessage(r)).append(System.getProperty("line.separator"));
        if (r.getThrown() != null) {
            sb.append("Throwable occurred: ");
            Throwable t = r.getThrown();
            PrintWriter pw = null;
            try {
                StringWriter sw = new StringWriter();
                pw = new PrintWriter(sw);
                t.printStackTrace(pw);
                sb.append(sw.toString());
            }
            catch (Throwable throwable) {
                if (pw != null) {
                    try {
                        pw.close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            if (pw != null) {
                try {
                    pw.close();
                }
                catch (Exception exception) {}
            }
        }
        return sb.toString();
    }
}

