/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.xrefs;

import com.ibm.pdp.framework.ControllerFactory;
import com.ibm.pdp.framework.GenerationManager;
import com.ibm.pdp.framework.MigrationHelpTool;
import com.ibm.pdp.framework.PdpTool;
import com.ibm.pdp.framework.ResourceLink;
import com.ibm.pdp.framework.interfaces.IController;
import com.ibm.pdp.framework.interfaces.IGenStatus;
import com.ibm.pdp.framework.interfaces.IStatusMessage;
import com.ibm.pdp.pacbase.generator.CobolCompare;
import com.ibm.pdp.pacbase.xrefs.RppFormatter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.resources.IFile;

public class RestoreGeneratedReferences {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2015, 2018.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static int READ = 1;
    public static int WRITE = 0;
    private static String LOG_FILE = ".restoreGenRefs.log";
    private static String FOLDER_LOG_FILE = "/.metadata/";
    private static Logger _logger = null;
    public static String reportFilePath = null;

    public static String getWorkspaceFolder() {
        return PdpTool.getWorkspaceFolder();
    }

    public static Logger getLogger() throws Exception {
        if (_logger != null) {
            return _logger;
        }
        _logger = Logger.getLogger(RestoreGeneratedReferences.class.getName());
        reportFilePath = LOG_FILE;
        boolean append = true;
        reportFilePath = String.valueOf(RestoreGeneratedReferences.getWorkspaceFolder()) + FOLDER_LOG_FILE + reportFilePath;
        FileHandler handler = new FileHandler(reportFilePath, append);
        _logger.setUseParentHandlers(false);
        _logger.addHandler(handler);
        _logger.setLevel(Level.FINEST);
        handler.setFormatter(new RppFormatter());
        return _logger;
    }

    public static void log(int statusGravity, String message) {
        try {
            if (statusGravity == 4) {
                RestoreGeneratedReferences.getLogger().log(Level.SEVERE, message);
            } else if (statusGravity == 2) {
                RestoreGeneratedReferences.getLogger().log(Level.WARNING, message);
            } else {
                RestoreGeneratedReferences.getLogger().log(Level.INFO, message);
            }
        }
        catch (Exception exception) {
            System.out.println("Cannot create the log file.");
            return;
        }
    }

    public static void log(String message, Throwable e) {
        try {
            RestoreGeneratedReferences.getLogger().log(Level.SEVERE, message, e);
        }
        catch (Exception exception) {
            System.out.println("Cannot create the log file.");
        }
    }

    public static void restoreReferences(boolean writeMode, String cobolsToIgnoreFile, String cobolsToManageFile, boolean listSourceFiles) {
        System.out.println("Start analyzing");
        if (listSourceFiles) {
            RestoreGeneratedReferences.listSourceFiles();
            return;
        }
        ControllerFactory.getInstance().removeResourceChangeListener();
        String mess = "Start analysing : Write Mode :" + writeMode + "   COBOLs To Ignore file :" + (cobolsToIgnoreFile == null ? "none" : cobolsToIgnoreFile) + "   COBOLs to manage File:" + (cobolsToManageFile == null ? "none" : cobolsToManageFile);
        RestoreGeneratedReferences.log(1, mess);
        HashSet<String> cobolsToIgnore = new HashSet<String>();
        ArrayList<String> cobolsToManage = new ArrayList<String>();
        boolean fileLoaded = RestoreGeneratedReferences.loadFile(cobolsToIgnoreFile, cobolsToIgnore);
        if (!fileLoaded) {
            return;
        }
        fileLoaded = RestoreGeneratedReferences.loadFile(cobolsToManageFile, cobolsToManage);
        if (!fileLoaded) {
            return;
        }
        List<String> sourceFiles = RestoreGeneratedReferences.findAllSourceFiles(cobolsToManage);
        int size = sourceFiles.size();
        int i = 1;
        ArrayList<String> notFoundCblOrPdpCobols = new ArrayList<String>();
        ArrayList<String> notImpactedCobol = new ArrayList<String>();
        ArrayList<String> regenerationErrorCobols = new ArrayList<String>();
        ArrayList<String> dephasedCobol = new ArrayList<String>();
        ArrayList<String> cobolsToSave = new ArrayList<String>();
        for (String sourceFileLocation : sourceFiles) {
            String message;
            boolean differenceDetected;
            System.out.println(String.valueOf(++i) + "/" + size + "                " + sourceFileLocation);
            if (cobolsToIgnore.contains(sourceFileLocation)) {
                String message2 = "Following source file is ignored :" + sourceFileLocation;
                notImpactedCobol.add(sourceFileLocation);
                RestoreGeneratedReferences.log(1, message2);
                continue;
            }
            IController controller = ControllerFactory.getInstance().getController(sourceFileLocation);
            if (controller == null) {
                String message3 = "Source file or PDP file not found for source file :" + sourceFileLocation;
                notFoundCblOrPdpCobols.add(sourceFileLocation);
                RestoreGeneratedReferences.log(4, message3);
                continue;
            }
            String cobolBeforeReGeneration = controller.getTextProcessor().getText().toString();
            Iterator iter = controller.getGenerationLink().getSubReferences();
            int generationSubRefCount = 0;
            while (iter.hasNext()) {
                iter.next();
                ++generationSubRefCount;
            }
            ((ResourceLink)controller.getResourceLink()).suspendGenerationBeforeSaving = true;
            Iterator referencesIterator = controller.getGenerationLink().getSubReferences();
            String logicalDesignName = MigrationHelpTool.getLogicalDesignName((Iterator)referencesIterator);
            String realFileName = PdpTool.addRPPFolderToFileName((String)logicalDesignName);
            IGenStatus genStatus = GenerationManager.generate((String)realFileName, (String)controller.getPattern().getName(), null, null).getGenStatus();
            if (genStatus != null && genStatus.getState() == 1) {
                regenerationErrorCobols.add(sourceFileLocation);
                StringBuilder sb = new StringBuilder();
                sb.append("Generation Failed for :");
                sb.append(sourceFileLocation);
                Iterator messageIter = genStatus.getMessages();
                while (messageIter.hasNext()) {
                    IStatusMessage iStatusMessage = (IStatusMessage)messageIter.next();
                    sb.append("\n");
                    sb.append(iStatusMessage.getText());
                }
                RestoreGeneratedReferences.log(4, sb.toString());
                continue;
            }
            String cobolAfterRegeneration = controller.getTextProcessor().getText().toString();
            iter = controller.getGenerationLink().getSubReferences();
            int generationSubRefCount2 = 0;
            while (iter.hasNext()) {
                iter.next();
                ++generationSubRefCount2;
            }
            if (generationSubRefCount == generationSubRefCount2) {
                String message4 = String.valueOf(sourceFileLocation) + "  Sub references are corrects. No modification for this COBOL.";
                RestoreGeneratedReferences.log(1, message4);
                notImpactedCobol.add(sourceFileLocation);
                continue;
            }
            System.out.println("The generationSubRefs are differents :" + generationSubRefCount + " " + generationSubRefCount2);
            boolean bl = differenceDetected = !CobolCompare.compare(cobolBeforeReGeneration, cobolAfterRegeneration);
            if (differenceDetected) {
                dephasedCobol.add(sourceFileLocation);
                message = String.valueOf(sourceFileLocation) + " This COBOL after re-generation is different (The COBOL may be desynchronized). The COBOL will NOT be saved.";
                RestoreGeneratedReferences.log(2, message);
                continue;
            }
            cobolsToSave.add(sourceFileLocation);
            message = String.valueOf(sourceFileLocation) + "  Incorrect sub-references, same COBOL. The COBOL will be saved.";
            RestoreGeneratedReferences.log(1, message);
            if (writeMode) {
                GenerationManager.saveController((boolean)true, (IController)controller);
            }
            ControllerFactory.getInstance().dispose(controller);
            ((ResourceLink)controller.getResourceLink()).suspendGenerationBeforeSaving = false;
        }
        RestoreGeneratedReferences.logRepport(notFoundCblOrPdpCobols, notImpactedCobol, regenerationErrorCobols, dephasedCobol, cobolsToSave, writeMode);
    }

    private static void listSourceFiles() {
        ArrayList<String> cobolsToManage = new ArrayList<String>();
        List<String> sourceFiles = RestoreGeneratedReferences.findAllSourceFiles(cobolsToManage);
        StringBuilder sb = new StringBuilder();
        String lineSeparator = "\r\n";
        sb.append(lineSeparator);
        sb.append("All source files in workspace");
        sb.append(lineSeparator);
        for (String source : sourceFiles) {
            sb.append(lineSeparator);
            sb.append(source);
        }
        RestoreGeneratedReferences.log(1, sb.toString());
    }

    private static void logRepport(ArrayList<String> notFoundCblOrPdpCobols, ArrayList<String> notImpactedCobols, ArrayList<String> regenerationErrorCobols, ArrayList<String> dephasedCobols, ArrayList<String> cobolsToSave, boolean writeMode) {
        StringBuilder sb = new StringBuilder();
        String lineSeparator = "\r\n";
        sb.append(lineSeparator);
        sb.append("********************************************************************************************************");
        sb.append(lineSeparator);
        sb.append("Not Impacted COBOLS");
        for (String notImpactedCobol : notImpactedCobols) {
            sb.append(lineSeparator);
            sb.append(notImpactedCobol);
        }
        sb.append(lineSeparator);
        sb.append(lineSeparator);
        if (writeMode) {
            sb.append("COBOLs saved.");
        } else {
            sb.append("COBOLs to save.");
        }
        for (String cobolToSave : cobolsToSave) {
            sb.append(lineSeparator);
            sb.append(cobolToSave);
        }
        sb.append(lineSeparator);
        sb.append(lineSeparator);
        sb.append("Not found CBL or PDP files");
        for (String notFoundCblOrPdpCobol : notFoundCblOrPdpCobols) {
            sb.append(lineSeparator);
            sb.append(notFoundCblOrPdpCobol);
        }
        sb.append(lineSeparator);
        sb.append(lineSeparator);
        sb.append("Regeneration failed COBOLS:");
        for (String regenerationErrorCobol : regenerationErrorCobols) {
            sb.append(lineSeparator);
            sb.append(regenerationErrorCobol);
        }
        sb.append(lineSeparator);
        sb.append(lineSeparator);
        sb.append("Dephased COBOLS:");
        for (String dephasedCobol : dephasedCobols) {
            sb.append(lineSeparator);
            sb.append(dephasedCobol);
        }
        RestoreGeneratedReferences.log(1, sb.toString());
    }

    private static List<String> findAllSourceFiles(ArrayList<String> cobolsToManage) {
        if (cobolsToManage.size() == 0) {
            ArrayList<String> sourceFiles = new ArrayList<String>();
            List pdpFiles = PdpTool.findAllPDPFiles(null);
            for (IFile pdpFile : pdpFiles) {
                if (!pdpFile.getName().endsWith("cblpdp")) continue;
                String pdpFileLocation = pdpFile.getFullPath().toString();
                String sourceFileLocation = PdpTool.computeSourceFileLocationFromPdpFileLocation((String)pdpFileLocation);
                sourceFiles.add(sourceFileLocation);
            }
            return sourceFiles;
        }
        return cobolsToManage;
    }

    private static boolean loadFile(String cobolsFile, ArrayList<String> cobols) {
        boolean emptyFile = true;
        if (cobolsFile == null) {
            return true;
        }
        File file = new File(cobolsFile);
        if (!file.exists()) {
            RestoreGeneratedReferences.log(4, "File not found : " + cobolsFile);
            return false;
        }
        String line = null;
        BufferedReader br = RestoreGeneratedReferences.getBuffer(cobolsFile);
        try {
            while ((line = br.readLine()) != null) {
                if (line.startsWith("//")) continue;
                emptyFile = false;
                cobols.add(line.trim());
            }
            br.close();
        }
        catch (IOException io) {
            io.printStackTrace();
        }
        if (emptyFile) {
            RestoreGeneratedReferences.log(4, "Empty file : " + cobolsFile);
            return false;
        }
        return true;
    }

    private static boolean loadFile(String cobolsFile, HashSet<String> cobols) {
        boolean emptyFile = true;
        if (cobolsFile == null) {
            return true;
        }
        File file = new File(cobolsFile);
        if (!file.exists()) {
            RestoreGeneratedReferences.log(4, "File not found : " + cobolsFile);
            return false;
        }
        String line = null;
        BufferedReader br = RestoreGeneratedReferences.getBuffer(cobolsFile);
        try {
            while ((line = br.readLine()) != null) {
                if (line.startsWith("//")) continue;
                emptyFile = false;
                cobols.add(line.trim());
            }
            br.close();
        }
        catch (IOException io) {
            io.printStackTrace();
        }
        if (emptyFile) {
            RestoreGeneratedReferences.log(4, "Empty file : " + cobolsFile);
            return false;
        }
        return true;
    }

    private static BufferedReader getBuffer(String filename) {
        BufferedReader br = null;
        try {
            FileReader fis = new FileReader(filename);
            br = new BufferedReader(fis);
        }
        catch (FileNotFoundException fileNotFoundException) {
            br = null;
        }
        return br;
    }
}

