/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.xrefs;

import com.ibm.pdp.engine.IGeneratedTag;
import com.ibm.pdp.engine.ITagProperties;
import com.ibm.pdp.engine.ITextProcessor;
import com.ibm.pdp.engine.internal.ITextSegment;
import com.ibm.pdp.engine.tree.IEditTree;
import com.ibm.pdp.engine.tree.ITextNode;
import com.ibm.pdp.framework.PdpTool;
import com.ibm.pdp.framework.Trace;
import com.ibm.pdp.framework.interfaces.IController;
import com.ibm.pdp.framework.interfaces.IReference;
import com.ibm.pdp.mdl.link.design.CobolVariablesScanner;
import com.ibm.pdp.mdl.link.design.DichoSearch;
import com.ibm.pdp.mdl.link.design.MPReferencesFinder;
import com.ibm.pdp.mdl.link.design.MicroPatternsAndDEUsagesResults;
import com.ibm.pdp.mdl.link.design.RubriqueToken;
import com.ibm.pdp.mdl.link.design.RubriqueUsage;
import com.ibm.pdp.mdl.link.design.Util;
import com.ibm.pdp.mdl.meta.Reference;
import com.ibm.pdp.pacbase.extension.matching.BasicPacLabelRecognizer;
import com.ibm.pdp.pacbase.extension.matching.PacLabel;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class CobolMicroPatternsAndDEUsagesParser {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2013, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String DATAELEMENT_SUFFIX = ".dataelement";
    private static final String DATAELEMENT = "dataelement";
    private static final String DATA_DIVISION = "DATA DIVISION.";
    private static final String PROCEDURE_DIVISION = "PROCEDURE DIVISION";
    private static final String MICRO_PATTERN_START = "*!W";
    private String CR = PdpTool.EOL;
    private int CR_LENGTH = this.CR.length();
    private static final String MICRO_PATTERN_PROPERTY = "mp";
    private static final String MSP_PROPERTY = "msp";
    private static final String MP_WITH_LOW_VALUE_ORIGIN = "lowMPFrom";
    private String _text;
    private int _procDivOffset;
    private int _dataDivOffset;
    private int _procDivLineNumber;
    private String _documentId;
    private IController _controler;
    private ITextProcessor _textProcessor;
    private IEditTree _editTree;
    private CobolVariablesScanner _cobolVariablesScanner = new CobolVariablesScanner();

    protected String getStringFromStream(InputStream stream) {
        long a = System.currentTimeMillis();
        String result = "";
        try {
            result = Util.convertStreamToString((InputStream)stream);
        }
        catch (IOException exc) {
            throw new RuntimeException(exc);
        }
        long b = System.currentTimeMillis();
        if (Trace.traceOn) {
            Trace.outPrintln((String)("DesignReferencesFinder.getStringFromStream elapsed = " + (b - a)));
        }
        return result;
    }

    private List<RubriqueUsage> findRubriquesOfProcDiv2(int counter, int lineNumber, String line, List<String> dataElements) {
        ArrayList<RubriqueUsage> result = new ArrayList<RubriqueUsage>(2);
        List variablesInLine = this._cobolVariablesScanner.findVariables(line);
        int i = 0;
        while (i < variablesInLine.size()) {
            RubriqueToken aToken = (RubriqueToken)variablesInLine.get(i);
            String aTokenName = aToken.getName();
            int idx = DichoSearch.search((String)aTokenName, dataElements);
            if (idx >= 0) {
                String macroName;
                int debut = counter + aToken.getIndexInLine();
                int fin = debut + aTokenName.length();
                RubriqueUsage ru = new RubriqueUsage(aTokenName, debut, fin, lineNumber, counter, line.substring(0, line.length() - this.CR_LENGTH));
                String pacFunction = this.searchEncompassingPacFunction(debut);
                ru.setEncompassingPacFunction(pacFunction);
                ITextNode node = this._editTree.includingNode(debut, fin);
                if (node != null && (macroName = this.getMacroName(node)) != null) {
                    ru.setMacroName(macroName);
                }
                result.add(ru);
            }
            ++i;
        }
        return result;
    }

    private String searchEncompassingPacFunction(int start) {
        int counter = start;
        while (counter > this._procDivOffset) {
            int debut = PdpTool.getLineStartOffset((CharSequence)this._text, (int)(counter - this.CR_LENGTH));
            String line = this._text.substring(debut, counter);
            PacLabel pl = BasicPacLabelRecognizer.findPacbaseLabelInLine(line);
            if (pl != null) {
                return pl.getPacLabel();
            }
            counter = debut;
        }
        return null;
    }

    private boolean isProcedureLineASpecificLine(int beginOffset, int endOffset) {
        String prop;
        IGeneratedTag genTag;
        if (!this.isFullyGenerated(beginOffset, endOffset)) {
            return true;
        }
        ITextNode node = this._editTree.includingNode(beginOffset, endOffset);
        if (node == null) {
            return false;
        }
        return node.beginIndex() >= beginOffset && node.endIndex() <= endOffset && (genTag = node.enclosingGeneratedTag()) != null && (prop = genTag.getProperty(MICRO_PATTERN_PROPERTY)) != null;
    }

    /*
     * Unable to fully structure code
     */
    private boolean isFullyGenerated(int beginOffset, int endOffset) {
        segments = this._textProcessor.segments(beginOffset, endOffset);
        segment = null;
        while (segments.hasNext()) {
            segment = (ITextSegment)segments.next();
            if (segment.endIndex() > beginOffset) break;
        }
        if (segment == null || segment.beginIndex() >= endOffset) {
            return true;
        }
        if (!segment.isFromMacro() && segment.isGenerated()) ** GOTO lbl16
        return false;
lbl-1000:
        // 1 sources

        {
            segment = (ITextSegment)segments.next();
            if (segment.beginIndex() >= endOffset) {
                return true;
            }
            if (!segment.isFromMacro() && segment.isGenerated()) continue;
            return false;
lbl16:
            // 2 sources

            ** while (segments.hasNext())
        }
lbl17:
        // 1 sources

        return true;
    }

    private String findRubriqueInLine2(String line, List<String> declaredDataElements) {
        int len = line.length();
        if (len < 10) {
            return null;
        }
        List vars = this._cobolVariablesScanner.findVariables(line);
        if (vars.size() == 0) {
            return null;
        }
        RubriqueToken token = (RubriqueToken)vars.get(0);
        if (DichoSearch.search((String)token.getShortName(), declaredDataElements) > -1) {
            return token.getName();
        }
        return null;
    }

    private boolean isDeclarationLineAGeneratedLineOrMP(int beginOffset, int endOffset) {
        if (this.isFullyGenerated(beginOffset, endOffset)) {
            return true;
        }
        int x = PdpTool.getLineStartOffset((CharSequence)this._text, (int)(beginOffset - this.CR_LENGTH));
        String previousLine = this._text.substring(x, beginOffset);
        return previousLine.length() > 10 && previousLine.startsWith(MICRO_PATTERN_START, 6);
    }

    private List<String> scanDataDivToFindCompleteNames(List<String> declaredDataElements) {
        ArrayList<String> completeRubNames = new ArrayList<String>();
        int counter = this._dataDivOffset;
        String rubName = null;
        while (counter < this._procDivOffset) {
            int end = PdpTool.getLineEndOffset((CharSequence)this._text, (int)counter);
            String line = this._text.substring(counter, end);
            boolean b = this.isDeclarationLineAGeneratedLineOrMP(counter, end);
            if (!b) {
                counter = end;
                continue;
            }
            rubName = this.findRubriqueInLine2(line, declaredDataElements);
            if (rubName == null) {
                counter = end;
                continue;
            }
            completeRubNames.add(rubName);
            counter = end;
        }
        return completeRubNames;
    }

    private List<String> buildDataElementsShortNamesList(Map<String, List<Reference>> mpDesignRefs) {
        TreeSet<String> dataElementsDeclared = new TreeSet<String>();
        int dataElementSuffix_Len = DATAELEMENT_SUFFIX.length();
        Iterator subRefs = this._controler.getGenerationLink().getSubReferences();
        IReference ref = null;
        while (subRefs.hasNext()) {
            ref = (IReference)subRefs.next();
            if (!ref.getType().equals(DATAELEMENT)) continue;
            dataElementsDeclared.add(ref.getName());
        }
        Iterator<String> keyIter = mpDesignRefs.keySet().iterator();
        if (keyIter.hasNext()) {
            List<Reference> mpRefs = mpDesignRefs.get(keyIter.next());
            int i = 0;
            while (i < mpRefs.size()) {
                Reference aRef = mpRefs.get(i);
                String targetId = aRef.getTargetId();
                if (targetId.endsWith(DATAELEMENT_SUFFIX)) {
                    int idx = targetId.lastIndexOf(47);
                    if (idx != -1) {
                        dataElementsDeclared.add(targetId.substring(idx + 1, targetId.length() - dataElementSuffix_Len));
                    } else {
                        dataElementsDeclared.add(targetId.substring(targetId.length() - dataElementSuffix_Len));
                    }
                }
                ++i;
            }
        }
        ArrayList<String> result = new ArrayList<String>(dataElementsDeclared.size());
        result.addAll(dataElementsDeclared);
        return result;
    }

    private String getMacroName(ITextNode aNode) {
        if (!aNode.isTagged()) {
            return null;
        }
        ITagProperties properties = aNode.getProperties();
        if (properties != null) {
            String mspName = properties.getProperty(MSP_PROPERTY);
            if (mspName != null && !mspName.isEmpty()) {
                return mspName;
            }
            String microPatternWithLowValue = properties.getProperty(MP_WITH_LOW_VALUE_ORIGIN);
            if (microPatternWithLowValue != null) {
                return microPatternWithLowValue;
            }
        }
        return null;
    }

    private List<RubriqueUsage> scanProcDivToFindUsages(List<String> dataElementsCompleteNames) {
        int counter = this._procDivOffset;
        int endFileOffset = this._text.length();
        int lineNumber = this._procDivLineNumber;
        ArrayList<RubriqueUsage> rubUsages = new ArrayList<RubriqueUsage>();
        while (counter < endFileOffset) {
            int end = PdpTool.getLineEndOffset((CharSequence)this._text, (int)counter);
            String line = this._text.substring(counter, end);
            if (line.length() < 10 || line.charAt(6) == '*' && line.charAt(7) != '!') {
                counter = end;
                ++lineNumber;
                continue;
            }
            if (!this.isProcedureLineASpecificLine(counter, end)) {
                counter = end;
                ++lineNumber;
                continue;
            }
            List<RubriqueUsage> x = this.findRubriquesOfProcDiv2(counter, lineNumber, line, dataElementsCompleteNames);
            if (x.size() > 0) {
                rubUsages.addAll(x);
            }
            ++lineNumber;
            counter = end;
        }
        return rubUsages;
    }

    private void init() {
        this._dataDivOffset = 0;
        this._procDivOffset = 0;
        int counter = 0;
        int endFileOffset = this._text.length();
        int lineNumber = 1;
        boolean dataDivFound = false;
        while (counter < endFileOffset) {
            int end = PdpTool.getLineEndOffset((CharSequence)this._text, (int)counter);
            String line = this._text.substring(counter, end);
            if (!dataDivFound && line.length() >= 20 && line.substring(6).trim().startsWith(DATA_DIVISION)) {
                this._dataDivOffset = end;
                dataDivFound = true;
            }
            if (line.length() >= 25 && line.substring(6).trim().startsWith(PROCEDURE_DIVISION)) {
                this._procDivOffset = end;
                this._procDivLineNumber = lineNumber + 1;
                break;
            }
            ++lineNumber;
            counter = end;
        }
    }

    private List<Reference> createRubUsagesReferences(List<RubriqueUsage> rubUsages) {
        ArrayList<Reference> references = new ArrayList<Reference>(rubUsages.size());
        int size = rubUsages.size();
        Reference aReference = null;
        int i = 0;
        while (i < size) {
            RubriqueUsage ru = rubUsages.get(i);
            aReference = ru.convertIntoReference(this._documentId);
            references.add(aReference);
            ++i;
        }
        return references;
    }

    public MicroPatternsAndDEUsagesResults parse(String fileName, IController controler) {
        long a = System.currentTimeMillis();
        this._controler = controler;
        this._textProcessor = this._controler.getTextProcessor();
        this._text = this._textProcessor.getText().toString();
        this._editTree = this._textProcessor.getEditTree();
        this._documentId = fileName;
        this._dataDivOffset = 0;
        this._procDivOffset = 0;
        this.init();
        MicroPatternsAndDEUsagesResults drr = new MicroPatternsAndDEUsagesResults();
        drr.setDocumentId(this._documentId);
        MPReferencesFinder mprf = new MPReferencesFinder();
        Map mpDesignRefs = mprf.parse(this._documentId, this._text);
        Iterator iter = mpDesignRefs.keySet().iterator();
        if (iter.hasNext()) {
            drr.setMicroPatternRefs((List)mpDesignRefs.get(iter.next()));
        }
        if (this._procDivOffset == 0) {
            return drr;
        }
        long oo = System.currentTimeMillis();
        List<String> dataElementsList = this.buildDataElementsShortNamesList(mpDesignRefs);
        long pp = System.currentTimeMillis();
        if (Trace.traceOn) {
            Trace.outPrintln((String)("buildDataElementsShortNamesList(). elapsed=" + (pp - oo)));
        }
        long qq = System.currentTimeMillis();
        List<String> deCompleteNames = this.scanDataDivToFindCompleteNames(dataElementsList);
        long rr = System.currentTimeMillis();
        if (Trace.traceOn) {
            Trace.outPrintln((String)("scanDataDivToFindCompleteNames(). elapsed=" + (rr - qq)));
        }
        long tt = System.currentTimeMillis();
        Collections.sort(deCompleteNames);
        List<RubriqueUsage> rubUsages = this.scanProcDivToFindUsages(deCompleteNames);
        long uu = System.currentTimeMillis();
        if (Trace.traceOn) {
            Trace.outPrintln((String)("scanProcDivToFindUsages(). elapsed=" + (uu - tt)));
        }
        List<Reference> references = this.createRubUsagesReferences(rubUsages);
        drr.setDetailedUsages(references);
        long b = System.currentTimeMillis();
        if (Trace.traceOn) {
            Trace.outPrintln((String)("DesignReferencesFinder.parse(). elapsed=" + (b - a)));
        }
        return drr;
    }

    public int getProcDivOffset() {
        return this._procDivOffset;
    }

    public static void main(String[] args) {
    }
}

