/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.xrefs;

import com.ibm.pdp.engine.IBuilderTag;
import com.ibm.pdp.engine.IGeneratedInfo;
import com.ibm.pdp.engine.turbo.impl.GenInfoBuilder;
import com.ibm.pdp.explorer.model.PTLocation;
import com.ibm.pdp.explorer.model.PTModelManager;
import com.ibm.pdp.explorer.model.service.PTModelService;
import com.ibm.pdp.framework.ControllerFactory;
import com.ibm.pdp.framework.GenerationLink;
import com.ibm.pdp.framework.GenerationManager;
import com.ibm.pdp.framework.MigrationHelpTool;
import com.ibm.pdp.framework.PdpTool;
import com.ibm.pdp.framework.ResourceLink;
import com.ibm.pdp.framework.interfaces.IController;
import com.ibm.pdp.framework.interfaces.IGenStatus;
import com.ibm.pdp.framework.interfaces.IGenerationLink;
import com.ibm.pdp.framework.interfaces.IPattern;
import com.ibm.pdp.framework.interfaces.IStatusMessage;
import com.ibm.pdp.framework.pattern.PdpPatternManager;
import com.ibm.pdp.generation.menu.SynchronizationTool;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.pacbase.PacAbstractDialog;
import com.ibm.pdp.mdl.pacbase.PacAbstractDialogServer;
import com.ibm.pdp.mdl.pacbase.PacDialog;
import com.ibm.pdp.mdl.pacbase.PacDialogTypeValues;
import com.ibm.pdp.mdl.pacbase.PacGenerationHeader;
import com.ibm.pdp.mdl.pacbase.PacLibrarySubstitutionGenerationHeader;
import com.ibm.pdp.mdl.pacbase.PacProgram;
import com.ibm.pdp.mdl.pacbase.PacScreen;
import com.ibm.pdp.pacbase.design.ModelUtil;
import com.ibm.pdp.pacbase.generator.CobolCompare;
import com.ibm.pdp.pacbase.xrefs.ControllerAndInformation;
import com.ibm.pdp.pacbase.xrefs.Messages;
import com.ibm.pdp.pacbase.xrefs.RppFormatter;
import com.ibm.pdp.resources.PdpResourcesMgr;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class AnalyzeRegeneratedFiles {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2016, 2018.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String CONSTANTES_PAC = "CONSTANTES-PAC";
    private static final String PACBASE_CONSTANTS = "PACBASE-CONSTANTS";
    private static final String CONSTANTS_TAG = "CONSTANTS";
    private static final String DATE_COMPILED_TAG = "DATE-COMPILED";
    public static final String DATE_COMPILED = "DATE-COMPILED";
    public static int READ = 1;
    public static int WRITE = 0;
    private static String LOG_FILE = ".analyzeRegeneratedFile.log";
    private static String FOLDER_LOG_FILE = "/.metadata/";
    private static final String BLOCK_SESSI = "SESSI:";
    private static final String BLOCK_LIBRA = "LIBRA:";
    private static Logger _logger = null;
    public static String reportFilePath = null;

    public static Logger getLogger() throws Exception {
        if (_logger != null) {
            return _logger;
        }
        _logger = Logger.getLogger(AnalyzeRegeneratedFiles.class.getName());
        reportFilePath = LOG_FILE;
        boolean append = true;
        reportFilePath = String.valueOf(AnalyzeRegeneratedFiles.getWorkspaceFolder()) + FOLDER_LOG_FILE + reportFilePath;
        FileHandler handler = new FileHandler(reportFilePath, append);
        _logger.setUseParentHandlers(false);
        _logger.addHandler(handler);
        _logger.setLevel(Level.FINEST);
        handler.setFormatter(new RppFormatter());
        return _logger;
    }

    public static String getWorkspaceFolder() {
        return PdpTool.getWorkspaceFolder();
    }

    public static void log(int statusGravity, String message) {
        try {
            if (statusGravity == 4) {
                AnalyzeRegeneratedFiles.getLogger().log(Level.SEVERE, message);
            } else if (statusGravity == 2) {
                AnalyzeRegeneratedFiles.getLogger().log(Level.WARNING, message);
            } else {
                AnalyzeRegeneratedFiles.getLogger().log(Level.INFO, message);
            }
        }
        catch (Exception ex) {
            System.out.println("Cannot create the log file..");
            System.out.println(ex.getMessage());
            return;
        }
    }

    public static void analyzeRegeneretedFiles(boolean writeMode, String generatedFilesToIgnoreFile, String generatedFilesToManageFile, boolean listSourceFiles, String dephasedGeneratedFilesDestinationFolderPath) {
        if (listSourceFiles) {
            AnalyzeRegeneratedFiles.listSourceFiles();
            return;
        }
        List locations = PTModelManager.getLocations();
        for (PTLocation ptLocation : locations) {
            ptLocation.open(true, false);
        }
        String writeModeLabel = writeMode ? Messages.AnalyzeRegeneratedFiles_enabled : Messages.AnalyzeRegeneratedFiles_disabled;
        String generatedFilesToIgnoreLabel = generatedFilesToIgnoreFile == null ? Messages.AnalyzeRegeneratedFiles_none : generatedFilesToIgnoreFile;
        String generatedFilesToManageFileLabel = generatedFilesToManageFile == null ? Messages.AnalyzeRegeneratedFiles_none : generatedFilesToManageFile;
        Object[] binding = new Object[]{writeModeLabel, generatedFilesToIgnoreLabel, generatedFilesToManageFileLabel};
        String mess = NLS.bind((String)Messages.AnalyzeRegeneratedFiles_Start_analyzing, (Object[])binding);
        AnalyzeRegeneratedFiles.log(1, mess);
        HashSet<String> generatedFilesToIgnore = new HashSet<String>();
        ArrayList<String> generatedFilesToManage = new ArrayList<String>();
        boolean fileLoaded = AnalyzeRegeneratedFiles.loadFile(generatedFilesToIgnoreFile, generatedFilesToIgnore);
        if (!fileLoaded) {
            return;
        }
        fileLoaded = AnalyzeRegeneratedFiles.loadFile(generatedFilesToManageFile, generatedFilesToManage);
        if (!fileLoaded) {
            return;
        }
        List<String> sourceFiles = AnalyzeRegeneratedFiles.findAllSourceFiles(generatedFilesToManage);
        int size = sourceFiles.size();
        int i = 1;
        ArrayList<String> notFoundCblOrPdpCobols = new ArrayList<String>();
        ArrayList<String> desynchonizedCobol = new ArrayList<String>();
        ArrayList<String> desynchonizedAndDephasedCobol = new ArrayList<String>();
        ArrayList<String> notImpactedCobol = new ArrayList<String>();
        ArrayList<String> regenerationErrorCobols = new ArrayList<String>();
        ArrayList<String> dephasedCobol = new ArrayList<String>();
        ArrayList<String> cobolsToSave = new ArrayList<String>();
        ArrayList<String> genInfoTxtConstantReplacementError = new ArrayList<String>();
        ArrayList<String> genInfoTxtConstantReplacementInfo = new ArrayList<String>();
        ArrayList<String> cobolConstantReplacementError = new ArrayList<String>();
        int desynchronizedCorrected = 0;
        if (sourceFiles.size() != 0) {
            PdpResourcesMgr.getInstance().rebuildWorkspaceGenerationLinks((IProgressMonitor)new NullProgressMonitor());
        }
        ArrayList<String> alreadyDoneByMultipleGeneration = new ArrayList<String>();
        for (String sourceFileLocation : sourceFiles) {
            IController iController;
            boolean generationFailed;
            boolean isSynchronized;
            System.out.println(String.valueOf(i) + "/" + size + "                " + sourceFileLocation);
            ++i;
            if (alreadyDoneByMultipleGeneration.contains(sourceFileLocation)) continue;
            if (generatedFilesToIgnore.contains(sourceFileLocation)) {
                String message = String.valueOf(Messages.AnalyzeRegeneratedFiles_ignored_generated_file) + sourceFileLocation;
                notImpactedCobol.add(sourceFileLocation);
                AnalyzeRegeneratedFiles.log(1, message);
                continue;
            }
            IController controller = ControllerFactory.getInstance().getController(sourceFileLocation);
            if (controller == null) {
                String message = String.valueOf(Messages.AnalyzeRegeneratedFiles_generated_file_or_pdp_file_not_found) + sourceFileLocation;
                notFoundCblOrPdpCobols.add(sourceFileLocation);
                AnalyzeRegeneratedFiles.log(4, message);
                continue;
            }
            String generatedFileBeforeRegeneration = controller.getTextProcessor().getText().toString();
            long generationTimeStamp = controller.getGenerationLink().getGenerationTimeStamp();
            ((ResourceLink)controller.getResourceLink()).suspendGenerationBeforeSaving = true;
            Iterator referencesIterator = controller.getGenerationLink().getSubReferences();
            String logicalDesignName = MigrationHelpTool.getLogicalDesignName((Iterator)referencesIterator);
            String realFileName = PdpTool.addRPPFolderToFileName((String)logicalDesignName);
            String genInfoTextBeforeConstantsGeneration = controller.getTextProcessor().getGeneratedInfo().getText().toString();
            String genInfoId2 = controller.getTextProcessor().getGeneratedInfo().getProperty("GeneratedInfoIdentifier");
            String logicalFileName = controller.getGenerationLink().getGenerationOutput().getLogicalFileName();
            boolean bl = isSynchronized = !SynchronizationTool.checkIfTheGeneratedResourceNeedsRegeneration((String)logicalFileName, (String)sourceFileLocation);
            if (!isSynchronized) {
                desynchonizedCobol.add(String.valueOf(sourceFileLocation) + " (" + realFileName + ")");
            }
            String designId = controller.getDesignLink().getFileId();
            PTModelService.getPath((String)designId);
            ArrayList<ControllerAndInformation> otherControllers = new ArrayList<ControllerAndInformation>();
            AnalyzeRegeneratedFiles.getOtherControllersForTheSameDesignId(controller, designId, otherControllers, alreadyDoneByMultipleGeneration, generatedFilesToIgnore, sourceFiles, desynchonizedCobol, realFileName);
            IGenStatus genStatus = GenerationManager.generate((String)realFileName, (String)controller.getPattern().getName(), null, null).getGenStatus();
            boolean bl2 = generationFailed = genStatus != null && genStatus.getState() == 1;
            if (otherControllers.size() != 0) {
                for (ControllerAndInformation cai : otherControllers) {
                    iController = cai.getController();
                    if (generationFailed || cai.getGeneratedFileBeforeRegeneration() == null) {
                        ((ResourceLink)iController.getResourceLink()).suspendGenerationBeforeSaving = false;
                        ControllerFactory.getInstance().dispose(iController);
                    }
                    if (cai.getGeneratedFileBeforeRegeneration() != null) continue;
                    String message = String.valueOf(Messages.AnalyzeRegeneratedFiles_ignored_generated_file) + iController.getResourceName();
                    notImpactedCobol.add(iController.getResourceName());
                    AnalyzeRegeneratedFiles.log(1, message);
                }
            }
            if (generationFailed) {
                regenerationErrorCobols.add(sourceFileLocation);
                StringBuilder sb = new StringBuilder();
                sb.append(Messages.AnalyzeRegeneratedFiles_Generation_failed_for);
                sb.append(sourceFileLocation);
                Iterator messageIter = genStatus.getMessages();
                while (messageIter.hasNext()) {
                    IStatusMessage iStatusMessage = (IStatusMessage)messageIter.next();
                    sb.append("\n");
                    sb.append(iStatusMessage.getText());
                }
                AnalyzeRegeneratedFiles.log(4, sb.toString());
                ControllerFactory.getInstance().dispose(controller);
                ((ResourceLink)controller.getResourceLink()).suspendGenerationBeforeSaving = false;
                continue;
            }
            desynchronizedCorrected = AnalyzeRegeneratedFiles.processGenerationForController(controller, writeMode, dephasedGeneratedFilesDestinationFolderPath, desynchonizedAndDephasedCobol, notImpactedCobol, dephasedCobol, cobolsToSave, genInfoTxtConstantReplacementError, genInfoTxtConstantReplacementInfo, cobolConstantReplacementError, desynchronizedCorrected, sourceFileLocation, generatedFileBeforeRegeneration, generationTimeStamp, realFileName, genInfoTextBeforeConstantsGeneration, genInfoId2, isSynchronized);
            if (otherControllers.size() == 0) continue;
            for (ControllerAndInformation cai : otherControllers) {
                iController = cai.getController();
                if (cai.getGeneratedFileBeforeRegeneration() == null) continue;
                desynchronizedCorrected = AnalyzeRegeneratedFiles.processGenerationForController(iController, writeMode, dephasedGeneratedFilesDestinationFolderPath, desynchonizedAndDephasedCobol, notImpactedCobol, dephasedCobol, cobolsToSave, genInfoTxtConstantReplacementError, genInfoTxtConstantReplacementInfo, cobolConstantReplacementError, desynchronizedCorrected, iController.getResourceName(), cai.getGeneratedFileBeforeRegeneration(), cai.getGenerationTimeStamp(), realFileName, cai.getGenInfoTextBeforeConstantsGeneration(), cai.getGenInfID2(), cai.isSynchronized());
            }
        }
        System.out.println("Desynchronized and corrected : " + desynchronizedCorrected);
        AnalyzeRegeneratedFiles.logRepport(notFoundCblOrPdpCobols, notImpactedCobol, regenerationErrorCobols, dephasedCobol, cobolsToSave, writeMode, genInfoTxtConstantReplacementError, cobolConstantReplacementError, desynchonizedCobol, desynchonizedAndDephasedCobol, genInfoTxtConstantReplacementInfo);
        mess = Messages.AnalyzeRegeneratedFiles_End_analyzing;
        AnalyzeRegeneratedFiles.log(1, mess);
    }

    private static int processGenerationForController(IController controller, boolean writeMode, String dephasedGeneratedFilesDestinationFolderPath, ArrayList<String> desynchonizedAndDephasedCobol, ArrayList<String> notImpactedCobol, ArrayList<String> dephasedCobol, ArrayList<String> cobolsToSave, ArrayList<String> genInfoTxtConstantReplacementError, ArrayList<String> genInfoTxtConstantReplacementInfo, ArrayList<String> cobolConstantReplacementError, int desynchronizedCorrected, String sourceFileLocation, String generatedFileBeforeRegeneration, long generationTimeStamp, String realFileName, String genInfoTextBeforeConstantsGeneration, String genInfoId2, boolean isSynchronized) {
        String newCobolwithOldDate;
        String generatedFileAfterRegeneration = controller.getTextProcessor().getText().toString();
        boolean differenceDetected = AnalyzeRegeneratedFiles.detectDifferences(controller, generatedFileBeforeRegeneration, generatedFileAfterRegeneration, false);
        if (differenceDetected) {
            String message;
            AnalyzeRegeneratedFiles.writeGeneratedFilesBeforeAndAfterRegeneration(generatedFileBeforeRegeneration, generatedFileAfterRegeneration, sourceFileLocation, dephasedGeneratedFilesDestinationFolderPath);
            dephasedCobol.add(String.valueOf(sourceFileLocation) + " (" + realFileName + ")");
            if (!isSynchronized) {
                desynchonizedAndDephasedCobol.add(String.valueOf(sourceFileLocation) + " (" + realFileName + ")");
                message = Messages.AnalyzeRegeneratedFiles_synchronized_and_depahased;
            } else {
                message = Messages.AnalyzeRegeneratedFiles_desynchronized_and_depahsed;
            }
            Object[] binding = new Object[]{sourceFileLocation, realFileName};
            message = NLS.bind((String)message, (Object[])binding);
            AnalyzeRegeneratedFiles.log(2, message);
            ControllerFactory.getInstance().dispose(controller);
            ((ResourceLink)controller.getResourceLink()).suspendGenerationBeforeSaving = false;
            return desynchronizedCorrected;
        }
        if (isSynchronized) {
            notImpactedCobol.add(String.valueOf(sourceFileLocation) + "(" + realFileName + ")");
            ControllerFactory.getInstance().dispose(controller);
            ((ResourceLink)controller.getResourceLink()).suspendGenerationBeforeSaving = false;
            return desynchronizedCorrected;
        }
        IGeneratedInfo genInfowithOldDate = AnalyzeRegeneratedFiles.restoreGenereatedInfo(controller, generatedFileBeforeRegeneration, genInfoId2);
        String genInfoTextAfterConstantsGeneration = genInfowithOldDate.getText().toString();
        differenceDetected = AnalyzeRegeneratedFiles.detectDifferences(controller, genInfoTextBeforeConstantsGeneration, genInfoTextAfterConstantsGeneration, true);
        boolean differenceDetected2 = AnalyzeRegeneratedFiles.detectDifferences(controller, genInfoTextBeforeConstantsGeneration, genInfoTextAfterConstantsGeneration, false);
        if (differenceDetected2) {
            String message = String.valueOf(sourceFileLocation) + Messages.AnalyzeRegeneratedFiles_Geninfo_text_different;
            ControllerFactory.getInstance().dispose(controller);
            ((ResourceLink)controller.getResourceLink()).suspendGenerationBeforeSaving = false;
            AnalyzeRegeneratedFiles.log(4, message);
            genInfoTxtConstantReplacementError.add(String.valueOf(sourceFileLocation) + "(" + realFileName + ")");
            return desynchronizedCorrected;
        }
        if (differenceDetected != differenceDetected2) {
            String message = String.valueOf(sourceFileLocation) + Messages.AnalyzeRegeneratedFiles_Geninfo_text_different_override;
            genInfoTxtConstantReplacementInfo.add(String.valueOf(sourceFileLocation) + "(" + realFileName + ")");
            AnalyzeRegeneratedFiles.log(1, message);
        }
        controller.getTextProcessor().initialize(genInfowithOldDate);
        IGenerationLink genLink = controller.getGenerationLink();
        if (genLink instanceof GenerationLink) {
            GenerationLink gl = (GenerationLink)genLink;
            gl.setGenerationTimeStamp(generationTimeStamp);
        }
        if (differenceDetected = AnalyzeRegeneratedFiles.detectDifferences(controller, generatedFileBeforeRegeneration, newCobolwithOldDate = AnalyzeRegeneratedFiles.restoreCobolsConstants(controller, generatedFileBeforeRegeneration, generatedFileAfterRegeneration), true)) {
            String message = String.valueOf(sourceFileLocation) + Messages.AnalyzeRegeneratedFiles_Geninfo_different;
            ControllerFactory.getInstance().dispose(controller);
            ((ResourceLink)controller.getResourceLink()).suspendGenerationBeforeSaving = false;
            AnalyzeRegeneratedFiles.log(4, message);
            cobolConstantReplacementError.add(sourceFileLocation);
            return desynchronizedCorrected;
        }
        controller.getTextProcessor().setText((CharSequence)newCobolwithOldDate);
        cobolsToSave.add(String.valueOf(sourceFileLocation) + " (" + realFileName + ")");
        Object[] binding = new Object[]{sourceFileLocation};
        String message = NLS.bind((String)Messages.AnalyzeRegeneratedFiles_desynchronized_but_not_depahased, (Object[])binding);
        String message2 = writeMode ? Messages.AnalyzeRegeneratedFiles_pdp_file_will_be_saved : Messages.AnalyzeRegeneratedFiles_pdp_file_can_be_saved;
        AnalyzeRegeneratedFiles.log(1, String.valueOf(message) + message2);
        if (!isSynchronized) {
            ++desynchronizedCorrected;
        }
        if (writeMode) {
            GenerationManager.saveController((boolean)true, (IController)controller);
        }
        ControllerFactory.getInstance().dispose(controller);
        ((ResourceLink)controller.getResourceLink()).suspendGenerationBeforeSaving = false;
        return desynchronizedCorrected;
    }

    private static boolean detectDifferences(IController controller, String generatedFileBeforeReGeneration, String generatedFileAfterReGeneration, boolean compareConstants) {
        String pattern = controller.getPattern().getName();
        if (pattern.equals("com.ibm.pdp.pacbase.databaseblock")) {
            if (!compareConstants) {
                generatedFileBeforeReGeneration = AnalyzeRegeneratedFiles.removeFirstCommentLine(generatedFileBeforeReGeneration);
                generatedFileAfterReGeneration = AnalyzeRegeneratedFiles.removeFirstCommentLine(generatedFileAfterReGeneration);
            }
            return !generatedFileBeforeReGeneration.equals(generatedFileAfterReGeneration);
        }
        if (pattern.equals("com.ibm.pdp.pacbase.errorlabel")) {
            return !generatedFileBeforeReGeneration.equals(generatedFileAfterReGeneration);
        }
        return !CobolCompare.compare(generatedFileBeforeReGeneration, generatedFileAfterReGeneration, compareConstants);
    }

    private static String removeFirstCommentLine(String generatedFile) {
        int endOfFirstLineIndex = generatedFile.indexOf("\n");
        if (endOfFirstLineIndex == -1) {
            return generatedFile;
        }
        String firstLine = generatedFile.substring(0, endOfFirstLineIndex);
        if (firstLine.contains(BLOCK_SESSI) && firstLine.contains(BLOCK_LIBRA)) {
            return generatedFile.substring(endOfFirstLineIndex);
        }
        return generatedFile;
    }

    private static void getOtherControllersForTheSameDesignId(IController controller, String designId, ArrayList<ControllerAndInformation> otherControllers, ArrayList<String> alreadyDoneByMultipleGeneration, HashSet<String> generatedFilesToIgnore, List<String> generatedFilesToManage, ArrayList<String> desynchronizedCobol, String realFileName) {
        String fullDesignName = PdpTool.addRPPFolderToFileName((String)designId);
        String[] generators = GenerationManager.generatorsFor((String)fullDesignName);
        if (generators != null && generators.length != 0) {
            String patternName = generators[0];
            IPattern pattern = PdpPatternManager.getPdpPattern((String)patternName);
            List super_refs = GenerationManager.getGenerationOutputsFromSuperRef((String)designId, (IPattern)pattern);
            for (GenerationManager.SuperRef superRef : super_refs) {
                String uri = PdpResourcesMgr.getURIFromGeneratedDocument((String)superRef.getDocumentId());
                ControllerFactory factory = (ControllerFactory)ControllerFactory.getInstance();
                IController sourceController = factory.getController(designId, pattern.getName(), uri);
                if (sourceController == controller) continue;
                String resourceName = sourceController.getResourceName();
                String generatedFileBeforeRegeneration = null;
                String genInfoTextBeforeConstantsGeneration = null;
                long generationTimeStamp = 0L;
                String genInfoId2 = null;
                boolean isSynchronized = false;
                if (generatedFilesToManage.contains(resourceName) && !generatedFilesToIgnore.contains(resourceName)) {
                    generatedFileBeforeRegeneration = sourceController.getTextProcessor().getText().toString();
                    genInfoTextBeforeConstantsGeneration = sourceController.getTextProcessor().getGeneratedInfo().getText().toString();
                    generationTimeStamp = sourceController.getGenerationLink().getGenerationTimeStamp();
                    genInfoId2 = sourceController.getTextProcessor().getGeneratedInfo().getProperty("GeneratedInfoIdentifier");
                    String logicalFileName = sourceController.getGenerationLink().getGenerationOutput().getLogicalFileName();
                    boolean bl = isSynchronized = !SynchronizationTool.checkIfTheGeneratedResourceNeedsRegeneration((String)logicalFileName, (String)resourceName);
                    if (!isSynchronized) {
                        desynchronizedCobol.add(String.valueOf(resourceName) + "(" + realFileName + ")");
                    }
                    alreadyDoneByMultipleGeneration.add(resourceName);
                }
                ControllerAndInformation cai = new ControllerAndInformation(sourceController, generatedFileBeforeRegeneration, genInfoTextBeforeConstantsGeneration, generationTimeStamp, genInfoId2, isSynchronized);
                otherControllers.add(cai);
            }
        }
        if (otherControllers.size() != 0) {
            for (ControllerAndInformation cai : otherControllers) {
                IController iController = cai.getController();
                ((ResourceLink)iController.getResourceLink()).suspendGenerationBeforeSaving = true;
            }
        }
    }

    private static void writeGeneratedFilesBeforeAndAfterRegeneration(String cobolBeforeReGeneration, String cobolAfterRegeneration, String sourceFileLocation, String dephasedCobolsDestinationfolderPath) {
        if (dephasedCobolsDestinationfolderPath == null) {
            return;
        }
        if ((dephasedCobolsDestinationfolderPath = dephasedCobolsDestinationfolderPath.replace('\\', '/')).endsWith("/")) {
            dephasedCobolsDestinationfolderPath = dephasedCobolsDestinationfolderPath.substring(0, dephasedCobolsDestinationfolderPath.length() - 1);
        }
        String fullNameBefore = String.valueOf(dephasedCobolsDestinationfolderPath) + "/BeforeRegeneration" + sourceFileLocation;
        String fullNameAfter = String.valueOf(dephasedCobolsDestinationfolderPath) + "/AfterRegeneration" + sourceFileLocation;
        File file = new File(fullNameBefore);
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            PdpTool.writeFileContents((String)cobolBeforeReGeneration, (String)fullNameBefore);
        }
        if (!(file = new File(fullNameAfter)).exists()) {
            file.getParentFile().mkdirs();
            PdpTool.writeFileContents((String)cobolAfterRegeneration, (String)fullNameAfter);
        }
    }

    private static IGeneratedInfo restoreGenereatedInfo(IController controller, String specificCobolFile, String genInfoId2) {
        String pattern = controller.getPattern().getName();
        if (pattern.equals("com.ibm.pdp.pacbase.databaseblock")) {
            IGeneratedInfo genInfo = controller.getTextProcessor().getGeneratedInfo();
            String text = genInfo.getText().toString();
            int endOfFirstLineIndex = text.indexOf("\n");
            if (endOfFirstLineIndex == -1) {
                return genInfo;
            }
            String firstLine = text.substring(0, endOfFirstLineIndex);
            if (firstLine.contains(BLOCK_SESSI) && firstLine.contains(BLOCK_LIBRA)) {
                GenInfoBuilder genBuilder = new GenInfoBuilder(genInfo);
                IBuilderTag rootTag = genBuilder.getRootTag();
                int endOfFirstLineIndexInOldText = specificCobolFile.indexOf("\n");
                if (endOfFirstLineIndexInOldText == -1) {
                    return genInfo;
                }
                String firstLineInOldText = specificCobolFile.substring(0, endOfFirstLineIndex);
                rootTag.setText((CharSequence)(String.valueOf(firstLineInOldText) + text.substring(endOfFirstLineIndex)));
                return genBuilder.toGeneratedInfo();
            }
            return genInfo;
        }
        if (pattern.equals("com.ibm.pdp.pacbase.errorlabel")) {
            IGeneratedInfo genInfo = controller.getTextProcessor().getGeneratedInfo();
            return genInfo;
        }
        IGeneratedInfo result = null;
        String designFileId = controller.getDesignLink().getFileId();
        RadicalEntity re = ModelUtil.getSharedRadicalEntity(designFileId);
        IGeneratedInfo genInfo = controller.getTextProcessor().getGeneratedInfo();
        if (re instanceof PacProgram) {
            result = AnalyzeRegeneratedFiles.allignConstantsAndDate(genInfo, specificCobolFile, "CONSTANTES-PAC.     ");
            result = AnalyzeRegeneratedFiles.allignConstantsAndDate(result, specificCobolFile, "PACBASE-CONSTANTS.      ");
        }
        if (re instanceof PacAbstractDialog) {
            if (AnalyzeRegeneratedFiles.isMIA2MigrationHelpFile(re)) {
                result = AnalyzeRegeneratedFiles.allignConstantsAndDate(genInfo, specificCobolFile, "PACBASE-CONSTANTS.      ");
            } else if (AnalyzeRegeneratedFiles.isMIA3MigrationHelpFile(re)) {
                result = AnalyzeRegeneratedFiles.allignConstantsAndDateForClient(genInfo, specificCobolFile, "PACBASE-CONSTANTS.      ");
            }
        }
        if (re instanceof PacAbstractDialogServer) {
            result = AnalyzeRegeneratedFiles.allignConstantsAndDate(genInfo, specificCobolFile, "PACBASE-CONSTANTS.      ");
        }
        result.setProperty("GeneratedInfoIdentifier", genInfoId2);
        return result;
    }

    private static String restoreCobolsConstants(IController controller, String specificCobolFile, String cobolToModify) {
        String pattern = controller.getPattern().getName();
        if (pattern.equals("com.ibm.pdp.pacbase.databaseblock")) {
            int endOfFirstLineIndex = cobolToModify.indexOf("\n");
            if (endOfFirstLineIndex == -1) {
                return cobolToModify;
            }
            String firstLine = cobolToModify.substring(0, endOfFirstLineIndex);
            if (firstLine.contains(BLOCK_SESSI) && firstLine.contains(BLOCK_LIBRA)) {
                int endOfFirstLineIndexInOldText = specificCobolFile.indexOf("\n");
                if (endOfFirstLineIndexInOldText == -1) {
                    return cobolToModify;
                }
                String firstLineInOldText = specificCobolFile.substring(0, endOfFirstLineIndex);
                return String.valueOf(firstLineInOldText) + cobolToModify.substring(endOfFirstLineIndex);
            }
            return cobolToModify;
        }
        if (pattern.equals("com.ibm.pdp.pacbase.errorlabel")) {
            return cobolToModify;
        }
        String result = null;
        String designFileId = controller.getDesignLink().getFileId();
        RadicalEntity re = ModelUtil.getSharedRadicalEntity(designFileId);
        IGeneratedInfo genInfo = controller.getTextProcessor().getGeneratedInfo();
        if (re instanceof PacProgram && (result = AnalyzeRegeneratedFiles.allignConstantsAndDate(cobolToModify, specificCobolFile, "CONSTANTES-PAC.     ")) == null) {
            result = AnalyzeRegeneratedFiles.allignConstantsAndDate(cobolToModify, specificCobolFile, "PACBASE-CONSTANTS.      ");
        }
        if (re instanceof PacAbstractDialog) {
            if (!controller.getResourceName().endsWith("cbl")) {
                return cobolToModify;
            }
            if (AnalyzeRegeneratedFiles.isMIA2MigrationHelpFile(re)) {
                result = AnalyzeRegeneratedFiles.allignConstantsAndDate(cobolToModify, specificCobolFile, "PACBASE-CONSTANTS.      ");
            } else if (AnalyzeRegeneratedFiles.isMIA3MigrationHelpFile(re)) {
                result = AnalyzeRegeneratedFiles.allignConstantsAndDateForClient(cobolToModify, genInfo, specificCobolFile, "PACBASE-CONSTANTS.      ");
            }
        }
        if (re instanceof PacAbstractDialogServer) {
            if (!controller.getResourceName().endsWith("cbl")) {
                return cobolToModify;
            }
            result = AnalyzeRegeneratedFiles.allignConstantsAndDate(cobolToModify, specificCobolFile, "PACBASE-CONSTANTS.      ");
        }
        return result;
    }

    private static void listSourceFiles() {
        ArrayList<String> cobolsToManage = new ArrayList<String>();
        List<String> sourceFiles = AnalyzeRegeneratedFiles.findAllSourceFiles(cobolsToManage);
        StringBuilder sb = new StringBuilder();
        String lineSeparator = "\r\n";
        sb.append(lineSeparator);
        sb.append(Messages.AnalyzeRegeneratedFiles_all_generated_files);
        sb.append(lineSeparator);
        for (String source : sourceFiles) {
            sb.append(lineSeparator);
            sb.append(source);
        }
        AnalyzeRegeneratedFiles.log(1, sb.toString());
    }

    private static void logRepport(ArrayList<String> notFoundCblOrPdpCobols, ArrayList<String> notImpactedCobols, ArrayList<String> regenerationErrorCobols, ArrayList<String> dephasedCobols, ArrayList<String> cobolsToSave, boolean writeMode, ArrayList<String> genInfoConstantsErrors, ArrayList<String> cobolsConstantsError, ArrayList<String> desynchronizedCobols, ArrayList<String> desynchronizedAndDephasedCobols, ArrayList<String> genInfoConstantsInfo) {
        StringBuilder sb = new StringBuilder();
        String lineSeparator = "\r\n";
        sb.append(lineSeparator);
        sb.append("********************************************************************************************************");
        sb.append(lineSeparator);
        sb.append(String.valueOf(Messages.AnalyzeRegeneratedFiles_Good_generated_files) + notImpactedCobols.size());
        for (String notImpactedCobol : notImpactedCobols) {
            sb.append(lineSeparator);
            sb.append(notImpactedCobol);
        }
        sb.append(lineSeparator);
        sb.append("********************************************************************************************************");
        sb.append(lineSeparator);
        if (writeMode) {
            sb.append(String.valueOf(Messages.AnalyzeRegeneratedFiles_PDP_files_saved) + cobolsToSave.size());
        } else {
            sb.append(String.valueOf(Messages.AnalyzeRegeneratedFiles_PDP_files_to_save) + cobolsToSave.size());
        }
        for (String cobolToSave : cobolsToSave) {
            sb.append(lineSeparator);
            sb.append(cobolToSave);
        }
        sb.append(lineSeparator);
        sb.append("********************************************************************************************************");
        sb.append(lineSeparator);
        sb.append(String.valueOf(Messages.AnalyzeRegeneratedFiles_Not_found_generated_files_or_pdp) + notFoundCblOrPdpCobols.size());
        for (String notFoundCblOrPdpCobol : notFoundCblOrPdpCobols) {
            sb.append(lineSeparator);
            sb.append(notFoundCblOrPdpCobol);
        }
        sb.append(lineSeparator);
        sb.append("********************************************************************************************************");
        sb.append(lineSeparator);
        sb.append(String.valueOf(Messages.AnalyzeRegeneratedFiles_Regeneration_failed) + regenerationErrorCobols.size());
        for (String regenerationErrorCobol : regenerationErrorCobols) {
            sb.append(lineSeparator);
            sb.append(regenerationErrorCobol);
        }
        sb.append(lineSeparator);
        sb.append("********************************************************************************************************");
        sb.append(lineSeparator);
        sb.append(String.valueOf(Messages.AnalyzeRegeneratedFiles_Dephased_generated_files) + dephasedCobols.size());
        for (String dephasedCobol : dephasedCobols) {
            sb.append(lineSeparator);
            sb.append(dephasedCobol);
        }
        if (genInfoConstantsErrors.size() != 0) {
            sb.append(lineSeparator);
            sb.append("********************************************************************************************************");
            sb.append(lineSeparator);
            sb.append(String.valueOf(Messages.AnalyzeRegeneratedFiles_Generated_texts_with_differences) + genInfoConstantsErrors.size());
            for (String dephasedCobol : genInfoConstantsErrors) {
                sb.append(lineSeparator);
                sb.append(dephasedCobol);
            }
        }
        if (genInfoConstantsInfo.size() != 0) {
            sb.append(lineSeparator);
            sb.append("********************************************************************************************************");
            sb.append(lineSeparator);
            sb.append(String.valueOf(Messages.AnalyzeRegeneratedFiles_Generated_texts_with_diffrences_constants) + genInfoConstantsInfo.size());
            for (String dephasedCobol : genInfoConstantsInfo) {
                sb.append(lineSeparator);
                sb.append(dephasedCobol);
            }
        }
        if (cobolsConstantsError.size() != 0) {
            sb.append(lineSeparator);
            sb.append("********************************************************************************************************");
            sb.append(lineSeparator);
            sb.append(String.valueOf(Messages.AnalyzeRegeneratedFiles_Generated_files_with_differences_after_constants) + cobolsConstantsError.size());
            for (String dephasedCobol : cobolsConstantsError) {
                sb.append(lineSeparator);
                sb.append(dephasedCobol);
            }
        }
        sb.append(lineSeparator);
        sb.append("********************************************************************************************************");
        sb.append(lineSeparator);
        sb.append(String.valueOf(Messages.AnalyzeRegeneratedFiles_Desynchronized_generated_files) + desynchronizedCobols.size());
        for (String dephasedCobol : desynchronizedCobols) {
            sb.append(lineSeparator);
            sb.append(dephasedCobol);
        }
        sb.append(lineSeparator);
        sb.append("********************************************************************************************************");
        sb.append(lineSeparator);
        sb.append(String.valueOf(Messages.AnalyzeRegeneratedFiles_Desynchronized_and_dephased_generated) + desynchronizedAndDephasedCobols.size());
        for (String dephasedCobol : desynchronizedAndDephasedCobols) {
            sb.append(lineSeparator);
            sb.append(dephasedCobol);
        }
        AnalyzeRegeneratedFiles.log(1, sb.toString());
    }

    private static List<String> findAllSourceFiles(ArrayList<String> cobolsToManage) {
        if (cobolsToManage.size() == 0) {
            ArrayList<String> sourceFiles = new ArrayList<String>();
            List pdpFiles = PdpTool.findAllPDPFiles(null);
            for (IFile pdpFile : pdpFiles) {
                String pdpFileLocation = pdpFile.getFullPath().toString();
                String sourceFileLocation = PdpTool.computeSourceFileLocationFromPdpFileLocation((String)pdpFileLocation);
                if (sourceFileLocation.equals("")) {
                    AnalyzeRegeneratedFiles.log(2, String.valueOf(Messages.AnalyzeRegeneratedFiles_Generated_file_not_found) + pdpFileLocation);
                    continue;
                }
                sourceFiles.add(sourceFileLocation);
            }
            return sourceFiles;
        }
        return cobolsToManage;
    }

    private static boolean loadFile(String cobolsFile, ArrayList<String> cobols) {
        boolean emptyFile = true;
        if (cobolsFile == null) {
            return true;
        }
        File file = new File(cobolsFile);
        if (!file.exists()) {
            AnalyzeRegeneratedFiles.log(4, String.valueOf(Messages.AnalyzeRegeneratedFiles_File_not_found) + cobolsFile);
            return false;
        }
        String line = null;
        BufferedReader br = AnalyzeRegeneratedFiles.getBuffer(cobolsFile);
        try {
            while ((line = br.readLine()) != null) {
                if (line.startsWith("//")) continue;
                emptyFile = false;
                cobols.add(line.trim());
            }
            br.close();
        }
        catch (IOException io) {
            io.printStackTrace();
        }
        if (emptyFile) {
            AnalyzeRegeneratedFiles.log(4, String.valueOf(Messages.AnalyzeRegeneratedFiles_Empty_file) + cobolsFile);
            return false;
        }
        return true;
    }

    private static boolean loadFile(String cobolsFile, HashSet<String> cobols) {
        boolean emptyFile = true;
        if (cobolsFile == null) {
            return true;
        }
        File file = new File(cobolsFile);
        if (!file.exists()) {
            AnalyzeRegeneratedFiles.log(4, String.valueOf(Messages.AnalyzeRegeneratedFiles_File_not_found) + cobolsFile);
            return false;
        }
        String line = null;
        BufferedReader br = AnalyzeRegeneratedFiles.getBuffer(cobolsFile);
        try {
            while ((line = br.readLine()) != null) {
                if (line.startsWith("//")) continue;
                emptyFile = false;
                cobols.add(line.trim());
            }
            br.close();
        }
        catch (IOException io) {
            io.printStackTrace();
        }
        if (emptyFile) {
            AnalyzeRegeneratedFiles.log(4, String.valueOf(Messages.AnalyzeRegeneratedFiles_Empty_file) + cobolsFile);
            return false;
        }
        return true;
    }

    private static BufferedReader getBuffer(String filename) {
        BufferedReader br = null;
        try {
            FileReader fis = new FileReader(filename);
            br = new BufferedReader(fis);
        }
        catch (FileNotFoundException fileNotFoundException) {
            br = null;
        }
        return br;
    }

    private static IGeneratedInfo allignConstantsAndDate(IGeneratedInfo refGenInfo, String specificCobolFile, String constants) {
        String NEW_LINE = PdpTool.determineDelimiterOfV2((CharSequence)specificCobolFile);
        String NEW_LINE_MIA = PdpTool.determineDelimiterOfV2((CharSequence)refGenInfo.getText());
        StringBuilder constantBloc = new StringBuilder();
        int const_pac_index = specificCobolFile.indexOf(constants);
        if (const_pac_index != -1) {
            int startOfLineIndex = specificCobolFile.lastIndexOf(NEW_LINE, const_pac_index);
            if (startOfLineIndex < 0) {
                return refGenInfo;
            }
            int previousStartOfLine = startOfLineIndex += NEW_LINE.length();
            boolean firstLine = true;
            while (true) {
                int nextLineIndex;
                if ((nextLineIndex = specificCobolFile.indexOf(NEW_LINE, previousStartOfLine)) < 0) {
                    return refGenInfo;
                }
                String line = specificCobolFile.substring(previousStartOfLine, nextLineIndex);
                if (line.substring(7, 9).equals("01")) {
                    if (!firstLine) break;
                    firstLine = false;
                }
                constantBloc.append(line);
                constantBloc.append(NEW_LINE_MIA);
                previousStartOfLine = nextLineIndex + NEW_LINE.length();
            }
        }
        if (constantBloc.length() == 0) {
            return refGenInfo;
        }
        int date_CompiledIndex = specificCobolFile.indexOf("DATE-COMPILED");
        if (date_CompiledIndex < 0) {
            return refGenInfo;
        }
        int startOfLineIndex = specificCobolFile.lastIndexOf(NEW_LINE, date_CompiledIndex);
        if (startOfLineIndex < 0) {
            return refGenInfo;
        }
        int nextLineIndex = specificCobolFile.indexOf(NEW_LINE, startOfLineIndex += NEW_LINE.length());
        String date = String.valueOf(specificCobolFile.substring(startOfLineIndex, nextLineIndex)) + NEW_LINE_MIA;
        GenInfoBuilder gibuild = new GenInfoBuilder(refGenInfo);
        IBuilderTag tag = gibuild.tagFromName(CONSTANTS_TAG);
        if (tag != null) {
            tag.setText((CharSequence)constantBloc);
        }
        if ((tag = gibuild.tagFromName("DATE-COMPILED")) != null) {
            tag.setText((CharSequence)date);
        }
        return gibuild.toGeneratedInfo();
    }

    private static IGeneratedInfo allignConstantsAndDateForClient(IGeneratedInfo refGenInfo, String specificCobolFile, String constants) {
        int indexOfLastLine;
        String text;
        int indexOfValue;
        String NEW_LINE = PdpTool.determineDelimiterOfV2((CharSequence)specificCobolFile);
        String NEW_LINE_MIA = PdpTool.determineDelimiterOfV2((CharSequence)refGenInfo.getText());
        GenInfoBuilder gibuild = new GenInfoBuilder(refGenInfo);
        IBuilderTag tag = gibuild.tagFromName(CONSTANTS_TAG);
        String lastBeginingLineOfConstantsTag = "";
        if (tag != null && (indexOfValue = (lastBeginingLineOfConstantsTag = (text = tag.getText().toString()).substring((indexOfLastLine = text.lastIndexOf(NEW_LINE_MIA, text.length() - 2)) + NEW_LINE_MIA.length())).indexOf("VALUE")) > 0) {
            lastBeginingLineOfConstantsTag = lastBeginingLineOfConstantsTag.substring(0, indexOfValue + "VALUE".length());
        }
        if (lastBeginingLineOfConstantsTag.trim().length() == 0) {
            return refGenInfo;
        }
        StringBuilder constantBloc = new StringBuilder();
        int const_pac_index = specificCobolFile.indexOf(constants);
        if (const_pac_index != -1) {
            String line;
            int startOfLineIndex = specificCobolFile.lastIndexOf(NEW_LINE, const_pac_index);
            if (startOfLineIndex < 0) {
                return refGenInfo;
            }
            int previousStartOfLine = startOfLineIndex += NEW_LINE.length();
            boolean firstLine = true;
            do {
                int nextLineIndex;
                if ((nextLineIndex = specificCobolFile.indexOf(NEW_LINE, previousStartOfLine)) < 0) {
                    return refGenInfo;
                }
                line = specificCobolFile.substring(previousStartOfLine, nextLineIndex);
                if (line.substring(7, 9).equals("01")) {
                    if (firstLine) {
                        firstLine = false;
                    } else {
                        return refGenInfo;
                    }
                }
                constantBloc.append(line);
                constantBloc.append(NEW_LINE_MIA);
                previousStartOfLine = nextLineIndex + NEW_LINE.length();
            } while (!line.startsWith(lastBeginingLineOfConstantsTag));
        }
        if (constantBloc.length() == 0) {
            return refGenInfo;
        }
        int date_CompiledIndex = specificCobolFile.indexOf("DATE-COMPILED");
        if (date_CompiledIndex < 0) {
            return refGenInfo;
        }
        int startOfLineIndex = specificCobolFile.lastIndexOf(NEW_LINE, date_CompiledIndex);
        if (startOfLineIndex < 0) {
            return refGenInfo;
        }
        int nextLineIndex = specificCobolFile.indexOf(NEW_LINE, startOfLineIndex += NEW_LINE.length());
        String date = String.valueOf(specificCobolFile.substring(startOfLineIndex, nextLineIndex)) + NEW_LINE_MIA;
        if (tag != null) {
            tag.setText((CharSequence)constantBloc);
        }
        if ((tag = gibuild.tagFromName("DATE-COMPILED")) != null) {
            tag.setText((CharSequence)date);
        }
        return gibuild.toGeneratedInfo();
    }

    private static String allignConstantsAndDate(String cobolFileToModify, String specificCobolFile, String constants) {
        String NEW_LINE = PdpTool.determineDelimiterOfV2((CharSequence)specificCobolFile);
        StringBuilder constantBloc = new StringBuilder();
        int const_pac_index = specificCobolFile.indexOf(constants);
        if (const_pac_index != -1) {
            int startOfLineIndex = specificCobolFile.lastIndexOf(NEW_LINE, const_pac_index);
            if (startOfLineIndex < 0) {
                return null;
            }
            int previousStartOfLine = startOfLineIndex += NEW_LINE.length();
            boolean firstLine = true;
            while (true) {
                int nextLineIndex;
                if ((nextLineIndex = specificCobolFile.indexOf(NEW_LINE, previousStartOfLine)) < 0) {
                    return null;
                }
                String line = specificCobolFile.substring(previousStartOfLine, nextLineIndex);
                if (line.substring(7, 9).equals("01")) {
                    if (!firstLine) break;
                    firstLine = false;
                }
                constantBloc.append(line);
                constantBloc.append(NEW_LINE);
                previousStartOfLine = nextLineIndex + NEW_LINE.length();
            }
        }
        if (constantBloc.length() == 0) {
            return null;
        }
        int date_CompiledIndex = specificCobolFile.indexOf("DATE-COMPILED");
        if (date_CompiledIndex < 0) {
            return null;
        }
        int startOfLineIndex = specificCobolFile.lastIndexOf(NEW_LINE, date_CompiledIndex);
        if (startOfLineIndex < 0) {
            return null;
        }
        int nextLineIndex = specificCobolFile.indexOf(NEW_LINE, startOfLineIndex += NEW_LINE.length());
        String date = String.valueOf(specificCobolFile.substring(startOfLineIndex, nextLineIndex)) + NEW_LINE;
        StringBuilder constantBlocToModify = new StringBuilder();
        const_pac_index = cobolFileToModify.indexOf(constants);
        int startOf_const_index = -1;
        int endOf_Const_index = -1;
        if (const_pac_index != -1) {
            startOfLineIndex = cobolFileToModify.lastIndexOf(NEW_LINE, const_pac_index);
            if (startOfLineIndex < 0) {
                return null;
            }
            startOf_const_index = startOfLineIndex += NEW_LINE.length();
            int previousStartOfLine = startOfLineIndex;
            boolean firstLine = true;
            while (true) {
                if ((nextLineIndex = cobolFileToModify.indexOf(NEW_LINE, previousStartOfLine)) < 0) {
                    return null;
                }
                String line = cobolFileToModify.substring(previousStartOfLine, nextLineIndex);
                if (line.substring(7, 9).equals("01")) {
                    if (!firstLine) break;
                    firstLine = false;
                }
                constantBlocToModify.append(line);
                constantBlocToModify.append(NEW_LINE);
                endOf_Const_index = previousStartOfLine = nextLineIndex + NEW_LINE.length();
            }
        }
        if (startOf_const_index == -1 || endOf_Const_index == -1 || startOf_const_index == endOf_Const_index) {
            return null;
        }
        date_CompiledIndex = cobolFileToModify.indexOf("DATE-COMPILED");
        int startOf_DateCompiledIndex = -1;
        int endOf_DateCompiledIndex = -1;
        if (date_CompiledIndex < 0) {
            return null;
        }
        startOfLineIndex = cobolFileToModify.lastIndexOf(NEW_LINE, date_CompiledIndex);
        if (startOfLineIndex < 0) {
            return null;
        }
        nextLineIndex = cobolFileToModify.indexOf(NEW_LINE, startOfLineIndex += NEW_LINE.length());
        startOf_DateCompiledIndex = startOfLineIndex;
        endOf_DateCompiledIndex = nextLineIndex + NEW_LINE.length();
        String dateToModify = String.valueOf(cobolFileToModify.substring(startOfLineIndex, nextLineIndex)) + NEW_LINE;
        if (constantBloc.length() != constantBlocToModify.length() || date.length() != dateToModify.length()) {
            System.out.println("different constants sizes");
            return null;
        }
        StringBuilder cobolModified = new StringBuilder();
        cobolModified.append(cobolFileToModify.subSequence(0, startOf_DateCompiledIndex));
        cobolModified.append(date);
        cobolModified.append(cobolFileToModify.subSequence(endOf_DateCompiledIndex, startOf_const_index));
        cobolModified.append((CharSequence)constantBloc);
        cobolModified.append(cobolFileToModify.substring(endOf_Const_index));
        return cobolModified.toString();
    }

    private static String allignConstantsAndDateForClient(String cobolFileToModify, IGeneratedInfo refGenInfo, String specificCobolFile, String constants) {
        int indexOfLastLine;
        String text;
        int indexOfValue;
        String NEW_LINE = PdpTool.determineDelimiterOfV2((CharSequence)specificCobolFile);
        String NEW_LINE_MIA = PdpTool.determineDelimiterOfV2((CharSequence)refGenInfo.getText());
        GenInfoBuilder gibuild = new GenInfoBuilder(refGenInfo);
        IBuilderTag tag = gibuild.tagFromName(CONSTANTS_TAG);
        String lastBeginingLineOfConstantsTag = "";
        if (tag != null && (indexOfValue = (lastBeginingLineOfConstantsTag = (text = tag.getText().toString()).substring((indexOfLastLine = text.lastIndexOf(NEW_LINE_MIA, text.length() - 2)) + NEW_LINE_MIA.length())).indexOf("VALUE")) > 0) {
            lastBeginingLineOfConstantsTag = lastBeginingLineOfConstantsTag.substring(0, indexOfValue + "VALUE".length());
        }
        if (lastBeginingLineOfConstantsTag.trim().length() == 0) {
            return null;
        }
        StringBuilder constantBloc = new StringBuilder();
        int const_pac_index = specificCobolFile.indexOf(constants);
        if (const_pac_index != -1) {
            String line;
            int startOfLineIndex = specificCobolFile.lastIndexOf(NEW_LINE, const_pac_index);
            if (startOfLineIndex < 0) {
                return null;
            }
            int previousStartOfLine = startOfLineIndex += NEW_LINE.length();
            boolean firstLine = true;
            do {
                int nextLineIndex;
                if ((nextLineIndex = specificCobolFile.indexOf(NEW_LINE, previousStartOfLine)) < 0) {
                    return null;
                }
                line = specificCobolFile.substring(previousStartOfLine, nextLineIndex);
                if (line.substring(7, 9).equals("01")) {
                    if (firstLine) {
                        firstLine = false;
                    } else {
                        return null;
                    }
                }
                constantBloc.append(line);
                constantBloc.append(NEW_LINE_MIA);
                previousStartOfLine = nextLineIndex + NEW_LINE.length();
            } while (!line.startsWith(lastBeginingLineOfConstantsTag));
        }
        if (constantBloc.length() == 0) {
            return null;
        }
        int date_CompiledIndex = specificCobolFile.indexOf("DATE-COMPILED");
        if (date_CompiledIndex < 0) {
            return null;
        }
        int startOfLineIndex = specificCobolFile.lastIndexOf(NEW_LINE, date_CompiledIndex);
        if (startOfLineIndex < 0) {
            return null;
        }
        int nextLineIndex = specificCobolFile.indexOf(NEW_LINE, startOfLineIndex += NEW_LINE.length());
        String date = String.valueOf(specificCobolFile.substring(startOfLineIndex, nextLineIndex)) + NEW_LINE_MIA;
        StringBuilder constantBlocToModify = new StringBuilder();
        const_pac_index = cobolFileToModify.indexOf(constants);
        int startOf_const_index = -1;
        int endOf_Const_index = -1;
        if (const_pac_index != -1) {
            String line;
            startOfLineIndex = cobolFileToModify.lastIndexOf(NEW_LINE, const_pac_index);
            if (startOfLineIndex < 0) {
                return null;
            }
            startOf_const_index = startOfLineIndex += NEW_LINE.length();
            int previousStartOfLine = startOfLineIndex;
            boolean firstLine = true;
            do {
                if ((nextLineIndex = cobolFileToModify.indexOf(NEW_LINE, previousStartOfLine)) < 0) {
                    return null;
                }
                line = cobolFileToModify.substring(previousStartOfLine, nextLineIndex);
                if (line.substring(7, 9).equals("01")) {
                    if (firstLine) {
                        firstLine = false;
                    } else {
                        return null;
                    }
                }
                constantBlocToModify.append(line);
                constantBlocToModify.append(NEW_LINE_MIA);
                endOf_Const_index = previousStartOfLine = nextLineIndex + NEW_LINE.length();
            } while (!line.startsWith(lastBeginingLineOfConstantsTag));
        }
        if (constantBlocToModify.length() == 0) {
            return null;
        }
        date_CompiledIndex = cobolFileToModify.indexOf("DATE-COMPILED");
        int startOf_DateCompiledIndex = -1;
        int endOf_DateCompiledIndex = -1;
        if (date_CompiledIndex < 0) {
            return null;
        }
        startOfLineIndex = cobolFileToModify.lastIndexOf(NEW_LINE, date_CompiledIndex);
        if (startOfLineIndex < 0) {
            return null;
        }
        nextLineIndex = cobolFileToModify.indexOf(NEW_LINE, startOfLineIndex += NEW_LINE.length());
        startOf_DateCompiledIndex = startOfLineIndex;
        endOf_DateCompiledIndex = nextLineIndex + NEW_LINE.length();
        String dateToModify = String.valueOf(cobolFileToModify.substring(startOfLineIndex, nextLineIndex)) + NEW_LINE;
        if (constantBloc.length() != constantBlocToModify.length() || date.length() != dateToModify.length()) {
            System.out.println("different constants sizes");
            return null;
        }
        StringBuilder cobolModified = new StringBuilder();
        cobolModified.append(cobolFileToModify.subSequence(0, startOf_DateCompiledIndex));
        cobolModified.append(date);
        cobolModified.append(cobolFileToModify.subSequence(endOf_DateCompiledIndex, startOf_const_index));
        cobolModified.append((CharSequence)constantBloc);
        cobolModified.append(cobolFileToModify.substring(endOf_Const_index));
        return cobolModified.toString();
    }

    private static boolean isMIA2MigrationHelpFile(RadicalEntity re) {
        PacDialog dialog;
        PacDialogTypeValues typeValue;
        if (re instanceof PacScreen) {
            PacScreen screen = (PacScreen)re;
            PacDialogTypeValues typeValue2 = screen.getDialogType();
            if (screen.getDialogType().equals(PacDialogTypeValues._INHERITED_LITERAL)) {
                PacGenerationHeader header;
                PacDialog dialog2 = screen.getDialog();
                if (dialog2 == null && (header = screen.getGenerationHeader()) instanceof PacLibrarySubstitutionGenerationHeader) {
                    PacScreen referencedScreen = (PacScreen)((PacLibrarySubstitutionGenerationHeader)header).getGeneratedRadicalEntity();
                    dialog2 = referencedScreen.getDialog();
                }
                typeValue2 = dialog2.getDialogType();
            }
            if (typeValue2.equals(PacDialogTypeValues._NONE_LITERAL)) {
                return true;
            }
            return typeValue2.equals(PacDialogTypeValues._MW_LITERAL);
        }
        return re instanceof PacDialog && (typeValue = (dialog = (PacDialog)re).getDialogType()).equals(PacDialogTypeValues._NONE_LITERAL);
    }

    private static boolean isMIA3MigrationHelpFile(RadicalEntity re) {
        if (re instanceof PacScreen) {
            PacScreen screen = (PacScreen)re;
            PacDialogTypeValues typeValue = screen.getDialogType();
            if (screen.getDialogType().equals(PacDialogTypeValues._INHERITED_LITERAL)) {
                PacGenerationHeader header;
                PacDialog dialog = screen.getDialog();
                if (dialog == null && (header = screen.getGenerationHeader()) instanceof PacLibrarySubstitutionGenerationHeader) {
                    PacScreen referencedScreen = (PacScreen)((PacLibrarySubstitutionGenerationHeader)header).getGeneratedRadicalEntity();
                    dialog = referencedScreen.getDialog();
                }
                typeValue = dialog.getDialogType();
            }
            if (typeValue.equals(PacDialogTypeValues._C_LITERAL) || typeValue.equals(PacDialogTypeValues._SC_LITERAL) || typeValue.equals(PacDialogTypeValues._MC_LITERAL)) {
                return true;
            }
        }
        return false;
    }
}

