/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.wizards;

import com.ibm.pdp.engine.tree.IEditTree;
import com.ibm.pdp.pacbase.INodeLoader;
import com.ibm.pdp.pacbase.wizards.FunctionModel;
import com.ibm.pdp.pacbase.wizards.FunctionWizard;
import com.ibm.pdp.pacbase.wizards.FunctionWizardForPdpEditor;
import com.ibm.pdp.pacbase.wizards.IFunctionControls;
import com.ibm.pdp.pacbase.wizards.IPdpEditorFunctionControls;
import com.ibm.pdp.pacbase.wizards.Messages;
import com.ibm.pdp.pacbase.wizards.PdpEditorFunctionControls;
import com.ibm.pdp.pacbase.wizards.PdpFunctionWizardUtil;
import com.ibm.pdp.pacbase.wizards.ServerSQLProcessInsertPage;
import java.util.ArrayList;
import org.eclipse.swt.widgets.Button;

public class ServerSQLProcessingInsertPageForPdpEditor
extends ServerSQLProcessInsertPage {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private IEditTree _editTree;

    public ServerSQLProcessingInsertPageForPdpEditor(String pageName, IEditTree editTree) {
        super(pageName);
        this._editTree = editTree;
    }

    @Override
    public boolean isPageComplete() {
        String message;
        FunctionModel oldDataModel;
        boolean isComplete = super.isPageComplete();
        if (!isComplete) {
            return false;
        }
        String reference = "";
        reference = this._wheneverSQLButton.getSelection() ? "SQLW" : "SQLD " + this._logicalViewCode.getText().toUpperCase();
        IFunctionControls controls = ((FunctionWizardForPdpEditor)this.getWizard()).getFunctionControls();
        INodeLoader nodeLoader = null;
        if (controls instanceof IPdpEditorFunctionControls) {
            IPdpEditorFunctionControls pdpControls = (IPdpEditorFunctionControls)controls;
            nodeLoader = pdpControls.getNodeLoader();
        }
        String tagName = PdpFunctionWizardUtil.buildTagNameInServer(reference);
        String oldFunction = null;
        FunctionModel dataModel = ((FunctionWizardForPdpEditor)this.getWizard()).getDataModel();
        if (dataModel.isMoveAction() && (oldDataModel = ((FunctionWizard)this.getWizard()).getOldDataModel()) != null) {
            oldFunction = "F" + oldDataModel.getFunction() + oldDataModel.getSubFunction();
        }
        if ((message = PdpFunctionWizardUtil.isServerPageComplete(tagName, reference, nodeLoader, this._editTree, "F" + this._functionLabel.getText(), this._replaceButton.getSelection(), oldFunction)).length() > 0) {
            this.setErrorMessage(message);
            isComplete = false;
        }
        this.setGenerationMessage(reference);
        return isComplete;
    }

    private void setGenerationMessage(String reference) {
        Button[] buttons = new Button[]{this._insertAfterButton, this._insertBeforeButton, this._replaceButton};
        String message = PdpFunctionWizardUtil.getGenerationMessageForServerPage(((FunctionWizard)this.getWizard()).getDataModel(), ((FunctionWizardForPdpEditor)this.getWizard()).getOldDataModel(), reference, buttons);
        this.setMessage(message, 1);
    }

    @Override
    protected void handleEventForLogicalViewSelection() {
        ArrayList<String[]> list = null;
        IFunctionControls controls = ((FunctionWizardForPdpEditor)this.getWizard()).getFunctionControls();
        PdpEditorFunctionControls pdpControls = (PdpEditorFunctionControls)controls;
        list = pdpControls.getSegmentsList("FSQL-CURSR");
        String element = PdpFunctionWizardUtil.openListDialog(this.getShell(), list, Messages.SEGMENT_SELECTION);
        if (element != null) {
            this._logicalViewCode.setText(element);
        }
    }
}

