/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.wizards;

import com.ibm.pdp.explorer.model.PTElement;
import com.ibm.pdp.explorer.view.service.PTWidgetTool;
import com.ibm.pdp.mdl.kernel.DataAggregate;
import com.ibm.pdp.mdl.pacbase.util.IPacFunctionConstants;
import com.ibm.pdp.mdl.pacbase.util.PacFunctionCheckingUtilities;
import com.ibm.pdp.pacbase.PdpPacbasePlugin;
import com.ibm.pdp.pacbase.wizards.FunctionModel;
import com.ibm.pdp.pacbase.wizards.FunctionWizard;
import com.ibm.pdp.pacbase.wizards.IFunctionWizardPage;
import com.ibm.pdp.pacbase.wizards.Messages;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class ServerSQLProcessInsertPage
extends WizardPage
implements IPacFunctionConstants,
Listener,
IFunctionWizardPage {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2013, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected Label _functionLabel;
    private Label _levelLabel;
    private Label _logicalViewLabel;
    private Button _declareCursorSQLButton;
    protected Button _insertAfterButton;
    protected Button _insertBeforeButton;
    private Button _logicalViewSelection;
    protected Button _replaceButton;
    protected Button _wheneverSQLButton;
    protected Text _logicalViewCode;
    private String CONTEXT_ID_FOR_HELP = "Macro_wiz_serv_sql";

    public ServerSQLProcessInsertPage(String pageName) {
        super(pageName);
        this.setTitle(pageName);
    }

    public void createControl(Composite parent) {
        Composite composite = PTWidgetTool.createComposite((Composite)parent, (int)1, (boolean)false);
        PdpPacbasePlugin.setHelpMechanism(composite, this.CONTEXT_ID_FOR_HELP);
        this.createFunctionGroup(composite);
        PTWidgetTool.createLabel((Composite)composite, (String)"");
        this.createProcessesGroup(composite);
        PTWidgetTool.createLabel((Composite)composite, (String)"");
        this.createActionsRadioButtonsGroup(composite);
        this.initDataWithModel();
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite);
        this.initListeners();
    }

    private void createFunctionGroup(Composite parent) {
        Group group = PTWidgetTool.createGroup((Composite)parent, (int)4, (String)"");
        PTWidgetTool.createLabel((Composite)group, (String)(String.valueOf(Messages.FUNCTION_CODE) + ": "));
        this._functionLabel = PTWidgetTool.createLabel((Composite)group, (String)"");
        ((GridData)this._functionLabel.getLayoutData()).grabExcessHorizontalSpace = true;
        PTWidgetTool.createLabel((Composite)group, (String)(String.valueOf(Messages.LEVEL) + ": "));
        this._levelLabel = PTWidgetTool.createLabel((Composite)group, (String)"");
        ((GridData)this._levelLabel.getLayoutData()).grabExcessHorizontalSpace = true;
    }

    private void createProcessesGroup(Composite parent) {
        Group group = PTWidgetTool.createGroup((Composite)parent, (int)3, (String)Messages.BLOCK_SQL);
        PTWidgetTool.createLabel((Composite)group, (String)"", (int)3);
        this._wheneverSQLButton = PTWidgetTool.createRadioButton((Composite)group, (String)Messages.WHENEVER_CURSOR_SQL_ORDER, (boolean)false, (int)3);
        this._declareCursorSQLButton = PTWidgetTool.createRadioButton((Composite)group, (String)Messages.DECLARE_CURSOR_SQL_ORDER, (boolean)false, (int)3);
        this._logicalViewLabel = PTWidgetTool.createLabel((Composite)group, (String)Messages.TABLE_CODE);
        ((GridData)this._logicalViewLabel.getLayoutData()).horizontalAlignment = 3;
        this._logicalViewLabel.setEnabled(false);
        this._logicalViewCode = PTWidgetTool.createTextField((Composite)group, (boolean)false, (boolean)false);
        this._logicalViewCode.setTextLimit(4);
        this._logicalViewCode.setEnabled(false);
        this._logicalViewSelection = PTWidgetTool.createPushButton((Composite)group, (String)Messages.BROWSE_BUTTON, (boolean)true);
        ((GridData)this._logicalViewSelection.getLayoutData()).horizontalAlignment = 3;
        PTWidgetTool.createLabel((Composite)group, (String)"", (int)3);
    }

    private void createActionsRadioButtonsGroup(Composite parent) {
        Group group = PTWidgetTool.createGroup((Composite)parent, (int)4, (String)Messages.ACTION_TYPE);
        this._insertBeforeButton = PTWidgetTool.createRadioButton((Composite)group, (String)Messages.INSERTION_BEFORE, (boolean)false);
        this._insertAfterButton = PTWidgetTool.createRadioButton((Composite)group, (String)Messages.INSERTION_AFTER, (boolean)false);
        this._replaceButton = PTWidgetTool.createRadioButton((Composite)group, (String)Messages.REPLACE, (boolean)false);
    }

    public boolean canFlipToNextPage() {
        return false;
    }

    public IWizardPage getNextPage() {
        return null;
    }

    public void handleEvent(Event event) {
        if (event.widget == this._declareCursorSQLButton) {
            this._logicalViewLabel.setEnabled(true);
            this._logicalViewCode.setEnabled(true);
        } else if (event.widget == this._declareCursorSQLButton || event.widget == this._wheneverSQLButton) {
            this._logicalViewLabel.setEnabled(false);
            this._logicalViewCode.setEnabled(false);
        } else if (event.widget == this._logicalViewSelection) {
            this.handleEventForLogicalViewSelection();
        }
        boolean isPagecomplete = this.isPageComplete();
        this.setPageComplete(isPagecomplete);
        this.getWizard().getContainer().updateButtons();
    }

    protected void handleEventForLogicalViewSelection() {
        PTElement element = ((FunctionWizard)this.getWizard()).openSelectionDialog(DataAggregate.class.getSimpleName());
        if (element != null) {
            this._logicalViewCode.setText(element.getName());
        }
    }

    private void initFunctionDatasFromModel() {
        FunctionModel dataModel = ((FunctionWizard)this.getWizard()).getDataModel();
        this._functionLabel.setText(String.valueOf(dataModel.getFunction()) + dataModel.getSubFunction());
        this._levelLabel.setText(dataModel.getLevel());
    }

    private void initDataWithModel() {
        String action;
        FunctionModel dataModel = ((FunctionWizard)this.getWizard()).getDataModel();
        StringTokenizer tokenizer = new StringTokenizer(dataModel.getReference(), " ");
        ArrayList<String> refs = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            refs.add(tokenizer.nextToken());
        }
        if (refs.size() > 0) {
            String bloc = (String)refs.get(0);
            if (bloc.equals("SQLD") || bloc.startsWith("$")) {
                this._declareCursorSQLButton.setSelection(true);
                if (refs.size() > 1) {
                    this._logicalViewCode.setText((String)refs.get(1));
                    this._logicalViewLabel.setEnabled(true);
                    this._logicalViewCode.setEnabled(true);
                }
            } else if (bloc.equals("SQLW")) {
                this._wheneverSQLButton.setSelection(true);
            }
        }
        if ((action = dataModel.getAction()) != null && action.trim().length() > 0) {
            if (action.equals("*P")) {
                this._insertAfterButton.setSelection(true);
            } else if (action.equals("*A")) {
                this._insertBeforeButton.setSelection(true);
            } else if (action.equals("*R")) {
                this._replaceButton.setSelection(true);
            }
        }
    }

    private void initListeners() {
        this._wheneverSQLButton.addListener(13, (Listener)this);
        this._declareCursorSQLButton.addListener(13, (Listener)this);
        this._logicalViewCode.addListener(24, (Listener)this);
        this._insertAfterButton.addListener(13, (Listener)this);
        this._insertBeforeButton.addListener(13, (Listener)this);
        this._replaceButton.addListener(13, (Listener)this);
        this._logicalViewSelection.addListener(13, (Listener)this);
    }

    public boolean isPageComplete() {
        if (!this._declareCursorSQLButton.getSelection() && !this._wheneverSQLButton.getSelection()) {
            this.setErrorMessage(String.valueOf(Messages.BLOCK_SQL) + ": " + Messages.DATA_REQUIRED);
            return false;
        }
        String logicalViewCode = this._logicalViewCode.getText().toUpperCase().trim();
        if (this._declareCursorSQLButton.getSelection()) {
            boolean b;
            if (logicalViewCode.length() == 0) {
                this.setErrorMessage(String.valueOf(Messages.TABLE_CODE) + ": " + Messages.DATA_REQUIRED);
                return false;
            }
            if (logicalViewCode.contains("$") && logicalViewCode.length() != 2 && logicalViewCode.length() != 4 || !logicalViewCode.startsWith("$") && logicalViewCode.length() != 4) {
                this.setErrorMessage(String.valueOf(Messages.SEGMENT_CODE) + ": " + Messages.LENGTH_INVALID);
                return false;
            }
            if (logicalViewCode.contains("$") && !(b = PacFunctionCheckingUtilities.isParameterWithDollarWellFormed((String)logicalViewCode, null))) {
                this.setErrorMessage(String.valueOf(Messages.TABLE_CODE) + ": " + Messages.DATA_INVALID);
                return false;
            }
        }
        if (!(this._insertAfterButton.getSelection() || this._insertBeforeButton.getSelection() || this._replaceButton.getSelection())) {
            this.setErrorMessage(String.valueOf(Messages.ACTION_TYPE) + ": " + Messages.DATA_REQUIRED);
            return false;
        }
        this.setErrorMessage(null);
        this.saveDataToModel();
        return true;
    }

    @Override
    public void saveDataToModel() {
        FunctionModel dataModel = ((FunctionWizard)this.getWizard()).getDataModel();
        if (this._insertAfterButton.getSelection()) {
            dataModel.setAction("*P");
        }
        if (this._insertBeforeButton.getSelection()) {
            dataModel.setAction("*A");
        }
        if (this._replaceButton.getSelection()) {
            dataModel.setAction("*R");
        }
        if (this._wheneverSQLButton.getSelection()) {
            dataModel.setReference("SQLW");
        } else {
            dataModel.setReference("SQLD " + this._logicalViewCode.getText().toUpperCase());
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.initFunctionDatasFromModel();
        }
        super.setVisible(visible);
    }
}

