/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.wizards;

import com.ibm.pdp.engine.tree.IEditTree;
import com.ibm.pdp.pacbase.INodeLoader;
import com.ibm.pdp.pacbase.extension.organize.ServerFunctionUtilities;
import com.ibm.pdp.pacbase.wizards.CommonFunctionPageForPdpEditor;
import com.ibm.pdp.pacbase.wizards.FunctionModel;
import com.ibm.pdp.pacbase.wizards.FunctionWizard;
import com.ibm.pdp.pacbase.wizards.FunctionWizardForPdpEditor;
import com.ibm.pdp.pacbase.wizards.IFunctionControls;
import com.ibm.pdp.pacbase.wizards.IPdpEditorFunctionControls;
import com.ibm.pdp.pacbase.wizards.Messages;
import com.ibm.pdp.pacbase.wizards.PdpEditorFunctionControls;
import com.ibm.pdp.pacbase.wizards.PdpFunctionWizardUtil;
import com.ibm.pdp.pacbase.wizards.ServerLogicalViewInsertPage;
import java.util.ArrayList;
import org.eclipse.swt.widgets.Button;

public class ServerLogicalViewInsertPageForPdpEditor
extends ServerLogicalViewInsertPage {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private IEditTree _editTree;

    public ServerLogicalViewInsertPageForPdpEditor(String pageName, IEditTree editTree) {
        super(pageName);
        this._editTree = editTree;
    }

    @Override
    protected void initDataWithModel() {
        super.initDataWithModel();
        this.initGenerationMessage();
    }

    private void initGenerationMessage() {
        FunctionModel dataModel = ((FunctionWizard)this.getWizard()).getDataModel();
        if (dataModel.isHighUpdatesForModel(((FunctionWizardForPdpEditor)this.getWizard()).getOldDataModel()) && dataModel.isGenerationRequested()) {
            this.setMessage(Messages.REQUIRED_GENERATION, 1);
        } else {
            this.setMessage(null, 0);
        }
    }

    @Override
    public void saveDataToModel() {
        super.saveDataToModel();
        FunctionModel dataModel = ((FunctionWizard)this.getWizard()).getDataModel();
        boolean b = dataModel.isHighUpdatesForModel(((FunctionWizardForPdpEditor)this.getWizard()).getOldDataModel());
        dataModel.setGenerationRequested(b);
        ((CommonFunctionPageForPdpEditor)this.getPreviousPage())._generationButton.setSelection(b);
        ((CommonFunctionPageForPdpEditor)this.getPreviousPage())._generationButton.setEnabled(!b);
    }

    @Override
    public boolean isPageComplete() {
        String message;
        FunctionModel oldDataModel;
        boolean isComplete = super.isPageComplete();
        if (!isComplete) {
            return false;
        }
        IFunctionControls controls = ((FunctionWizardForPdpEditor)this.getWizard()).getFunctionControls();
        INodeLoader nodeLoader = null;
        if (controls instanceof IPdpEditorFunctionControls) {
            IPdpEditorFunctionControls pdpControls = (IPdpEditorFunctionControls)controls;
            nodeLoader = pdpControls.getNodeLoader();
        }
        FunctionModel dataModel = ((FunctionWizardForPdpEditor)this.getWizard()).getDataModel();
        String tagName = "F" + ServerFunctionUtilities.FromEtiquetteToFunctionName(this._reference.toString(), dataModel.getLogicalView());
        String oldFunction = null;
        if (dataModel.isMoveAction() && (oldDataModel = ((FunctionWizard)this.getWizard()).getOldDataModel()) != null) {
            oldFunction = "F" + oldDataModel.getFunction() + oldDataModel.getSubFunction();
        }
        if ((message = PdpFunctionWizardUtil.isServerPageComplete(tagName, this._reference.toString(), nodeLoader, this._editTree, "F" + this._functionLabel.getText(), this._replaceButton.getSelection(), oldFunction)).length() > 0) {
            this.setErrorMessage(message);
            isComplete = false;
        }
        this.setGenerationMessage();
        return isComplete;
    }

    private void setGenerationMessage() {
        Button[] buttons = new Button[]{this._insertAfterButton, this._insertBeforeButton, this._replaceButton, this._insertBeginButton};
        String message = PdpFunctionWizardUtil.getGenerationMessageForServerPage(((FunctionWizard)this.getWizard()).getDataModel(), ((FunctionWizardForPdpEditor)this.getWizard()).getOldDataModel(), this._reference.toString(), buttons);
        this.setMessage(message, 1);
    }

    @Override
    protected void handleEventForDataElementSelection() {
        String element;
        ArrayList<String[]> list = null;
        String generalProcess = this._cbbProcessTypes.getItem(this._cbbProcessTypes.getSelectionIndex());
        if (generalProcess.length() > 0) {
            FunctionModel dataModel = ((FunctionWizardForPdpEditor)this.getWizard()).getDataModel();
            String tagName = "F" + dataModel.getLogicalView() + "-" + generalProcess.substring(0, 4);
            String categ = this._cbbCategory.getText();
            if (categ.length() > 0) {
                tagName = String.valueOf(tagName) + "-" + categ;
            }
            IFunctionControls controls = ((FunctionWizardForPdpEditor)this.getWizard()).getFunctionControls();
            PdpEditorFunctionControls pdpControls = (PdpEditorFunctionControls)controls;
            list = pdpControls.getDataEltsList(tagName);
        }
        if ((element = PdpFunctionWizardUtil.openListDialog(this.getShell(), list, Messages.DATA_ELEMENT_SELECTION)) != null) {
            this._dataEltCode.setText(element);
        }
    }

    @Override
    protected void handleEventForFileSelection() {
        String element;
        ArrayList<String[]> list = null;
        String generalProcess = this._cbbProcessTypes.getItem(this._cbbProcessTypes.getSelectionIndex());
        if (generalProcess.length() > 0) {
            IFunctionControls controls = ((FunctionWizardForPdpEditor)this.getWizard()).getFunctionControls();
            PdpEditorFunctionControls pdpControls = (PdpEditorFunctionControls)controls;
            FunctionModel dataModel = ((FunctionWizardForPdpEditor)this.getWizard()).getDataModel();
            list = pdpControls.getFilesList("F" + dataModel.getLogicalView() + "-" + generalProcess.substring(0, 4));
        }
        if ((element = PdpFunctionWizardUtil.openListDialog(this.getShell(), list, Messages.SEGMENT_SELECTION)) != null) {
            this._fileCode.setText(element);
        }
    }

    @Override
    protected void handleEventForSegmentSelection() {
        String element;
        ArrayList<String[]> list = null;
        String generalProcess = this._cbbProcessTypes.getItem(this._cbbProcessTypes.getSelectionIndex());
        if (generalProcess.length() > 0) {
            IFunctionControls controls = ((FunctionWizardForPdpEditor)this.getWizard()).getFunctionControls();
            PdpEditorFunctionControls pdpControls = (PdpEditorFunctionControls)controls;
            FunctionModel dataModel = ((FunctionWizardForPdpEditor)this.getWizard()).getDataModel();
            list = pdpControls.getSegmentsList("F" + dataModel.getLogicalView() + "-" + generalProcess.substring(0, 4));
        }
        if ((element = PdpFunctionWizardUtil.openListDialog(this.getShell(), list, Messages.SEGMENT_SELECTION)) != null) {
            this._segmentCode.setText(element);
        }
    }
}

