/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.wizards;

import com.ibm.pdp.explorer.model.PTElement;
import com.ibm.pdp.explorer.view.service.PTWidgetTool;
import com.ibm.pdp.mdl.kernel.DataAggregate;
import com.ibm.pdp.mdl.kernel.DataElement;
import com.ibm.pdp.mdl.kernel.DataUnit;
import com.ibm.pdp.mdl.pacbase.util.IPacFunctionConstants;
import com.ibm.pdp.mdl.pacbase.util.PacFunctionCheckingUtilities;
import com.ibm.pdp.pacbase.PdpPacbasePlugin;
import com.ibm.pdp.pacbase.extension.organize.Location;
import com.ibm.pdp.pacbase.wizards.FunctionModel;
import com.ibm.pdp.pacbase.wizards.FunctionWizard;
import com.ibm.pdp.pacbase.wizards.IFunctionWizardPage;
import com.ibm.pdp.pacbase.wizards.Messages;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class ServerLogicalViewInsertPage
extends WizardPage
implements IPacFunctionConstants,
Listener,
IFunctionWizardPage {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2013, 2018.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Label _dataEltCodeLabel;
    protected Label _functionLabel;
    private Label _levelLabel;
    private Group _functionGroup;
    protected Combo _cbbCategory;
    protected Combo _cbbProcessTypes;
    protected Combo _cbbServiceTypes;
    protected Combo _cbbElementaryProcessTypes;
    protected Text _dataEltCode;
    protected Text _fileCode;
    protected Text _segmentCode;
    private Button _dataEltSelection;
    private Button _fileCodeSelection;
    protected Button _insertAfterButton;
    protected Button _insertBeforeButton;
    protected Button _insertBeginButton;
    protected Button _replaceButton;
    protected Button _segmentSelection;
    private static String[] _processTypeValues = new String[]{Messages.GAL_PROCESS_BEGV, Messages.GAL_PROCESS_CCNX, Messages.GAL_PROCESS_CHKD, Messages.GAL_PROCESS_CHUP, Messages.GAL_PROCESS_CLOSE, Messages.GAL_PROCESS_DCNX, Messages.GAL_PROCESS_ENDV, Messages.GAL_PROCESS_ERRV, Messages.GAL_PROCESS_LOCK, Messages.GAL_PROCESS_OPEN, Messages.GAL_PROCESS_SELC, Messages.GAL_PROCESS_TRDT, Messages.GAL_PROCESS_TRER, Messages.GAL_PROCESS_TRVW, Messages.GAL_PROCESS_UNLOCK, Messages.GAL_PROCESS_USER};
    private static String[] _serviceCHUPValues = new String[]{Messages.SERVICE_SRVE, Messages.SERVICE_SRVL, Messages.SERVICE_SRVM, Messages.SERVICE_SRVT, Messages.SERVICE_SRVX};
    private static String[] _serviceSELCValues = new String[]{Messages.SERVICE_SRVA};
    private static String[] _eltProcessValues1 = new String[]{Messages.ELT_PROCESS_INIT, Messages.ELT_PROCESS_CHCK, Messages.ELT_PROCESS_DONE, Messages.ELT_PROCESS_TRCS};
    private static String[] _eltProcessValues2 = new String[]{Messages.ELT_PROCESS_INIT, Messages.ELT_PROCESS_CHCK, Messages.ELT_PROCESS_TRAN, Messages.ELT_PROCESS_DONE};
    private static String[] _eltProcessValues3 = new String[]{Messages.ELT_PROCESS_INIT, Messages.ELT_PROCESS_CHCK, Messages.ELT_PROCESS_TRAN, Messages.ELT_PROCESS_UPDT, Messages.ELT_PROCESS_DONE};
    private static String[] _eltProcessValues$ = new String[]{Messages.ELT_PROCESS_INIT, Messages.ELT_PROCESS_CHCK, Messages.ELT_PROCESS_TRAN, Messages.ELT_PROCESS_UPDT, Messages.ELT_PROCESS_DONE, Messages.ELT_PROCESS_TRCS};
    private static String[] _eltProcessValues4 = new String[]{Messages.ELT_PROCESS_INIT, Messages.ELT_PROCESS_SELC, Messages.ELT_PROCESS_TRAN, Messages.ELT_PROCESS_DONE};
    private String[] _predefinedCategories = new String[]{Messages.INIT_CATEG, Messages.ITER_CATEG, Messages.END_CATEG};
    private String[] _predefined_CHUP_SELC_Categories = new String[]{Messages.INIT_CATEG, Messages.ITER_CATEG, Messages.END_CATEG, Messages.AFTER_ITER_CATEG};
    protected StringBuilder _reference = new StringBuilder();
    private String CONTEXT_ID_FOR_HELP = "Macro_wiz_serv_view";

    public ServerLogicalViewInsertPage(String pageName) {
        super(pageName);
        this.setTitle(pageName);
    }

    public void createControl(Composite parent) {
        Composite composite = PTWidgetTool.createComposite((Composite)parent, (int)1, (boolean)false);
        PdpPacbasePlugin.setHelpMechanism(composite, this.CONTEXT_ID_FOR_HELP);
        this.createFunctionGroup(composite);
        PTWidgetTool.createLabel((Composite)composite, (String)"");
        this.createGeneralProcessComposite(composite);
        PTWidgetTool.createLabel((Composite)composite, (String)"");
        this.createActionsRadioButtonsGroup(composite);
        this.initDataWithModel();
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite);
        this.initListeners();
    }

    private void createFunctionGroup(Composite parent) {
        this._functionGroup = PTWidgetTool.createGroup((Composite)parent, (int)4, (String)"");
        PTWidgetTool.createLabel((Composite)this._functionGroup, (String)(String.valueOf(Messages.FUNCTION_CODE) + ": "));
        this._functionLabel = PTWidgetTool.createLabel((Composite)this._functionGroup, (String)"");
        ((GridData)this._functionLabel.getLayoutData()).grabExcessHorizontalSpace = true;
        PTWidgetTool.createLabel((Composite)this._functionGroup, (String)(String.valueOf(Messages.LEVEL) + ": "));
        this._levelLabel = PTWidgetTool.createLabel((Composite)this._functionGroup, (String)"");
        ((GridData)this._levelLabel.getLayoutData()).grabExcessHorizontalSpace = true;
    }

    private void createGeneralProcessComposite(Composite parent) {
        Composite composite = PTWidgetTool.createComposite((Composite)parent, (int)3, (boolean)false);
        PTWidgetTool.createLabel((Composite)composite, (String)Messages.PROCESS_TYPE);
        this._cbbProcessTypes = PTWidgetTool.createCombo((Composite)composite);
        this._cbbProcessTypes.setItems(_processTypeValues);
        this._cbbProcessTypes.setVisibleItemCount(_processTypeValues.length);
        this._cbbProcessTypes.select(0);
        PTWidgetTool.createLabel((Composite)composite, (String)"");
        PTWidgetTool.createLabel((Composite)composite, (String)"", (int)3);
        this.createServiceComposite(composite);
        this.createElementaryProcessComposite(composite);
        this.createSimpleDatas(composite);
        this.createCategoryComposite(composite);
    }

    private void createSimpleDatas(Composite composite) {
        PTWidgetTool.createLabel((Composite)composite, (String)Messages.FILE_CODE);
        this._fileCode = PTWidgetTool.createTextField((Composite)composite, (boolean)false, (boolean)false);
        this._fileCode.setTextLimit(2);
        this._fileCodeSelection = PTWidgetTool.createPushButton((Composite)composite, (String)Messages.BROWSE_BUTTON, (boolean)false);
        this._fileCode.setEnabled(false);
        PTWidgetTool.createLabel((Composite)composite, (String)Messages.SEGMENT_CODE);
        this._segmentCode = PTWidgetTool.createTextField((Composite)composite, (boolean)false, (boolean)false);
        this._segmentCode.setTextLimit(4);
        this._segmentSelection = PTWidgetTool.createPushButton((Composite)composite, (String)Messages.BROWSE_BUTTON, (boolean)false);
        this._segmentCode.setEnabled(false);
        this._dataEltCodeLabel = PTWidgetTool.createLabel((Composite)composite, (String)Messages.DATA_ELEMENT_CODE);
        this._dataEltCode = PTWidgetTool.createTextField((Composite)composite, (boolean)false, (boolean)false);
        this._dataEltCode.setTextLimit(6);
        this._dataEltSelection = PTWidgetTool.createPushButton((Composite)composite, (String)Messages.BROWSE_BUTTON, (boolean)false);
        this._dataEltCode.setEnabled(false);
    }

    private void createServiceComposite(Composite composite) {
        PTWidgetTool.createLabel((Composite)composite, (String)Messages.SERVICE_PROCESS_TYPE);
        this._cbbServiceTypes = PTWidgetTool.createDropDownCombo((Composite)composite);
        this._cbbServiceTypes.setEnabled(false);
        PTWidgetTool.createLabel((Composite)composite, (String)"");
    }

    private void createElementaryProcessComposite(Composite composite) {
        PTWidgetTool.createLabel((Composite)composite, (String)Messages.ELEMENTARY_PROCESS_TYPE);
        this._cbbElementaryProcessTypes = PTWidgetTool.createDropDownCombo((Composite)composite);
        this._cbbElementaryProcessTypes.setEnabled(false);
        PTWidgetTool.createLabel((Composite)composite, (String)"");
    }

    private void createCategoryComposite(Composite composite) {
        PTWidgetTool.createLabel((Composite)composite, (String)Messages.CATEGORY);
        this._cbbCategory = PTWidgetTool.createDropDownCombo((Composite)composite);
        this._cbbCategory.setEnabled(false);
        PTWidgetTool.createLabel((Composite)composite, (String)"");
    }

    private void createActionsRadioButtonsGroup(Composite parent) {
        Group group = PTWidgetTool.createGroup((Composite)parent, (int)5, (String)Messages.ACTION_TYPE);
        this._insertBeginButton = PTWidgetTool.createRadioButton((Composite)group, (String)Messages.INSERT_BEGIN, (boolean)false);
        this._insertBeginButton.setData("ACTION=", (Object)Location.BEGINNING);
        this._insertBeforeButton = PTWidgetTool.createRadioButton((Composite)group, (String)Messages.INSERTION_BEFORE, (boolean)false);
        this._insertBeforeButton.setData("ACTION=", (Object)Location.BEFORE);
        this._insertAfterButton = PTWidgetTool.createRadioButton((Composite)group, (String)Messages.INSERTION_AFTER, (boolean)false);
        this._insertAfterButton.setData("ACTION=", (Object)Location.AFTER);
        this._replaceButton = PTWidgetTool.createRadioButton((Composite)group, (String)Messages.REPLACE, (boolean)false);
        this._replaceButton.setData("ACTION=", (Object)Location.REPLACE);
    }

    public boolean canFlipToNextPage() {
        return false;
    }

    public IWizardPage getNextPage() {
        return null;
    }

    public void handleEvent(Event event) {
        this.handleCommonEvent(event);
        boolean isPagecomplete = this.isPageComplete();
        this.setPageComplete(isPagecomplete);
        this.getWizard().getContainer().updateButtons();
    }

    protected void handleCommonEvent(Event event) {
        this.handleGeneralProcessEvent(event);
        this.handleServiceTypeEvent(event);
        this.handleElementaryProcessEvent(event);
        this.handleCategoryEvent(event);
        if (event.widget == this._dataEltSelection) {
            this.handleEventForDataElementSelection();
        } else if (event.widget == this._segmentSelection) {
            this.handleEventForSegmentSelection();
        } else if (event.widget == this._fileCodeSelection) {
            this.handleEventForFileSelection();
        }
    }

    protected void handleEventForSegmentSelection() {
        PTElement element = ((FunctionWizard)this.getWizard()).openSelectionDialog(DataAggregate.class.getSimpleName());
        if (element != null) {
            this._segmentCode.setText(element.getName());
        }
    }

    protected void handleEventForDataElementSelection() {
        PTElement element = ((FunctionWizard)this.getWizard()).openSelectionDialog(DataElement.class.getSimpleName());
        if (element != null) {
            this._dataEltCode.setText(element.getName());
        }
    }

    protected void handleEventForFileSelection() {
        PTElement element = ((FunctionWizard)this.getWizard()).openSelectionDialog(DataUnit.class.getSimpleName());
        if (element != null) {
            this._fileCode.setText(element.getName());
        }
    }

    private void handleElementaryProcessEvent(Event event) {
        if (event.widget == this._cbbElementaryProcessTypes && event.type == 13 && this._cbbElementaryProcessTypes.getSelectionIndex() >= 0) {
            this._cbbElementaryProcessTypes.setText(this._cbbElementaryProcessTypes.getItem(this._cbbElementaryProcessTypes.getSelectionIndex()));
        }
    }

    private void handleCategoryEvent(Event event) {
        if (event.widget == this._cbbCategory && event.type == 13 && this._cbbCategory.getSelectionIndex() >= 0) {
            this._cbbCategory.setText(this._cbbCategory.getItem(this._cbbCategory.getSelectionIndex()));
        }
    }

    private void handleGeneralProcessEvent(Event event) {
        if (event.widget == this._cbbProcessTypes) {
            String[] values = null;
            String[] values_categ = null;
            this._cbbCategory.setEnabled(false);
            this._dataEltCode.setEnabled(false);
            this._dataEltSelection.setEnabled(false);
            this._fileCode.setEnabled(false);
            this._fileCodeSelection.setEnabled(false);
            this._segmentCode.setEnabled(false);
            this._segmentSelection.setEnabled(false);
            this._insertBeginButton.setEnabled(false);
            this._insertBeginButton.setSelection(false);
            if (this._cbbProcessTypes.getItem(this._cbbProcessTypes.getSelectionIndex()).equals(Messages.GAL_PROCESS_CHUP)) {
                values = _serviceCHUPValues;
                values_categ = this._predefined_CHUP_SELC_Categories;
            } else if (this._cbbProcessTypes.getItem(this._cbbProcessTypes.getSelectionIndex()).equals(Messages.GAL_PROCESS_SELC)) {
                values = _serviceSELCValues;
                values_categ = this._predefined_CHUP_SELC_Categories;
            } else if (this._cbbProcessTypes.getItem(this._cbbProcessTypes.getSelectionIndex()).equals(Messages.GAL_PROCESS_CHKD)) {
                this._dataEltCodeLabel.setEnabled(true);
                this._dataEltCode.setEnabled(true);
                this._dataEltSelection.setEnabled(true);
                this._cbbCategory.setEnabled(true);
                values_categ = this._predefinedCategories;
            } else if (this._cbbProcessTypes.getItem(this._cbbProcessTypes.getSelectionIndex()).equals(Messages.GAL_PROCESS_TRER)) {
                this._segmentCode.setEnabled(true);
                this._segmentSelection.setEnabled(true);
            } else if (this._cbbProcessTypes.getItem(this._cbbProcessTypes.getSelectionIndex()).equals(Messages.GAL_PROCESS_OPEN) || this._cbbProcessTypes.getItem(this._cbbProcessTypes.getSelectionIndex()).equals(Messages.GAL_PROCESS_CLOSE)) {
                this._fileCode.setEnabled(true);
                this._fileCodeSelection.setEnabled(true);
            } else if (this._cbbProcessTypes.getItem(this._cbbProcessTypes.getSelectionIndex()).equals(Messages.GAL_PROCESS_TRDT) || this._cbbProcessTypes.getItem(this._cbbProcessTypes.getSelectionIndex()).equals(Messages.GAL_PROCESS_TRVW)) {
                this._cbbCategory.setEnabled(true);
                values_categ = this._predefinedCategories;
            }
            if (this._cbbProcessTypes.getItem(this._cbbProcessTypes.getSelectionIndex()).equals(Messages.GAL_PROCESS_CHUP) || this._cbbProcessTypes.getItem(this._cbbProcessTypes.getSelectionIndex()).equals(Messages.GAL_PROCESS_SELC) || this._cbbProcessTypes.getItem(this._cbbProcessTypes.getSelectionIndex()).equals(Messages.GAL_PROCESS_TRDT) || this._cbbProcessTypes.getItem(this._cbbProcessTypes.getSelectionIndex()).equals(Messages.GAL_PROCESS_CHKD) || this._cbbProcessTypes.getItem(this._cbbProcessTypes.getSelectionIndex()).equals(Messages.GAL_PROCESS_TRVW)) {
                this._cbbCategory.setEnabled(true);
            }
            if (this._cbbProcessTypes.getItem(this._cbbProcessTypes.getSelectionIndex()).equals(Messages.GAL_PROCESS_CCNX) || this._cbbProcessTypes.getItem(this._cbbProcessTypes.getSelectionIndex()).equals(Messages.GAL_PROCESS_DCNX) || this._cbbProcessTypes.getItem(this._cbbProcessTypes.getSelectionIndex()).equals(Messages.GAL_PROCESS_OPEN) || this._cbbProcessTypes.getItem(this._cbbProcessTypes.getSelectionIndex()).equals(Messages.GAL_PROCESS_CLOSE) || this._cbbProcessTypes.getItem(this._cbbProcessTypes.getSelectionIndex()).equals(Messages.GAL_PROCESS_TRER) || this._cbbProcessTypes.getItem(this._cbbProcessTypes.getSelectionIndex()).equals(Messages.GAL_PROCESS_TRDT) || this._cbbProcessTypes.getItem(this._cbbProcessTypes.getSelectionIndex()).equals(Messages.GAL_PROCESS_TRVW) || this._cbbProcessTypes.getItem(this._cbbProcessTypes.getSelectionIndex()).equals(Messages.GAL_PROCESS_CHKD)) {
                this._insertBeginButton.setEnabled(true);
            }
            if (values == null) {
                this._cbbServiceTypes.setEnabled(false);
                this._cbbElementaryProcessTypes.setEnabled(false);
            } else {
                this._cbbServiceTypes.setEnabled(true);
                if (this._cbbServiceTypes.getItemCount() > 1) {
                    this._cbbServiceTypes.removeAll();
                }
                this._cbbServiceTypes.setItems(values);
                this._cbbServiceTypes.setVisibleItemCount(values.length);
            }
            if (values_categ == null) {
                this._cbbCategory.setEnabled(false);
                this._cbbElementaryProcessTypes.setEnabled(false);
            } else {
                this._cbbCategory.setEnabled(true);
                if (this._cbbCategory.getItemCount() > 1) {
                    this._cbbCategory.removeAll();
                }
                this._cbbCategory.setItems(values_categ);
                this._cbbCategory.setVisibleItemCount(values_categ.length);
            }
        }
    }

    private void handleServiceTypeEvent(Event event) {
        if (event.widget == this._cbbServiceTypes) {
            String[] values = null;
            if (event.type == 13) {
                if (this._cbbServiceTypes.getSelectionIndex() >= 0) {
                    this._cbbServiceTypes.setText(this._cbbServiceTypes.getItem(this._cbbServiceTypes.getSelectionIndex()));
                }
                if (this._cbbServiceTypes.getItemCount() > 0) {
                    if (this._cbbServiceTypes.getItem(this._cbbServiceTypes.getSelectionIndex()).equals(Messages.SERVICE_SRVE) || this._cbbServiceTypes.getItem(this._cbbServiceTypes.getSelectionIndex()).equals(Messages.SERVICE_SRVX)) {
                        values = _eltProcessValues1;
                    } else if (this._cbbServiceTypes.getItem(this._cbbServiceTypes.getSelectionIndex()).equals(Messages.SERVICE_SRVL)) {
                        values = _eltProcessValues2;
                    } else if (this._cbbServiceTypes.getItem(this._cbbServiceTypes.getSelectionIndex()).equals(Messages.SERVICE_SRVM) || this._cbbServiceTypes.getItem(this._cbbServiceTypes.getSelectionIndex()).equals(Messages.SERVICE_SRVT)) {
                        values = _eltProcessValues3;
                    } else if (this._cbbServiceTypes.getItem(this._cbbServiceTypes.getSelectionIndex()).equals(Messages.SERVICE_SRVA)) {
                        values = _eltProcessValues4;
                    }
                }
            } else if (event.type == 24 && this._cbbServiceTypes.getText().startsWith("$")) {
                values = _eltProcessValues$;
            }
            if (values != null) {
                if (this._cbbElementaryProcessTypes.getItemCount() > 1) {
                    this._cbbElementaryProcessTypes.removeAll();
                }
                this._cbbElementaryProcessTypes.setItems(values);
                this._cbbElementaryProcessTypes.setVisibleItemCount(values.length);
                this._cbbElementaryProcessTypes.setEnabled(true);
            } else {
                this._cbbElementaryProcessTypes.setEnabled(false);
            }
        }
    }

    protected void initFunctionDatasFromModel() {
        FunctionModel dataModel = ((FunctionWizard)this.getWizard()).getDataModel();
        this._functionLabel.setText(String.valueOf(dataModel.getFunction()) + dataModel.getSubFunction());
        this._levelLabel.setText(dataModel.getLevel());
    }

    protected void initDataWithModel() {
        String action;
        FunctionModel dataModel = ((FunctionWizard)this.getWizard()).getDataModel();
        StringTokenizer tokenizer = new StringTokenizer(dataModel.getReference(), " ");
        ArrayList<String> refs = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            refs.add(tokenizer.nextToken());
        }
        Event event = new Event();
        String service = "";
        String eltProcess = "";
        String categ = "";
        this._insertBeginButton.setEnabled(false);
        if (refs.size() > 0) {
            String process;
            if (refs.get(0) != null && ((String)refs.get(0)).trim().length() > 0) {
                int i = 0;
                while (i < this._cbbProcessTypes.getItems().length) {
                    String process2 = this._cbbProcessTypes.getItem(i).substring(0, 4);
                    if (((String)refs.get(0)).trim().equals(process2)) {
                        this._cbbProcessTypes.select(i);
                        event.widget = this._cbbProcessTypes;
                        this.handleGeneralProcessEvent(event);
                        break;
                    }
                    ++i;
                }
            }
            String galProcess = this._cbbProcessTypes.getItem(this._cbbProcessTypes.getSelectionIndex()).trim();
            if (refs.size() > 1) {
                if (galProcess.equals(Messages.GAL_PROCESS_CLOSE) || galProcess.equals(Messages.GAL_PROCESS_OPEN)) {
                    this._fileCode.setText(((String)refs.get(1)).trim());
                    this._fileCode.setEnabled(true);
                } else if (galProcess.equals(Messages.GAL_PROCESS_TRER)) {
                    this._segmentCode.setText(((String)refs.get(1)).trim());
                    this._segmentCode.setEnabled(true);
                } else {
                    this._cbbCategory.setEnabled(true);
                    categ = ((String)refs.get(1)).trim();
                    if (categ.contains("$")) {
                        this._cbbCategory.setText(categ);
                    } else {
                        int i = 0;
                        while (i < this._cbbCategory.getItems().length) {
                            String category = this._cbbCategory.getItem(i).substring(0, 4);
                            if (categ.equals(category)) {
                                this._cbbCategory.select(i);
                                this._cbbCategory.setText(this._cbbCategory.getItem(i));
                                break;
                            }
                            ++i;
                        }
                    }
                }
            }
            if (refs.size() > 2 && refs.get(2) != null && ((String)refs.get(2)).trim().length() > 0) {
                if (galProcess.equals(Messages.GAL_PROCESS_CHKD)) {
                    this._dataEltCode.setText(((String)refs.get(2)).trim());
                    this._dataEltCode.setEnabled(true);
                } else {
                    service = ((String)refs.get(2)).trim();
                    if (((String)refs.get(2)).contains("$")) {
                        this._cbbElementaryProcessTypes.setItems(_eltProcessValues3);
                        this._cbbServiceTypes.setText(service);
                    } else {
                        int i = 0;
                        while (i < this._cbbServiceTypes.getItems().length) {
                            process = this._cbbServiceTypes.getItem(i).substring(0, 4);
                            if (service.equals(process)) {
                                this._cbbServiceTypes.select(i);
                                event.widget = this._cbbServiceTypes;
                                event.type = 13;
                                this.handleServiceTypeEvent(event);
                                this._cbbServiceTypes.setEnabled(true);
                                break;
                            }
                            ++i;
                        }
                    }
                }
            }
            if (refs.size() > 3 && refs.get(3) != null && ((String)refs.get(3)).trim().length() > 0) {
                this._cbbElementaryProcessTypes.setEnabled(true);
                eltProcess = ((String)refs.get(3)).trim();
                if (eltProcess.startsWith("$")) {
                    this._cbbElementaryProcessTypes.setText(eltProcess);
                } else {
                    int i = 0;
                    while (i < this._cbbElementaryProcessTypes.getItems().length) {
                        process = this._cbbElementaryProcessTypes.getItem(i).substring(0, 4);
                        if (eltProcess.equals(process)) {
                            this._cbbElementaryProcessTypes.select(i);
                            this._cbbElementaryProcessTypes.setText(this._cbbElementaryProcessTypes.getItem(this._cbbElementaryProcessTypes.getSelectionIndex()));
                            break;
                        }
                        ++i;
                    }
                }
            }
        }
        if ((action = dataModel.getAction()) != null && action.trim().length() > 0) {
            if (action.equals("*P")) {
                this._insertAfterButton.setSelection(true);
            } else if (action.equals("*A")) {
                this._insertBeforeButton.setSelection(true);
            } else if (action.equals("*R")) {
                this._replaceButton.setSelection(true);
            } else if (action.equals("*B")) {
                this._insertBeginButton.setSelection(true);
            }
        }
    }

    private void initListeners() {
        this.initButtonListeners();
        this.initTextListeners();
        this.initComboListeners();
    }

    private void initButtonListeners() {
        this._dataEltSelection.addListener(13, (Listener)this);
        this._fileCodeSelection.addListener(13, (Listener)this);
        this._insertAfterButton.addListener(13, (Listener)this);
        this._insertBeforeButton.addListener(13, (Listener)this);
        this._insertBeginButton.addListener(13, (Listener)this);
        this._replaceButton.addListener(13, (Listener)this);
        this._segmentSelection.addListener(13, (Listener)this);
    }

    private void initTextListeners() {
        this._dataEltCode.addListener(24, (Listener)this);
        this._fileCode.addListener(24, (Listener)this);
        this._segmentCode.addListener(24, (Listener)this);
    }

    private void initComboListeners() {
        this._cbbCategory.addListener(13, (Listener)this);
        this._cbbCategory.addListener(24, (Listener)this);
        this._cbbElementaryProcessTypes.addListener(13, (Listener)this);
        this._cbbElementaryProcessTypes.addListener(24, (Listener)this);
        this._cbbProcessTypes.addListener(13, (Listener)this);
        this._cbbServiceTypes.addListener(13, (Listener)this);
        this._cbbServiceTypes.addListener(24, (Listener)this);
    }

    public boolean isPageComplete() {
        String eltProcess;
        String process;
        String segmentCode;
        String generalProcess = this._cbbProcessTypes.getItem(this._cbbProcessTypes.getSelectionIndex());
        FunctionModel dataModel = ((FunctionWizard)this.getWizard()).getDataModel();
        this._reference = new StringBuilder(generalProcess.substring(0, 4));
        String category = "";
        if (this._cbbCategory.isEnabled() && (category = this._cbbCategory.getText().trim().toUpperCase()).length() > 0) {
            if (category.contains("$")) {
                boolean isValid = PacFunctionCheckingUtilities.isParameterWithDollarWellFormed((String)category, (String[])CATEG);
                if (!isValid) {
                    this.setErrorMessage(String.valueOf(Messages.CATEGORY) + ": " + Messages.DATA_INVALID);
                    return false;
                }
            } else {
                if (category.length() < 4) {
                    this.setErrorMessage(String.valueOf(Messages.CATEGORY) + ": " + Messages.DATA_INVALID);
                    return false;
                }
                category = category.substring(0, 4);
                boolean exist = false;
                int i = 0;
                while (i < this._predefined_CHUP_SELC_Categories.length) {
                    String process2 = this._predefined_CHUP_SELC_Categories[i].substring(0, 4);
                    if (category.equals(process2)) {
                        exist = true;
                        this._cbbCategory.removeListener(24, (Listener)this);
                        this._cbbCategory.setText(this._predefined_CHUP_SELC_Categories[i]);
                        this._cbbCategory.addListener(24, (Listener)this);
                        break;
                    }
                    ++i;
                }
                if (!exist) {
                    this.setErrorMessage(String.valueOf(Messages.CATEGORY) + ": " + Messages.DATA_INVALID);
                    return false;
                }
            }
            this._reference.append(" ").append(category);
        }
        if (generalProcess.equals(Messages.GAL_PROCESS_CHKD)) {
            String dataEltCode = this._dataEltCode.getText().trim().toUpperCase();
            if (dataEltCode.startsWith("$")) {
                if (dataEltCode.length() != 2) {
                    this.setErrorMessage(String.valueOf(Messages.DATA_ELEMENT_CODE) + ": " + Messages.DATA_INVALID);
                    return false;
                }
                if (!FunctionWizard.IsExistingData(dataEltCode.toUpperCase(), PARAMS$, dataModel.isMacro())) {
                    this.setErrorMessage(String.valueOf(Messages.DATA_ELEMENT_CODE) + ": " + Messages.DATA_INVALID);
                    return false;
                }
            }
            if (dataEltCode.length() > 0) {
                if (category.trim().length() == 0) {
                    this.setErrorMessage(String.valueOf(Messages.CATEGORY) + ": " + Messages.DATA_REQUIRED);
                    return false;
                }
                this._reference.append(" ").append(dataEltCode);
            }
        } else if (generalProcess.equals(Messages.GAL_PROCESS_CLOSE) || generalProcess.equals(Messages.GAL_PROCESS_OPEN)) {
            String fileCode = this._fileCode.getText().trim().toUpperCase();
            if (fileCode.length() > 0) {
                if (fileCode.length() != 2) {
                    this.setErrorMessage(String.valueOf(Messages.FILE_CODE) + ": " + Messages.DATA_INVALID);
                    return false;
                }
                if (fileCode.startsWith("$") && !FunctionWizard.IsExistingData(fileCode.toUpperCase(), PARAMS$, dataModel.isMacro())) {
                    this.setErrorMessage(String.valueOf(Messages.FILE_CODE) + ": " + Messages.DATA_INVALID);
                    return false;
                }
                this._reference.append(" ").append(fileCode);
            }
        } else if (generalProcess.equals(Messages.GAL_PROCESS_TRER) && (segmentCode = this._segmentCode.getText().trim().toUpperCase()).length() > 0) {
            if (segmentCode.startsWith("$") && segmentCode.length() != 2 && segmentCode.length() != 4 || !segmentCode.startsWith("$") && segmentCode.length() != 4) {
                this.setErrorMessage(String.valueOf(Messages.SEGMENT_CODE) + ": " + Messages.DATA_INVALID);
                return false;
            }
            if (segmentCode.startsWith("$") && !FunctionWizard.IsExistingData(segmentCode.toUpperCase(), PARAMS$, dataModel.isMacro())) {
                this.setErrorMessage(String.valueOf(Messages.SEGMENT_CODE) + ": " + Messages.DATA_INVALID);
                return false;
            }
            this._reference.append(" ").append(segmentCode);
        }
        if (this._cbbServiceTypes.isEnabled()) {
            String serviceProcess = this._cbbServiceTypes.getText().trim().toUpperCase();
            if (serviceProcess.length() > 0) {
                if (serviceProcess.contains("$")) {
                    boolean isValid;
                    String[] table = new String[]{"SRVA"};
                    if ("CHUP".equals(generalProcess)) {
                        table = SERVICES_CHUP;
                    }
                    if (!(isValid = PacFunctionCheckingUtilities.isParameterWithDollarWellFormed((String)serviceProcess, (String[])table))) {
                        this.setErrorMessage(String.valueOf(Messages.SERVICE_PROCESS_TYPE) + ": " + Messages.DATA_INVALID);
                        return false;
                    }
                } else {
                    if (serviceProcess.length() < 4) {
                        this.setErrorMessage(String.valueOf(Messages.SERVICE_PROCESS_TYPE) + ": " + Messages.DATA_INVALID);
                        return false;
                    }
                    serviceProcess = serviceProcess.substring(0, 4);
                    boolean exist = false;
                    int i = 0;
                    while (i < this._cbbServiceTypes.getItems().length) {
                        process = this._cbbServiceTypes.getItem(i).substring(0, 4);
                        if (serviceProcess.equals(process)) {
                            exist = true;
                            this._cbbServiceTypes.removeListener(24, (Listener)this);
                            this._cbbServiceTypes.setText(this._cbbServiceTypes.getItem(i));
                            this._cbbServiceTypes.addListener(24, (Listener)this);
                            break;
                        }
                        ++i;
                    }
                    if (!exist) {
                        this.setErrorMessage(String.valueOf(Messages.SERVICE_PROCESS_TYPE) + ": " + Messages.DATA_INVALID);
                        return false;
                    }
                }
                this._reference.append(" ").append(serviceProcess);
            }
            if (serviceProcess.trim().length() > 0 && category.trim().length() == 0) {
                this.setErrorMessage(String.valueOf(Messages.CATEGORY) + ": " + Messages.DATA_REQUIRED);
                return false;
            }
        }
        if (this._cbbElementaryProcessTypes.isEnabled() && (eltProcess = this._cbbElementaryProcessTypes.getText().trim().toUpperCase()).length() > 0) {
            if (eltProcess.startsWith("$")) {
                if (eltProcess.length() != 2) {
                    this.setErrorMessage(String.valueOf(Messages.ELEMENTARY_PROCESS_TYPE) + ": " + Messages.DATA_INVALID);
                    return false;
                }
                if (!FunctionWizard.IsExistingData(eltProcess.toUpperCase(), PARAMS$, dataModel.isMacro())) {
                    this.setErrorMessage(String.valueOf(Messages.ELEMENTARY_PROCESS_TYPE) + ": " + Messages.DATA_INVALID);
                    return false;
                }
            } else {
                if (eltProcess.length() < 4) {
                    this.setErrorMessage(String.valueOf(Messages.ELEMENTARY_PROCESS_TYPE) + ": " + Messages.DATA_INVALID);
                    return false;
                }
                eltProcess = eltProcess.substring(0, 4);
                boolean exist = false;
                int i = 0;
                while (i < this._cbbElementaryProcessTypes.getItems().length) {
                    process = this._cbbElementaryProcessTypes.getItem(i).substring(0, 4);
                    if (eltProcess.equals(process)) {
                        exist = true;
                        this._cbbElementaryProcessTypes.removeListener(24, (Listener)this);
                        this._cbbElementaryProcessTypes.setText(this._cbbElementaryProcessTypes.getItem(i));
                        this._cbbElementaryProcessTypes.addListener(24, (Listener)this);
                        break;
                    }
                    ++i;
                }
                if (!exist) {
                    this.setErrorMessage(String.valueOf(Messages.ELEMENTARY_PROCESS_TYPE) + ": " + Messages.DATA_INVALID);
                    return false;
                }
            }
            this._reference.append(" ").append(eltProcess);
        }
        if (!(this._insertBeginButton.getSelection() || this._insertAfterButton.getSelection() || this._insertBeforeButton.getSelection() || this._replaceButton.getSelection())) {
            this.setErrorMessage(String.valueOf(Messages.ACTION_TYPE) + ": " + Messages.DATA_REQUIRED);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    @Override
    public void saveDataToModel() {
        FunctionModel dataModel = ((FunctionWizard)this.getWizard()).getDataModel();
        if (this._insertAfterButton.getSelection()) {
            dataModel.setAction(Location.AFTER.getInsertMspName());
        }
        if (this._insertBeforeButton.getSelection()) {
            dataModel.setAction(Location.BEFORE.getInsertMspName());
        }
        if (this._replaceButton.getSelection()) {
            dataModel.setAction(Location.REPLACE.getInsertMspName());
        }
        if (this._insertBeginButton.getSelection()) {
            dataModel.setAction(Location.BEGINNING.getInsertMspName());
        }
        dataModel.setReference(this._reference.toString());
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.initFunctionDatasFromModel();
        }
        super.setVisible(visible);
    }
}

