/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.wizards;

import com.ibm.pdp.explorer.model.PTElement;
import com.ibm.pdp.explorer.view.service.PTWidgetTool;
import com.ibm.pdp.mdl.kernel.DataAggregate;
import com.ibm.pdp.mdl.pacbase.util.IPacFunctionConstants;
import com.ibm.pdp.mdl.pacbase.util.PacFunctionCheckingUtilities;
import com.ibm.pdp.pacbase.PdpPacbasePlugin;
import com.ibm.pdp.pacbase.extension.organize.Location;
import com.ibm.pdp.pacbase.wizards.FunctionModel;
import com.ibm.pdp.pacbase.wizards.FunctionWizard;
import com.ibm.pdp.pacbase.wizards.IFunctionWizardPage;
import com.ibm.pdp.pacbase.wizards.Messages;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class ServerLogicalAccessInsertPage
extends WizardPage
implements IPacFunctionConstants,
Listener,
IFunctionWizardPage {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2013, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Combo _cbbCategory;
    public Combo _cbbProcessTypes;
    private Combo _cbbElementaryProcessTypes;
    protected Text _segmentCode;
    protected Button _insertAfterButton;
    protected Button _insertBeforeButton;
    protected Button _insertBeginButton;
    protected Button _replaceButton;
    private Button _segmentSelection;
    protected Label _functionLabel;
    private Label _levelLabel;
    private Group _functionGroup;
    private static String[] _processTypeValues = new String[]{Messages.LOGICAL_ACCESS_CHCK, Messages.LOGICAL_ACCESS_SLCT, Messages.LOGICAL_ACCESS_UPDT};
    private static String[] _elementaryProcessValues = new String[]{Messages.PROCESS_ALIM, Messages.PROCESS_CALL, Messages.PROCESS_ERRS};
    private String[] _predefinedCategories = new String[]{Messages.INIT_CATEG, Messages.ITER_CATEG, Messages.END_CATEG};
    protected StringBuilder _reference = new StringBuilder();
    private String CONTEXT_ID_FOR_HELP = "Macro_wiz_serv_log";

    public ServerLogicalAccessInsertPage(String pageName) {
        super(pageName);
        this.setTitle(pageName);
    }

    public void createControl(Composite parent) {
        Composite composite = PTWidgetTool.createComposite((Composite)parent, (int)1, (boolean)false);
        PdpPacbasePlugin.setHelpMechanism(composite, this.CONTEXT_ID_FOR_HELP);
        this.createFunctionGroup(composite);
        PTWidgetTool.createLabel((Composite)composite, (String)"");
        this.createGeneralDatasComposite(composite);
        this.createActionsRadioButtonsGroup(composite);
        this.initDataWithModel();
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite);
        this.initListeners();
    }

    private void createFunctionGroup(Composite parent) {
        this._functionGroup = PTWidgetTool.createGroup((Composite)parent, (int)4, (String)"");
        PTWidgetTool.createLabel((Composite)this._functionGroup, (String)(String.valueOf(Messages.FUNCTION_CODE) + ": "));
        this._functionLabel = PTWidgetTool.createLabel((Composite)this._functionGroup, (String)"");
        ((GridData)this._functionLabel.getLayoutData()).grabExcessHorizontalSpace = true;
        PTWidgetTool.createLabel((Composite)this._functionGroup, (String)(String.valueOf(Messages.LEVEL) + ": "));
        this._levelLabel = PTWidgetTool.createLabel((Composite)this._functionGroup, (String)"");
        ((GridData)this._levelLabel.getLayoutData()).grabExcessHorizontalSpace = true;
    }

    private void createGeneralDatasComposite(Composite parent) {
        Composite composite = PTWidgetTool.createComposite((Composite)parent, (int)3, (boolean)false);
        PTWidgetTool.createLabel((Composite)composite, (String)Messages.PROCESS_TYPE);
        this._cbbProcessTypes = PTWidgetTool.createCombo((Composite)composite);
        this._cbbProcessTypes.setItems(_processTypeValues);
        this._cbbProcessTypes.setVisibleItemCount(_processTypeValues.length);
        this._cbbProcessTypes.select(0);
        PTWidgetTool.createLabel((Composite)composite, (String)"");
        PTWidgetTool.createLabel((Composite)composite, (String)"", (int)3);
        PTWidgetTool.createLabel((Composite)composite, (String)"", (int)3);
        PTWidgetTool.createLabel((Composite)composite, (String)Messages.SEGMENT_CODE);
        this._segmentCode = PTWidgetTool.createTextField((Composite)composite, (boolean)false, (boolean)false);
        this._segmentCode.setTextLimit(4);
        this._segmentSelection = PTWidgetTool.createPushButton((Composite)composite, (String)Messages.BROWSE_BUTTON, (boolean)true);
        PTWidgetTool.createLabel((Composite)composite, (String)Messages.ELEMENTARY_PROCESS_TYPE);
        this._cbbElementaryProcessTypes = PTWidgetTool.createDropDownCombo((Composite)composite);
        this._cbbElementaryProcessTypes.setItems(_elementaryProcessValues);
        this._cbbElementaryProcessTypes.setVisibleItemCount(_elementaryProcessValues.length);
        PTWidgetTool.createLabel((Composite)composite, (String)"");
        PTWidgetTool.createLabel((Composite)composite, (String)Messages.CATEGORY);
        this._cbbCategory = PTWidgetTool.createDropDownCombo((Composite)composite);
        this._cbbCategory.setItems(this._predefinedCategories);
        this._cbbCategory.setVisibleItemCount(this._predefinedCategories.length);
        PTWidgetTool.createLabel((Composite)composite, (String)" ", (int)4);
    }

    private void createActionsRadioButtonsGroup(Composite parent) {
        Group group = PTWidgetTool.createGroup((Composite)parent, (int)5, (String)Messages.ACTION_TYPE);
        this._insertBeginButton = PTWidgetTool.createRadioButton((Composite)group, (String)Messages.INSERT_BEGIN, (boolean)false);
        this._insertBeginButton.setData("ACTION=", (Object)Location.BEGINNING);
        this._insertBeforeButton = PTWidgetTool.createRadioButton((Composite)group, (String)Messages.INSERTION_BEFORE, (boolean)false);
        this._insertBeforeButton.setData("ACTION=", (Object)Location.BEFORE);
        this._insertAfterButton = PTWidgetTool.createRadioButton((Composite)group, (String)Messages.INSERTION_AFTER, (boolean)false);
        this._insertAfterButton.setData("ACTION=", (Object)Location.AFTER);
        this._replaceButton = PTWidgetTool.createRadioButton((Composite)group, (String)Messages.REPLACE, (boolean)false);
        this._replaceButton.setData("ACTION=", (Object)Location.REPLACE);
    }

    public boolean canFlipToNextPage() {
        return false;
    }

    public IWizardPage getNextPage() {
        return null;
    }

    public void handleEvent(Event event) {
        if (event.widget == this._segmentSelection) {
            this.handleEventForSegmentSelection();
        } else if (event.widget == this._cbbCategory && event.type == 13) {
            if (this._cbbCategory.getSelectionIndex() >= 0) {
                this._cbbCategory.setText(this._cbbCategory.getItem(this._cbbCategory.getSelectionIndex()));
            }
        } else if (event.widget == this._cbbElementaryProcessTypes && event.type == 13 && this._cbbElementaryProcessTypes.getSelectionIndex() >= 0) {
            this._cbbElementaryProcessTypes.setText(this._cbbElementaryProcessTypes.getItem(this._cbbElementaryProcessTypes.getSelectionIndex()));
        }
        boolean isPagecomplete = this.isPageComplete();
        this.setPageComplete(isPagecomplete);
        this.getWizard().getContainer().updateButtons();
    }

    protected void handleEventForSegmentSelection() {
        PTElement element = ((FunctionWizard)this.getWizard()).openSelectionDialog(DataAggregate.class.getSimpleName());
        if (element != null) {
            this._segmentCode.setText(element.getName());
        }
    }

    private void initListeners() {
        this._segmentCode.addListener(24, (Listener)this);
        this.initButtonListeners();
        this.initComboListeners();
    }

    private void initButtonListeners() {
        this._insertAfterButton.addListener(13, (Listener)this);
        this._insertBeforeButton.addListener(13, (Listener)this);
        this._insertBeginButton.addListener(13, (Listener)this);
        this._replaceButton.addListener(13, (Listener)this);
        this._segmentSelection.addListener(13, (Listener)this);
    }

    private void initComboListeners() {
        this._cbbCategory.addListener(13, (Listener)this);
        this._cbbCategory.addListener(24, (Listener)this);
        this._cbbProcessTypes.addListener(13, (Listener)this);
        this._cbbElementaryProcessTypes.addListener(13, (Listener)this);
        this._cbbElementaryProcessTypes.addListener(24, (Listener)this);
    }

    public boolean isPageComplete() {
        String eltProcess;
        String generalProcess = this._cbbProcessTypes.getItem(this._cbbProcessTypes.getSelectionIndex());
        this._reference = new StringBuilder(generalProcess.substring(0, 4));
        String segmentCode = this._segmentCode.getText().toUpperCase().trim();
        if (segmentCode.length() == 0) {
            this.setErrorMessage(String.valueOf(Messages.SEGMENT_CODE) + " " + Messages.DATA_REQUIRED);
            return false;
        }
        if (segmentCode.startsWith("$") && segmentCode.length() != 2 && segmentCode.length() != 4 || !segmentCode.startsWith("$") && segmentCode.length() != 4) {
            this.setErrorMessage(String.valueOf(Messages.SEGMENT_CODE) + ": " + Messages.DATA_INVALID);
            return false;
        }
        FunctionModel dataModel = ((FunctionWizard)this.getWizard()).getDataModel();
        if (segmentCode.startsWith("$") && !FunctionWizard.IsExistingData(segmentCode.toUpperCase(), PARAMS$, dataModel.isMacro())) {
            this.setErrorMessage(String.valueOf(Messages.SEGMENT_CODE) + ": " + Messages.DATA_INVALID);
            return false;
        }
        this._reference.append(" ").append(segmentCode);
        String category = this._cbbCategory.getText().trim().toUpperCase();
        if (category.length() > 0) {
            if (category.contains("$")) {
                boolean isValid = PacFunctionCheckingUtilities.isParameterWithDollarWellFormed((String)category, (String[])CATEG);
                if (!isValid) {
                    this.setErrorMessage(String.valueOf(Messages.CATEGORY) + ": " + Messages.DATA_INVALID);
                    return false;
                }
            } else {
                if (category.length() < 4) {
                    this.setErrorMessage(String.valueOf(Messages.CATEGORY) + ": " + Messages.DATA_INVALID);
                    return false;
                }
                category = category.substring(0, 4);
                boolean exist = false;
                int i = 0;
                while (i < this._predefinedCategories.length) {
                    String categ = this._predefinedCategories[i].substring(0, 4);
                    if (category.equals(categ)) {
                        this._cbbCategory.removeListener(24, (Listener)this);
                        this._cbbCategory.setText(this._predefinedCategories[i]);
                        this._cbbCategory.addListener(24, (Listener)this);
                        exist = true;
                        break;
                    }
                    ++i;
                }
                if (!exist) {
                    this.setErrorMessage(String.valueOf(Messages.CATEGORY) + ": " + Messages.DATA_INVALID);
                    return false;
                }
            }
            this._reference.append(" ").append(category);
        }
        if ((eltProcess = this._cbbElementaryProcessTypes.getText().trim().toUpperCase()).length() > 0) {
            if (eltProcess.startsWith("$")) {
                if (eltProcess.length() != 2) {
                    this.setErrorMessage(String.valueOf(Messages.ELEMENTARY_PROCESS_TYPE) + ": " + Messages.DATA_INVALID);
                    return false;
                }
                if (!FunctionWizard.IsExistingData(eltProcess.toUpperCase(), PARAMS$, dataModel.isMacro())) {
                    this.setErrorMessage(String.valueOf(Messages.ELEMENTARY_PROCESS_TYPE) + ": " + Messages.DATA_INVALID);
                    return false;
                }
            } else {
                if (eltProcess.length() < 4) {
                    this.setErrorMessage(String.valueOf(Messages.ELEMENTARY_PROCESS_TYPE) + ": " + Messages.DATA_INVALID);
                    return false;
                }
                eltProcess = eltProcess.substring(0, 4);
                boolean exist = false;
                int i = 0;
                while (i < _elementaryProcessValues.length) {
                    String process = _elementaryProcessValues[i].substring(0, 4);
                    if (eltProcess.equals(process)) {
                        exist = true;
                        this._cbbElementaryProcessTypes.removeListener(24, (Listener)this);
                        this._cbbElementaryProcessTypes.setText(_elementaryProcessValues[i]);
                        this._cbbElementaryProcessTypes.addListener(24, (Listener)this);
                        break;
                    }
                    ++i;
                }
                if (!exist) {
                    this.setErrorMessage(String.valueOf(Messages.ELEMENTARY_PROCESS_TYPE) + ": " + Messages.DATA_INVALID);
                    return false;
                }
            }
            if (category.trim().length() == 0) {
                this.setErrorMessage(String.valueOf(Messages.CATEGORY) + ": " + Messages.DATA_REQUIRED);
                return false;
            }
            this._reference.append(" ").append(eltProcess);
        }
        if (!(this._insertBeginButton.getSelection() || this._insertAfterButton.getSelection() || this._insertBeforeButton.getSelection() || this._replaceButton.getSelection())) {
            this.setErrorMessage(String.valueOf(Messages.ACTION_TYPE) + ": " + Messages.DATA_REQUIRED);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    private void initFunctionDatasFromModel() {
        FunctionModel dataModel = ((FunctionWizard)this.getWizard()).getDataModel();
        this._functionLabel.setText(String.valueOf(dataModel.getFunction()) + dataModel.getSubFunction());
        this._levelLabel.setText(dataModel.getLevel());
    }

    protected void initDataWithModel() {
        String action;
        FunctionModel dataModel = ((FunctionWizard)this.getWizard()).getDataModel();
        StringTokenizer tokenizer = new StringTokenizer(dataModel.getReference(), " ");
        ArrayList<String> refs = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            refs.add(tokenizer.nextToken());
        }
        String categ = "";
        String eltProcess = "";
        if (refs.size() > 0) {
            String process;
            int i;
            if (refs.get(0) != null && ((String)refs.get(0)).trim().length() > 0) {
                i = 0;
                while (i < this._cbbProcessTypes.getItems().length) {
                    process = this._cbbProcessTypes.getItem(i).substring(0, 4);
                    if (((String)refs.get(0)).trim().equals(process)) {
                        this._cbbProcessTypes.select(i);
                        break;
                    }
                    ++i;
                }
            }
            if (refs.size() > 1) {
                this._segmentCode.setText(((String)refs.get(1)).trim());
                this._segmentCode.setEnabled(true);
            }
            if (refs.size() > 2) {
                categ = ((String)refs.get(2)).trim();
                if (categ.startsWith("$")) {
                    this._cbbCategory.setText(categ);
                } else {
                    i = 0;
                    while (i < this._cbbCategory.getItems().length) {
                        String category = this._cbbCategory.getItem(i).substring(0, 4);
                        if (categ.equals(category)) {
                            this._cbbCategory.select(i);
                            this._cbbCategory.setText(this._cbbCategory.getItem(this._cbbCategory.getSelectionIndex()));
                            break;
                        }
                        ++i;
                    }
                }
            }
            if (refs.size() > 3) {
                eltProcess = ((String)refs.get(3)).trim();
                if (eltProcess.startsWith("$")) {
                    this._cbbElementaryProcessTypes.setText(eltProcess);
                } else {
                    i = 0;
                    while (i < this._cbbElementaryProcessTypes.getItems().length) {
                        process = this._cbbElementaryProcessTypes.getItem(i).substring(0, 4);
                        if (eltProcess.equals(process)) {
                            this._cbbElementaryProcessTypes.select(i);
                            this._cbbElementaryProcessTypes.setText(this._cbbElementaryProcessTypes.getItem(this._cbbElementaryProcessTypes.getSelectionIndex()));
                            break;
                        }
                        ++i;
                    }
                }
            }
        }
        if ((action = dataModel.getAction()) != null && action.trim().length() > 0) {
            if (action.equals("*P")) {
                this._insertAfterButton.setSelection(true);
            } else if (action.equals("*A")) {
                this._insertBeforeButton.setSelection(true);
            } else if (action.equals("*R")) {
                this._replaceButton.setSelection(true);
            } else if (action.equals("*B")) {
                this._insertBeginButton.setSelection(true);
            }
        }
    }

    @Override
    public void saveDataToModel() {
        FunctionModel dataModel = ((FunctionWizard)this.getWizard()).getDataModel();
        if (this._insertAfterButton.getSelection()) {
            dataModel.setAction("*P");
        }
        if (this._insertBeforeButton.getSelection()) {
            dataModel.setAction("*A");
        }
        if (this._replaceButton.getSelection()) {
            dataModel.setAction("*R");
        }
        if (this._insertBeginButton.getSelection()) {
            dataModel.setAction("*B");
        }
        if (this._insertBeginButton.getSelection()) {
            dataModel.setAction("*B");
        }
        dataModel.setReference(this._reference.toString());
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.initFunctionDatasFromModel();
        }
        super.setVisible(visible);
    }
}

