/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.wizards;

import com.ibm.pdp.engine.tree.IEditTree;
import com.ibm.pdp.mdl.pacbase.util.IPacFunctionConstants;
import com.ibm.pdp.pacbase.IFunctionNode;
import com.ibm.pdp.pacbase.INodeLoader;
import com.ibm.pdp.pacbase.extension.organize.Location;
import com.ibm.pdp.pacbase.wizards.FunctionModel;
import com.ibm.pdp.pacbase.wizards.FunctionWizard;
import com.ibm.pdp.pacbase.wizards.FunctionWizardForPdpEditor;
import com.ibm.pdp.pacbase.wizards.IFunctionControls;
import com.ibm.pdp.pacbase.wizards.IPdpEditorFunctionControls;
import com.ibm.pdp.pacbase.wizards.Messages;
import com.ibm.pdp.pacbase.wizards.PdpEditorFunctionControls;
import com.ibm.pdp.pacbase.wizards.PdpFunctionWizardUtil;
import com.ibm.pdp.pacbase.wizards.ServerGeneralInsertPage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Listener;

public class ServerGeneralInsertPageForPdpEditor
extends ServerGeneralInsertPage
implements Listener,
IPacFunctionConstants {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private IEditTree _editTree;

    public ServerGeneralInsertPageForPdpEditor(String pageName, IEditTree editTree) {
        super(pageName);
        this.setTitle(pageName);
        this._editTree = editTree;
    }

    @Override
    public boolean isPageComplete() {
        String message;
        FunctionModel oldDataModel;
        boolean isComplete = super.isPageComplete();
        if (!isComplete) {
            return false;
        }
        IFunctionControls controls = ((FunctionWizardForPdpEditor)this.getWizard()).getFunctionControls();
        INodeLoader nodeLoader = null;
        if (controls instanceof IPdpEditorFunctionControls) {
            IPdpEditorFunctionControls pdpControls = (IPdpEditorFunctionControls)controls;
            nodeLoader = pdpControls.getNodeLoader();
        }
        FunctionModel dataModel = ((FunctionWizardForPdpEditor)this.getWizard()).getDataModel();
        String functionName = "F" + dataModel.getFunction();
        String reference = dataModel.getReference();
        String tagName = PdpFunctionWizardUtil.buildTagNameInServer(reference);
        String oldFunction = null;
        if (dataModel.isMoveAction() && (oldDataModel = ((FunctionWizard)this.getWizard()).getOldDataModel()) != null) {
            oldFunction = "F" + oldDataModel.getFunction() + oldDataModel.getSubFunction();
        }
        if ((message = PdpFunctionWizardUtil.isServerPageComplete(tagName, reference.toString(), nodeLoader, this._editTree, functionName, this._replaceButton.getSelection(), oldFunction)).length() > 0) {
            this.setErrorMessage(message);
            return false;
        }
        if (this._replaceButton.getSelection()) {
            String[] fcts = PdpFunctionWizardUtil.searchFunctionForAttach(reference, this._editTree);
            if (nodeLoader != null && fcts.length > 0) {
                List<IFunctionNode> allNodes = nodeLoader.getNodesList();
                for (IFunctionNode fn : allNodes) {
                    String[] stringArray = fcts;
                    int n = fcts.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String fct = stringArray[n2];
                        if (fn.getName().startsWith(fct)) {
                            this.setErrorMessage(String.valueOf(tagName) + " " + Messages.AUTOMATIC_FUNCTION_HAS_RELATIVE + " " + Messages.FORBIDDEN_TO_OVERRIDE_FUNCTIONS);
                            return false;
                        }
                        ++n2;
                    }
                }
            }
        }
        this.setGenerationMessage(reference);
        return true;
    }

    @Override
    protected void initDataWithModel() {
        super.initDataWithModel();
        FunctionModel dataModel = ((FunctionWizard)this.getWizard()).getDataModel();
        if (Location.ATTACH.getInsertMspName().equals(dataModel.getAction())) {
            if (this._logicalViewButton.getSelection()) {
                this._serverBeginButton.setEnabled(false);
                this._serverEndButton.setEnabled(false);
                this._SQLCursorsDeclarationButton.setEnabled(false);
            }
        } else {
            String action = dataModel.getAction();
            if (action != null && action.trim().length() > 0) {
                this._insertNoneButton.setSelection(false);
                if (action.equals("*P")) {
                    this._insertAfterButton.setSelection(true);
                } else if (action.equals("*A")) {
                    this._insertBeforeButton.setSelection(true);
                } else if (action.equals("*R")) {
                    this._replaceButton.setSelection(true);
                }
            }
        }
    }

    @Override
    public void saveDataToModel() {
        super.saveDataToModel();
        FunctionModel dataModel = ((FunctionWizard)this.getWizard()).getDataModel();
        if (dataModel.getReference().startsWith("BS ") || dataModel.getReference().startsWith("ES ") || dataModel.getReference().startsWith("SQ ")) {
            dataModel.setReference(dataModel.getReference().substring(0, 2));
            if (this._insertAfterButton.getSelection()) {
                dataModel.setAction("*P");
            } else if (this._insertBeforeButton.getSelection()) {
                dataModel.setAction("*A");
            } else if (this._replaceButton.getSelection()) {
                dataModel.setAction("*R");
            }
        }
    }

    private void setGenerationMessage(String reference) {
        Button[] buttons = new Button[]{this._insertAfterButton, this._insertBeforeButton, this._insertNoneButton, this._replaceButton};
        String message = PdpFunctionWizardUtil.getGenerationMessageForServerPage(((FunctionWizard)this.getWizard()).getDataModel(), ((FunctionWizardForPdpEditor)this.getWizard()).getOldDataModel(), reference.toString(), buttons);
        this.setMessage(message, 1);
    }

    @Override
    protected void handleEventForLogicalViewSelection() {
        IFunctionControls controls = ((FunctionWizardForPdpEditor)this.getWizard()).getFunctionControls();
        PdpEditorFunctionControls pdpControls = (PdpEditorFunctionControls)controls;
        Map<String, String[]> logicalViewLines = pdpControls.getAllSegmentLines();
        ArrayList<String[]> list = new ArrayList<String[]>();
        for (Map.Entry<String, String[]> lv : logicalViewLines.entrySet()) {
            if (!"LV".equals(lv.getValue()[1])) continue;
            list.add(new String[]{lv.getKey(), lv.getValue()[0]});
        }
        String element = PdpFunctionWizardUtil.openListDialog(this.getShell(), list, Messages.LOGICAL_VIEW_SELECTION);
        if (element != null) {
            this._logicalViewCode.setText(element);
        }
    }
}

