/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.wizards;

import com.ibm.pdp.explorer.model.PTElement;
import com.ibm.pdp.explorer.view.service.PTWidgetTool;
import com.ibm.pdp.mdl.kernel.DataAggregate;
import com.ibm.pdp.mdl.pacbase.util.IPacFunctionConstants;
import com.ibm.pdp.pacbase.PdpPacbasePlugin;
import com.ibm.pdp.pacbase.wizards.FunctionModel;
import com.ibm.pdp.pacbase.wizards.FunctionWizard;
import com.ibm.pdp.pacbase.wizards.IFunctionWizardPage;
import com.ibm.pdp.pacbase.wizards.Messages;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class ServerGeneralInsertPage
extends WizardPage
implements Listener,
IPacFunctionConstants,
IFunctionWizardPage {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2013, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Label _functionLabel;
    private Label _levelLabel;
    private Label _logicalViewLabel;
    protected Button _insertAfterButton;
    protected Button _insertBeforeButton;
    protected Button _insertNoneButton;
    protected Button _logicalViewButton;
    private Button _logicalViewSelection;
    protected Button _replaceButton;
    protected Button _serverBeginButton;
    protected Button _serverEndButton;
    protected Button _SQLCursorsDeclarationButton;
    protected Text _logicalViewCode;
    private boolean init = true;
    private String CONTEXT_ID_FOR_HELP = "Macro_wiz_serv_05";

    public ServerGeneralInsertPage(String pageName) {
        super(pageName);
        this.setTitle(pageName);
    }

    public void createControl(Composite parent) {
        Composite composite = PTWidgetTool.createComposite((Composite)parent, (int)1, (boolean)false);
        PdpPacbasePlugin.setHelpMechanism(composite, this.CONTEXT_ID_FOR_HELP);
        this.createFunctionGroup(composite);
        PTWidgetTool.createLabel((Composite)composite, (String)"");
        this.createProcessesGroup(composite);
        PTWidgetTool.createLabel((Composite)composite, (String)"");
        this.createActionsRadioButtonsGroup(composite);
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite);
        this.initListeners();
    }

    private void createFunctionGroup(Composite parent) {
        Group group = PTWidgetTool.createGroup((Composite)parent, (int)4, (String)"");
        PTWidgetTool.createLabel((Composite)group, (String)(String.valueOf(Messages.FUNCTION_CODE) + ": "));
        this._functionLabel = PTWidgetTool.createLabel((Composite)group, (String)"");
        ((GridData)this._functionLabel.getLayoutData()).grabExcessHorizontalSpace = true;
        PTWidgetTool.createLabel((Composite)group, (String)(String.valueOf(Messages.LEVEL) + ": "));
        this._levelLabel = PTWidgetTool.createLabel((Composite)group, (String)"");
        ((GridData)this._levelLabel.getLayoutData()).grabExcessHorizontalSpace = true;
    }

    private void createProcessesGroup(Composite parent) {
        Group group = PTWidgetTool.createGroup((Composite)parent, (int)3, (String)Messages.BLOCK);
        PTWidgetTool.createLabel((Composite)group, (String)"", (int)3);
        this._serverBeginButton = PTWidgetTool.createRadioButton((Composite)group, (String)Messages.FSERVER, (boolean)false);
        PTWidgetTool.createLabel((Composite)group, (String)"", (int)2);
        this._logicalViewButton = PTWidgetTool.createRadioButton((Composite)group, (String)Messages.LOGICAL_VIEW, (boolean)false);
        PTWidgetTool.createLabel((Composite)group, (String)"", (int)2);
        this._logicalViewLabel = PTWidgetTool.createLabel((Composite)group, (String)Messages.SEGMENT_CODE);
        ((GridData)this._logicalViewLabel.getLayoutData()).horizontalAlignment = 3;
        this._logicalViewLabel.setEnabled(false);
        this._logicalViewCode = PTWidgetTool.createTextField((Composite)group, (boolean)false, (boolean)false);
        this._logicalViewCode.setTextLimit(4);
        this._logicalViewCode.setEnabled(false);
        this._logicalViewSelection = PTWidgetTool.createPushButton((Composite)group, (String)Messages.BROWSE_BUTTON, (boolean)true);
        ((GridData)this._logicalViewSelection.getLayoutData()).horizontalAlignment = 3;
        this._serverEndButton = PTWidgetTool.createRadioButton((Composite)group, (String)Messages.FSERVER_END, (boolean)false);
        PTWidgetTool.createLabel((Composite)group, (String)"", (int)2);
        this._SQLCursorsDeclarationButton = PTWidgetTool.createRadioButton((Composite)group, (String)Messages.SQL_CURSORS_DECLARATION, (boolean)false);
        PTWidgetTool.createLabel((Composite)group, (String)"");
        PTWidgetTool.createLabel((Composite)group, (String)"", (int)3);
    }

    private void createActionsRadioButtonsGroup(Composite parent) {
        Group group = PTWidgetTool.createGroup((Composite)parent, (int)4, (String)Messages.ACTION_TYPE);
        this._insertBeforeButton = PTWidgetTool.createRadioButton((Composite)group, (String)Messages.INSERTION_BEFORE, (boolean)false);
        this._insertAfterButton = PTWidgetTool.createRadioButton((Composite)group, (String)Messages.INSERTION_AFTER, (boolean)false);
        this._replaceButton = PTWidgetTool.createRadioButton((Composite)group, (String)Messages.REPLACE, (boolean)false);
        this._insertNoneButton = PTWidgetTool.createRadioButton((Composite)group, (String)Messages.NONE, (boolean)false);
    }

    public boolean canFlipToNextPage() {
        return false;
    }

    public IWizardPage getNextPage() {
        return null;
    }

    public void handleEvent(Event event) {
        if (event.widget == this._logicalViewButton) {
            this._logicalViewLabel.setEnabled(true);
            this._logicalViewCode.setEnabled(true);
            this._logicalViewSelection.setEnabled(true);
            this._insertNoneButton.setEnabled(true);
        } else if (event.widget == this._serverBeginButton || event.widget == this._serverEndButton || event.widget == this._SQLCursorsDeclarationButton) {
            this._logicalViewLabel.setEnabled(false);
            this._logicalViewCode.setEnabled(false);
            this._logicalViewSelection.setEnabled(false);
            this._insertNoneButton.setEnabled(false);
            this._insertNoneButton.setSelection(false);
            if (event.widget == this._SQLCursorsDeclarationButton) {
                this._insertNoneButton.setEnabled(true);
            }
        } else if (event.widget == this._logicalViewSelection) {
            this.handleEventForLogicalViewSelection();
        }
        boolean isPagecomplete = this.isPageComplete();
        this.setPageComplete(isPagecomplete);
        this.getWizard().getContainer().updateButtons();
    }

    protected void handleEventForLogicalViewSelection() {
        PTElement element = ((FunctionWizard)this.getWizard()).openSelectionDialog(DataAggregate.class.getSimpleName());
        if (element != null) {
            this._logicalViewCode.setText(element.getName());
        }
    }

    private void initFunctionDatasFromModel() {
        FunctionModel dataModel = ((FunctionWizard)this.getWizard()).getDataModel();
        this._functionLabel.setText(String.valueOf(dataModel.getFunction()) + dataModel.getSubFunction());
        this._levelLabel.setText(dataModel.getLevel());
    }

    protected void initDataWithModel() {
        String action;
        FunctionModel dataModel = ((FunctionWizard)this.getWizard()).getDataModel();
        StringTokenizer tokenizer = new StringTokenizer(dataModel.getReference(), " ");
        ArrayList<String> refs = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            refs.add(tokenizer.nextToken());
        }
        if (refs.size() > 0) {
            String bloc = (String)refs.get(0);
            if (bloc.equals("BS")) {
                this._serverBeginButton.setSelection(true);
                this._insertNoneButton.setEnabled(false);
            } else if (bloc.equals("ES")) {
                this._serverEndButton.setSelection(true);
                this._insertNoneButton.setEnabled(false);
            } else if (bloc.equals("SQ")) {
                this._SQLCursorsDeclarationButton.setSelection(true);
            } else {
                this._logicalViewButton.setSelection(true);
                this._logicalViewLabel.setEnabled(true);
                this._logicalViewCode.setText(bloc);
                this._logicalViewCode.setEnabled(true);
                this._logicalViewSelection.setEnabled(true);
                this._insertNoneButton.setEnabled(true);
            }
        }
        if (this._insertNoneButton.isEnabled()) {
            this._insertNoneButton.setSelection(true);
        }
        if (refs.size() > 1 && (action = (String)refs.get(1)) != null && action.trim().length() > 0) {
            this._insertNoneButton.setSelection(false);
            if (action.equals("P")) {
                this._insertAfterButton.setSelection(true);
            } else if (action.equals("A")) {
                this._insertBeforeButton.setSelection(true);
            } else if (action.equals("R")) {
                this._replaceButton.setSelection(true);
            }
        }
    }

    private void initListeners() {
        this._serverBeginButton.addListener(13, (Listener)this);
        this._logicalViewButton.addListener(13, (Listener)this);
        this._logicalViewCode.addListener(24, (Listener)this);
        this._serverEndButton.addListener(13, (Listener)this);
        this._SQLCursorsDeclarationButton.addListener(13, (Listener)this);
        this._insertAfterButton.addListener(13, (Listener)this);
        this._insertBeforeButton.addListener(13, (Listener)this);
        this._insertNoneButton.addListener(13, (Listener)this);
        this._replaceButton.addListener(13, (Listener)this);
        this._logicalViewSelection.addListener(13, (Listener)this);
    }

    public boolean isPageComplete() {
        if (this.init) {
            this.init = false;
            this.initDataWithModel();
        }
        if (!(this._logicalViewButton.getSelection() || this._serverBeginButton.getSelection() || this._serverEndButton.getSelection() || this._SQLCursorsDeclarationButton.getSelection())) {
            this.setErrorMessage(String.valueOf(Messages.BLOCK) + ": " + Messages.DATA_REQUIRED);
            return false;
        }
        String logicalViewCode = this._logicalViewCode.getText().toUpperCase().trim();
        if (this._logicalViewButton.getSelection()) {
            if (logicalViewCode.length() == 0) {
                this.setErrorMessage(String.valueOf(Messages.LOGICAL_VIEW) + ": " + Messages.DATA_REQUIRED);
                return false;
            }
            if (logicalViewCode.startsWith("$") && logicalViewCode.length() != 2 || !logicalViewCode.startsWith("$") && logicalViewCode.length() != 4) {
                this.setErrorMessage(String.valueOf(Messages.LOGICAL_VIEW) + ": " + Messages.LENGTH_INVALID);
                return false;
            }
            if (logicalViewCode.startsWith("$") && !FunctionWizard.IsExistingData(logicalViewCode.toUpperCase(), PARAMS$, ((FunctionWizard)this.getWizard()).getDataModel().isMacro())) {
                this.setErrorMessage(String.valueOf(Messages.SEGMENT_CODE) + ": " + Messages.DATA_INVALID);
                return false;
            }
        }
        if (!(!this._serverBeginButton.getSelection() && !this._serverEndButton.getSelection() || this._insertAfterButton.getSelection() || this._insertBeforeButton.getSelection() || this._replaceButton.getSelection())) {
            this.setErrorMessage(String.valueOf(Messages.ACTION_TYPE) + ": " + Messages.DATA_REQUIRED);
            return false;
        }
        this.setErrorMessage(null);
        this.saveDataToModel();
        return true;
    }

    @Override
    public void saveDataToModel() {
        FunctionModel dataModel = ((FunctionWizard)this.getWizard()).getDataModel();
        dataModel.setAction("*C");
        StringBuilder ref = new StringBuilder("");
        if (this._serverBeginButton.getSelection()) {
            ref.append("BS");
        } else if (this._serverEndButton.getSelection()) {
            ref.append("ES");
        } else if (this._SQLCursorsDeclarationButton.getSelection()) {
            ref.append("SQ");
        } else {
            ref.append(this._logicalViewCode.getText().trim().toUpperCase());
        }
        ref.append(" ");
        if (this._insertAfterButton.getSelection()) {
            ref.append("P");
        } else if (this._insertBeforeButton.getSelection()) {
            ref.append("A");
        } else if (this._replaceButton.getSelection()) {
            ref.append("R");
        }
        dataModel.setReference(ref.toString().trim());
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.initFunctionDatasFromModel();
        }
        super.setVisible(visible);
    }
}

