/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.wizards;

import com.ibm.pdp.engine.tree.IEditTree;
import com.ibm.pdp.pacbase.IFunctionNode;
import com.ibm.pdp.pacbase.INodeLoader;
import com.ibm.pdp.pacbase.PacTool;
import com.ibm.pdp.pacbase.extension.nodesview.CommonWizardFunctionAction;
import com.ibm.pdp.pacbase.wizards.CommonFunctionPageForPdpEditor;
import com.ibm.pdp.pacbase.wizards.FunctionModel;
import com.ibm.pdp.pacbase.wizards.FunctionWizard;
import com.ibm.pdp.pacbase.wizards.FunctionWizardForPdpEditor;
import com.ibm.pdp.pacbase.wizards.IFunctionControls;
import com.ibm.pdp.pacbase.wizards.IPdpEditorFunctionControls;
import com.ibm.pdp.pacbase.wizards.Messages;
import com.ibm.pdp.pacbase.wizards.PdpEditorFunctionControls;
import com.ibm.pdp.pacbase.wizards.PdpFunctionWizardUtil;
import com.ibm.pdp.pacbase.wizards.ScreenFunctionPage;
import java.util.ArrayList;
import org.eclipse.swt.widgets.Event;

public class ScreenFunctionPageForPdpEditor
extends ScreenFunctionPage {
    private IEditTree _editTree;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2013, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public ScreenFunctionPageForPdpEditor(String pageName, IEditTree editTree) {
        super(pageName);
        this._editTree = editTree;
    }

    @Override
    protected void initDataWithModel() {
        super.initDataWithModel();
        this.initGenerationMessage();
    }

    @Override
    protected void initFunctionDatasFromModel() {
        super.initFunctionDatasFromModel();
        this.initGenerationMessage();
    }

    private void initGenerationMessage() {
        FunctionModel dataModel = ((FunctionWizard)this.getWizard()).getDataModel();
        if (dataModel.isHighUpdatesForModel(((FunctionWizardForPdpEditor)this.getWizard()).getOldDataModel()) && dataModel.isGenerationRequested()) {
            this.setMessage(Messages.REQUIRED_GENERATION, 1);
        } else {
            this.setMessage(null, 0);
        }
    }

    @Override
    public void saveDataToModel() {
        super.saveDataToModel();
        FunctionModel dataModel = ((FunctionWizard)this.getWizard()).getDataModel();
        boolean b = dataModel.isHighUpdatesForModel(((FunctionWizardForPdpEditor)this.getWizard()).getOldDataModel());
        dataModel.setGenerationRequested(b);
        ((CommonFunctionPageForPdpEditor)this.getPreviousPage())._generationButton.setSelection(b);
        ((CommonFunctionPageForPdpEditor)this.getPreviousPage())._generationButton.setEnabled(!b);
    }

    @Override
    protected void handleEventForScreenPage(Event event) {
        if (event.widget == this._segmentSelection || event.widget == this._dataElementSelection) {
            FunctionModel dataModel = ((FunctionWizard)this.getWizard()).getDataModel();
            String functionName = "F" + dataModel.getFunction();
            IFunctionControls controls = ((FunctionWizardForPdpEditor)this.getWizard()).getFunctionControls();
            PdpEditorFunctionControls pdpControls = (PdpEditorFunctionControls)controls;
            ArrayList<String[]> list = null;
            String message = "";
            if (event.widget == this._segmentSelection) {
                String categ = this._cbbCategory.getText();
                if (categ.length() > 0) {
                    functionName = String.valueOf(functionName) + categ;
                }
                list = pdpControls.getSegmentsList(functionName);
                message = Messages.SEGMENT_SELECTION;
            } else {
                list = pdpControls.getDataEltsList(functionName);
                message = Messages.DATA_ELEMENT_SELECTION;
            }
            String element = PdpFunctionWizardUtil.openListDialog(this.getShell(), list, message);
            if (element != null) {
                if (event.widget == this._segmentSelection) {
                    this._segmentCode.setText(element);
                } else {
                    this._dataElementCode.setText(element);
                }
            }
        }
        this.handleEventForGenerationUpdates(event);
    }

    private void handleEventForGenerationUpdates(Event event) {
        FunctionModel dataModel = ((FunctionWizard)this.getWizard()).getDataModel();
        if (CommonWizardFunctionAction.IsGenerationNeeded("com.ibm.pdp.pacbase.dialog", dataModel.getFunction(), dataModel.getSubFunction())) {
            boolean b = false;
            FunctionModel oldModel = ((FunctionWizardForPdpEditor)this.getWizard()).getOldDataModel();
            if (oldModel != null) {
                if (event.widget == this._dataElementCode || event.widget == this._segmentSelection || event.widget == this._cbbCategory) {
                    if (!this.getReference().equals(oldModel.getReference())) {
                        b = true;
                    }
                } else if (event.widget == this._insertAfterButton || event.widget == this._insertBeforeButton || event.widget == this._replaceButton) {
                    String action = "";
                    if (event.widget == this._insertAfterButton && this._insertAfterButton.getSelection()) {
                        action = "*P";
                    } else if (event.widget == this._insertBeforeButton && this._insertBeforeButton.getSelection()) {
                        action = "*A";
                    } else if (event.widget == this._replaceButton && this._replaceButton.getSelection()) {
                        action = "*R";
                    }
                    if (!action.equals(oldModel.getAction())) {
                        b = true;
                    }
                }
            }
            if (b || dataModel.isCommonDatasUpdated(oldModel)) {
                this.setMessage(Messages.REQUIRED_GENERATION, 1);
            } else {
                this.setMessage(null, 0);
            }
        }
    }

    @Override
    public boolean isPageComplete() {
        String tagName;
        boolean b = super.isPageComplete();
        if (!b) {
            return false;
        }
        FunctionModel dataModel = ((FunctionWizard)this.getWizard()).getDataModel();
        String functionName = "F" + dataModel.getFunction();
        IFunctionControls controls = ((FunctionWizardForPdpEditor)this.getWizard()).getFunctionControls();
        INodeLoader nodeLoader = null;
        if (controls instanceof IPdpEditorFunctionControls) {
            IPdpEditorFunctionControls pdpControls = (IPdpEditorFunctionControls)controls;
            nodeLoader = pdpControls.getNodeLoader();
        }
        if (this._editTree.nodeFromTagName(tagName = PacTool.buildTagName(functionName, this.getReference(), this._editTree)) == null) {
            IFunctionNode fn = PdpFunctionWizardUtil.findOverridingNode(nodeLoader, new String[]{tagName});
            String fctToVerify = "F" + this._functionLabel.getText();
            if (dataModel.isMoveAction()) {
                FunctionModel oldDataModel = ((FunctionWizard)this.getWizard()).getOldDataModel();
                fctToVerify = "F" + oldDataModel.getFunction() + oldDataModel.getSubFunction();
            }
            if (fn == null || !fn.getName().equals(fctToVerify)) {
                String message = String.valueOf(tagName) + " " + Messages.AUTOMATIC_FUNCTION_DOES_NOT_EXIST;
                if ("F20".equals(functionName)) {
                    message = Messages.AUTOMATIC_FUNCTION_DOES_NOT_EXIST_DATAELT;
                } else if ("F25".equals(functionName) || "F35".equals(functionName) || "F60".equals(functionName)) {
                    message = Messages.AUTOMATIC_FUNCTION_DOES_NOT_EXIST_SEGMENT;
                }
                this.setErrorMessage(message);
                return false;
            }
        }
        if (this._replaceButton.getSelection() && !PdpFunctionWizardUtil.checkLocationForProcess(nodeLoader, tagName, "F" + this._functionLabel.getText())) {
            String mess = String.valueOf(tagName) + " " + Messages.AUTOMATIC_FUNCTION_HAS_RELATIVE + " " + Messages.FORBIDDEN_TO_OVERRIDE_FUNCTIONS;
            this.setErrorMessage(mess);
            return false;
        }
        return true;
    }
}

