/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.wizards;

import com.ibm.pdp.explorer.model.PTElement;
import com.ibm.pdp.explorer.view.service.PTWidgetTool;
import com.ibm.pdp.mdl.kernel.DataAggregate;
import com.ibm.pdp.mdl.kernel.DataElement;
import com.ibm.pdp.mdl.pacbase.util.IPacFunctionConstants;
import com.ibm.pdp.mdl.pacbase.util.PacFunctionCheckingUtilities;
import com.ibm.pdp.pacbase.PdpPacbasePlugin;
import com.ibm.pdp.pacbase.wizards.FunctionModel;
import com.ibm.pdp.pacbase.wizards.FunctionWizard;
import com.ibm.pdp.pacbase.wizards.IFunctionWizardPage;
import com.ibm.pdp.pacbase.wizards.Messages;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class ScreenFunctionPage
extends WizardPage
implements IPacFunctionConstants,
Listener,
IFunctionWizardPage {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2013, 2018.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Composite _composite;
    private Composite _refCompo;
    protected Text _dataElementCode;
    protected Text _segmentCode;
    private Label _categoryLabel;
    private Label _dataElementLabel;
    protected Label _functionLabel;
    private Label _levelLabel;
    private Label _segmentLabel;
    private Group _actionsGroup;
    protected Button _dataElementSelection;
    protected Button _insertAfterButton;
    protected Button _insertBeforeButton;
    protected Button _replaceButton;
    protected Button _segmentSelection;
    protected Combo _cbbCategory;
    private String[] _predefinedCategories = new String[]{"A", "R", "Z"};
    private String CONTEXT_ID_FOR_HELP = "Macro_wiz_dial";

    public ScreenFunctionPage(String pageName) {
        super(pageName);
        this.setTitle(pageName);
    }

    public void createControl(Composite parent) {
        this._composite = PTWidgetTool.createComposite((Composite)parent, (int)1, (boolean)false);
        PdpPacbasePlugin.setHelpMechanism(this._composite, this.CONTEXT_ID_FOR_HELP);
        this.createFunctionGroup(this._composite);
        this._refCompo = PTWidgetTool.createComposite((Composite)this._composite, (int)3, (boolean)false);
        PTWidgetTool.createLabel((Composite)this._refCompo, (String)"", (int)6);
        this.createDataElementControls(this._refCompo);
        this.createSegmentControls(this._refCompo);
        this.createCategoryControls(this._refCompo);
        PTWidgetTool.createLabel((Composite)this._refCompo, (String)"");
        ((GridData)this._refCompo.getLayoutData()).exclude = true;
        PTWidgetTool.createLabel((Composite)this._composite, (String)"");
        this._actionsGroup = PTWidgetTool.createGroup((Composite)this._composite, (int)4, (String)Messages.ACTION_TYPE);
        this.createActionsRadioButtonsGroup((Composite)this._actionsGroup);
        ((GridData)this._actionsGroup.getLayoutData()).exclude = true;
        this.createOthersGroups(this._composite);
        this.init();
        this.initDataWithModel();
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)this._composite);
        this.initListeners();
    }

    private void createCategoryControls(Composite parent) {
        PTWidgetTool.createLabel((Composite)parent, (String)" ", (int)3);
        this._categoryLabel = PTWidgetTool.createLabel((Composite)parent, (String)Messages.CATEGORY);
        this._cbbCategory = PTWidgetTool.createDropDownCombo((Composite)parent);
        this._cbbCategory.setItems(this._predefinedCategories);
        this._cbbCategory.setVisibleItemCount(this._predefinedCategories.length);
        this._cbbCategory.select(0);
        PTWidgetTool.createLabel((Composite)parent, (String)" ", (int)3);
    }

    private void createFunctionGroup(Composite parent) {
        PTWidgetTool.createLabel((Composite)parent, (String)"", (int)2);
        Group group = PTWidgetTool.createGroup((Composite)parent, (int)4, (String)"");
        PTWidgetTool.createLabel((Composite)group, (String)(String.valueOf(Messages.SUB_FUNCTION_CODE) + ": "));
        this._functionLabel = PTWidgetTool.createLabel((Composite)group, (String)"");
        ((GridData)this._functionLabel.getLayoutData()).grabExcessHorizontalSpace = true;
        PTWidgetTool.createLabel((Composite)group, (String)(String.valueOf(Messages.LEVEL) + ": "));
        this._levelLabel = PTWidgetTool.createLabel((Composite)group, (String)"");
        ((GridData)this._levelLabel.getLayoutData()).grabExcessHorizontalSpace = true;
    }

    private void createActionsRadioButtonsGroup(Composite parent) {
        this._insertBeforeButton = PTWidgetTool.createRadioButton((Composite)parent, (String)Messages.INSERTION_BEFORE, (boolean)false);
        this._insertAfterButton = PTWidgetTool.createRadioButton((Composite)parent, (String)Messages.INSERTION_AFTER, (boolean)false);
        this._replaceButton = PTWidgetTool.createRadioButton((Composite)parent, (String)Messages.REPLACE, (boolean)false);
    }

    private void createSegmentControls(Composite parent) {
        this._segmentLabel = PTWidgetTool.createLabel((Composite)parent, (String)Messages.SEGMENT_CODE);
        this._segmentCode = PTWidgetTool.createTextField((Composite)parent, (boolean)false, (boolean)false);
        this._segmentCode.setTextLimit(4);
        this._segmentSelection = PTWidgetTool.createPushButton((Composite)parent, (String)Messages.BROWSE_BUTTON, (boolean)true);
    }

    private void createDataElementControls(Composite parent) {
        this._dataElementLabel = PTWidgetTool.createLabel((Composite)parent, (String)Messages.DATA_ELEMENT_CODE);
        this._dataElementCode = PTWidgetTool.createTextField((Composite)parent, (boolean)false, (boolean)false);
        this._dataElementCode.setTextLimit(6);
        this._dataElementSelection = PTWidgetTool.createPushButton((Composite)parent, (String)Messages.BROWSE_BUTTON, (boolean)true);
    }

    protected void createOthersGroups(Composite parent) {
    }

    private void setDataElementControlsExclude(Boolean exclude) {
        ((GridData)this._dataElementCode.getLayoutData()).exclude = exclude;
        ((GridData)this._dataElementLabel.getLayoutData()).exclude = exclude;
        ((GridData)this._dataElementSelection.getLayoutData()).exclude = exclude;
    }

    private void setSegmentControlsExclude(Boolean exclude) {
        ((GridData)this._segmentCode.getLayoutData()).exclude = exclude;
        ((GridData)this._segmentLabel.getLayoutData()).exclude = exclude;
        ((GridData)this._segmentSelection.getLayoutData()).exclude = exclude;
    }

    private void setCategoryControlsExclude(Boolean exclude) {
        ((GridData)this._categoryLabel.getLayoutData()).exclude = exclude;
        ((GridData)this._cbbCategory.getLayoutData()).exclude = exclude;
    }

    private void init() {
        FunctionModel dataModel = ((FunctionWizard)this.getWizard()).getDataModel();
        ((GridData)this._refCompo.getLayoutData()).exclude = false;
        ((GridData)this._actionsGroup.getLayoutData()).exclude = false;
        this._insertAfterButton.setEnabled(true);
        this._insertBeforeButton.setEnabled(true);
        this._replaceButton.setEnabled(true);
        if (dataModel.getFunction().equals("20")) {
            this.setTitle(Messages.F20_TITLE);
            this.setDataElementControlsExclude(false);
            this.setSegmentControlsExclude(true);
            this.setCategoryControlsExclude(true);
        } else if (dataModel.getFunction().equals("30") || dataModel.getFunction().equals("65")) {
            if (dataModel.getFunction().equals("30")) {
                this.setTitle(Messages.F30_TITLE);
            } else {
                this.setTitle(Messages.F65_TITLE);
            }
            this.setCategoryControlsExclude(false);
            this.setDataElementControlsExclude(true);
            this.setSegmentControlsExclude(true);
            this._insertAfterButton.setEnabled(true);
            this._insertAfterButton.setSelection(true);
            this._insertBeforeButton.setEnabled(false);
            this._insertBeforeButton.setSelection(false);
            this._replaceButton.setEnabled(false);
            this._replaceButton.setSelection(false);
        } else {
            if (dataModel.getFunction().equals("35")) {
                this.setTitle(Messages.F35_TITLE);
            } else if (dataModel.getFunction().equals("25")) {
                this.setTitle(Messages.F25_TITLE);
            } else {
                this.setTitle(Messages.F60_TITLE);
            }
            this.setSegmentControlsExclude(false);
            this.setCategoryControlsExclude(false);
            this.setDataElementControlsExclude(true);
        }
        Control[] children = this._refCompo.getChildren();
        this._composite.layout(children);
        int i = 0;
        while (i < children.length) {
            children[i].setVisible(!((GridData)children[i].getLayoutData()).exclude);
            ++i;
        }
        this._composite.redraw();
    }

    public void handleEvent(Event event) {
        this.handleEventForScreenPage(event);
        this.setPageComplete(this.isPageComplete());
        this.getWizard().getContainer().updateButtons();
    }

    protected void handleEventForScreenPage(Event event) {
        if (event.widget == this._dataElementSelection) {
            PTElement element = ((FunctionWizard)this.getWizard()).openSelectionDialog(DataElement.class.getSimpleName());
            if (element != null) {
                this._dataElementCode.setText(element.getName());
            }
        } else if (event.widget == this._segmentSelection) {
            PTElement element = ((FunctionWizard)this.getWizard()).openSelectionDialog(DataAggregate.class.getSimpleName());
            if (element != null) {
                this._segmentCode.setText(element.getName());
            }
        } else if (event.widget == this._cbbCategory && event.type == 13 && this._cbbCategory.getSelectionIndex() >= 0) {
            this._cbbCategory.setText(this._cbbCategory.getItem(this._cbbCategory.getSelectionIndex()));
        }
    }

    public boolean canFlipToNextPage() {
        return false;
    }

    public IWizardPage getNextPage() {
        return null;
    }

    public boolean isPageComplete() {
        FunctionModel dataModel = ((FunctionWizard)this.getWizard()).getDataModel();
        if (dataModel.getFunction().equals("20")) {
            if (this._dataElementCode.getText().trim().length() == 0) {
                this.setErrorMessage(String.valueOf(Messages.DATA_ELEMENT_CODE) + ": " + Messages.DATA_REQUIRED);
                return false;
            }
        } else {
            String category;
            if (dataModel.getFunction().equals("25") || dataModel.getFunction().equals("35") || dataModel.getFunction().equals("60") || dataModel.getFunction().equals("80") && this.isF80WithReference(dataModel)) {
                boolean b;
                String segmentCode = this._segmentCode.getText().trim();
                if (segmentCode.length() == 0) {
                    this.setErrorMessage(String.valueOf(Messages.SEGMENT_CODE) + ": " + Messages.DATA_REQUIRED);
                    return false;
                }
                if (segmentCode.contains("$") && segmentCode.length() != 2 && segmentCode.length() != 4 || !segmentCode.startsWith("$") && segmentCode.length() != 4) {
                    this.setErrorMessage(String.valueOf(Messages.SEGMENT_CODE) + ": " + Messages.LENGTH_INVALID);
                    return false;
                }
                if (segmentCode.contains("$") && !(b = PacFunctionCheckingUtilities.isParameterWithDollarWellFormed((String)segmentCode, null))) {
                    this.setErrorMessage(String.valueOf(Messages.SEGMENT_CODE) + ": " + Messages.DATA_INVALID);
                    return false;
                }
            }
            if (!dataModel.getFunction().equals("20") && !dataModel.getFunction().equals("80") && (category = this._cbbCategory.getText().trim().toUpperCase()).length() > 0) {
                if (category.startsWith("$")) {
                    if (category.length() != 2) {
                        this.setErrorMessage(String.valueOf(Messages.CATEGORY) + ": " + Messages.DATA_INVALID);
                        return false;
                    }
                    if (!FunctionWizard.IsExistingData(category.toUpperCase(), PARAMS$, dataModel.isMacro())) {
                        this.setErrorMessage(String.valueOf(Messages.CATEGORY) + ": " + Messages.DATA_INVALID);
                        return false;
                    }
                } else {
                    boolean exist = false;
                    int i = 0;
                    while (i < this._predefinedCategories.length) {
                        String process = this._predefinedCategories[i];
                        if (category.equals(process)) {
                            exist = true;
                            this._cbbCategory.removeListener(24, (Listener)this);
                            this._cbbCategory.setText(this._predefinedCategories[i]);
                            this._cbbCategory.addListener(24, (Listener)this);
                            break;
                        }
                        ++i;
                    }
                    if (!exist) {
                        this.setErrorMessage(String.valueOf(Messages.CATEGORY) + ": " + Messages.DATA_INVALID);
                        return false;
                    }
                }
            }
        }
        if (!(this._insertAfterButton.getSelection() || this._insertBeforeButton.getSelection() || this._replaceButton.getSelection())) {
            this.setErrorMessage(String.valueOf(Messages.ACTION_TYPE) + ": " + Messages.DATA_REQUIRED);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    protected void initDataWithModel() {
        FunctionModel dataModel = ((FunctionWizard)this.getWizard()).getDataModel();
        String categ = "";
        String segmentCode = "";
        if (dataModel.getFunction().equals("20")) {
            this._dataElementCode.setText(dataModel.getReference());
        } else {
            StringTokenizer tokenizer = new StringTokenizer(dataModel.getReference(), " ");
            ArrayList<String> refs = new ArrayList<String>();
            while (tokenizer.hasMoreTokens()) {
                refs.add(tokenizer.nextToken());
            }
            if (refs.size() > 0) {
                if (dataModel.getFunction().equals("30") || dataModel.getFunction().equals("65")) {
                    categ = (String)refs.get(0);
                } else {
                    segmentCode = (String)refs.get(0);
                    if (refs.size() > 1) {
                        categ = (String)refs.get(1);
                    }
                }
            }
            if (segmentCode.length() > 0) {
                this._segmentCode.setText(segmentCode);
            }
            this._cbbCategory.setText(categ);
        }
        String action = dataModel.getAction();
        if (action != null && action.trim().length() > 0) {
            if (action.equals("*P")) {
                this._insertAfterButton.setSelection(true);
            } else if (action.equals("*A")) {
                this._insertBeforeButton.setSelection(true);
            } else if (action.equals("*R")) {
                this._replaceButton.setSelection(true);
            }
        }
    }

    protected void initFunctionDatasFromModel() {
        this.init();
        FunctionModel dataModel = ((FunctionWizard)this.getWizard()).getDataModel();
        this._functionLabel.setText(String.valueOf(dataModel.getFunction()) + dataModel.getSubFunction());
        this._levelLabel.setText(dataModel.getLevel());
    }

    private void initListeners() {
        this._dataElementSelection.addListener(13, (Listener)this);
        this._insertAfterButton.addListener(13, (Listener)this);
        this._insertBeforeButton.addListener(13, (Listener)this);
        this._segmentSelection.addListener(13, (Listener)this);
        this._replaceButton.addListener(13, (Listener)this);
        this._dataElementCode.addListener(24, (Listener)this);
        this._segmentCode.addListener(24, (Listener)this);
        this._cbbCategory.addListener(13, (Listener)this);
        this._cbbCategory.addListener(24, (Listener)this);
    }

    private boolean isF80WithReference(FunctionModel dataModel) {
        return !"80".equals(dataModel.getFunction()) || !"95".equals(dataModel.getSubFunction()) && !"98".equals(dataModel.getSubFunction()) && !"99".equals(dataModel.getSubFunction()) || !this._replaceButton.getSelection();
    }

    @Override
    public void saveDataToModel() {
        FunctionModel dataModel = ((FunctionWizard)this.getWizard()).getDataModel();
        dataModel.setReference(this.getReference());
        if (this._insertAfterButton.getSelection()) {
            dataModel.setAction("*P");
        } else if (this._insertBeforeButton.getSelection()) {
            dataModel.setAction("*A");
        } else if (this._replaceButton.getSelection()) {
            dataModel.setAction("*R");
        }
    }

    protected String getReference() {
        String category;
        FunctionModel dataModel = ((FunctionWizard)this.getWizard()).getDataModel();
        if (dataModel.getFunction().equals("20")) {
            return this._dataElementCode.getText().toUpperCase().trim();
        }
        StringBuilder reference = new StringBuilder();
        if (dataModel.getFunction().equals("25") || dataModel.getFunction().equals("35") || dataModel.getFunction().equals("60")) {
            reference.append(this._segmentCode.getText().toUpperCase().trim());
            reference.append(" ");
        }
        if ((category = this._cbbCategory.getText().toUpperCase()).trim().length() == 0) {
            category = "A";
        }
        reference.append(category);
        return reference.toString();
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.initFunctionDatasFromModel();
        }
        super.setVisible(visible);
    }
}

