/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.wizards;

import com.ibm.pdp.engine.ITagProperties;
import com.ibm.pdp.engine.tree.IEditTree;
import com.ibm.pdp.engine.turbo.core.SyntacticMark;
import com.ibm.pdp.engine.turbo.impl.TextProcessor;
import com.ibm.pdp.mdl.pacbase.util.IPacFunctionConstants;
import com.ibm.pdp.pacbase.IFunctionNode;
import com.ibm.pdp.pacbase.INodeLoader;
import com.ibm.pdp.pacbase.dialogs.PacListMonoSelectionDialog;
import com.ibm.pdp.pacbase.extension.nodesview.CommonWizardFunctionAction;
import com.ibm.pdp.pacbase.extension.organize.Location;
import com.ibm.pdp.pacbase.extension.organize.SyntacticInfoUtilities;
import com.ibm.pdp.pacbase.wizards.FunctionModel;
import com.ibm.pdp.pacbase.wizards.Messages;
import com.ibm.pdp.pacbase.wizards.RelativeLocationDatasLabelProvider;
import com.ibm.pdp.pacbase.wizards.RelativeLocationDatasViewerSorter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Shell;

public class PdpFunctionWizardUtil
implements IPacFunctionConstants {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String PROCEDURE_DIVISION_TAGNAME = "PROCEDURE-DIVISION";
    public static final String FSERVER_TAGNAME = "FSERVER";
    public static final String FSERVER_REF = "BS";
    public static final String FSERVER_END_TAGNAME = "FSERVER-END";
    public static final String FEND_PGM_TAGNAME = "FEND-PGM";
    public static final String FSERVER_END_REF = "ES";
    public static final String FSQL_TAGNAME = "FSQL";
    public static final String FSQL_REF = "SQ";
    public static final String SQL_LABEL = "SQL";
    public static final String FSQLW = "FSQL-WHENEVER";
    public static final String FSQLW_REF = "SQLW";
    public static final String ATTACH_KEYWORD = "@ATTACH ";
    public static final String FSQLD_REF = "SQLD";
    public static final String FSQLD_TAGNAME = "SQLD";
    public static final String FSQL_CURSOR_LABEL = "FSQL-CURSR-";

    public static boolean checkLocationForProcess(INodeLoader nodeLoader, String refEntity, String fctName) {
        if (nodeLoader == null || refEntity == null || "".equals(refEntity)) {
            return true;
        }
        List<IFunctionNode> allNodes = nodeLoader.getNodesList();
        boolean found = false;
        int i = 0;
        while (i < allNodes.size()) {
            IFunctionNode fn = allNodes.get(i);
            if (fn.isAttachedFunction()) {
                found = false;
                if (refEntity.equals(fn.getRefEntity())) {
                    if (!fn.getName().equals(fctName)) {
                        return false;
                    }
                    found = true;
                }
            } else if (fn.isAutomaticFunction() || fn.isOverrindingFunction()) {
                found = false;
            } else if (found) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static IFunctionNode findAttachedFunction(INodeLoader nodeLoader, String refEntityTagName) {
        if (nodeLoader == null || refEntityTagName == null || "".equals(refEntityTagName)) {
            return null;
        }
        List<IFunctionNode> allNodes = nodeLoader.getNodesList();
        int i = 0;
        while (i < allNodes.size()) {
            IFunctionNode fn = allNodes.get(i);
            if (fn.isAttachedFunction() && refEntityTagName.equals(fn.getRefEntity())) {
                return fn;
            }
            ++i;
        }
        return null;
    }

    public static IFunctionNode findOverridingNode(INodeLoader nodeLoader, String[] refEntityTagNames) {
        if (nodeLoader == null || refEntityTagNames == null || refEntityTagNames.length == 0) {
            return null;
        }
        List<IFunctionNode> nodesList = nodeLoader.getNodesList();
        int i = 0;
        while (i < nodesList.size()) {
            IFunctionNode node = nodesList.get(i);
            if (node.isOverrindingFunction() && !node.getName().equals(node.getRefEntity())) {
                String[] stringArray = refEntityTagNames;
                int n = refEntityTagNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String name = stringArray[n2];
                    if (name != null && name.equals(node.getRefEntity())) {
                        return node;
                    }
                    ++n2;
                }
            }
            ++i;
        }
        return null;
    }

    public static String buildTagNameInServer(String referencedEntity) {
        String refEntity = referencedEntity.trim();
        String[] values = referencedEntity.split(" ");
        if (values.length > 0) {
            if (values[0].equalsIgnoreCase("SQLD") && values.length == 2) {
                String s = FSQL_CURSOR_LABEL + values[1];
                return s;
            }
            refEntity = values[0];
            return PdpFunctionWizardUtil.getTagNameFromRef(refEntity);
        }
        return refEntity;
    }

    public static String getRefFromTagName(String tagName) {
        if (tagName == null) {
            return null;
        }
        if (tagName.equalsIgnoreCase(FSERVER_TAGNAME)) {
            return FSERVER_REF;
        }
        if (tagName.equalsIgnoreCase(FSERVER_END_TAGNAME)) {
            return FSERVER_END_REF;
        }
        if (tagName.equalsIgnoreCase(FSQL_TAGNAME)) {
            return FSQL_REF;
        }
        if (tagName.equalsIgnoreCase(FSQLW)) {
            return FSQLW_REF;
        }
        return tagName;
    }

    public static String getTagNameFromRef(String ref) {
        if (ref == null) {
            return null;
        }
        if (ref.equalsIgnoreCase(FSERVER_REF)) {
            return FSERVER_TAGNAME;
        }
        if (ref.equalsIgnoreCase(FSERVER_END_REF)) {
            return FSERVER_END_TAGNAME;
        }
        if (ref.equalsIgnoreCase(FSQL_REF)) {
            return FSQL_TAGNAME;
        }
        if (ref.equalsIgnoreCase(FSQLW_REF)) {
            return FSQLW;
        }
        return ref;
    }

    public static String getAttachmentPointOf(INodeLoader nodeLoader, String functionName) {
        List<String> attachedFunctions;
        String function = null;
        Map<String, List<String>> sqlMapping = nodeLoader.getSql_Func_Mapping();
        if (sqlMapping != null && (attachedFunctions = sqlMapping.get(FSQL_TAGNAME)) != null) {
            int i = 0;
            while (i < attachedFunctions.size()) {
                function = attachedFunctions.get(i);
                if (functionName.equalsIgnoreCase(function)) {
                    return FSQL_TAGNAME;
                }
                ++i;
            }
        }
        String logView2 = "";
        Map<String, List<String>> logViewMapping = nodeLoader.getLogViews_Func_Mapping();
        if (logViewMapping != null) {
            for (String logView2 : logViewMapping.keySet()) {
                List<String> attachedFunctions2 = logViewMapping.get(logView2);
                int i = 0;
                while (i < attachedFunctions2.size()) {
                    function = attachedFunctions2.get(i);
                    if (functionName.equalsIgnoreCase(function)) {
                        return logView2;
                    }
                    ++i;
                }
            }
        }
        return null;
    }

    protected static String getGenerationMessageForServerPage(FunctionModel newModel, FunctionModel oldModel, String reference, Button[] buttons) {
        if (CommonWizardFunctionAction.IsGenerationNeeded("com.ibm.pdp.pacbase.csserver", newModel.getFunction(), newModel.getSubFunction())) {
            boolean b = false;
            if (oldModel == null) {
                b = true;
            } else {
                if (!reference.equals(oldModel.getReference())) {
                    b = true;
                } else {
                    String action = "";
                    Button[] buttonArray = buttons;
                    int n = buttons.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Location location;
                        Button button = buttonArray[n2];
                        if (button.getSelection() && (location = (Location)((Object)button.getData("ACTION="))) != null) {
                            action = location.getInsertMspName();
                            break;
                        }
                        ++n2;
                    }
                    if (action.length() > 0 && !action.equals(oldModel.getAction())) {
                        b = true;
                    }
                }
                if (b || newModel.isCommonDatasUpdated(oldModel)) {
                    return Messages.REQUIRED_GENERATION;
                }
                return null;
            }
        }
        return null;
    }

    protected static String isServerPageComplete(String tagName, String reference, INodeLoader nodeLoader, IEditTree editTree, String function, boolean isReplace, String oldFunction) {
        if (editTree.nodeFromTagName(tagName) == null) {
            String fctToVerify;
            IFunctionNode fn = PdpFunctionWizardUtil.findOverridingNode(nodeLoader, new String[]{reference});
            String string = fctToVerify = oldFunction != null ? oldFunction : function;
            if (fn == null || !fn.getName().equals(fctToVerify)) {
                return String.valueOf(tagName) + " " + Messages.AUTOMATIC_FUNCTION_DOES_NOT_EXIST;
            }
        }
        if (isReplace && !PdpFunctionWizardUtil.checkLocationForProcess(nodeLoader, reference.toString(), function)) {
            String mess = String.valueOf(tagName) + " " + Messages.AUTOMATIC_FUNCTION_HAS_RELATIVE + " " + Messages.FORBIDDEN_TO_OVERRIDE_FUNCTIONS;
            return mess;
        }
        return "";
    }

    public static String searchAttachForFunction(String functionName, IEditTree editTree) {
        ITagProperties properties;
        String attach;
        String ref = null;
        TextProcessor textProcessor = (TextProcessor)editTree.getTextProcessor();
        List<SyntacticMark> l = SyntacticInfoUtilities.GetAllMarksFrom(textProcessor, "ATTACH_CATEGORY");
        for (SyntacticMark mark : l) {
            String fct = mark.toTag().getProperty("ATTACH_FUNCTION");
            if (!fct.equals(functionName)) continue;
            ref = mark.toTag().getProperty("ATTACH_LOGICAL_VIEW");
            break;
        }
        if (ref == null && (attach = (properties = editTree.nodeFromTagName("PROCEDURE").getProperties()).getProperty("attach")) != null) {
            String[] fctsList;
            String[] stringArray = fctsList = attach.split(",");
            int n = fctsList.length;
            int n2 = 0;
            while (n2 < n) {
                String corr = stringArray[n2];
                if (corr.startsWith(functionName)) {
                    ref = corr.substring(corr.indexOf("=") + 1).trim();
                }
                ++n2;
            }
        }
        if (ref != null) {
            StringTokenizer tokenizer = new StringTokenizer(ref, " ");
            ArrayList<String> refs = new ArrayList<String>();
            while (tokenizer.hasMoreTokens()) {
                refs.add(tokenizer.nextToken());
            }
            if (refs.size() > 0) {
                ref = (String)refs.get(0);
            }
        }
        return ref;
    }

    public static String[] searchFunctionForAttach(String attachType, IEditTree editTree) {
        String[] fcts = new String[]{""};
        int i = -1;
        TextProcessor textProcessor = (TextProcessor)editTree.getTextProcessor();
        List<SyntacticMark> l = SyntacticInfoUtilities.GetAllMarksFrom(textProcessor, "ATTACH_CATEGORY");
        for (SyntacticMark mark : l) {
            String ref = mark.toTag().getProperty("ATTACH_LOGICAL_VIEW");
            if (!ref.equals(attachType)) continue;
            fcts[++i] = mark.toTag().getProperty("ATTACH_FUNCTION");
        }
        ITagProperties properties = editTree.nodeFromTagName("PROCEDURE").getProperties();
        String attach = properties.getProperty("attach");
        if (attach != null) {
            String[] fctsList;
            String[] stringArray = fctsList = attach.split(",");
            int n = fctsList.length;
            int n2 = 0;
            while (n2 < n) {
                String corr = stringArray[n2];
                String ref = corr.substring(corr.indexOf("=") + 1).trim();
                String name = corr.substring(0, corr.indexOf("="));
                if (ref.startsWith(attachType)) {
                    String f;
                    boolean found = false;
                    String[] stringArray2 = fcts;
                    if (fcts.length != 0 && name.equals(f = stringArray2[0])) {
                        found = true;
                    }
                    if (!found) {
                        fcts[++i] = name;
                    }
                }
                ++n2;
            }
        }
        return fcts;
    }

    public static String openListDialog(Shell shell, ArrayList<String[]> list, String message) {
        if (list.isEmpty()) {
            MessageDialog.openInformation((Shell)shell, (String)message, (String)Messages.NO_ENTITY_FOUND);
            return null;
        }
        PacListMonoSelectionDialog dialog = new PacListMonoSelectionDialog(shell, list, (IStructuredContentProvider)ArrayContentProvider.getInstance(), (ILabelProvider)new RelativeLocationDatasLabelProvider(), message, "", new RelativeLocationDatasViewerSorter()){

            public boolean isHelpAvailable() {
                return false;
            }
        };
        dialog.open();
        Object[] elements = dialog.getResult();
        if (elements != null) {
            String[] element = (String[])elements[0];
            return element[0];
        }
        return null;
    }
}

