/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.wizards;

import com.ibm.pdp.framework.PdpTool;
import com.ibm.pdp.framework.interfaces.IEditor;
import com.ibm.pdp.framework.interfaces.IPattern;
import com.ibm.pdp.mdl.kernel.DataDefinition;
import com.ibm.pdp.mdl.kernel.DataElementDescription;
import com.ibm.pdp.mdl.kernel.KernelPackage;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.kernel.impl.DataElementImpl;
import com.ibm.pdp.mdl.kernel.impl.RadicalEntityImpl;
import com.ibm.pdp.mdl.kernel.util.Util;
import com.ibm.pdp.mdl.pacbase.PacAbstractCSLine;
import com.ibm.pdp.mdl.pacbase.PacCSLineLogicalViewCall;
import com.ibm.pdp.mdl.pacbase.PacCSLineSegmentCall;
import com.ibm.pdp.mdl.pacbase.PacCSLineServerCall;
import com.ibm.pdp.mdl.pacbase.PacDialogServerTypeValues;
import com.ibm.pdp.mdl.pacbase.PacDialogTypeValues;
import com.ibm.pdp.mdl.pacbase.impl.PacDialogImpl;
import com.ibm.pdp.mdl.pacbase.impl.PacDialogServerImpl;
import com.ibm.pdp.mdl.pacbase.impl.PacScreenImpl;
import com.ibm.pdp.mdl.pacbase.impl.PacServerImpl;
import com.ibm.pdp.mdl.pacbase.util.IPacFunctionConstants;
import com.ibm.pdp.mdl.pacbase.util.PacbaseModelService;
import com.ibm.pdp.pacbase.IFunctionNode;
import com.ibm.pdp.pacbase.INodeLoader;
import com.ibm.pdp.pacbase.wizards.IPdpEditorFunctionControls;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.ui.IFileEditorInput;

public class PdpEditorFunctionControls
implements IPdpEditorFunctionControls,
IPacFunctionConstants {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2013, 2019.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected IEditor _editor;
    protected IPacFunctionConstants.FunctionModelPatternValues _pattern;
    protected INodeLoader _nodeLoader;
    protected IPattern _pacPattern;
    private Map<String, String> _fileLines;
    private Map<String, String[]> _segmentLines;
    private ArrayList<String[]> _dataEltLines;

    public PdpEditorFunctionControls(IEditor editor, INodeLoader nodeLoader) {
        this._editor = editor;
        this._nodeLoader = nodeLoader;
        this._pacPattern = editor.getController().getPattern();
    }

    @Override
    public boolean isExistingLabel(String label) {
        Map<String, IFunctionNode> nodesMap = this._nodeLoader.getNodesMap();
        IFunctionNode fn = nodesMap.get("F" + label);
        return fn != null && fn.getOffset() != 0;
    }

    @Override
    public IFileEditorInput getEditorInput() {
        return null;
    }

    @Override
    public String getProject() {
        return ((RadicalEntityImpl)this._editor.getController().getDesignLink().getModelRoot()).getProject();
    }

    public String getPackage() {
        return ((RadicalEntityImpl)this._editor.getController().getDesignLink().getModelRoot()).getPackage();
    }

    @Override
    public IPacFunctionConstants.FunctionModelPatternValues getPattern() {
        IPattern pattern = this._editor.getController().getPattern();
        if ("com.ibm.pdp.pacbase.batch".equals(pattern.getName())) {
            return IPacFunctionConstants.FunctionModelPatternValues.NO_SPECIFIC_PATTERN;
        }
        if ("com.ibm.pdp.pacbase.dialog".equals(pattern.getName())) {
            return IPacFunctionConstants.FunctionModelPatternValues.DIALOG_PATTERN;
        }
        Object modelRoot = this._editor.getController().getDesignLink().getModelRoot();
        if ("com.ibm.pdp.pacbase.csclient".equals(pattern.getName())) {
            if (modelRoot instanceof PacScreenImpl) {
                if (PacDialogTypeValues._C_LITERAL.equals(((PacScreenImpl)modelRoot).getDialogType())) {
                    return IPacFunctionConstants.FunctionModelPatternValues.DIALOG_PATTERN;
                }
                if (PacDialogTypeValues._INHERITED_LITERAL.equals(((PacScreenImpl)modelRoot).getDialogType()) && PacDialogTypeValues._C_LITERAL.equals(((PacScreenImpl)modelRoot).getDialog().getDialogType())) {
                    return IPacFunctionConstants.FunctionModelPatternValues.DIALOG_PATTERN;
                }
            } else if (modelRoot instanceof PacDialogImpl && PacDialogTypeValues._C_LITERAL.equals(((PacScreenImpl)modelRoot).getDialogType())) {
                return IPacFunctionConstants.FunctionModelPatternValues.DIALOG_PATTERN;
            }
        } else if ("com.ibm.pdp.pacbase.csserver".equals(pattern.getName())) {
            if (modelRoot instanceof PacServerImpl) {
                if (PacDialogServerTypeValues._S_LITERAL.equals(((PacServerImpl)modelRoot).getDialogType())) {
                    return IPacFunctionConstants.FunctionModelPatternValues.SERVER_PATTERN;
                }
                if (PacDialogServerTypeValues._INHERITED_LITERAL.equals(((PacServerImpl)modelRoot).getDialogType()) && PacDialogServerTypeValues._S_LITERAL.equals(((PacServerImpl)modelRoot).getDialog().getDialogType())) {
                    return IPacFunctionConstants.FunctionModelPatternValues.SERVER_PATTERN;
                }
            } else if (modelRoot instanceof PacDialogServerImpl && PacDialogServerTypeValues._S_LITERAL.equals(((PacDialogServerImpl)modelRoot).getDialogType())) {
                return IPacFunctionConstants.FunctionModelPatternValues.SERVER_PATTERN;
            }
        }
        return IPacFunctionConstants.FunctionModelPatternValues.NO_SPECIFIC_PATTERN;
    }

    @Override
    public INodeLoader getNodeLoader() {
        return this._nodeLoader;
    }

    @Override
    public IPattern getPacPattern() {
        return this._pacPattern;
    }

    /*
     * Unable to fully structure code
     */
    protected Map<String, String[]> getAllSegmentLines() {
        block9: {
            if (this._segmentLines != null) break block9;
            this._segmentLines = new HashMap<String, String[]>();
            this._fileLines = new HashMap<String, String>();
            designId = this._editor.getController().getDesignLink().getFileId();
            if (designId == null) break block9;
            entryName = PdpTool.addRPPFolderToFileName((String)designId);
            object = this._editor.getController().getPattern().getDesign(entryName);
            if (!(object instanceof RadicalEntity)) break block9;
            radicalEntity = (RadicalEntity)object;
            it = null;
            if (radicalEntity instanceof PacScreenImpl) {
                it = ((PacScreenImpl)radicalEntity).getCSLines().iterator();
            } else if (radicalEntity instanceof PacServerImpl) {
                it = ((PacServerImpl)radicalEntity).getCSLines().iterator();
            }
            if (it != null) ** GOTO lbl40
            return this._segmentLines;
lbl-1000:
            // 1 sources

            {
                csLine = (PacAbstractCSLine)it.next();
                entityName = "";
                lv = false;
                if (csLine instanceof PacCSLineSegmentCall) {
                    csLineSegmentCall = (PacCSLineSegmentCall)csLine;
                    entityName = csLineSegmentCall.getSegment().getName();
                } else if (csLine instanceof PacCSLineLogicalViewCall) {
                    csLineLogicalViewCall = (PacCSLineLogicalViewCall)csLine;
                    entityName = csLineLogicalViewCall.getLogicalView().getName();
                    lv = true;
                } else if (csLine instanceof PacCSLineServerCall) {
                    csLineServerCall = (PacCSLineServerCall)csLine;
                    entityName = csLineServerCall.getSegment().getName();
                }
                if (entityName.length() <= 0) continue;
                re = PacbaseModelService.SearchRadicalEntity((String)this.getProject(), (String)this.getPackage(), (String)entityName, (String)KernelPackage.eINSTANCE.getDataAggregate().getName().toLowerCase());
                this._segmentLines.put(csLine.getSegmentCode(), new String[]{re != null ? re.getLabel() : "", lv != false ? "LV" : ""});
                re = PacbaseModelService.SearchRadicalEntity((String)this.getProject(), (String)this.getPackage(), (String)entityName.substring(0, 2), (String)KernelPackage.eINSTANCE.getDataUnit().getName().toLowerCase());
                this._fileLines.put(csLine.getSegmentCode().substring(0, 2), re != null ? re.getLabel() : "");
lbl40:
                // 3 sources

                ** while (it.hasNext())
            }
        }
        return this._segmentLines;
    }

    private Map<String, String> getAllFileLines() {
        if (this._fileLines == null) {
            this._fileLines = new HashMap<String, String>();
            this.getAllSegmentLines();
        }
        return this._fileLines;
    }

    public ArrayList<String[]> getFilesList(String tagname) {
        HashMap<String, String[]> list = new HashMap<String, String[]>();
        ArrayList<String[]> l = new ArrayList<String[]>();
        Map<String, IFunctionNode> nodesMap = this.getNodeLoader().getNodesMap();
        Set<String> fcts = nodesMap.keySet();
        for (String name : fcts) {
            if (!name.startsWith(tagname)) continue;
            name = name.substring(name.lastIndexOf("-") + 1);
            String value = "";
            if (list.containsKey(name)) continue;
            if (this.getAllFileLines().containsKey(name)) {
                value = this.getAllFileLines().get(name);
            }
            String[] s = new String[]{name, value};
            list.put(name, s);
        }
        l.addAll(list.values());
        return l;
    }

    public ArrayList<String[]> getSegmentsList(String tagName) {
        HashMap<String, String[]> list = new HashMap<String, String[]>();
        ArrayList<String[]> l = new ArrayList<String[]>();
        Map<String, IFunctionNode> nodesMap = this.getNodeLoader().getNodesMap();
        Set<String> fcts = nodesMap.keySet();
        boolean isValid = false;
        for (String name : fcts) {
            String ref;
            isValid = false;
            if (name.startsWith(tagName)) {
                if (name.contains("-")) {
                    if ("F80".equals(tagName)) {
                        name = name.substring(name.indexOf("-") + 1);
                        if (!this.getPattern().equals((Object)IPacFunctionConstants.FunctionModelPatternValues.DIALOG_PATTERN) ? this.getPattern().equals((Object)IPacFunctionConstants.FunctionModelPatternValues.SERVER_PATTERN) && "OK".equals(name) : "HELP".equals(name) || "LE00".equals(name) || "OKKO".equals(name)) continue;
                        if (name.contains("-")) {
                            name = name.substring(0, name.indexOf("-"));
                        }
                    } else {
                        name = name.substring(name.lastIndexOf("-") + 1);
                        if (tagName.startsWith("F35") && name.length() > 4) continue;
                    }
                    isValid = true;
                }
            } else if (this.getPattern().equals((Object)IPacFunctionConstants.FunctionModelPatternValues.SERVER_PATTERN) && name.contains("-") && (ref = name.substring(name.indexOf("-") + 1)).startsWith(tagName)) {
                name = name.substring(1, name.indexOf("-"));
                isValid = true;
            }
            if (!isValid) continue;
            String value = "";
            if (list.containsKey(name)) continue;
            if (this.getAllSegmentLines().containsKey(name)) {
                value = this.getAllSegmentLines().get(name)[0];
            } else if (this.getPattern().equals((Object)IPacFunctionConstants.FunctionModelPatternValues.SERVER_PATTERN)) continue;
            String[] s = new String[]{name, value};
            list.put(name, s);
        }
        l.addAll(list.values());
        return l;
    }

    public ArrayList<String[]> getDataEltsList(String tagname) {
        if (this._dataEltLines == null) {
            this._dataEltLines = new ArrayList();
            Map<String, IFunctionNode> nodesMap = this.getNodeLoader().getNodesMap();
            Set<String> fcts = nodesMap.keySet();
            for (String name : fcts) {
                if (!name.startsWith(tagname) || !name.contains("-")) continue;
                if (this.getPattern().equals((Object)IPacFunctionConstants.FunctionModelPatternValues.DIALOG_PATTERN)) {
                    name = name.substring(name.indexOf("-") + 1);
                } else {
                    int nb = 0;
                    int i = 0;
                    while (i < name.length()) {
                        if (name.charAt(i) == '-') {
                            ++nb;
                        }
                        ++i;
                    }
                    if (nb > 3) continue;
                    name = name.substring(name.lastIndexOf("-") + 1);
                }
                RadicalEntity re = PacbaseModelService.SearchRadicalEntity((String)this.getProject(), (String)this.getPackage(), (String)name, (String)KernelPackage.eINSTANCE.getDataElement().getName().toLowerCase());
                if (!(re instanceof DataElementImpl)) continue;
                DataElementImpl de = (DataElementImpl)re;
                String label = de.getLabel();
                if (label.length() == 0) {
                    DataDefinition deParent = Util.getPacDataDefinitionParent((DataElementDescription)((DataElementDescription)de.getDataDescription()));
                    label = deParent.getLabel();
                }
                this._dataEltLines.add(new String[]{name, label});
            }
        }
        return this._dataEltLines;
    }
}

