/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.wizards;

import com.ibm.pdp.explorer.model.PTElement;
import com.ibm.pdp.explorer.model.PTLocation;
import com.ibm.pdp.explorer.model.PTModelManager;
import com.ibm.pdp.explorer.nature.PTNature;
import com.ibm.pdp.mdl.pacbase.dialog.SelectPacbaseCallDialog;
import com.ibm.pdp.pacbase.wizards.AccessTypeInsertPage;
import com.ibm.pdp.pacbase.wizards.CommonFunctionPage;
import com.ibm.pdp.pacbase.wizards.FunctionModel;
import com.ibm.pdp.pacbase.wizards.IFunctionControls;
import com.ibm.pdp.pacbase.wizards.Messages;
import com.ibm.pdp.pacbase.wizards.ScreenFunctionPage;
import com.ibm.pdp.pacbase.wizards.ServerGeneralInsertPage;
import com.ibm.pdp.pacbase.wizards.ServerLogicalAccessInsertPage;
import com.ibm.pdp.pacbase.wizards.ServerLogicalViewInsertPage;
import com.ibm.pdp.pacbase.wizards.ServerSQLProcessInsertPage;
import java.util.List;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class FunctionWizard
extends Wizard {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2012, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private FunctionModel _dataModel;
    protected FunctionModel _oldDataModel;
    private IFunctionControls _functionControls;
    protected CommonFunctionPage commonFunctionPage;
    protected ScreenFunctionPage screenFunctionPage;
    protected ServerGeneralInsertPage serverGeneralInsertionPage;
    protected ServerSQLProcessInsertPage serverSQLInsertionPage;
    protected ServerLogicalViewInsertPage serverLogicalViewInsertionPage;
    protected ServerLogicalAccessInsertPage serverLogicalAccessInsertionPage;
    protected AccessTypeInsertPage accessTypeInsertPage;

    public FunctionWizard() {
    }

    public FunctionWizard(FunctionModel model, IFunctionControls functionControl, FunctionModel oldModel) {
        this._dataModel = model;
        this._oldDataModel = oldModel;
        this._functionControls = functionControl;
        if (model.isCopyAction() || model.isMoveAction() || oldModel != null) {
            this.setWindowTitle(Messages.UPDATE_FUNCTION_TITLE);
        } else {
            this.setWindowTitle(Messages.CREATE_FUNCTION_TITLE);
        }
    }

    public FunctionModel getOldDataModel() {
        return this._oldDataModel;
    }

    public void addPages() {
        this.addPage((IWizardPage)this.instanciateCommonFunctionPage(this.getName()));
        this.addPage((IWizardPage)this.instanciateScreenFunctionPage(String.valueOf(this.getName()) + " (" + Messages.DIALOG + ")"));
        this.addPage((IWizardPage)this.instanciateServerGeneralInsertionPage(Messages.INSERT_GENERAL_PROCESS));
        this.addPage((IWizardPage)this.instanciateServerSQLInsertionPage(Messages.INSERT_SQL_PROCESS));
        this.addPage((IWizardPage)this.instanciateServerLogicalViewInsertionPage(Messages.INSERT_LOGICAL_VIEW_PROCESS));
        this.addPage((IWizardPage)this.instanciateServerLogicalAccessInsertionPage(Messages.INSERT_LOGICAL_ACCESS_PROCESS));
        this.addPage((IWizardPage)this.instanciateAccessTypeInsertPage(Messages.INSERT_PHYSICAL_ACESS_PROCESS));
    }

    public boolean canFinish() {
        IWizardPage page = this.getContainer().getCurrentPage();
        boolean finish = page.isPageComplete();
        while (finish && page.getNextPage() != null) {
            page = page.getNextPage();
            finish = page.isPageComplete();
        }
        return finish;
    }

    private String getName() {
        String name = Messages.CREATE_FUNCTION_TITLE;
        if (this.getDataModel().getFunction().length() > 0) {
            name = Messages.UPDATE_FUNCTION_TITLE;
            if (this.getDataModel().getSubFunction().length() > 0) {
                name = Messages.UPDATE_SUBFUNCTION_TITLE;
            }
        }
        return name;
    }

    protected CommonFunctionPage instanciateCommonFunctionPage(String pageName) {
        if (this.commonFunctionPage == null) {
            this.commonFunctionPage = new CommonFunctionPage(pageName);
        }
        return this.commonFunctionPage;
    }

    protected ScreenFunctionPage instanciateScreenFunctionPage(String pageName) {
        if (this.screenFunctionPage == null) {
            this.screenFunctionPage = new ScreenFunctionPage(pageName);
        }
        return this.screenFunctionPage;
    }

    protected ServerGeneralInsertPage instanciateServerGeneralInsertionPage(String pageName) {
        if (this.serverGeneralInsertionPage == null) {
            this.serverGeneralInsertionPage = new ServerGeneralInsertPage(pageName);
        }
        return this.serverGeneralInsertionPage;
    }

    protected ServerSQLProcessInsertPage instanciateServerSQLInsertionPage(String pageName) {
        if (this.serverSQLInsertionPage == null) {
            this.serverSQLInsertionPage = new ServerSQLProcessInsertPage(pageName);
        }
        return this.serverSQLInsertionPage;
    }

    protected ServerLogicalViewInsertPage instanciateServerLogicalViewInsertionPage(String pageName) {
        if (this.serverLogicalViewInsertionPage == null) {
            this.serverLogicalViewInsertionPage = new ServerLogicalViewInsertPage(pageName);
        }
        return this.serverLogicalViewInsertionPage;
    }

    protected ServerLogicalAccessInsertPage instanciateServerLogicalAccessInsertionPage(String pageName) {
        if (this.serverLogicalAccessInsertionPage == null) {
            this.serverLogicalAccessInsertionPage = new ServerLogicalAccessInsertPage(pageName);
        }
        return this.serverLogicalAccessInsertionPage;
    }

    protected AccessTypeInsertPage instanciateAccessTypeInsertPage(String pageName) {
        if (this.accessTypeInsertPage == null) {
            this.accessTypeInsertPage = new AccessTypeInsertPage(pageName);
        }
        return this.accessTypeInsertPage;
    }

    private CommonFunctionPage getCommonFunctionPage() {
        return this.commonFunctionPage;
    }

    public boolean performFinish() {
        this.getCommonFunctionPage().saveDataToModel();
        return true;
    }

    public FunctionModel getDataModel() {
        return this._dataModel;
    }

    public IFunctionControls getFunctionControls() {
        return this._functionControls;
    }

    protected static boolean IsExistingData(String param, String[] elements, boolean toDo) {
        if (toDo) {
            int i = 0;
            while (i < elements.length) {
                if (param.equals(elements[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    protected PTElement openSelectionDialog(String type) {
        PTLocation location = PTModelManager.getSelectedLocation();
        List paths = PTNature.getPaths((String)this.getFunctionControls().getProject());
        SelectPacbaseCallDialog selectDialog = new SelectPacbaseCallDialog(this.getShell(), location, paths, type, 4);
        if (selectDialog.open() == 0) {
            return (PTElement)selectDialog.getSelection().get(0);
        }
        return null;
    }
}

