/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.wizards;

import com.ibm.pdp.mdl.pacbase.util.IPacFunctionConstants;

public class FunctionModel
implements IPacFunctionConstants {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2013, 2022.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    String action = "";
    String condition = "";
    String formattedTitle = "";
    String function = "";
    String subFunction = "";
    String level = "";
    String title = "";
    String reference = "";
    String model = "";
    String logicalView = "";
    private boolean isMacro = false;
    private boolean isMoveAction = false;
    private boolean isCopyPasteTreeAction = false;
    private boolean isMoveTreeAction = false;
    private boolean isCopyAction = false;
    private boolean isOverrideAction = false;
    private boolean isGenerationRequested = false;
    private boolean isBodyToDelete = false;
    private static String titleFunctionSchema = "*NFc.      NOTE *************************************.\r\n      *               *                                   *\r\n      *               *TITLE* \r\n      *               *                                   *\r\n      *               *************************************.";
    private static String multiLinesTitleFunctionSchema = "*NFc.      NOTE *************************************.\r\n      *               *                                   *\r\n      *               *TITLE* \r\nOTHERLINES \r\n      *               *                                   *\r\n      *               *************************************.";
    private static String titleSubFunctionSchema = "*NFcsf.    NOTE *TITLE*.";
    private static int titleLength = 35;
    private String newLine = "\r\n";
    private StringBuilder titleLines = new StringBuilder();

    public FunctionModel(boolean isMacro) {
        this.newLine = System.getProperty("line.separator");
        this.isMacro = isMacro;
    }

    public String getAction() {
        return this.action;
    }

    public String getCondition() {
        return this.condition;
    }

    public String getFunction() {
        return this.function;
    }

    public String getLevel() {
        return this.level;
    }

    public String getModel() {
        return this.model;
    }

    public String getReference() {
        return this.reference;
    }

    public String getSubFunction() {
        return this.subFunction;
    }

    public String getFormattedTitle() {
        return this.formattedTitle;
    }

    public String getLogicalView() {
        return this.logicalView;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isMacro() {
        return this.isMacro;
    }

    public boolean isUpdatedModel(FunctionModel oldModel) {
        if (oldModel != null && !oldModel.getTitle().equals(this.getTitle())) {
            return true;
        }
        return this.isHighUpdatesForModel(oldModel);
    }

    public boolean isHighUpdatesForModel(FunctionModel oldModel) {
        if (oldModel == null) {
            return true;
        }
        boolean b = this.isCommonDatasUpdated(oldModel);
        if (b) {
            return true;
        }
        if (!oldModel.getAction().equals(this.getAction())) {
            return true;
        }
        if (!oldModel.getCondition().equals(this.getCondition())) {
            return true;
        }
        return !oldModel.getReference().equals(this.getReference());
    }

    public boolean isOnlyLocationHasChanged(FunctionModel oldModel) {
        if (oldModel == null) {
            return false;
        }
        if (!oldModel.getAction().equals(this.getAction())) {
            boolean b = this.isCommonDatasUpdated(oldModel);
            if (b) {
                return false;
            }
            if (!oldModel.getCondition().equals(this.getCondition())) {
                return false;
            }
            if (!oldModel.getReference().equals(this.getReference())) {
                return false;
            }
        }
        return true;
    }

    public boolean isCommonDatasUpdated(FunctionModel oldModel) {
        if (oldModel == null) {
            return false;
        }
        if (!oldModel.getFunction().equals(this.getFunction())) {
            return true;
        }
        if (!oldModel.getSubFunction().equals(this.getSubFunction())) {
            return true;
        }
        return !oldModel.getLevel().equals(this.getLevel());
    }

    public boolean isCopyAction() {
        return this.isCopyAction;
    }

    public boolean isMoveAction() {
        return this.isMoveAction;
    }

    public boolean isCopyPasteTreeAction() {
        return this.isCopyPasteTreeAction;
    }

    public boolean isOverrideAction() {
        return this.isOverrideAction;
    }

    public boolean isGenerationRequested() {
        return this.isGenerationRequested;
    }

    public boolean isBodyToDelete() {
        return this.isBodyToDelete;
    }

    public void setAction(String newAction) {
        this.action = newAction;
    }

    public void setCondition(String newCondition) {
        this.condition = newCondition;
    }

    public void setFunction(String function) {
        this.function = function;
    }

    public void setCopyAction(boolean isCopyAction) {
        this.isCopyAction = isCopyAction;
    }

    public void setLogicalView(String logicalView) {
        this.logicalView = logicalView;
    }

    public void setMoveAction(boolean isMoveAction) {
        this.isMoveAction = isMoveAction;
    }

    public void setCopyPasteTreeAction(boolean isCopyPasteTreeAction) {
        this.isCopyPasteTreeAction = isCopyPasteTreeAction;
    }

    public void setOverrideAction(boolean isOverrideAction) {
        this.isOverrideAction = isOverrideAction;
    }

    public void setMoveTreeAction(boolean isMoveTreeAction) {
        this.isMoveTreeAction = isMoveTreeAction;
    }

    public void setGenerationRequested(boolean isGenerationRequested) {
        this.isGenerationRequested = isGenerationRequested;
    }

    public void setDeleteBodyRequested(boolean isBodyToDelete) {
        this.isBodyToDelete = isBodyToDelete;
    }

    public void setLevel(String newLevel) {
        this.level = newLevel;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public void setReference(String newReference) {
        this.reference = newReference;
    }

    public void setSubFunction(String subFunction) {
        this.subFunction = subFunction;
    }

    public void setFormattedTitles(String formattedTitle) {
        this.formattedTitle = formattedTitle;
        this.title = this.unformatTitle(formattedTitle);
    }

    public void setFormattedTitle(String formattedTitle) {
        this.formattedTitle = formattedTitle;
    }

    public void setTitles(String newTitle) {
        this.title = newTitle;
        this.formattedTitle = this.formatTitle(newTitle);
    }

    public void setTitle(String newTitle) {
        this.title = newTitle;
    }

    public String formatTitle(String title) {
        String formattedTitle = "";
        if (title.length() > 0) {
            StringBuilder text = new StringBuilder(this.getTitle());
            int max = titleLength - text.length();
            int i = 0;
            while (i < max) {
                text.append(" ");
                ++i;
            }
            if (this.getSubFunction().length() > 0) {
                formattedTitle = titleSubFunctionSchema.replace("Fcsf", String.valueOf(this.getFunction()) + this.getSubFunction()).replace("TITLE", text);
            } else if (this.titleLines.toString().trim().length() == 0) {
                formattedTitle = titleFunctionSchema.replace("Fc", this.getFunction()).replace("TITLE", text);
            } else {
                formattedTitle = multiLinesTitleFunctionSchema.replace("Fc", this.getFunction()).replace("TITLE", text);
                formattedTitle = formattedTitle.replaceAll("OTHERLINES", this.titleLines.toString());
            }
            if (!this.newLine.equals("\r\n")) {
                formattedTitle = formattedTitle.replaceAll("\r\n", this.newLine);
            }
        }
        return formattedTitle;
    }

    public String unformatTitle(String formattedTitle) {
        String title = "";
        this.titleLines = new StringBuilder();
        if (formattedTitle.trim().length() > 0) {
            String[] lines = formattedTitle.split(this.newLine);
            int j = 0;
            if (lines.length == 5) {
                j = 2;
            }
            if (lines.length == 2) {
                j = 1;
            }
            title = lines[j].substring(0, lines[j].lastIndexOf("*"));
            title = this.isOverrideAction && !"NOTE *".equals(title.substring(17, 23)) ? title.substring(19).trim() : title.substring(23).trim();
        }
        return title;
    }
}

