/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.wizards;

import com.ibm.pdp.engine.tree.IEditTree;
import com.ibm.pdp.explorer.view.service.PTWidgetTool;
import com.ibm.pdp.framework.interfaces.IPattern;
import com.ibm.pdp.mdl.pacbase.util.IPacFunctionConstants;
import com.ibm.pdp.pacbase.IFunctionNode;
import com.ibm.pdp.pacbase.INodeLoader;
import com.ibm.pdp.pacbase.PacTool;
import com.ibm.pdp.pacbase.extension.nodesview.CommonWizardFunctionAction;
import com.ibm.pdp.pacbase.extension.organize.Location;
import com.ibm.pdp.pacbase.wizards.CommonFunctionPage;
import com.ibm.pdp.pacbase.wizards.FunctionModel;
import com.ibm.pdp.pacbase.wizards.FunctionWizard;
import com.ibm.pdp.pacbase.wizards.FunctionWizardForPdpEditor;
import com.ibm.pdp.pacbase.wizards.IFunctionControls;
import com.ibm.pdp.pacbase.wizards.IPdpEditorFunctionControls;
import com.ibm.pdp.pacbase.wizards.Messages;
import com.ibm.pdp.pacbase.wizards.PdpFunctionWizardUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class CommonFunctionPageForPdpEditor
extends CommonFunctionPage {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2013, 2021.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static String MUST_BE_ALPHABETIC = Messages.MUST_BE_ALPHABETIC;
    private static String CR = System.getProperty("line.separator");
    private static String[] modelValuesForBatch = new String[]{Messages.NONE};
    private static String[] modelValuesForDialog = new String[]{Messages.NONE, Messages.DIALOG};
    private static String[] modelValuesForServer = new String[]{Messages.NONE, Messages.SERVER};
    protected static String[] pdpeditor_insertionTypeValues = new String[]{Messages.INSERT_GENERAL_PROCESS, Messages.INSERT_SQL_PROCESS};
    private INodeLoader _nodeLoader;
    private IPdpEditorFunctionControls _functionControls;
    private IPattern _pacPattern;
    protected Button _generationButton;
    protected Button _deleteBodyButton;
    private IEditTree _editTree;
    private boolean _isBodyToDelete;

    public CommonFunctionPageForPdpEditor(String pageName, IEditTree editTree) {
        super(pageName);
        this.isLimited = true;
        this._editTree = editTree;
    }

    public CommonFunctionPageForPdpEditor(String pageName, IEditTree editTree, boolean isBodyToDelete) {
        super(pageName);
        this.isLimited = true;
        this._editTree = editTree;
        this._isBodyToDelete = isBodyToDelete;
    }

    @Override
    public void createControl(Composite parent) {
        this.init();
        super.createControl(parent);
    }

    @Override
    protected void createOthersGroups(Composite parent) {
        FunctionModel dataModel;
        PTWidgetTool.createLabel((Composite)parent, (String)"", (int)8);
        this._generationButton = PTWidgetTool.createCheckBox((Composite)parent, (String)Messages.GENERATION, (int)2);
        this._deleteBodyButton = PTWidgetTool.createCheckBox((Composite)parent, (String)Messages.OVERRIDE, (int)2);
        if (this.isLimited) {
            this._generationButton.setVisible(false);
        }
        if (!(dataModel = ((FunctionWizard)this.getWizard()).getDataModel()).isOverrideAction()) {
            this._deleteBodyButton.setVisible(false);
        } else {
            this._generationButton.setVisible(false);
            this.initDeleteBodyButton(this._isBodyToDelete);
        }
    }

    public String getTitle() {
        String title = super.getTitle();
        FunctionModel dataModel = ((FunctionWizard)this.getWizard()).getDataModel();
        if (dataModel.isCopyAction()) {
            title = Messages.COPYPASTE_SUBFUNCTION_TITLE;
        } else if (dataModel.isMoveAction()) {
            title = Messages.MOVE_SUBFUNCTION_TITLE;
        } else if (dataModel.isOverrideAction()) {
            title = Messages.OVERRIDE_TITLE;
        }
        return title;
    }

    @Override
    protected String[] getModelValues() {
        IFunctionControls functionControls = ((FunctionWizard)this.getWizard()).getFunctionControls();
        if (IPacFunctionConstants.FunctionModelPatternValues.DIALOG_PATTERN.equals((Object)functionControls.getPattern())) {
            return modelValuesForDialog;
        }
        if (IPacFunctionConstants.FunctionModelPatternValues.SERVER_PATTERN.equals((Object)functionControls.getPattern())) {
            return modelValuesForServer;
        }
        return modelValuesForBatch;
    }

    @Override
    protected void createFunctionGroup(Composite parent) {
        super.createFunctionGroup(parent);
        if (this.isLimited) {
            this._cbbConditions.setEnabled(this._isCreateFunctionWizardLaunched);
        }
        if (!this._isCreateFunctionWizardLaunched) {
            FunctionModel dataModel = ((FunctionWizard)this.getWizard()).getDataModel();
            if (dataModel.isMoveAction() || dataModel.isCopyAction()) {
                this._function.setEnabled(true);
                this._subFunction.setEnabled(true);
            } else {
                this._function.removeListener(24, (Listener)this);
                this._function.setText(this.updtFunction);
                this._function.addListener(24, (Listener)this);
                this._function.setEnabled(false);
                this._subFunction.removeListener(24, (Listener)this);
                this._subFunction.setText(this.updtSubFunction);
                this._subFunction.addListener(24, (Listener)this);
                this._subFunction.setEnabled(false);
            }
        }
    }

    protected void init() {
        FunctionWizardForPdpEditor wizard = (FunctionWizardForPdpEditor)this.getWizard();
        this._functionControls = (IPdpEditorFunctionControls)wizard.getFunctionControls();
        this._nodeLoader = this._functionControls.getNodeLoader();
        this._pacPattern = this._functionControls.getPacPattern();
        if (PacTool.isGenerationWithVirtualMacroAlreadyDone(this._editTree.getTextProcessor().getGeneratedInfo())) {
            this.isLimited = false;
        }
    }

    @Override
    protected void initDataWithModel() {
        super.initDataWithModel();
        FunctionModel dataModel = ((FunctionWizard)this.getWizard()).getDataModel();
        this.initGenerationButton(dataModel.isGenerationRequested());
        if (dataModel != null && dataModel.isOverrideAction() && this._isBodyToDelete) {
            this._level.setEnabled(false);
            this.initDeleteBodyButton(true);
        }
        if (dataModel != null && Location.ATTACH.getInsertMspName().equals(dataModel.getAction())) {
            this._title.setEnabled(false);
        }
    }

    private void initGenerationButton(boolean b) {
        if (!this.isLimited) {
            this._generationButton.setSelection(b);
            this._generationButton.setEnabled(!b);
        }
    }

    private void initDeleteBodyButton(boolean b) {
        if (!this.isLimited) {
            this._deleteBodyButton.setSelection(b);
            this._deleteBodyButton.setEnabled(!b);
        }
    }

    private boolean belongsTo(String elem, String[] liste) {
        int i = 0;
        while (i < liste.length) {
            if (elem.equals(liste[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected boolean isPageCompleteforServerPattern() {
        String functionName = "F" + this._function.getText();
        if (this._subFunction.getText().length() == 0) {
            String ref;
            FunctionModel oldModel = ((FunctionWizard)this.getWizard()).getOldDataModel();
            if (!this._isCreateFunctionWizardLaunched) {
                if (this._isCreateFunctionWizardLaunched) return true;
                if (oldModel == null) return true;
                if (functionName.equals("F" + oldModel.getFunction())) return true;
            }
            if ((ref = PdpFunctionWizardUtil.searchAttachForFunction(functionName, this._editTree)) == null) return true;
            if ("SQ".equals(ref)) {
                this.setErrorMessage(Messages.FUNCTION_ALREADY_ATTACHED_TO_SQL_TREATMENT);
                return false;
            }
            if (ref.length() != 4) return false;
            if (ref.indexOf(" ") != -1) return false;
            this.setErrorMessage(Messages.FUNCTION_ALREADY_ATTACHED_TO_LOGICALVIEW);
            return false;
        }
        String insertionType = this._cbbInsertionTypes.getItem(this._cbbInsertionTypes.getSelectionIndex());
        String ref = PdpFunctionWizardUtil.searchAttachForFunction(functionName, this._editTree);
        if (!insertionType.equals(Messages.INSERT_LOGICAL_VIEW_PROCESS)) {
            if (!insertionType.equals(Messages.INSERT_SQL_PROCESS)) return true;
            if (ref == null) return true;
            if (ref.length() != 4) return true;
            this.setErrorMessage(Messages.FUNCTION_ALREADY_ATTACHED_TO_LOGICALVIEW);
            return false;
        }
        if (ref != null && ref.length() == 4) {
            FunctionModel dataModel = ((FunctionWizard)this.getWizard()).getDataModel();
            dataModel.setLogicalView(ref);
            return true;
        }
        this.setErrorMessage(Messages.FUNCTION_NOT_ATTACHED_TO_LOGICALVIEW);
        return false;
    }

    protected boolean isPageCompleteforDialogPattern() {
        String fText;
        if (this._function.isEnabled() && this._subFunction.isEnabled() && this.belongsTo(fText = this._function.getText(), this.getDialogFunctionsValues())) {
            if (this.isLimited) {
                this.setErrorMessage(Messages.INSERT_IN_HIGHPRIORITY_MACRO);
                return false;
            }
            String subFunc = this._subFunction.getText();
            if (subFunc.length() == 2) {
                if ("80".equals(fText)) {
                    if (!this.isSpecificF80SubFunction() && Character.isDigit(subFunc.charAt(0)) && Character.isDigit(subFunc.charAt(1))) {
                        this.setErrorMessage(String.valueOf(Messages.SUB_FUNCTION_CODE) + ": " + MUST_BE_ALPHABETIC);
                        return false;
                    }
                } else if (Character.isDigit(subFunc.charAt(1))) {
                    this.setErrorMessage(String.valueOf(Messages.SUB_FUNCTION_CODE) + ": " + MUST_BE_ALPHABETIC);
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public boolean isPageComplete() {
        String fText;
        IFunctionNode rootNode = this._nodeLoader.getTreeRoot();
        if (rootNode == null || this._nodeLoader.getErrorMessage().length() > 0) {
            this.setErrorMessage(String.valueOf(Messages.INVALID_FUNCTIONS_STRUCTURE) + CR + this._nodeLoader.getErrorMessage());
        }
        if (!super.isPageComplete()) {
            return false;
        }
        if (this._pacPattern.getName().equals("com.ibm.pdp.pacbase.dialog") || this._pacPattern.getName().equals("com.ibm.pdp.pacbase.csclient")) {
            if (!this.isPageCompleteforDialogPattern()) {
                return false;
            }
        } else if (this._pacPattern.getName().equals("com.ibm.pdp.pacbase.csserver")) {
            if (!this.isPageCompleteforServerPattern()) {
                return false;
            }
        } else if (this._pacPattern.getName().equals("com.ibm.pdp.pacbase.server.it") && "80".equals(fText = this._function.getText())) {
            this.setErrorMessage(Messages.INSERT_IN_HIGHPRIORITY_MACRO);
            return false;
        }
        return this.isPageCompleteForMoveCopyFunction();
    }

    private boolean isPageCompleteForMoveCopyFunction() {
        FunctionModel dataModel = ((FunctionWizard)this.getWizard()).getDataModel();
        if (!this._isCreateFunctionWizardLaunched && (dataModel.isCopyAction() || dataModel.isMoveAction()) && !Location.ATTACH.getInsertMspName().equals(dataModel.getAction())) {
            String functionCode = this._function.getText().toUpperCase().trim();
            String subFunctionCode = this._subFunction.getText().toUpperCase().trim();
            if (functionCode.equals(this.updtFunction) && subFunctionCode.equals(this.updtSubFunction)) {
                this.setErrorMessage(Messages.TARGET_FUNCTION_REQUIRED);
                return false;
            }
            if (this.updtSubFunction.length() == 0 && subFunctionCode.length() > 0) {
                this.setErrorMessage(Messages.INVALID_FUNCTION_TARGET);
                return false;
            }
            if (this.updtSubFunction.length() > 0 && subFunctionCode.length() == 0) {
                this.setErrorMessage(Messages.INVALID_SUBFUNCTION_TARGET);
                return false;
            }
        }
        return true;
    }

    @Override
    protected void handleFunctionEvent(Event event) {
        super.handleFunctionEvent(event);
        this.handleEventForGenerationUpdates(event);
    }

    private void handleEventForGenerationUpdates(Event event) {
        boolean gen = this._generationButton.getSelection();
        FunctionModel oldModel = ((FunctionWizardForPdpEditor)this.getWizard()).getOldDataModel();
        FunctionModel dataModel = ((FunctionWizard)this.getWizard()).getDataModel();
        if (PacTool.isGenerationWithVirtualMacroAlreadyDone(this._editTree.getTextProcessor().getGeneratedInfo())) {
            if (CommonWizardFunctionAction.IsGenerationNeeded(this._functionControls.getPacPattern().getName(), this._function.getText(), this._subFunction.getText())) {
                String model;
                boolean b = false;
                if (oldModel == null) {
                    b = true;
                } else if (event.widget == this._function || event.widget == this._subFunction) {
                    if (!this._function.getText().equals(oldModel.getFunction()) || !this._subFunction.getText().equals(oldModel.getSubFunction())) {
                        b = true;
                    }
                } else if (event.widget == this._level) {
                    if (!this._level.getText().equals(oldModel.getLevel())) {
                        b = true;
                    }
                } else if (event.widget == this._cbbModels) {
                    model = this._cbbModels.getItem(this._cbbModels.getSelectionIndex());
                    if (model.equals(Messages.DIALOG) && oldModel.getModel().equals("") && oldModel.getReference().length() != 0) {
                        b = false;
                    }
                    if (model.equals(Messages.NONE) && oldModel.getReference().length() > 0 || model.equals(Messages.SERVER) && oldModel.getReference().length() == 0) {
                        b = true;
                    }
                }
                if (!(b || (model = this._cbbModels.getItem(this._cbbModels.getSelectionIndex())).equals(Messages.NONE) && !"80".equals(this._function.getText()) || (oldModel.getReference().length() <= 0 || oldModel.getReference().equals(dataModel.getReference())) && (oldModel.getAction().length() <= 0 || oldModel.getAction().equals(dataModel.getAction())))) {
                    b = true;
                }
                gen = b;
            } else if (dataModel.isMoveAction() && CommonWizardFunctionAction.IsGenerationNeeded(this._functionControls.getPacPattern().getName(), oldModel.getFunction(), oldModel.getSubFunction())) {
                gen = true;
            } else if (this._isCreateFunctionWizardLaunched) {
                gen = false;
            }
        }
        if (oldModel != null) {
            String item = this._cbbConditions.getItem(this._cbbConditions.getSelectionIndex());
            if (item.equals(Messages.NONE)) {
                item = "";
            } else if (item.contains(Messages.NOT_AVAILABLE)) {
                item = item.substring(0, 2);
            }
            if (!oldModel.getCondition().equals(item)) {
                gen = true;
            }
        }
        String message = "";
        if (this.isSpecificF80SubFunction()) {
            String text = "";
            if ("95".equals(this._subFunction.getText())) {
                text = "HELP";
            } else if ("98".equals(this._subFunction.getText())) {
                text = "LE00";
            } else if ("99".equals(this._subFunction.getText())) {
                text = "OKKO";
            }
            message = Messages.OVERRIDE_SPECIFIC_F80;
            message = NLS.bind((String)message, (Object[])new String[]{text});
        }
        if (dataModel.isOverrideAction()) {
            gen = false;
        }
        if (gen) {
            this.setMessage(String.valueOf(message) + System.getProperty("line.separator") + Messages.REQUIRED_GENERATION, 1);
        } else {
            this.setMessage(message, 0);
        }
        this._generationButton.setSelection(gen);
        this._generationButton.setEnabled(!gen);
    }

    @Override
    public void saveDataToModel() {
        super.saveDataToModel();
        FunctionModel dataModel = ((FunctionWizard)this.getWizard()).getDataModel();
        dataModel.setGenerationRequested(this._generationButton.getSelection());
        dataModel.setDeleteBodyRequested(this._deleteBodyButton.getSelection());
        if (this.isSpecificF80SubFunction()) {
            dataModel.setAction("*R");
            String ref = "HELP";
            if ("98".equals(dataModel.getSubFunction())) {
                ref = "LE00";
            } else if ("99".equals(dataModel.getSubFunction())) {
                ref = "OKKO";
            }
            dataModel.setReference(ref);
        }
    }

    @Override
    protected IPacFunctionConstants.FunctionModelPatternValues getPattern() {
        if (this._pacPattern.getName().equals("com.ibm.pdp.pacbase.dialog") || this._pacPattern.getName().equals("com.ibm.pdp.pacbase.csclient")) {
            return IPacFunctionConstants.FunctionModelPatternValues.DIALOG_PATTERN;
        }
        if (this._pacPattern.getName().equals("com.ibm.pdp.pacbase.csserver")) {
            return IPacFunctionConstants.FunctionModelPatternValues.SERVER_PATTERN;
        }
        return IPacFunctionConstants.FunctionModelPatternValues.NO_SPECIFIC_PATTERN;
    }

    @Override
    public boolean canFlipToNextPage() {
        if (this.isSpecificF80SubFunction()) {
            return false;
        }
        return super.canFlipToNextPage();
    }

    private boolean isSpecificF80SubFunction() {
        String fct = this._function.getText();
        String ssfct = this._subFunction.getText();
        return "80".equals(fct) && (IPacFunctionConstants.FunctionModelPatternValues.DIALOG_PATTERN.equals((Object)this.getPattern()) ? "95".equals(ssfct) || "98".equals(ssfct) || "99".equals(ssfct) : IPacFunctionConstants.FunctionModelPatternValues.SERVER_PATTERN.equals((Object)this.getPattern()) && "99".equals(ssfct));
    }
}

