/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.wizards;

import com.ibm.pdp.explorer.view.service.PTWidgetTool;
import com.ibm.pdp.mdl.pacbase.util.IPacFunctionConstants;
import com.ibm.pdp.mdl.pacbase.util.PacFunctionCheckingUtilities;
import com.ibm.pdp.pacbase.PdpPacbasePlugin;
import com.ibm.pdp.pacbase.extension.Ebcdic;
import com.ibm.pdp.pacbase.wizards.FunctionModel;
import com.ibm.pdp.pacbase.wizards.FunctionWizard;
import com.ibm.pdp.pacbase.wizards.IFunctionWizardPage;
import com.ibm.pdp.pacbase.wizards.Messages;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class CommonFunctionPage
extends WizardPage
implements Listener,
IPacFunctionConstants,
IFunctionWizardPage {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2012, 2020.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected Combo _cbbConditions;
    protected Combo _cbbModels;
    protected Combo _cbbInsertionTypes;
    protected Text _function;
    protected Text _subFunction;
    protected Text _level;
    protected Text _title;
    private Label _cbbInsertionTypesLabel;
    private static String[] modelValues = new String[]{Messages.NONE, Messages.DIALOG, Messages.SERVER};
    protected static String[] insertionTypeValues = new String[]{Messages.INSERT_GENERAL_PROCESS, Messages.INSERT_SQL_PROCESS, Messages.INSERT_LOGICAL_VIEW_PROCESS, Messages.INSERT_LOGICAL_ACCESS_PROCESS};
    private boolean _isListening = true;
    protected boolean _isCreateFunctionWizardLaunched = true;
    private static final String[] conditionValuesArray = new String[]{Messages.NONE, "IT", "EL", "DW", "DU"};
    private static final String[] dialogFunctionsArray = new String[]{"20", "25", "30", "35", "60", "65", "80"};
    private static String DEFAULT_TITLE = "---------------------";
    private String CONTEXT_ID_FOR_HELP = "Macro_wiz_none";
    protected boolean isLimited = false;
    protected String updtFunction = null;
    protected String updtSubFunction = null;

    public CommonFunctionPage(String pageName) {
        super(pageName);
        this.setTitle(pageName);
    }

    protected String[] getConditionValues() {
        if (this._function.getText().trim().length() == 0 || this._subFunction.getText().trim().length() > 0) {
            return conditionValuesArray;
        }
        String[] cv = new String[]{Messages.NONE, "IT"};
        return cv;
    }

    protected String[] getDialogFunctionsValues() {
        return dialogFunctionsArray;
    }

    protected String[] getModelValues() {
        return modelValues;
    }

    protected String[] getInsertionTypeValues() {
        return insertionTypeValues;
    }

    public void createControl(Composite parent) {
        Composite composite = PTWidgetTool.createComposite((Composite)parent, (int)2, (boolean)false);
        PdpPacbasePlugin.setHelpMechanism(composite, this.CONTEXT_ID_FOR_HELP);
        FunctionModel dataModel = ((FunctionWizard)this.getWizard()).getDataModel();
        if (dataModel.getFunction().length() > 0) {
            this._isCreateFunctionWizardLaunched = false;
        }
        this.createFunctionGroup(composite);
        PTWidgetTool.createLabel((Composite)composite, (String)"", (int)8);
        this.createInsertionsGroup(composite);
        this.createOthersGroups(composite);
        this.fillCbbConditions();
        this.initDataWithModel();
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite);
        this.getShell().setMinimumSize(520, 720);
        this.getShell().pack();
        this.initListeners();
    }

    protected void createFunctionGroup(Composite parent) {
        Group group = PTWidgetTool.createGroup((Composite)parent, (int)2, (String)"");
        PTWidgetTool.createLabel((Composite)group, (String)"", (int)4);
        PTWidgetTool.createLabel((Composite)group, (String)Messages.FUNCTION_CODE);
        this._function = PTWidgetTool.createTextField((Composite)group, (boolean)false, (boolean)false);
        this._function.setTextLimit(2);
        this._function.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent focusEvent) {
            }

            public void focusGained(FocusEvent focusEvent) {
                CommonFunctionPage.this._function.selectAll();
            }
        });
        PTWidgetTool.createLabel((Composite)group, (String)Messages.SUB_FUNCTION_CODE);
        this._subFunction = PTWidgetTool.createTextField((Composite)group, (boolean)false, (boolean)false);
        this._subFunction.setTextLimit(2);
        this._subFunction.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent focusEvent) {
            }

            public void focusGained(FocusEvent focusEvent) {
                CommonFunctionPage.this._subFunction.selectAll();
            }
        });
        PTWidgetTool.createLabel((Composite)group, (String)Messages.LEVEL);
        this._level = PTWidgetTool.createTextField((Composite)group, (boolean)false, (boolean)false);
        this._level.setTextLimit(2);
        this._level.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent focusEvent) {
                if (CommonFunctionPage.this._level.getText().length() < 2) {
                    CommonFunctionPage.this._isListening = false;
                    CommonFunctionPage.this._level.setText("0" + CommonFunctionPage.this._level.getText());
                    CommonFunctionPage.this._isListening = true;
                }
            }

            public void focusGained(FocusEvent focusEvent) {
                CommonFunctionPage.this._level.selectAll();
            }
        });
        PTWidgetTool.createLabel((Composite)group, (String)"", (int)2);
        FunctionModel dataModel = ((FunctionWizard)this.getWizard()).getDataModel();
        PTWidgetTool.createLabel((Composite)group, (String)Messages.TITLE);
        if (dataModel.getLevel().length() > 0 && dataModel.getSubFunction().trim().length() == 0) {
            this._level.setEnabled(false);
        }
        this._title = PTWidgetTool.createTextField((Composite)group, (boolean)false, (boolean)false);
        this._title.setTextLimit(35);
        PTWidgetTool.createLabel((Composite)group, (String)Messages.CONDITION);
        this._cbbConditions = PTWidgetTool.createCombo((Composite)group);
        if (dataModel.getFunction().length() > 0) {
            if (this.updtFunction == null) {
                this.updtFunction = dataModel.getFunction();
                this.updtSubFunction = dataModel.getSubFunction();
            }
            this._function.setText(dataModel.getFunction());
            this._subFunction.setText(dataModel.getSubFunction());
            this._function.setEnabled(false);
            this._subFunction.setEnabled(false);
        }
        this.fillCbbConditions();
        if (dataModel.getLevel().length() > 0) {
            this._level.setText(dataModel.getLevel());
            this._title.setText(dataModel.getTitle());
            int i = 0;
            while (i < this._cbbConditions.getItems().length) {
                String item = this._cbbConditions.getItem(i);
                if (item.length() > 0) {
                    item = item.equals(Messages.NONE) ? "" : item.substring(0, 2);
                }
                if (dataModel.getCondition().equals(item)) {
                    this._cbbConditions.select(i);
                    break;
                }
                ++i;
            }
        } else {
            this._level.setText("05");
            if (dataModel.getSubFunction().length() > 0) {
                this._level.setText("10");
            }
        }
        if (dataModel.getLevel().length() == 0) {
            this._title.setText(DEFAULT_TITLE);
        }
    }

    private void createInsertionsGroup(Composite parent) {
        Group group = PTWidgetTool.createGroup((Composite)parent, (int)2, (String)Messages.SPECIFIC_POSITIONING);
        PTWidgetTool.createLabel((Composite)group, (String)"", (int)2);
        PTWidgetTool.createLabel((Composite)group, (String)Messages.MODEL);
        this._cbbModels = PTWidgetTool.createCombo((Composite)group);
        String[] modelValuesArray = this.getModelValues();
        int i = 0;
        while (i < modelValuesArray.length) {
            this._cbbModels.add(modelValuesArray[i]);
            ++i;
        }
        this._cbbModels.setVisibleItemCount(modelValuesArray.length);
        this._cbbModels.select(0);
        this._cbbInsertionTypesLabel = PTWidgetTool.createLabel((Composite)group, (String)Messages.INSERTION_TYPE);
        this._cbbInsertionTypes = PTWidgetTool.createCombo((Composite)group);
        int nbInsertionTypes = this.getInsertionTypeValues().length;
        if (!this._subFunction.isEnabled() && this._subFunction.getText().trim().length() == 0) {
            nbInsertionTypes = 1;
        }
        int i2 = 0;
        while (i2 < nbInsertionTypes) {
            this._cbbInsertionTypes.add(this.getInsertionTypeValues()[i2]);
            ++i2;
        }
        this._cbbInsertionTypes.setVisibleItemCount(this.getInsertionTypeValues().length);
        this._cbbInsertionTypes.select(0);
        this._cbbInsertionTypesLabel.setEnabled(false);
        this._cbbInsertionTypes.setEnabled(false);
        PTWidgetTool.createLabel((Composite)group, (String)"", (int)2);
    }

    protected void createOthersGroups(Composite parent) {
    }

    public void handleEvent(Event event) {
        if (this._isListening) {
            this.handleFunctionEvent(event);
            this.handleModelEvent(event);
            this.getWizard().getContainer().updateButtons();
        }
    }

    protected void handleFunctionEvent(Event event) {
        FunctionModel dataModel = ((FunctionWizard)this.getWizard()).getDataModel();
        if (dataModel.isUpdatedModel(((FunctionWizard)this.getWizard()).getOldDataModel()) || this._isCreateFunctionWizardLaunched) {
            if (event.widget == this._function) {
                if (this._subFunction.getText().length() == 0) {
                    this._level.removeListener(24, (Listener)this);
                    this._level.setText("05");
                    this._level.setEnabled(false);
                    this._level.addListener(24, (Listener)this);
                }
                if ("80".equals(this._function.getText().toString())) {
                    this._cbbInsertionTypes.setEnabled(false);
                    this._cbbModels.setEnabled(false);
                }
                this.fillCbbConditions();
            } else if (event.widget == this._subFunction) {
                this._level.setEnabled(true);
                if (!this._level.getText().startsWith("$")) {
                    this._level.removeListener(24, (Listener)this);
                    if (this._subFunction.getText().trim().length() > 0) {
                        if (this._level.getText().length() == 0) {
                            this._level.setText("10");
                        } else if (this._level.getText().equals("05")) {
                            this._level.setText("10");
                        }
                    } else if (this._level.getText().length() == 0) {
                        this._level.setText("05");
                    } else if (Ebcdic.stringCompare(this._level.getText(), "05") > 0) {
                        this._level.setText("05");
                    }
                    this._level.addListener(24, (Listener)this);
                    this.fillCbbConditions();
                }
            }
        }
    }

    private void fillCbbConditions() {
        if (this._subFunction.getText().trim().length() > 0 && this._cbbConditions.getItemCount() < 3 || this._subFunction.getText().trim().length() == 0 && this._cbbConditions.getItemCount() != 2) {
            String[] conditionValuesArray = this.getConditionValues();
            this._cbbConditions.removeAll();
            int i = 0;
            while (i < conditionValuesArray.length) {
                this._cbbConditions.add(conditionValuesArray[i]);
                ++i;
            }
            FunctionModel dataModel = ((FunctionWizard)this.getWizard()).getDataModel();
            if ("DO".equals(dataModel.getCondition())) {
                this._cbbConditions.add(String.valueOf(dataModel.getCondition()) + Messages.NOT_AVAILABLE);
            }
            this._cbbConditions.setVisibleItemCount(conditionValuesArray.length + 1);
            this._cbbConditions.select(0);
        }
    }

    public void handleModelEvent(Event event) {
        String functionCode;
        if (event.widget == this._cbbModels) {
            this._cbbInsertionTypesLabel.setEnabled(false);
            this._cbbInsertionTypes.setEnabled(false);
            this._cbbConditions.setEnabled(true);
            if (this._function.getText().trim().length() == 0) {
                this._function.setEnabled(true);
                this._subFunction.setEnabled(true);
                this._level.setEnabled(true);
            }
            if (this._cbbModels.getItem(this._cbbModels.getSelectionIndex()).equals(Messages.SERVER)) {
                int i;
                functionCode = this._function.getText().toUpperCase().trim();
                if (!"80".equals(functionCode)) {
                    this._cbbInsertionTypesLabel.setEnabled(true);
                    this._cbbInsertionTypes.setEnabled(true);
                }
                this._cbbConditions.select(0);
                this._cbbConditions.setEnabled(false);
                FunctionModel oldDataModel = ((FunctionWizard)this.getWizard()).getOldDataModel();
                if (oldDataModel != null && (i = this.searchModelInsertionFromData(((FunctionWizard)this.getWizard()).getDataModel(), IPacFunctionConstants.FunctionModelPatternValues.SERVER_PATTERN)) > 2) {
                    this._cbbInsertionTypes.select(i - 2);
                    this._cbbInsertionTypesLabel.setEnabled(true);
                }
            }
        }
        if (event.widget == this._cbbModels && this._cbbInsertionTypes.isEnabled() || event.widget == this._cbbInsertionTypes) {
            if (this._isCreateFunctionWizardLaunched) {
                this._function.setEnabled(true);
                this._subFunction.setEnabled(true);
                this._level.setEnabled(true);
            } else if (this._cbbInsertionTypes.getItem(this._cbbInsertionTypes.getSelectionIndex()).equals(Messages.INSERT_GENERAL_PROCESS)) {
                this._cbbConditions.select(0);
                this._cbbConditions.setEnabled(false);
            }
        }
        if (event.widget == this._function && this._cbbModels.getItem(this._cbbModels.getSelectionIndex()).equals(Messages.DIALOG) && FunctionWizard.IsExistingData(functionCode = this._function.getText().toUpperCase().trim(), this.getDialogFunctionsValues(), true)) {
            this._cbbConditions.select(0);
            this._cbbConditions.setEnabled(false);
        }
        if (event.widget == this._cbbConditions) {
            FunctionModel oldDataModel = ((FunctionWizard)this.getWizard()).getOldDataModel();
            FunctionModel dataModel = ((FunctionWizard)this.getWizard()).getDataModel();
            if (!dataModel.isOverrideAction() && !dataModel.isMacro() && oldDataModel != null && !oldDataModel.getCondition().equals(this._cbbConditions.getText()) && (oldDataModel.getCondition().equals("IT") || oldDataModel.getCondition().equals("DW") || oldDataModel.getCondition().equals("DU") || oldDataModel.getCondition().equals("DO"))) {
                MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart().getSite().getShell(), (String)Messages.TITLE_WARNING_CONDITION_COMMENT, (String)Messages.WARNING_CONDITION_COMMENT);
            }
        }
    }

    public boolean canFlipToNextPage() {
        if (super.canFlipToNextPage()) {
            if (this._cbbModels.isEnabled() && this._cbbModels.getItem(this._cbbModels.getSelectionIndex()).equals(Messages.NONE)) {
                return false;
            }
            String functionCode = this._function.getText().toUpperCase().trim();
            if ("80".equals(functionCode)) {
                String item = this._cbbConditions.getItem(this._cbbConditions.getSelectionIndex());
                return item.equals(Messages.NONE);
            }
            return true;
        }
        return false;
    }

    public IWizardPage getNextPage() {
        String insertionType = this._cbbInsertionTypes.getItem(this._cbbInsertionTypes.getSelectionIndex());
        String functionCode = this._function.getText().toUpperCase().trim();
        if ("80".equals(functionCode) && !this.isLimited) {
            return ((FunctionWizard)this.getWizard()).accessTypeInsertPage;
        }
        if (this._cbbModels.getItem(this._cbbModels.getSelectionIndex()).equals(Messages.DIALOG)) {
            return ((FunctionWizard)this.getWizard()).screenFunctionPage;
        }
        if (this._cbbModels.getItem(this._cbbModels.getSelectionIndex()).equals(Messages.SERVER)) {
            if (insertionType.equals(Messages.INSERT_GENERAL_PROCESS)) {
                return ((FunctionWizard)this.getWizard()).serverGeneralInsertionPage;
            }
            if (insertionType.equals(Messages.INSERT_SQL_PROCESS)) {
                return ((FunctionWizard)this.getWizard()).serverSQLInsertionPage;
            }
            if (insertionType.equals(Messages.INSERT_LOGICAL_VIEW_PROCESS)) {
                return ((FunctionWizard)this.getWizard()).serverLogicalViewInsertionPage;
            }
            if (insertionType.equals(Messages.INSERT_LOGICAL_ACCESS_PROCESS)) {
                return ((FunctionWizard)this.getWizard()).serverLogicalAccessInsertionPage;
            }
        }
        return null;
    }

    public boolean isPageComplete() {
        String subFunctionCode;
        if (this._function.getText().length() == 0) {
            this.setErrorMessage(String.valueOf(Messages.FUNCTION_CODE) + ": " + Messages.DATA_REQUIRED);
            return false;
        }
        if (this._function.getText().length() < 2) {
            this.setErrorMessage(String.valueOf(Messages.FUNCTION_CODE) + ": " + Messages.DATA_INVALID);
            return false;
        }
        String functionCode = this._function.getText().toUpperCase().trim();
        FunctionModel dataModel = ((FunctionWizard)this.getWizard()).getDataModel();
        if (functionCode.startsWith("$")) {
            if (this._cbbModels.getItem(this._cbbModels.getSelectionIndex()).equals(Messages.DIALOG) || this._cbbModels.getItem(this._cbbModels.getSelectionIndex()).equals(Messages.SERVER) && this._cbbInsertionTypes.getItem(this._cbbInsertionTypes.getSelectionIndex()).equals(Messages.INSERT_PHYSICAL_ACESS_PROCESS)) {
                this.setErrorMessage(String.valueOf(Messages.FUNCTION_CODE) + ": " + Messages.DATA_INVALID);
                return false;
            }
            if (!FunctionWizard.IsExistingData(functionCode, PARAMS$, true)) {
                this.setErrorMessage(String.valueOf(Messages.FUNCTION_CODE) + ": " + Messages.DATA_INVALID);
                return false;
            }
        }
        if ((subFunctionCode = this._subFunction.getText().toUpperCase().trim()).length() == 1) {
            this.setErrorMessage(String.valueOf(Messages.SUB_FUNCTION_CODE) + ": " + Messages.DATA_INVALID);
            return false;
        }
        if (this._cbbModels.getItem(this._cbbModels.getSelectionIndex()).equals(Messages.DIALOG)) {
            if (!FunctionWizard.IsExistingData(functionCode, this.getDialogFunctionsValues(), true)) {
                this.setErrorMessage(String.valueOf(Messages.FUNCTION_CODE) + ": " + Messages.DATA_INVALID);
                return false;
            }
            if (subFunctionCode.length() == 0) {
                this.setErrorMessage(String.valueOf(Messages.SUB_FUNCTION_CODE) + ": " + Messages.DATA_REQUIRED);
                return false;
            }
        } else if ("80".equals(functionCode) || this._cbbModels.getItem(this._cbbModels.getSelectionIndex()).equals(Messages.SERVER)) {
            if ("80".equals(functionCode) || this._cbbInsertionTypes.getItem(this._cbbInsertionTypes.getSelectionIndex()).equals(Messages.INSERT_SQL_PROCESS) || this._cbbInsertionTypes.getItem(this._cbbInsertionTypes.getSelectionIndex()).equals(Messages.INSERT_LOGICAL_ACCESS_PROCESS) || this._cbbInsertionTypes.getItem(this._cbbInsertionTypes.getSelectionIndex()).equals(Messages.INSERT_PHYSICAL_ACESS_PROCESS) || this._cbbInsertionTypes.getItem(this._cbbInsertionTypes.getSelectionIndex()).equals(Messages.INSERT_LOGICAL_VIEW_PROCESS)) {
                if (subFunctionCode.length() == 0) {
                    this.setErrorMessage(String.valueOf(Messages.SUB_FUNCTION_CODE) + ": " + Messages.DATA_REQUIRED);
                    return false;
                }
            } else if (this._cbbInsertionTypes.getItem(this._cbbInsertionTypes.getSelectionIndex()).equals(Messages.INSERT_GENERAL_PROCESS)) {
                if ("81".equals(functionCode)) {
                    this.setErrorMessage(String.valueOf(Messages.FUNCTION_CODE) + ": " + Messages.NOT_AUTHORIZED_FOR_THE_INSERTION);
                    return false;
                }
                if (subFunctionCode.trim().length() > 0) {
                    this.setErrorMessage(String.valueOf(Messages.SUB_FUNCTION_CODE) + ": " + Messages.NOT_AUTHORIZED_FOR_THE_INSERTION);
                    return false;
                }
            }
        }
        String name = String.valueOf(functionCode) + subFunctionCode;
        if (subFunctionCode.startsWith("$") && !FunctionWizard.IsExistingData(subFunctionCode, PARAMS$, true)) {
            this.setErrorMessage(String.valueOf(Messages.SUB_FUNCTION_CODE) + ": " + Messages.DATA_INVALID);
            return false;
        }
        if (this._level.getText().length() == 0) {
            this.setErrorMessage(String.valueOf(Messages.LEVEL) + ": " + Messages.DATA_REQUIRED);
            return false;
        }
        String level = this._level.getText().toUpperCase().trim();
        int lev = 0;
        try {
            if (level.length() > 0 && !level.startsWith("$")) {
                lev = Integer.parseInt(level);
                if (subFunctionCode.trim().length() > 0 && lev < 6) {
                    this.setErrorMessage(String.valueOf(Messages.LEVEL) + ": " + Messages.MUST_BE_UPPER);
                    return false;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.setErrorMessage(String.valueOf(Messages.LEVEL) + ": " + Messages.MUST_BE_NUMERIC);
            return false;
        }
        if (level.startsWith("$") && !FunctionWizard.IsExistingData(level, PARAMS$LEVEL, dataModel.isMacro())) {
            this.setErrorMessage(String.valueOf(Messages.LEVEL) + ": " + Messages.DATA_INVALID);
            return false;
        }
        if (subFunctionCode.length() == 0 && !this._cbbConditions.getItem(this._cbbConditions.getSelectionIndex()).equals("IT") && !this._cbbConditions.getItem(this._cbbConditions.getSelectionIndex()).equals(Messages.NONE)) {
            this.setErrorMessage(String.valueOf(Messages.CONDITION) + ": " + Messages.DATA_INVALID);
            return false;
        }
        if (dataModel.isOverrideAction() && this._title.getText().length() == 0) {
            this.setErrorMessage(String.valueOf(Messages.TITLE) + ": " + Messages.DATA_REQUIRED);
            return false;
        }
        FunctionWizard wizard = (FunctionWizard)this.getWizard();
        if (!(!this._isCreateFunctionWizardLaunched && (this._isCreateFunctionWizardLaunched || functionCode.equals(this.updtFunction) && subFunctionCode.equals(this.updtSubFunction)) || !wizard.getFunctionControls().isExistingLabel(name))) {
            this.setErrorMessage(Messages.LABEL_ALREADY_EXIST);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    private void initListeners() {
        this._function.addListener(24, (Listener)this);
        this._subFunction.addListener(24, (Listener)this);
        this._level.addListener(24, (Listener)this);
        this._title.addListener(24, (Listener)this);
        this._cbbConditions.addListener(13, (Listener)this);
        this._cbbModels.addListener(13, (Listener)this);
        this._cbbInsertionTypes.addListener(13, (Listener)this);
    }

    protected void initDataWithModel() {
        FunctionModel dataModel = ((FunctionWizard)this.getWizard()).getDataModel();
        if (!this._isCreateFunctionWizardLaunched && "".equals(dataModel.getSubFunction())) {
            this._subFunction.setEnabled(false);
        }
        if ("80".equals(dataModel.getFunction())) {
            this._cbbModels.setEnabled(false);
            this._cbbInsertionTypes.setEnabled(false);
        } else if (dataModel.getReference().length() > 0 || dataModel.getAction() != null && dataModel.getAction().length() > 0) {
            this._cbbModels.setEnabled(true);
            this._cbbInsertionTypes.setEnabled(true);
            int i = this.searchModelInsertionFromData(dataModel, this.getPattern());
            switch (i) {
                case 0: {
                    this._cbbModels.select(1);
                    this._cbbInsertionTypes.setEnabled(false);
                    break;
                }
                case 1: {
                    this._cbbModels.select(1);
                    this._cbbInsertionTypes.setEnabled(false);
                    break;
                }
                default: {
                    this._cbbModels.select(this._cbbModels.getItemCount() - 1);
                    this._cbbInsertionTypes.select(i - 2);
                    this._cbbInsertionTypesLabel.setEnabled(true);
                }
            }
        }
        if (this.isLimited) {
            this._cbbModels.setEnabled(false);
        }
    }

    @Override
    public void saveDataToModel() {
        FunctionModel dataModel = ((FunctionWizard)this.getWizard()).getDataModel();
        dataModel.setFunction(this._function.getText().trim().toUpperCase());
        dataModel.setSubFunction(this._subFunction.getText().trim().toUpperCase());
        String model = this._cbbModels.getItem(this._cbbModels.getSelectionIndex());
        if (model.equals(Messages.NONE)) {
            dataModel.setModel("");
        } else {
            dataModel.setModel(model);
        }
        dataModel.setLevel(this._level.getText().toUpperCase());
        String item = this._cbbConditions.getItem(this._cbbConditions.getSelectionIndex());
        if (item.equals(Messages.NONE)) {
            dataModel.setCondition("");
        } else if (item.contains(Messages.NOT_AVAILABLE)) {
            dataModel.setCondition(item.substring(0, 2));
        } else {
            dataModel.setCondition(item);
        }
        if (this._title.isEnabled()) {
            dataModel.setTitles(this._title.getText().trim());
        }
        if (!"80".equals(dataModel.getFunction()) && dataModel.getModel().length() == 0) {
            dataModel.setReference("");
            dataModel.setAction("");
        }
    }

    protected int searchModelInsertionFromData(FunctionModel dataModel, IPacFunctionConstants.FunctionModelPatternValues currentPattern) {
        if (dataModel.getReference().trim().length() > 0) {
            StringTokenizer tokenizer = new StringTokenizer(dataModel.getReference(), " ");
            ArrayList<String> refs = new ArrayList<String>();
            while (tokenizer.hasMoreTokens()) {
                refs.add(tokenizer.nextToken());
            }
            String ref = (String)refs.get(0);
            IPacFunctionConstants.FunctionModelPatternValues pattern = PacFunctionCheckingUtilities.searchPattern((String)("F" + dataModel.getFunction()), (String)dataModel.getReference(), (String)dataModel.getAction(), (IPacFunctionConstants.FunctionModelPatternValues)currentPattern);
            if (IPacFunctionConstants.FunctionModelPatternValues.DIALOG_PATTERN.equals((Object)pattern)) {
                return 1;
            }
            if (IPacFunctionConstants.FunctionModelPatternValues.SERVER_PATTERN.equals((Object)pattern)) {
                if ("05".equals(dataModel.getLevel())) {
                    return 2;
                }
                if (ref.startsWith("SQLD") || ref.startsWith("SQLW")) {
                    return 3;
                }
                int i = 0;
                while (i < LOGICAL_VIEW_PROCESS.length) {
                    if (ref.startsWith(LOGICAL_VIEW_PROCESS[i])) {
                        return 4;
                    }
                    ++i;
                }
                i = 0;
                while (i < LOGICAL_ACCESS_PROCESS.length) {
                    if (ref.startsWith(LOGICAL_ACCESS_PROCESS[i])) {
                        return 5;
                    }
                    ++i;
                }
                if (dataModel.getAction().equals("*B")) {
                    return 5;
                }
                if (dataModel.getAction().equals("*C")) {
                    return 2;
                }
            }
            if (PacFunctionCheckingUtilities.isDialogFunction((String)("F" + dataModel.getFunction()))) {
                return 0;
            }
            if ("05".equals(dataModel.getLevel())) {
                return 2;
            }
            return 3;
        }
        return 0;
    }

    protected IPacFunctionConstants.FunctionModelPatternValues getPattern() {
        return null;
    }
}

