/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.wizards;

import com.ibm.pdp.mdl.pacbase.util.IPacFunctionConstants;
import com.ibm.pdp.pacbase.wizards.AccessTypeFunction;
import com.ibm.pdp.pacbase.wizards.Messages;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class AccessTypeTreeContentProvider
implements ITreeContentProvider,
IPacFunctionConstants {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2016.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String STANDARD = "STANDARD";
    private static final String SERVER = "SERVER";
    private static final String DLI = "DLI";
    public static final AccessTypeFunction[] FIRST_LEVELS = new AccessTypeFunction[]{new AccessTypeFunction("STANDARD", Messages.ACCESS_TYPE_STANDARD), new AccessTypeFunction("SERVER", Messages.ACCESS_SERVER), new AccessTypeFunction("DLI", Messages.ACCESS_DL1)};
    public static final AccessTypeFunction[] PREDEFINED_ACCESS_TYPES = new AccessTypeFunction[]{new AccessTypeFunction("CL", Messages.ACCESS_CLOSE), new AccessTypeFunction("D", Messages.ACCESS_DELETE), new AccessTypeFunction("EB", Messages.ACCESS_END_BROWSE), new AccessTypeFunction("R", Messages.ACCESS_READ), new AccessTypeFunction("RA", Messages.ACCESS_READ_ALL), new AccessTypeFunction("RN", Messages.ACCESS_READ_NEXT), new AccessTypeFunction("RU", Messages.ACCESS_READ_UPDATE), new AccessTypeFunction("RW", Messages.ACCESS_REWRITE), new AccessTypeFunction("P", Messages.ACCESS_START), new AccessTypeFunction("UN", Messages.ACCESS_UNLOCK), new AccessTypeFunction("W ", Messages.ACCESS_WRITE)};
    public static final AccessTypeFunction[] PREDEFINED_ACCESS_TYPES_SERVER = new AccessTypeFunction[]{new AccessTypeFunction("R1", Messages.CALL_ALIM), new AccessTypeFunction("R2", Messages.CALL_CALL), new AccessTypeFunction("R3", Messages.CALL_RETC)};
    public static final AccessTypeFunction[] PREDEFINED_ACCESS_TYPES_DLI = new AccessTypeFunction[]{new AccessTypeFunction("1", "CALL 1"), new AccessTypeFunction("2", "CALL 2"), new AccessTypeFunction("3", "CALL 3")};

    public void dispose() {
    }

    public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
    }

    public Object[] getChildren(Object arg0) {
        AccessTypeFunction atf = (AccessTypeFunction)arg0;
        if (STANDARD.equals(atf.getAccesType())) {
            return PREDEFINED_ACCESS_TYPES;
        }
        if (SERVER.equals(atf.getAccesType())) {
            return PREDEFINED_ACCESS_TYPES_SERVER;
        }
        if (DLI.equals(atf.getAccesType())) {
            return PREDEFINED_ACCESS_TYPES_DLI;
        }
        return null;
    }

    public Object[] getElements(Object arg0) {
        return FIRST_LEVELS;
    }

    public Object getParent(Object arg0) {
        return null;
    }

    public boolean hasChildren(Object arg0) {
        AccessTypeFunction[] accessTypeFunctionArray = FIRST_LEVELS;
        int n = FIRST_LEVELS.length;
        int n2 = 0;
        while (n2 < n) {
            AccessTypeFunction firstLevel = accessTypeFunctionArray[n2];
            if (firstLevel.getAccesType().equals(((AccessTypeFunction)arg0).getAccesType())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public AccessTypeFunction getFirstElement() {
        return FIRST_LEVELS[0];
    }
}

