/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.wizards;

import com.ibm.pdp.engine.tree.IEditTree;
import com.ibm.pdp.pacbase.IFunctionNode;
import com.ibm.pdp.pacbase.INodeLoader;
import com.ibm.pdp.pacbase.PacTool;
import com.ibm.pdp.pacbase.extension.nodesview.CommonWizardFunctionAction;
import com.ibm.pdp.pacbase.wizards.AccessTypeInsertPage;
import com.ibm.pdp.pacbase.wizards.CommonFunctionPageForPdpEditor;
import com.ibm.pdp.pacbase.wizards.FunctionModel;
import com.ibm.pdp.pacbase.wizards.FunctionWizard;
import com.ibm.pdp.pacbase.wizards.FunctionWizardForPdpEditor;
import com.ibm.pdp.pacbase.wizards.IFunctionControls;
import com.ibm.pdp.pacbase.wizards.IPdpEditorFunctionControls;
import com.ibm.pdp.pacbase.wizards.Messages;
import com.ibm.pdp.pacbase.wizards.PdpEditorFunctionControls;
import com.ibm.pdp.pacbase.wizards.PdpFunctionWizardUtil;
import java.util.ArrayList;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Event;

public class AccessTypeInsertPageForPdpEditor
extends AccessTypeInsertPage {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private IEditTree _editTree;

    public AccessTypeInsertPageForPdpEditor(String pageName, IEditTree editTree) {
        super(pageName);
        this._editTree = editTree;
    }

    @Override
    protected void handleEventForAccesTypeInsertPage(Event event) {
        super.handleEventForAccesTypeInsertPage(event);
        this.handleEventForGenerationUpdates(event);
    }

    @Override
    protected void handleEventForSegmentSelection() {
        FunctionModel dataModel = ((FunctionWizard)this.getWizard()).getDataModel();
        String functionName = "F" + dataModel.getFunction();
        IFunctionControls controls = ((FunctionWizardForPdpEditor)this.getWizard()).getFunctionControls();
        PdpEditorFunctionControls pdpControls = (PdpEditorFunctionControls)controls;
        ArrayList<String[]> list = null;
        list = pdpControls.getSegmentsList(functionName);
        String element = PdpFunctionWizardUtil.openListDialog(this.getShell(), list, Messages.SEGMENT_SELECTION);
        if (element != null) {
            this._segmentCode.setText(element);
        }
    }

    private void handleEventForGenerationUpdates(Event event) {
        FunctionModel dataModel = ((FunctionWizard)this.getWizard()).getDataModel();
        IFunctionControls functionControls = ((FunctionWizard)this.getWizard()).getFunctionControls();
        if (CommonWizardFunctionAction.IsGenerationNeeded(functionControls.getPattern().toString(), dataModel.getFunction(), dataModel.getSubFunction())) {
            boolean b = false;
            FunctionModel oldModel = ((FunctionWizardForPdpEditor)this.getWizard()).getOldDataModel();
            if (oldModel != null && (event == null || event.widget == this._segmentCode || event.widget instanceof Button) && !this.getReference().equals(oldModel.getReference())) {
                b = true;
            }
            if (b || dataModel.isCommonDatasUpdated(oldModel)) {
                this.setMessage(Messages.REQUIRED_GENERATION, 1);
            } else {
                this.setMessage(null, 0);
            }
        }
    }

    @Override
    protected void handleTreeSelectionChanged(SelectionChangedEvent event) {
        super.handleTreeSelectionChanged(event);
        this.handleEventForGenerationUpdates(null);
    }

    @Override
    protected void initDataWithModel() {
        super.initDataWithModel();
        this._paramAccessTypeButton.setVisible(false);
        this.initGenerationMessage();
    }

    @Override
    protected void initFunctionDatasFromModel() {
        super.initFunctionDatasFromModel();
        this.initGenerationMessage();
    }

    private void initGenerationMessage() {
        FunctionModel dataModel = ((FunctionWizard)this.getWizard()).getDataModel();
        if (dataModel.isHighUpdatesForModel(((FunctionWizardForPdpEditor)this.getWizard()).getOldDataModel()) && dataModel.isGenerationRequested()) {
            this.setMessage(Messages.REQUIRED_GENERATION, 1);
        } else {
            this.setMessage(null, 0);
        }
    }

    @Override
    public void saveDataToModel() {
        super.saveDataToModel();
        FunctionModel dataModel = ((FunctionWizard)this.getWizard()).getDataModel();
        boolean b = dataModel.isHighUpdatesForModel(((FunctionWizardForPdpEditor)this.getWizard()).getOldDataModel());
        dataModel.setGenerationRequested(b);
        ((CommonFunctionPageForPdpEditor)this.getPreviousPage())._generationButton.setSelection(b);
        ((CommonFunctionPageForPdpEditor)this.getPreviousPage())._generationButton.setEnabled(!b);
    }

    @Override
    public boolean isPageComplete() {
        IFunctionNode fn;
        String tagName;
        boolean b = super.isPageComplete();
        if (!b) {
            return false;
        }
        FunctionModel dataModel = ((FunctionWizard)this.getWizard()).getDataModel();
        if (dataModel.getFunction().length() == 0) {
            return true;
        }
        String functionName = "F" + dataModel.getFunction();
        String ref = this.getReference();
        if (ref.length() == 0) {
            return true;
        }
        IFunctionControls controls = ((FunctionWizardForPdpEditor)this.getWizard()).getFunctionControls();
        INodeLoader nodeLoader = null;
        if (controls instanceof IPdpEditorFunctionControls) {
            IPdpEditorFunctionControls pdpControls = (IPdpEditorFunctionControls)controls;
            nodeLoader = pdpControls.getNodeLoader();
        }
        if (!(this._editTree.nodeFromTagName(tagName = PacTool.buildTagName(functionName, ref, this._editTree)) != null || (fn = PdpFunctionWizardUtil.findOverridingNode(nodeLoader, new String[]{tagName, tagName.contains("-") ? tagName.substring(0, tagName.lastIndexOf("-")) : null})) != null && fn.getName().equals(String.valueOf(functionName) + dataModel.getSubFunction()))) {
            this.setErrorMessage(String.valueOf(tagName) + " " + Messages.AUTOMATIC_FUNCTION_DOES_NOT_EXIST);
            return false;
        }
        return true;
    }
}

