/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.wizards;

import com.ibm.pdp.explorer.model.PTElement;
import com.ibm.pdp.explorer.view.service.PTWidgetTool;
import com.ibm.pdp.mdl.kernel.DataAggregate;
import com.ibm.pdp.mdl.pacbase.util.IPacFunctionConstants;
import com.ibm.pdp.mdl.pacbase.util.PacFunctionCheckingUtilities;
import com.ibm.pdp.pacbase.PdpPacbasePlugin;
import com.ibm.pdp.pacbase.wizards.AccessTypeFunction;
import com.ibm.pdp.pacbase.wizards.AccessTypeTreeContentProvider;
import com.ibm.pdp.pacbase.wizards.AccessTypeTreeLabelProvider;
import com.ibm.pdp.pacbase.wizards.FunctionModel;
import com.ibm.pdp.pacbase.wizards.FunctionWizard;
import com.ibm.pdp.pacbase.wizards.IFunctionWizardPage;
import com.ibm.pdp.pacbase.wizards.Messages;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class AccessTypeInsertPage
extends WizardPage
implements IPacFunctionConstants,
Listener,
IFunctionWizardPage {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2016, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Composite _composite;
    private Label _functionLabel;
    private Label _levelLabel;
    protected TreeViewer _trvAccess;
    protected Text _accessTypeParameter;
    protected Text _segmentCode;
    private Button _segmentSelection;
    protected Button _accessTypeButton;
    protected Button _paramAccessTypeButton;
    private String CONTEXT_ID_FOR_HELP = "Macro_wiz_serv_phys";
    private IStructuredSelection selection;

    public AccessTypeInsertPage(String pageName) {
        super(pageName);
        this.setTitle(pageName);
    }

    public AccessTypeInsertPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createControl(Composite parent) {
        this._composite = PTWidgetTool.createComposite((Composite)parent, (int)1, (boolean)false);
        PdpPacbasePlugin.setHelpMechanism(this._composite, this.CONTEXT_ID_FOR_HELP);
        this.createFunctionGroup(this._composite);
        PTWidgetTool.createLabel((Composite)this._composite, (String)"", (int)6);
        this.createSegmentControls(this._composite);
        PTWidgetTool.createLabel((Composite)this._composite, (String)"", (int)3);
        this.createAccessTypeControls(this._composite);
        PTWidgetTool.createLabel((Composite)this._composite, (String)"");
        this.setErrorMessage(null);
        this.setMessage(null);
        this.initDataWithModel();
        this.createListeners();
        this.setControl((Control)this._composite);
    }

    private void createFunctionGroup(Composite parent) {
        PTWidgetTool.createLabel((Composite)parent, (String)"", (int)2);
        Group group = PTWidgetTool.createGroup((Composite)parent, (int)4, (String)"");
        PTWidgetTool.createLabel((Composite)group, (String)(String.valueOf(Messages.SUB_FUNCTION_CODE) + ": "));
        this._functionLabel = PTWidgetTool.createLabel((Composite)group, (String)"");
        ((GridData)this._functionLabel.getLayoutData()).grabExcessHorizontalSpace = true;
        PTWidgetTool.createLabel((Composite)group, (String)(String.valueOf(Messages.LEVEL) + ": "));
        this._levelLabel = PTWidgetTool.createLabel((Composite)group, (String)"");
        ((GridData)this._levelLabel.getLayoutData()).grabExcessHorizontalSpace = true;
    }

    private void createSegmentControls(Composite parent) {
        Composite refCompo = PTWidgetTool.createComposite((Composite)this._composite, (int)3, (boolean)false);
        PTWidgetTool.createLabel((Composite)refCompo, (String)Messages.SEGMENT_CODE);
        this._segmentCode = PTWidgetTool.createTextField((Composite)refCompo, (boolean)false, (boolean)false);
        this._segmentCode.setTextLimit(4);
        this._segmentSelection = PTWidgetTool.createPushButton((Composite)refCompo, (String)Messages.BROWSE_BUTTON, (boolean)true);
    }

    private void createAccessTypeControls(Composite parent) {
        Group group = PTWidgetTool.createGroup((Composite)parent, (int)2, (String)Messages.ACCESS_TYPE);
        this._paramAccessTypeButton = PTWidgetTool.createCheckBox((Composite)group, (String)Messages.PARAMETER, (int)1);
        this._accessTypeParameter = PTWidgetTool.createTextField((Composite)group, (boolean)false, (boolean)false, (int)1);
        this._accessTypeParameter.setTextLimit(2);
        this._accessTypeButton = PTWidgetTool.createCheckBox((Composite)group, (String)Messages.ACCESS, (int)1);
        PTWidgetTool.createLabel((Composite)group, (String)"", (int)1);
        PTWidgetTool.createLabel((Composite)group, (String)"", (int)1);
        this._trvAccess = PTWidgetTool.createTreeViewer((Composite)group, (boolean)false, (int)1);
        this._trvAccess.setContentProvider((IContentProvider)new AccessTypeTreeContentProvider());
        this._trvAccess.setLabelProvider((IBaseLabelProvider)new AccessTypeTreeLabelProvider());
    }

    private void createListeners() {
        this._segmentCode.addListener(24, (Listener)this);
        this._segmentSelection.addListener(13, (Listener)this);
        this._paramAccessTypeButton.addListener(13, (Listener)this);
        this._accessTypeParameter.addListener(24, (Listener)this);
        this._accessTypeButton.addListener(13, (Listener)this);
        this._trvAccess.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AccessTypeInsertPage.this.handleTreeSelectionChanged(event);
            }
        });
    }

    protected void initFunctionDatasFromModel() {
        FunctionModel dataModel = ((FunctionWizard)this.getWizard()).getDataModel();
        this._functionLabel.setText(String.valueOf(dataModel.getFunction()) + dataModel.getSubFunction());
        this._levelLabel.setText(dataModel.getLevel());
    }

    protected void initDataWithModel() {
        this._trvAccess.setInput((Object)"");
        AccessTypeTreeContentProvider provider = (AccessTypeTreeContentProvider)this._trvAccess.getContentProvider();
        this._trvAccess.expandToLevel((Object)provider.getFirstElement(), 2);
        this._accessTypeParameter.setEnabled(false);
        this._trvAccess.getTree().setEnabled(false);
        FunctionModel dataModel = ((FunctionWizard)this.getWizard()).getDataModel();
        StringTokenizer tokenizer = new StringTokenizer(dataModel.getReference(), " ");
        ArrayList<String> refs = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            refs.add(tokenizer.nextToken());
        }
        if (refs.size() > 0) {
            this._segmentCode.setText((String)refs.get(0));
            String accessType = "";
            if (refs.size() > 1) {
                accessType = (String)refs.get(1);
                if (dataModel.isMacro() && accessType.startsWith("$")) {
                    this._accessTypeParameter.setText(accessType);
                    this._accessTypeParameter.setEnabled(true);
                    this._paramAccessTypeButton.setSelection(true);
                    this._trvAccess.getTree().setEnabled(false);
                } else {
                    AccessTypeFunction[] atf;
                    boolean found = false;
                    this._accessTypeParameter.setEnabled(false);
                    AccessTypeFunction[] accessTypeFunctionArray = atf = (AccessTypeFunction[])provider.getElements("");
                    int n = atf.length;
                    int n2 = 0;
                    while (n2 < n) {
                        AccessTypeFunction[] atfchildren;
                        AccessTypeFunction accessTypeFunction = accessTypeFunctionArray[n2];
                        AccessTypeFunction[] accessTypeFunctionArray2 = atfchildren = (AccessTypeFunction[])provider.getChildren(accessTypeFunction);
                        int n3 = atfchildren.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            AccessTypeFunction child = accessTypeFunctionArray2[n4];
                            if (child.getAccesType().equals(accessType)) {
                                this.selection = new StructuredSelection((Object)child);
                                this._trvAccess.expandToLevel((Object)accessTypeFunction, 2);
                                this._trvAccess.setSelection((ISelection)this.selection);
                                found = true;
                                break;
                            }
                            ++n4;
                        }
                        ++n2;
                    }
                    if (found) {
                        this._accessTypeButton.setEnabled(true);
                        this._accessTypeButton.setSelection(true);
                        this._trvAccess.getTree().setEnabled(true);
                    }
                }
            }
        }
    }

    public void handleEvent(Event event) {
        this.handleEventForAccesTypeInsertPage(event);
        this.setPageComplete(this.isPageComplete());
        this.getWizard().getContainer().updateButtons();
    }

    protected void handleEventForAccesTypeInsertPage(Event event) {
        if (event.widget == this._segmentSelection) {
            this.handleEventForSegmentSelection();
        } else if (event.widget instanceof Button) {
            if (this._accessTypeButton.getSelection()) {
                this._trvAccess.getTree().setEnabled(true);
                if (this._paramAccessTypeButton.isVisible()) {
                    this._paramAccessTypeButton.setSelection(false);
                    this._accessTypeParameter.setEnabled(false);
                }
            } else if (this._paramAccessTypeButton.getSelection()) {
                this._trvAccess.getTree().setEnabled(false);
                if (this._paramAccessTypeButton.isVisible()) {
                    this._accessTypeParameter.setEnabled(true);
                    this._accessTypeButton.setSelection(false);
                }
            }
        }
    }

    protected void handleEventForSegmentSelection() {
        PTElement element = ((FunctionWizard)this.getWizard()).openSelectionDialog(DataAggregate.class.getSimpleName());
        if (element != null) {
            this._segmentCode.setText(element.getName());
        }
    }

    protected void handleTreeSelectionChanged(SelectionChangedEvent event) {
        this.selection = (IStructuredSelection)event.getSelection();
        this.setPageComplete(this.isPageComplete());
        this.getWizard().getContainer().updateButtons();
    }

    public boolean isPageComplete() {
        FunctionModel dataModel = ((FunctionWizard)this.getWizard()).getDataModel();
        String segmentCode = this._segmentCode.getText().trim();
        if (segmentCode.length() == 0) {
            if (this._paramAccessTypeButton.isVisible() && this._paramAccessTypeButton.getSelection() || this._accessTypeButton.getSelection()) {
                this.setErrorMessage(String.valueOf(Messages.SEGMENT_CODE) + ": " + Messages.DATA_REQUIRED);
                return false;
            }
        } else {
            boolean b;
            if (segmentCode.contains("$") && segmentCode.length() != 2 && segmentCode.length() != 4 || !segmentCode.startsWith("$") && segmentCode.length() != 4) {
                this.setErrorMessage(String.valueOf(Messages.SEGMENT_CODE) + ": " + Messages.LENGTH_INVALID);
                return false;
            }
            if (segmentCode.contains("$") && !(b = PacFunctionCheckingUtilities.isParameterWithDollarWellFormed((String)segmentCode, null))) {
                this.setErrorMessage(String.valueOf(Messages.SEGMENT_CODE) + ": " + Messages.DATA_INVALID);
                return false;
            }
        }
        if (this._paramAccessTypeButton.isVisible() && this._paramAccessTypeButton.getSelection()) {
            String accessType = this._accessTypeParameter.getText().trim();
            if (accessType.length() == 0) {
                this.setErrorMessage(String.valueOf(Messages.ACCESS_TYPE) + ": " + Messages.DATA_REQUIRED);
                return false;
            }
            if (!accessType.startsWith("$") || accessType.length() != 2) {
                this.setErrorMessage(String.valueOf(Messages.ACCESS_TYPE) + ": " + Messages.DATA_INVALID);
                return false;
            }
            if (accessType.startsWith("$") && !FunctionWizard.IsExistingData(accessType.toUpperCase(), PARAMS$, dataModel.isMacro())) {
                this.setErrorMessage(String.valueOf(Messages.ACCESS_TYPE) + ": " + Messages.DATA_INVALID);
                return false;
            }
        } else if (this._accessTypeButton.isVisible() && this._accessTypeButton.getSelection()) {
            if (this.selection == null || this.selection.isEmpty()) {
                this.setErrorMessage(String.valueOf(Messages.ACCESS_TYPE) + ": " + Messages.DATA_REQUIRED);
                return false;
            }
            AccessTypeFunction atf = (AccessTypeFunction)this.selection.getFirstElement();
            AccessTypeFunction[] accessTypeFunctionArray = AccessTypeTreeContentProvider.FIRST_LEVELS;
            int n = AccessTypeTreeContentProvider.FIRST_LEVELS.length;
            int n2 = 0;
            while (n2 < n) {
                AccessTypeFunction access = accessTypeFunctionArray[n2];
                if (atf.getAccesType().equals(access.getAccesType())) {
                    this.setErrorMessage(String.valueOf(Messages.ACCESS_TYPE) + ": " + Messages.DATA_REQUIRED);
                    return false;
                }
                ++n2;
            }
        }
        this.setErrorMessage(null);
        return true;
    }

    @Override
    public void saveDataToModel() {
        FunctionModel dataModel = ((FunctionWizard)this.getWizard()).getDataModel();
        String ref = this.getReference();
        dataModel.setReference(ref);
        if (ref.length() > 0) {
            dataModel.setAction("*R");
        } else {
            dataModel.setAction("");
        }
    }

    protected String getReference() {
        FunctionModel dataModel = ((FunctionWizard)this.getWizard()).getDataModel();
        StringBuilder ref = new StringBuilder(this._segmentCode.getText().toUpperCase().trim());
        String accessType = "";
        if (this._accessTypeButton.getSelection() && this.selection != null) {
            AccessTypeFunction atf = (AccessTypeFunction)this.selection.getFirstElement();
            accessType = atf.getAccesType();
        } else if (dataModel.isMacro() && this._paramAccessTypeButton.getSelection()) {
            accessType = this._accessTypeParameter.getText().toUpperCase().trim();
        }
        if (accessType.length() > 0) {
            ref.append(" ").append(accessType);
        }
        return ref.toString();
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.initFunctionDatasFromModel();
        }
        super.setVisible(visible);
    }
}

