/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.preferences;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class PdpColorDialog {
    private Point point;
    private Image image;
    private RGB colorValue;
    private Color color;
    private Button button;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public PdpColorDialog(Composite parent, final String label) {
        this.button = new Button(parent, 8);
        this.point = this.computeImageSize((Control)parent);
        this.image = new Image((Device)parent.getDisplay(), this.point.x, this.point.y);
        GC gc = new GC((Drawable)this.image);
        gc.setBackground(this.button.getBackground());
        gc.fillRectangle(0, 0, this.point.x, this.point.y);
        gc.dispose();
        this.button.setImage(this.image);
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ColorDialog colorDialog = new ColorDialog(PdpColorDialog.this.button.getShell());
                colorDialog.setRGB(PdpColorDialog.this.colorValue);
                RGB newColor = colorDialog.open();
                if (newColor != null) {
                    PdpColorDialog.this.colorValue = newColor;
                    PdpColorDialog.this.updateColorImage();
                }
            }
        });
        this.button.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = label;
            }
        });
        this.button.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                if (PdpColorDialog.this.image != null) {
                    PdpColorDialog.this.image.dispose();
                    PdpColorDialog.this.image = null;
                }
                if (PdpColorDialog.this.color != null) {
                    PdpColorDialog.this.color.dispose();
                    PdpColorDialog.this.color = null;
                }
            }
        });
    }

    public RGB getColorValue() {
        return this.colorValue;
    }

    public void setColorValue(RGB rgb) {
        this.colorValue = rgb;
        this.updateColorImage();
    }

    public Button getButton() {
        return this.button;
    }

    protected void updateColorImage() {
        Display display = this.button.getDisplay();
        GC gc = new GC((Drawable)this.image);
        gc.setForeground(display.getSystemColor(2));
        gc.drawRectangle(0, 2, this.point.x - 1, this.point.y - 4);
        if (this.color != null) {
            this.color.dispose();
        }
        this.color = new Color((Device)display, this.colorValue);
        gc.setBackground(this.color);
        gc.fillRectangle(1, 3, this.point.x - 2, this.point.y - 5);
        gc.dispose();
        this.button.setImage(this.image);
    }

    protected Point computeImageSize(Control window) {
        GC gc = new GC((Drawable)window);
        Font f = JFaceResources.getFontRegistry().get("org.eclipse.jface.defaultfont");
        gc.setFont(f);
        int height = gc.getFontMetrics().getHeight();
        gc.dispose();
        Point p = new Point(height * 3 - 6, height);
        return p;
    }
}

