/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.generator.compare;

import com.ibm.pdp.engine.IProblem;
import com.ibm.pdp.engine.internal.ITextProcessor;
import com.ibm.pdp.engine.turbo.reconcile.ReconcileProblem;
import com.ibm.pdp.explorer.editor.PTFlatEditor;
import com.ibm.pdp.explorer.editor.service.PTEditorService;
import com.ibm.pdp.explorer.model.service.PTModelService;
import com.ibm.pdp.framework.ControllerFactory;
import com.ibm.pdp.framework.GenerationManager;
import com.ibm.pdp.framework.PdpTool;
import com.ibm.pdp.framework.interfaces.IController;
import com.ibm.pdp.framework.interfaces.IEditor;
import com.ibm.pdp.framework.interfaces.IGenResult;
import com.ibm.pdp.framework.interfaces.IGenStatus;
import com.ibm.pdp.framework.interfaces.IPattern;
import com.ibm.pdp.framework.interfaces.IStatusMessage;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.kernel.editor.page.extension.IPTFlatPageActionContribution;
import com.ibm.pdp.pacbase.PacTool;
import com.ibm.pdp.pacbase.generator.compare.GenerateCompareEditorInput;
import com.ibm.pdp.pacbase.generator.compare.Messages;
import com.ibm.pdp.resources.PdpResourcesMgr;
import com.ibm.pdp.util.Util;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.internal.ICompareUIConstants;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class GenerateAndCompare
implements IPTFlatPageActionContribution {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2016, 2020.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private RadicalEntity currentEntity = null;
    private String _name;

    public void initialize(RadicalEntity re) {
        this.currentEntity = re;
    }

    private void displayError(String message) {
        Shell parent = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        MessageDialog.openError((Shell)parent, (String)Messages.GENERATION_FAILED, (String)message);
        PdpTool.openErrorLog();
    }

    public boolean isValidFor(RadicalEntity currentEntity) {
        this.currentEntity = currentEntity;
        IPattern pattern = PacTool.GetPatternFor(currentEntity);
        if (pattern == null) {
            this.displayError(Messages.PREVIOUS_COBOL_ABSENT_OR_NOT_COBOL);
            return false;
        }
        IEditorReference[] allEditors = PdpTool.findAllOpenedEditors();
        if (allEditors.length != 1 && this.countRppEditors(allEditors) > 1) {
            Object[] params = new String[]{currentEntity.getIdentifier()};
            String nl1String = NLS.bind((String)Messages.MULTIPLE_EDITORS_OPEN, (Object[])params);
            this.displayError(nl1String);
            return false;
        }
        String designId = currentEntity.getDesignId(currentEntity.getProject());
        List super_refs = GenerationManager.getGenerationOutputsFromSuperRef((String)designId, (IPattern)pattern);
        if (super_refs == null) {
            return false;
        }
        IController sourceController = null;
        for (GenerationManager.SuperRef superRef : super_refs) {
            String uri = PdpResourcesMgr.getURIFromGeneratedDocument((String)superRef.getDocumentId());
            ControllerFactory factory = (ControllerFactory)ControllerFactory.getInstance();
            sourceController = factory.getController(designId, pattern.getName(), uri);
        }
        if (PacTool.isDephasedEntity(sourceController)) {
            this.displayError(Messages.DESYNCHONIZED_FILE);
            return false;
        }
        if (PacTool.isEntityWithMigrationWarnings(sourceController)) {
            this.displayError(Messages.MIGRATION_WARNINGS_PRESENT);
            return false;
        }
        return true;
    }

    private int countRppEditors(IEditorReference[] allEditors) {
        int count = 0;
        int i = 0;
        while (i < allEditors.length) {
            IEditorReference editor = allEditors[i];
            IEditorPart edPart = editor.getEditor(true);
            if (edPart instanceof PTFlatEditor) {
                PTFlatEditor cfr_ignored_0 = (PTFlatEditor)edPart;
                ++count;
            } else if (edPart.getClass().getName().equals("com.ibm.pdp.pdpeditor.editor.PdpCobolEditor2") && ((IEditor)edPart).getController().getDesignLink().getModelRoot() == this.currentEntity) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public void run() {
        IPattern pattern = PacTool.GetPatternFor(this.currentEntity);
        String designId = this.currentEntity.getDesignId(this.currentEntity.getProject());
        List super_refs = GenerationManager.getGenerationOutputsFromSuperRef((String)designId, (IPattern)pattern);
        IController cblSourceController = null;
        IController cblDuplicatedController = null;
        ArrayList<IController> controllers = null;
        RadicalEntity sharedInstance = null;
        IPath path = PTModelService.getPath((String)designId);
        sharedInstance = PTEditorService.getSharedResource((IPath)path);
        for (GenerationManager.SuperRef superRef : super_refs) {
            IController duplicatedController;
            com.ibm.pdp.engine.ITextProcessor tp;
            String uri = PdpResourcesMgr.getURIFromGeneratedDocument((String)superRef.getDocumentId());
            ControllerFactory factory = (ControllerFactory)ControllerFactory.getInstance();
            IController sourceController = factory.getController(designId, pattern.getName(), uri);
            if (controllers == null) {
                controllers = new ArrayList<IController>();
            }
            if ((tp = (duplicatedController = factory.createDuplicatedControllerFrom(sourceController)).getTextProcessor()) instanceof ITextProcessor) {
                ((ITextProcessor)tp).getGlobalContext().put("generation_mode", "from_wizard");
            }
            controllers.add(duplicatedController);
            if (!uri.endsWith(".cbl")) continue;
            cblDuplicatedController = duplicatedController;
            cblSourceController = sourceController;
        }
        if (cblDuplicatedController == null) {
            this.displayError(Messages.PREVIOUS_COBOL_ABSENT_OR_NOT_COBOL);
            return;
        }
        if (!this.generate(sharedInstance, pattern, controllers)) {
            return;
        }
        CompareConfiguration compConf = new CompareConfiguration(){

            public String getLeftLabel(Object element) {
                return Messages.GenerateAndCompare_Memory_code;
            }

            public String getRightLabel(Object element) {
                return Messages.GenerateAndCompare_Local_generated;
            }

            public boolean isRightEditable() {
                return false;
            }

            public boolean isLeftEditable() {
                return true;
            }
        };
        compConf.setProperty(ICompareUIConstants.PROP_IGNORE_ANCESTOR, (Object)new Boolean(true));
        GenerateCompareEditorInput gcei = new GenerateCompareEditorInput(compConf, cblDuplicatedController, cblSourceController, true);
        boolean continu = true;
        while (continu) {
            CompareUI.openCompareDialog((CompareEditorInput)gcei);
            if (!gcei.isValidatedByUser) {
                return;
            }
            boolean bl = continu = !this.generate(sharedInstance, pattern, controllers);
        }
        try {
            this.currentEntity.save();
        }
        catch (IOException e) {
            Util.rethrow((Throwable)e);
        }
        PTEditorService.dirty((IPath)path, (boolean)false);
        GenerateAndCompare.removeReconciliationProblems(cblDuplicatedController.getTextProcessor());
        for (IController duplicatedController : controllers) {
            ((ControllerFactory)ControllerFactory.getInstance()).setUpNewController(duplicatedController);
        }
    }

    private boolean generate(RadicalEntity sharedInstance, IPattern pattern, List<IController> controllers) {
        RunnableWithProgress genProcess = new RunnableWithProgress(sharedInstance, pattern, controllers);
        try {
            if (PlatformUI.isWorkbenchRunning()) {
                IProgressService ips = PlatformUI.getWorkbench().getProgressService();
                ips.run(true, true, (IRunnableWithProgress)genProcess);
            } else {
                genProcess.run((IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (InvocationTargetException e) {
            Util.rethrow((Throwable)e.getCause());
        }
        catch (InterruptedException f) {
            Util.rethrow((Throwable)f);
        }
        IGenStatus genStatus = genProcess.getStatus().getGenStatus();
        if (genStatus != null && genStatus.getState() == 1) {
            Iterator it = genStatus.getMessages();
            StringBuilder sb = new StringBuilder();
            while (it.hasNext()) {
                IStatusMessage message = (IStatusMessage)it.next();
                sb.append(message.getText());
                sb.append("\n");
            }
            Shell parent = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            MessageDialog.openError((Shell)parent, (String)Messages.GENERATION_FAILED, (String)sb.toString());
            PdpTool.openErrorLog();
            return false;
        }
        return true;
    }

    public static void removeReconciliationProblems(com.ibm.pdp.engine.ITextProcessor textProcessor) {
        GenerationManager.removeReconciliationProblems((com.ibm.pdp.engine.ITextProcessor)textProcessor);
        Iterator problems = textProcessor.problems();
        ArrayList<IProblem> problemsToRemove = new ArrayList<IProblem>();
        while (problems.hasNext()) {
            IProblem aPb = (IProblem)problems.next();
            if (!(aPb instanceof ReconcileProblem)) continue;
            problemsToRemove.add(aPb);
        }
        int i = 0;
        while (i < problemsToRemove.size()) {
            IProblem aPb = (IProblem)problemsToRemove.get(i);
            aPb.remove();
            ++i;
        }
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void initialize(IEditorInput editorInput, String name) {
    }

    private static class RunnableWithProgress
    implements IRunnableWithProgress {
        private IGenResult _result;
        private Object _design;
        private IPattern _pattern;
        private List<IController> _controllers;

        public RunnableWithProgress(RadicalEntity design, IPattern pattern, List<IController> controllers) {
            this._design = design;
            this._pattern = pattern;
            this._controllers = controllers;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            if (this._controllers != null && !this._controllers.isEmpty()) {
                this._result = GenerationManager.generate(this._controllers, (Object)this._design, (IPattern)this._pattern, (IProgressMonitor)monitor, null);
            }
            this._design = null;
        }

        public IGenResult getStatus() {
            return this._result;
        }
    }
}

