/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.generator.compare;

import com.ibm.pdp.framework.interfaces.IController;
import com.ibm.pdp.pacbase.generator.compare.GenerateCompareEditorInput;
import com.ibm.pdp.pacbase.generator.compare.Messages;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.internal.ICompareUIConstants;
import org.eclipse.swt.widgets.Display;

public class ComparatorForGeneration {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2018.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private CompareConfiguration compConf = null;
    private boolean _leftEditable = false;
    private boolean _rightEditable = false;

    public ComparatorForGeneration(boolean leftEditable, boolean rightEditable) {
        this._leftEditable = leftEditable;
        this._rightEditable = rightEditable;
        this.initialize();
    }

    private void initialize() {
        this.compConf = new CompareConfiguration(){

            public String getLeftLabel(Object element) {
                return Messages.GenerateAndCompare_Memory_code;
            }

            public String getRightLabel(Object element) {
                return Messages.GenerateAndCompare_Local_generated;
            }

            public boolean isRightEditable() {
                return ComparatorForGeneration.this._rightEditable;
            }

            public boolean isLeftEditable() {
                return ComparatorForGeneration.this._leftEditable;
            }
        };
        this.compConf.setProperty(ICompareUIConstants.PROP_IGNORE_ANCESTOR, (Object)new Boolean(true));
    }

    public boolean showCompareTool(IController originalController, IController duplicatedController) {
        final GenerateCompareEditorInput gcei = new GenerateCompareEditorInput(this.compConf, duplicatedController, originalController, true);
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                CompareUI.openCompareDialog((CompareEditorInput)gcei);
            }
        });
        return gcei.isValidatedByUser;
    }
}

