/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.generator;

import com.ibm.pdp.engine.IBuilderTag;
import com.ibm.pdp.engine.IBuilderTree;
import com.ibm.pdp.engine.IGenInfoBuilder;
import com.ibm.pdp.engine.IGeneratedInfo;
import com.ibm.pdp.framework.PdpTool;
import com.ibm.pdp.pacbase.extension.organize.IVirtualFunction;
import com.ibm.pdp.pacbase.extension.organize.Location;
import com.ibm.pdp.pacbase.generate.util.NodeInformations;
import com.ibm.pdp.pacbase.generate.util.NodeTagInformations;
import com.ibm.pdp.pacbase.util.EBCDICCompare;
import com.ibm.pdp.util.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.StringTokenizer;

public class VirtualMacroCleaner {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2016, 2025.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String DEFAULT_NAME = "ZZZZZZZZZZZZ";
    public static final String MSPVIRT = "MSPVIRT";
    public static final String VIRTUAL_MACRO_DELETE_TAGS_PROPERTY = "MSPVIRT_DELETE_TAGS";
    public static final String VIRTUAL_MACRO_DASH_900_INSERT_PROPERTY = "MSPVIRT_DASH_900_TO_INSERT";
    public static final String VIRTUAL_MACRO_DASH_900_DELETE_PROPERTY = "MSPVIRT_DASH_900_TO_DELETE";
    public static final String VIRTUAL_MACRO_TAGS_WITH_NTI_PROPERTY = "MSPVIRT_TAGS_WITH_NTI_PROP";
    private List<NodeInformations> ntiList;
    private List<String> mspVirtTagsToDelete;
    private List<String> tagsWithNTIprop;
    private List<String> tagsToCleanAtEnd;
    private List<String> dash900ToInsert;
    private List<String> dash900ToReplace;
    private List<String> oldDash900toRemove;
    private static Comparator<NodeInformations> CompareNTI = null;
    private String generatedEntityCode;
    private String patternName;
    private List<String> subFctToRestoreInOldGenInfo;
    private List<String> allFunctionsOverridenInSpecific;
    private List<String> allArtificialCreateSubFunctions;
    String allSUPfunctions;

    public VirtualMacroCleaner(String entity, String pattern) {
        VirtualMacroCleaner.InstanciateCompareNTI();
        this.ntiList = new ArrayList<NodeInformations>();
        this.mspVirtTagsToDelete = new ArrayList<String>();
        this.dash900ToInsert = new ArrayList<String>();
        this.tagsWithNTIprop = new ArrayList<String>();
        this.subFctToRestoreInOldGenInfo = new ArrayList<String>();
        this.allFunctionsOverridenInSpecific = new ArrayList<String>();
        this.allArtificialCreateSubFunctions = new ArrayList<String>();
        this.tagsToCleanAtEnd = new ArrayList<String>();
        this.generatedEntityCode = entity;
        this.patternName = pattern;
    }

    public IGeneratedInfo clean(IGeneratedInfo gi) {
        IGenInfoBuilder gib = gi.toGeneratedInfoBuilder();
        this.cleanCommaInWSSContinuation(gib);
        this.cleanDash900infos(gib);
        this.modifyMSPVIRTtags(gib);
        IBuilderTag tag = gib.tagFromName("PROCEDURE");
        if (tag != null) {
            this.cleanMSPVirtTagsFrom(tag);
        }
        this.tagFirstTextInArtificialCreate(gib, false);
        this.specialCleaning(gib);
        this.mergeDash900(gib);
        VirtualMacroCleaner.restoreDeletedSubFunctions(gib, this.ntiList, this.generatedEntityCode, false);
        if (this.dash900ToInsert.size() > 0) {
            gib.setProperty(VIRTUAL_MACRO_DASH_900_INSERT_PROPERTY, VirtualMacroCleaner.FromListToString(this.dash900ToInsert, '/'));
        }
        if (this.oldDash900toRemove.size() > 0) {
            gib.setProperty(VIRTUAL_MACRO_DASH_900_DELETE_PROPERTY, VirtualMacroCleaner.FromListToString(this.oldDash900toRemove, '/'));
        }
        if (this.mspVirtTagsToDelete.size() > 0) {
            gib.setProperty(VIRTUAL_MACRO_DELETE_TAGS_PROPERTY, VirtualMacroCleaner.FromListToString(this.mspVirtTagsToDelete, ' '));
        }
        if (this.tagsWithNTIprop.size() > 0) {
            gib.setProperty(VIRTUAL_MACRO_TAGS_WITH_NTI_PROPERTY, VirtualMacroCleaner.FromListToString(this.tagsWithNTIprop, '/'));
        }
        this.tagFirstTextInArtificialCreate(gib, true);
        this.cleanSUPFunctions(gib);
        return gib.toGeneratedInfo();
    }

    private void cleanCommaInWSSContinuation(IGenInfoBuilder gib) {
        if (gib == null) {
            return;
        }
        IBuilderTag tag_wss_continuation = gib.tagFromName("WSS-CONTINUATION");
        if (tag_wss_continuation == null) {
            return;
        }
        if (!tag_wss_continuation.hasSon()) {
            return;
        }
        String textToModify = tag_wss_continuation.lastSon().getTextAfter().toString();
        if (textToModify.length() == 0) {
            return;
        }
        String newLine = PdpTool.determineDelimiterOfV2((CharSequence)textToModify);
        String[] allLines = textToModify.split(newLine);
        StringBuilder result = new StringBuilder();
        String[] stringArray = allLines;
        int n = allLines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (!line.startsWith("                             ,               ") && !line.startsWith("                             ,.              ")) {
                result.append(line).append(newLine);
            }
            ++n2;
        }
        gib.tagFromName("WSS-CONTINUATION").lastSon().setTextAfter((CharSequence)result);
    }

    private void cleanSUPFunctions(IGenInfoBuilder gib) {
        StringTokenizer st = new StringTokenizer(this.allSUPfunctions);
        while (st.hasMoreTokens()) {
            IBuilderTag tag;
            String s = st.nextToken();
            if (s.length() == 3 || (tag = gib.tagFromName(s)) == null || tag.getLength() != 0) continue;
            gib.removeTag(tag);
            this.allSUPfunctions = this.allSUPfunctions.replaceFirst(s, "");
        }
    }

    private IBuilderTag searchTag(IGenInfoBuilder gib, String tagName) {
        IBuilderTag result = gib.tagFromName(tagName);
        if (result == null && tagName.startsWith("N")) {
            result = gib.tagFromName(String.valueOf(tagName) + "000");
        }
        return result;
    }

    public void modifyMSPVIRTtags(IGenInfoBuilder gib) {
        boolean lastLoopWithModification = true;
        while (lastLoopWithModification) {
            Iterator<NodeInformations> itn = this.ntiList.iterator();
            ArrayList<NodeInformations> toRemove = new ArrayList<NodeInformations>();
            while (itn.hasNext()) {
                IBuilderTag tag;
                IBuilderTag parentTag;
                NodeInformations currentNTI = itn.next();
                if (currentNTI instanceof NodeTagInformations) {
                    String entityCode;
                    String propName;
                    NodeTagInformations nti = (NodeTagInformations)currentNTI;
                    IBuilderTag tag2 = this.searchTag(gib, nti.getTagName());
                    if (tag2 == null) continue;
                    Iterator itp = tag2.propertyNames();
                    while (itp.hasNext()) {
                        propName = (String)itp.next();
                        if (this.isPropertyToKeep(propName)) continue;
                        tag2.setProperty(propName, null);
                    }
                    itp = nti.properties();
                    while (itp.hasNext()) {
                        propName = (String)itp.next();
                        if (!propName.equals("msp") && tag2.getProperty(propName) != null) {
                            tag2.setProperty("NTI_" + propName, nti.getProperty(propName));
                            if (this.tagsWithNTIprop.contains(tag2.getName())) continue;
                            this.tagsWithNTIprop.add(tag2.getName());
                            continue;
                        }
                        tag2.setProperty(propName, nti.getProperty(propName));
                    }
                    if (MSPVIRT.equals(tag2.getProperty("msp"))) {
                        tag2.setProperty("msp", null);
                    }
                    String text = nti.getText();
                    if (tag2.hasSon()) {
                        entityCode = this.generatedEntityCode;
                        if (nti.getProperty("msp") != null) {
                            entityCode = nti.getProperty("msp");
                        }
                        if (entityCode != null && text.length() > 0) {
                            text = VirtualMacroCleaner.AppendMacroCode(text, entityCode);
                        }
                        tag2 = tag2.firstSon();
                        tag2.setTextBefore((CharSequence)text);
                        toRemove.add(currentNTI);
                        continue;
                    }
                    if (tag2.getName().startsWith("N")) {
                        entityCode = this.generatedEntityCode;
                        if (tag2.getProperty("msp") != null) {
                            entityCode = tag2.getProperty("msp");
                        } else {
                            String name = tag2.getName();
                            String endName = name.substring(name.length() - 3);
                            if (Character.isDigit(endName.charAt(0)) && Character.isDigit(endName.charAt(1)) && Character.isDigit(endName.charAt(2))) {
                                String newName = name.substring(0, name.length() - 3);
                                tag2 = gib.addTag(tag2.getBeginIndex(), tag2.getEndIndex(), newName, name);
                                gib.removeTag(name);
                            }
                        }
                        text = VirtualMacroCleaner.AppendMacroCode(text, entityCode);
                    } else if (text.charAt(7) == 'F') {
                        String textNT;
                        IBuilderTag nextTag;
                        IBuilderTag parent = tag2.getParent();
                        String prop = parent.getProperty("NTI_level");
                        if (prop == null) {
                            prop = parent.getProperty("level");
                        }
                        if (prop != null) {
                            text = VirtualMacroCleaner.AppendLevel(text, "lv" + prop, false);
                        }
                        String entityCode2 = this.generatedEntityCode;
                        if (tag2.getProperty("msp") != null) {
                            entityCode2 = tag2.getProperty("msp");
                        }
                        text = VirtualMacroCleaner.AppendMacroCode(text, entityCode2);
                        if (this.allSUPfunctions.indexOf(parent.getName()) == -1 && (nextTag = tag2.nextTag()) != null && (textNT = nextTag.getText().toString()).length() > 11 && "*!CO".equals(textNT.substring(6, 10))) {
                            nextTag.setText((CharSequence)"");
                        }
                    }
                    toRemove.add(currentNTI);
                    tag2.setText((CharSequence)text);
                    continue;
                }
                NodeInformations ni = currentNTI;
                String entityCode = this.generatedEntityCode;
                if (ni.getNodeTagEnclosing() != null && (parentTag = gib.tagFromName(ni.getNodeTagEnclosing())) != null && parentTag.getProperty("msp") != null) {
                    entityCode = parentTag.getProperty("msp");
                }
                if (ni.getNodeTagBefore() != null) {
                    tag = gib.tagFromName(ni.getNodeTagBefore());
                    if (tag == null) continue;
                    tag.setTextAfter((CharSequence)VirtualMacroCleaner.AppendMacroCode(ni.getText(), entityCode));
                    toRemove.add(currentNTI);
                    continue;
                }
                if (ni.getNodeTagAfter() == null || (tag = gib.tagFromName(ni.getNodeTagAfter())) == null) continue;
                tag.setTextBefore((CharSequence)VirtualMacroCleaner.AppendMacroCode(ni.getText(), entityCode));
                toRemove.add(currentNTI);
            }
            lastLoopWithModification = !toRemove.isEmpty();
            this.ntiList.removeAll(toRemove);
        }
    }

    private void specialCleaning(IGenInfoBuilder gib) {
        if (this.patternName.equals("com.ibm.pdp.pacbase.batch")) {
            this.fnCleaningForSpecialFunction(gib, "F05");
            this.fnCleaningForSpecialFunction(gib, "F9099");
        }
        for (String fct : this.tagsToCleanAtEnd) {
            gib.removeTag(fct);
        }
    }

    private void fnCleaningForSpecialFunction(IGenInfoBuilder gib, String fct) {
        StringBuilder text;
        int index;
        IBuilderTag parent = gib.tagFromName(fct);
        if (parent != null && !parent.hasSon() && (index = (text = new StringBuilder(parent.getText())).indexOf("       " + fct + "-FN.")) != -1) {
            parent.setText(text.subSequence(0, index));
        }
    }

    private void addToDeletedTags(IBuilderTag tag) {
        if ("true".equals(tag.getProperty("functionOverridedBySpecific"))) {
            this.allFunctionsOverridenInSpecific.add(tag.getName());
            return;
        }
        this.mspVirtTagsToDelete.add(tag.getName());
    }

    private void cleanMSPVirtTagsFrom(IBuilderTag tag) {
        if (tag.hasSon()) {
            IBuilderTag currentTag = tag.firstSon();
            while (currentTag != null) {
                IBuilderTag tagToDelete = currentTag;
                currentTag = tagToDelete.nextTag();
                this.cleanMSPVirtTagsFrom(tagToDelete);
            }
        }
        if (MSPVIRT.equals(tag.getProperty("msp"))) {
            if (!tag.hasSon()) {
                if (tag.getProperty("level") != null) {
                    tag.setText((CharSequence)"");
                    Iterator itp = tag.propertyNames();
                    while (itp.hasNext()) {
                        String prop = (String)itp.next();
                        if (this.isPropertyToKeep(prop)) continue;
                        tag.setProperty(prop, null);
                    }
                    this.addToDeletedTags(tag);
                    tag.setProperty("specificSubFunction", "true");
                    tag.setProperty("msp", null);
                } else {
                    if (tag.getName().endsWith("-900")) {
                        this.dash900ToInsert.add(tag.getText().toString());
                    }
                    tag.getGenInfoBuilder().removeTagAndText(tag);
                }
            } else {
                boolean tagFct;
                boolean bl = tagFct = tag.getProperty("level") != null;
                if (tagFct && this.isFunctionReallyVirt(tag)) {
                    int index = tag.getBeginIndex();
                    IBuilderTag tmpTag = tag.firstSon();
                    while (tmpTag != null) {
                        if (index < tmpTag.getBeginIndex()) {
                            tmpTag.setTextBefore((CharSequence)"");
                        }
                        tmpTag = tmpTag.nextTag();
                    }
                    index = tag.getEndIndex();
                    if (index > (tmpTag = tag.lastSon()).getEndIndex()) {
                        tmpTag.setTextAfter((CharSequence)"");
                    }
                }
                if (!tagFct) {
                    tag.getGenInfoBuilder().removeTag(tag);
                } else {
                    IBuilderTag tmpTag = tag.firstSon();
                    tmpTag.setTextBefore((CharSequence)"");
                    tmpTag = tag.lastSon();
                    tmpTag.setTextAfter((CharSequence)"");
                    Iterator itp = tag.propertyNames();
                    while (itp.hasNext()) {
                        String prop = (String)itp.next();
                        if (this.isPropertyToKeep(prop)) continue;
                        tag.setProperty(prop, null);
                    }
                    this.addToDeletedTags(tag);
                    tag.setProperty("specificSubFunction", "true");
                    tag.setProperty("msp", null);
                }
            }
        }
    }

    private boolean isFunctionReallyVirt(IBuilderTag tag) {
        if ("com.ibm.pdp.pacbase.dialog".equals(this.patternName)) {
            String fctName = tag.getName();
            return !"F05".equals(fctName) && !"F50".equals(fctName);
        }
        return true;
    }

    private boolean isPropertyToKeep(String property) {
        if ("level".equals(property) || "msp".equals(property) || "functionOverridedBySpecific".equals(property)) {
            return true;
        }
        if (!"com.ibm.pdp.pacbase.batch".equals(this.patternName)) {
            if ("ref".equals(property) || "categ".equals(property) || "refInPgm".equals(property) || "action".equals(property)) {
                return true;
            }
            if ("com.ibm.pdp.pacbase.csserver".equals(this.patternName) && "LogicalView".equals(property)) {
                return true;
            }
        }
        return false;
    }

    private String computeTagName(IBuilderTag firstSonTag) {
        String tagName = firstSonTag.getName();
        String sort = firstSonTag.getProperty("sort");
        if (sort != null && sort.trim().length() > 0) {
            String numberLine = sort.substring(6);
            if (numberLine.trim().indexOf("  ") != -1) {
                return tagName.substring(0, tagName.length() - 1);
            }
            if (numberLine.trim().indexOf(" ") != -1) {
                return tagName.substring(0, tagName.length() - 2);
            }
        }
        return tagName.substring(0, tagName.length() - 3);
    }

    public void tagFirstTextInArtificialCreate(IGenInfoBuilder gib, boolean secondAttempt) {
        IBuilderTag tag = gib.tagFromName("PROCEDURE");
        ArrayList<String> tagNames = new ArrayList<String>();
        Object currentTag = tag;
        Stack<IBuilderTag> stackTags = new Stack<IBuilderTag>();
        while (currentTag != null) {
            if (currentTag.nextTag() != null) {
                stackTags.push(currentTag.nextTag());
            }
            if (currentTag.getProperty("level") != null && "artificialCreate".equals(currentTag.getProperty("msp"))) {
                tagNames.add(currentTag.getName());
            }
            currentTag = currentTag.hasSon() ? currentTag.firstSon() : (!stackTags.isEmpty() ? (IBuilderTag)stackTags.pop() : null);
        }
        Iterator ittn = tagNames.iterator();
        while (ittn.hasNext()) {
            String tagName;
            IBuilderTag firstSonTag;
            currentTag = gib.tagFromName((String)ittn.next());
            if (currentTag.getProperty("bC") != null) {
                this.subFctToRestoreInOldGenInfo.add(currentTag.getName());
            }
            if ((firstSonTag = currentTag.firstSon()) == null) continue;
            String text = firstSonTag.getText().toString();
            boolean changeTag = false;
            changeTag = text.length() > 6 ? (text.length() > 72 ? text.substring(6, 72).trim().length() == 0 : text.substring(6).trim().length() == 0) : true;
            if (changeTag) {
                firstSonTag = firstSonTag.nextTag();
            }
            if ((tagName = this.computeTagName(firstSonTag)).equals(currentTag.getName())) {
                tagName = String.valueOf(firstSonTag.getName()) + "_Label";
            }
            if (currentTag.getBeginIndex() != firstSonTag.getBeginIndex()) {
                IBuilderTag newTag = gib.addTag(currentTag.getBeginIndex(), firstSonTag.getBeginIndex(), tagName, currentTag.getName());
                String newLevel = currentTag.getProperty("NTI_level");
                if (newLevel == null) {
                    newLevel = currentTag.getProperty("level");
                }
                if (newLevel == null) {
                    newLevel = "10";
                    if (currentTag.getName().length() == 3) {
                        newLevel = "05";
                    }
                    currentTag.setProperty("level", newLevel);
                }
                newTag.setProperty("msp", "artificialCreate");
                newTag.setText((CharSequence)"");
                gib.removeTagAndText(newTag);
                currentTag.lastSon().setTextAfter((CharSequence)"");
                this.allArtificialCreateSubFunctions.add(currentTag.getName());
                continue;
            }
            if (!secondAttempt) continue;
            String newLevel = currentTag.getProperty("NTI_level");
            if (newLevel == null) {
                newLevel = currentTag.getProperty("level");
            }
            if (newLevel != null) continue;
            newLevel = "10";
            if (currentTag.getName().length() == 3) {
                newLevel = "05";
            }
            currentTag.setProperty("level", newLevel);
        }
    }

    public void setInformations(List<NodeInformations> infos) {
        Collections.sort(infos, CompareNTI);
        this.ntiList = infos;
    }

    private void cleanDash900infos(IGenInfoBuilder gib) {
        Iterator<String> it900 = this.oldDash900toRemove.iterator();
        ArrayList<String> listToRemove = new ArrayList<String>();
        while (it900.hasNext()) {
            String levFN;
            String dash900 = it900.next();
            String tmpS = dash900.trim();
            if (!tmpS.endsWith("-FN.")) continue;
            tmpS = tmpS.substring(0, tmpS.length() - 4);
            int index = tmpS.indexOf("-900");
            String dash900fct = tmpS.substring(0, index);
            index = tmpS.lastIndexOf(" ");
            if (index == -1) continue;
            String fnFct = tmpS.substring(index + 1);
            IBuilderTag tag900 = gib.tagFromName(dash900fct);
            if (tag900 == null) continue;
            String lev900 = tag900.getProperty("level");
            IBuilderTag tagFN = gib.tagFromName(fnFct);
            if (tagFN == null || lev900.compareTo(levFN = tagFN.getProperty("level")) <= 0) continue;
            IBuilderTag tmpTag = tag900;
            while (tmpTag != null && tmpTag != tagFN) {
                tmpTag = tmpTag.getParent();
            }
            if (tmpTag != tagFN) continue;
            listToRemove.add(dash900);
        }
        this.oldDash900toRemove.removeAll(listToRemove);
    }

    public void setDash900List(List<String> l) {
        this.oldDash900toRemove = l;
    }

    private void mergeDash900(IGenInfoBuilder gib) {
        this.oldDash900toRemove.removeAll(this.dash900ToInsert);
        if (!this.oldDash900toRemove.isEmpty()) {
            String text = gib.getText().toString();
            ArrayList<String> toDelete = new ArrayList<String>();
            for (String dash900 : this.oldDash900toRemove) {
                if (text.indexOf(dash900) == -1) continue;
                toDelete.add(dash900);
            }
            this.oldDash900toRemove.removeAll(toDelete);
            if (toDelete != null || toDelete.isEmpty()) {
                this.dash900ToReplace = new ArrayList<String>();
                for (String dash900 : toDelete) {
                    dash900 = dash900.trim();
                    dash900 = dash900.substring(0, dash900.indexOf(" ") - 1);
                    this.dash900ToReplace.add(dash900);
                }
            }
        }
    }

    public List<String> getDash900toReplaceInOld() {
        if (this.dash900ToReplace == null || this.dash900ToReplace.isEmpty()) {
            return Collections.emptyList();
        }
        return this.dash900ToReplace;
    }

    /*
     * Unable to fully structure code
     */
    private static IBuilderTag AddSpecialTag(IGenInfoBuilder gib, int beginIndex, int endIndex, String tagName, String parentName, boolean restoreOldGenInfo) {
        block7: {
            block8: {
                block9: {
                    if (beginIndex != endIndex) {
                        return gib.addTag(beginIndex, endIndex, tagName, parentName);
                    }
                    tag = gib.tagFromName(parentName);
                    if (tag.getBeginIndex() > beginIndex || gib.tagFromName(parentName).getEndIndex() < endIndex) {
                        tag = gib.includingTag(beginIndex, endIndex);
                    }
                    if (tag == null || !tag.getName().equals(parentName)) break block7;
                    if (!tag.hasSon()) {
                        return gib.addTag(beginIndex, endIndex, tagName, parentName);
                    }
                    if (!restoreOldGenInfo) break block8;
                    tag = tag.firstSon();
                    while (tag != null && tag.getBeginIndex() < beginIndex) {
                        tag = tag.nextTag();
                    }
                    if (tag == null) break block9;
                    if (tag.getBeginIndex() == tag.getEndIndex() && tag.getBeginIndex() == beginIndex) {
                        return gib.addTagBefore(tagName, tag.getName());
                    }
                    break block7;
                }
                return gib.addTag(beginIndex, endIndex, tagName, parentName);
            }
            tag = tag.firstSon();
            while (tag.getBeginIndex() <= beginIndex && tag.nextTag() != null) {
                tag = tag.nextTag();
            }
            if (tag.getEndIndex() >= beginIndex) ** GOTO lbl28
            return gib.addTag(beginIndex, endIndex, tagName, parentName);
lbl-1000:
            // 1 sources

            {
                tag = tag.lastSon();
lbl28:
                // 2 sources

                ** while (tag.hasSon())
            }
lbl29:
            // 1 sources

            return gib.addTag(beginIndex, endIndex, tagName, tag.getName());
        }
        return null;
    }

    private static IBuilderTag AddEnglobingTag(NodeTagInformations nti, IGenInfoBuilder gib) {
        int begIndex = gib.tagFromName(nti.getFirstEnglobingTagName()).getBeginIndex();
        int endIndex = gib.tagFromName(nti.getLastEnglobingTagName()).getEndIndex();
        return gib.addTag(begIndex, endIndex, nti.getTagName(), nti.getNodeTagEnclosing());
    }

    public static void restoreDeletedSubFunctions(IGenInfoBuilder gib, List<NodeInformations> ntiList, String generatedEntityCode, boolean restoreOldGenInfo) {
        ArrayList<NodeTagInformations> dash900toRestore = new ArrayList<NodeTagInformations>();
        ArrayList<NodeInformations> ntiAtEnd = new ArrayList<NodeInformations>();
        boolean lastLoopWithModification = true;
        VirtualMacroCleaner.InstanciateCompareNTI();
        Collections.sort(ntiList, CompareNTI);
        while (!ntiList.isEmpty()) {
            ArrayList<Object> toDelete = new ArrayList<Object>();
            for (NodeInformations currentNTI : ntiList) {
                if (currentNTI instanceof NodeTagInformations) {
                    int index;
                    NodeTagInformations nti = (NodeTagInformations)currentNTI;
                    IBuilderTag enclosing = gib.tagFromName(nti.getNodeTagEnclosing());
                    if (nti.getTagName().startsWith("J")) {
                        VirtualMacroCleaner.Modify_J_NTI_ifNeeded(nti, gib);
                    }
                    if (enclosing == null) {
                        if (nti.getNodeTagAfter() != null || nti.getNodeTagBefore() != null || nti.getNodeTagEnclosing() != null) continue;
                        dash900toRestore.add(nti);
                        toDelete.add(nti);
                        continue;
                    }
                    IBuilderTag previous = null;
                    if (nti.getNodeTagBefore() != null) {
                        previous = gib.tagFromName(nti.getNodeTagBefore());
                    }
                    IBuilderTag next = null;
                    if (nti.getNodeTagAfter() != null) {
                        next = gib.tagFromName(nti.getNodeTagAfter());
                    }
                    IBuilderTag newTag = null;
                    if (previous != null) {
                        if (next != null) {
                            if (previous.nextTag() == next && next.previousTag() == previous) {
                                newTag = previous.getEndIndex() == next.getBeginIndex() ? gib.addTagAfter(nti.getTagName(), previous.getName()) : gib.addTagBefore(nti.getTagName(), next.getName());
                            } else if (nti.getFirstEnglobingTagName() != null && nti.getLastEnglobingTagName() != null) {
                                newTag = VirtualMacroCleaner.AddEnglobingTag(nti, gib);
                            } else {
                                if (lastLoopWithModification) continue;
                                newTag = gib.addTag(previous.getEndIndex(), next.getBeginIndex(), nti.getTagName(), enclosing.getName());
                                VirtualMacroCleaner.VerifyTagPosition(newTag, previous, next);
                            }
                        } else {
                            if (nti.getFirstEnglobingTagName() != null && nti.getLastEnglobingTagName() != null) {
                                newTag = VirtualMacroCleaner.AddEnglobingTag(nti, gib);
                            }
                            if (newTag == null) {
                                newTag = gib.addTagAfter(nti.getTagName(), previous.getName());
                            }
                        }
                    } else if (next != null) {
                        if (nti.getFirstEnglobingTagName() != null && nti.getLastEnglobingTagName() != null) {
                            newTag = VirtualMacroCleaner.AddEnglobingTag(nti, gib);
                        }
                        if (newTag == null) {
                            newTag = gib.addTagBefore(nti.getTagName(), next.getName());
                        }
                    } else if (!enclosing.hasSon() && enclosing.getBeginIndex() == enclosing.getEndIndex()) {
                        newTag = gib.addTag(enclosing.getBeginIndex(), enclosing.getEndIndex(), nti.getTagName(), enclosing.getName());
                    } else if (nti.getFirstEnglobingTagName() != null && nti.getLastEnglobingTagName() != null) {
                        newTag = VirtualMacroCleaner.AddEnglobingTag(nti, gib);
                    } else if (nti.getTextBefore() != null) {
                        int indexAfter;
                        String allText = enclosing.getText().toString();
                        int indexBefore = allText.indexOf(nti.getTextBefore());
                        int begin = enclosing.getBeginIndex();
                        if (indexBefore != -1) {
                            newTag = VirtualMacroCleaner.AddSpecialTag(gib, begin + (indexBefore += nti.getTextBefore().length()), begin + indexBefore, nti.getTagName(), enclosing.getName(), restoreOldGenInfo);
                        } else if (nti.getTextAfter() != null && (indexAfter = allText.indexOf(nti.getTextAfter())) != -1) {
                            newTag = gib.addTag(begin + indexAfter, begin + indexAfter, nti.getTagName(), enclosing.getName());
                        }
                    } else if (nti.getTextAfter() != null) {
                        String allText = enclosing.getText().toString();
                        int indexAfter = allText.indexOf(nti.getTextAfter());
                        int begin = enclosing.getBeginIndex();
                        if (indexAfter != -1) {
                            newTag = gib.addTag(begin + indexAfter, begin + indexAfter, nti.getTagName(), enclosing.getName());
                        }
                    } else if (enclosing.hasSon()) {
                        if (nti.getTagName().startsWith("N")) {
                            newTag = gib.addTagBefore(nti.getTagName(), enclosing.firstSon().getName());
                        }
                    } else if (!lastLoopWithModification && (index = VirtualMacroCleaner.GetFNindexFromText(enclosing.getText().toString())) != -1) {
                        String name = gib.includingTag(index += enclosing.getBeginIndex(), index + 1).getName();
                        newTag = gib.addTag(index, index, nti.getTagName(), name);
                    }
                    if (newTag == null) continue;
                    toDelete.add(nti);
                    Iterator its = nti.properties();
                    String entityCode = generatedEntityCode;
                    while (its.hasNext()) {
                        String prop = (String)its.next();
                        if ("msp".equals(prop)) {
                            entityCode = nti.getProperty(prop);
                        }
                        newTag.setProperty(prop, nti.getProperty(prop));
                    }
                    if (nti.getText() == null || nti.getText().trim().length() <= 0) continue;
                    String text = nti.getText();
                    text = VirtualMacroCleaner.AppendMacroCode(text, entityCode);
                    if (newTag.hasSon()) {
                        newTag.lastSon().setTextAfter((CharSequence)text);
                        continue;
                    }
                    newTag.setText((CharSequence)text);
                    continue;
                }
                ntiAtEnd.add(currentNTI);
                toDelete.add(currentNTI);
            }
            if (!lastLoopWithModification && toDelete.isEmpty()) {
                Util.rethrow((Throwable)new Exception("Error in restore Deleted Sub Function : Can't restore deleted sub function" + ntiList));
            }
            lastLoopWithModification = !toDelete.isEmpty();
            ntiList.removeAll(toDelete);
            if (!ntiList.isEmpty() || dash900toRestore.isEmpty()) continue;
            for (NodeTagInformations nti : dash900toRestore) {
                int index = nti.getTagName().indexOf("-900");
                if (index != -1) {
                    String enclosing = nti.getTagName().substring(0, index);
                    nti.setNodeTagEnclosing(enclosing);
                    nti.setNodeTagBefore(gib.tagFromName(enclosing).lastSon().getName());
                    ntiList.add((NodeInformations)nti);
                    continue;
                }
                Util.rethrow((Throwable)new Exception("Un NodeTagInformations n'a pas \u00e9t\u00e9 replac\u00e9 .. Ce n'est pas un -900" + nti));
            }
            dash900toRestore.clear();
        }
        for (NodeInformations currentNTI : ntiAtEnd) {
            NodeInformations ni = currentNTI;
            IBuilderTag enclosing = gib.tagFromName(ni.getNodeTagEnclosing());
            if (enclosing == null) continue;
            Iterator its = enclosing.propertyNames();
            String entityCode = generatedEntityCode;
            while (its.hasNext()) {
                String prop = (String)its.next();
                if (!"msp".equals(prop)) continue;
                entityCode = enclosing.getProperty(prop);
            }
            String text = ni.getText();
            if (ni.getText() != null && ni.getText().trim().length() > 0) {
                text = VirtualMacroCleaner.AppendMacroCode(text, entityCode);
            }
            if (!enclosing.hasSon() && enclosing.getLength() == 0) {
                enclosing.setText((CharSequence)text);
                continue;
            }
            if (restoreOldGenInfo) {
                if (!enclosing.hasSon()) {
                    enclosing.setText((CharSequence)text);
                    continue;
                }
                if (VirtualMacroCleaner.ContainsOnlyFN(text)) {
                    enclosing.lastSon().setTextAfter((CharSequence)text);
                    continue;
                }
                IBuilderTag currentSon = enclosing.firstSon();
                while (currentSon != null) {
                    if (currentSon.getProperty("mp") == null) break;
                    currentSon = currentSon.nextTag();
                }
                if (currentSon == null) {
                    enclosing.firstSon().setTextBefore((CharSequence)text);
                    continue;
                }
            }
            IBuilderTag previous = null;
            if (ni.getNodeTagBefore() != null) {
                previous = gib.tagFromName(ni.getNodeTagBefore());
            }
            IBuilderTag next = null;
            if (ni.getNodeTagAfter() != null) {
                next = gib.tagFromName(ni.getNodeTagAfter());
            }
            IBuilderTag newTag = null;
            if (previous != null) {
                if (next != null) {
                    if (previous.nextTag() == next && next.previousTag() == previous) {
                        previous.setTextAfter((CharSequence)(String.valueOf(text) + previous.getTextAfter()));
                        continue;
                    }
                    if (lastLoopWithModification) continue;
                    Util.rethrow((Throwable)new Exception("Emplacement impossible !!! lors du restoreDeletedSubFunctions" + ni));
                    continue;
                }
                previous.setTextAfter((CharSequence)(String.valueOf(text) + previous.getTextAfter()));
                continue;
            }
            if (next != null) {
                next.setTextBefore((CharSequence)(next.getTextBefore() + text));
                continue;
            }
            int index = -1;
            if (enclosing.hasSon()) {
                IBuilderTag currentTag = enclosing.firstSon();
                if ("artificialCreate".equals(enclosing.getProperty("msp"))) {
                    index = currentTag.getBeginIndex();
                    newTag = gib.addTag(index, index, "VIRTUALtagTO_DELETE", enclosing.getName());
                } else {
                    String fctCode = enclosing.getName().substring(1);
                    while (currentTag != null && currentTag.getName().substring(1).startsWith(fctCode)) {
                        currentTag = currentTag.nextTag();
                    }
                    if (currentTag != null) {
                        newTag = gib.addTagBefore("VIRTUALtagTO_DELETE", currentTag.getName());
                    }
                }
            } else if (enclosing.getLength() == 0) {
                enclosing.setText((CharSequence)text);
            }
            if (newTag == null) {
                index = VirtualMacroCleaner.GetFNindexFromText(enclosing.getText().toString());
                if (index != -1) {
                    index += enclosing.getBeginIndex();
                }
                if (index != -1) {
                    newTag = gib.addTag(index, index, "VIRTUALtagTO_DELETE", enclosing.getName());
                }
            }
            if (newTag == null) continue;
            newTag.setText((CharSequence)text);
            gib.removeTag(newTag);
        }
    }

    private static void Modify_J_NTI_ifNeeded(NodeTagInformations nti, IGenInfoBuilder gib) {
        String tagName = nti.getNodeTagBefore();
        if (tagName == null) {
            return;
        }
        IBuilderTag previousTag = gib.tagFromName(tagName);
        tagName = nti.getNodeTagAfter();
        if (tagName == null) {
            return;
        }
        IBuilderTag nextTag = gib.tagFromName(tagName);
        if (previousTag.nextTag() == nextTag && nextTag.previousTag() == previousTag) {
            return;
        }
        String currentTagName = nti.getTagName();
        IBuilderTag goodTag = null;
        while (previousTag != null && previousTag != nextTag && EBCDICCompare.stringCompare((String)previousTag.getName(), (String)currentTagName) < 0) {
            goodTag = previousTag;
            previousTag = previousTag.nextTag();
        }
        if (goodTag != null) {
            nti.setNodeTagBefore(goodTag.getName());
        }
        previousTag = gib.tagFromName(nti.getNodeTagBefore());
        goodTag = null;
        while (nextTag != null && nextTag != previousTag && EBCDICCompare.stringCompare((String)currentTagName, (String)nextTag.getName()) < 0) {
            goodTag = nextTag;
            nextTag = nextTag.previousTag();
        }
        if (goodTag != null) {
            nti.setNodeTagAfter(goodTag.getName());
        }
    }

    private static boolean ContainsOnlyFN(String text) {
        String nl = PdpTool.determineDelimiterOfV2((CharSequence)text);
        int indexLast = text.lastIndexOf(nl);
        int indexFirst = text.indexOf(nl);
        if (indexFirst == indexLast && text.startsWith("       ") && text.charAt(7) != ' ') {
            String endOfText = text.trim();
            int blank = endOfText.indexOf(" ");
            if (blank != -1) {
                endOfText = endOfText.substring(0, blank);
            }
            if (endOfText.endsWith("-FN.")) {
                return true;
            }
        }
        return false;
    }

    private static int GetFNindexFromText(String text) {
        String endOfText;
        String nl = PdpTool.determineDelimiterOfV2((CharSequence)text);
        int index = text.lastIndexOf(nl);
        if (index != -1) {
            text = text.substring(0, index);
        }
        if (VirtualMacroCleaner.ContainsOnlyFN(endOfText = text.substring(index = (index = text.lastIndexOf(nl)) != -1 ? text.lastIndexOf(nl) + nl.length() : 0))) {
            return index;
        }
        return -1;
    }

    public static String AppendMacroCode(String textOriginal, String macroCode) {
        String newLine = PdpTool.determineDelimiterOfV2((CharSequence)textOriginal);
        String[] allLines = textOriginal.split(newLine);
        StringBuilder result = new StringBuilder();
        String[] stringArray = allLines;
        int n = allLines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.length() > 6) {
                line = "      " + line.substring(6);
            }
            if (line.length() > 72) {
                int index = line.length() - 1;
                while (line.charAt(index) == ' ') {
                    --index;
                }
                if (index < 72) {
                    line = line.substring(0, index + 1);
                }
            }
            StringBuilder text = new StringBuilder(line);
            if (line.length() <= 72 && macroCode != null && (line.length() < 8 || line.charAt(7) != 'F')) {
                while (text.length() < 72) {
                    text.append(" ");
                }
                text.append(macroCode);
            }
            text.append(newLine);
            result.append((CharSequence)text);
            ++n2;
        }
        return result.toString();
    }

    public static String AppendLevel(String textOriginal, String level, boolean eraseIfPresent) {
        String newLine = PdpTool.determineDelimiterOfV2((CharSequence)textOriginal);
        String[] allLines = textOriginal.split(newLine);
        StringBuilder result = new StringBuilder();
        boolean found = false;
        String[] stringArray = allLines;
        int n = allLines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.length() > 6) {
                line = "      " + line.substring(6);
            }
            if (line.length() > 72) {
                int index = line.length() - 1;
                while (line.charAt(index) == ' ') {
                    --index;
                }
                if (index < 72) {
                    line = line.substring(0, index + 1);
                }
            }
            if (eraseIfPresent && line.length() > 72) {
                line = line.substring(0, 72);
            }
            StringBuilder text = new StringBuilder(line);
            if (!found && line.length() <= 72 && line.charAt(7) == 'F') {
                found = true;
                while (text.length() < 72) {
                    text.append(" ");
                }
                text.append(level);
            }
            text.append(newLine);
            result.append((CharSequence)text);
            ++n2;
        }
        return result.toString();
    }

    public String getAllSUPfunctions() {
        return this.allSUPfunctions;
    }

    public void setAllFunctions(List<IVirtualFunction> l) {
        Iterator<IVirtualFunction> itf = l.iterator();
        StringBuilder tmpS = new StringBuilder();
        while (itf.hasNext()) {
            IVirtualFunction f = itf.next();
            if ("SUP".equals(f.getCondition())) {
                tmpS.append(f.getCobolName());
                tmpS.append(" ");
                continue;
            }
            if (f.getLocation() != Location.ATTACH || f.getReference().startsWith("BS ") || f.getReference().startsWith("ES ") || f.getReference().startsWith("BS ") || f.getReference().startsWith("SQ ")) continue;
            this.tagsToCleanAtEnd.add(f.getCobolName());
        }
        this.allSUPfunctions = tmpS.toString();
    }

    public List<String> getAllSubFunctionsWithArtificialCreateToRestore() {
        return this.subFctToRestoreInOldGenInfo;
    }

    public List<String> getAllArtificalCreateSubfunctionsToClean() {
        return this.allArtificialCreateSubFunctions;
    }

    public List<String> getAllFunctionsOverridenInSpecific() {
        return this.allFunctionsOverridenInSpecific;
    }

    public static void VerifyTagPosition(IBuilderTag newTag, IBuilderTag previousTag, IBuilderTag nextTag) {
        IBuilderTree bt;
        if (newTag == null) {
            return;
        }
        IGenInfoBuilder gib = newTag.getGenInfoBuilder();
        if (newTag.previousTag() != previousTag && previousTag.getParent() == newTag) {
            boolean firstIsPrevious = false;
            do {
                firstIsPrevious = newTag.firstSon() == previousTag;
                bt = gib.removeTreeAndText(newTag.firstSon());
                gib.addTree(newTag.getBeginIndex(), bt, newTag.getParent().getName());
            } while (!firstIsPrevious);
        }
        if (newTag.nextTag() != nextTag && nextTag.getParent() == newTag) {
            boolean lastIsNext = false;
            do {
                lastIsNext = newTag.lastSon() == nextTag;
                bt = gib.removeTreeAndText(newTag.lastSon());
                gib.addTree(newTag.getEndIndex(), bt, newTag.getParent().getName());
            } while (!lastIsNext);
        }
    }

    public static String FromListToString(Collection<String> l, char separator) {
        Iterator<String> it = l.iterator();
        StringBuilder sb = new StringBuilder();
        while (it.hasNext()) {
            sb.append(it.next());
            sb.append(separator);
        }
        return sb.toString();
    }

    private static void InstanciateCompareNTI() {
        if (CompareNTI != null) {
            return;
        }
        CompareNTI = new Comparator<NodeInformations>(){

            @Override
            public int compare(NodeInformations o1, NodeInformations o2) {
                int i2;
                int i1;
                String o1Name = VirtualMacroCleaner.DEFAULT_NAME;
                String o2Name = VirtualMacroCleaner.DEFAULT_NAME;
                if (o1 instanceof NodeTagInformations) {
                    o1Name = ((NodeTagInformations)o1).getTagName();
                }
                if (o2 instanceof NodeTagInformations) {
                    o2Name = ((NodeTagInformations)o2).getTagName();
                }
                if ((i1 = o1Name.length()) != (i2 = o2Name.length())) {
                    return i1 - i2;
                }
                if (o1 instanceof NodeTagInformations && o2 instanceof NodeTagInformations) {
                    boolean o2HasEnglobing;
                    boolean o1HasEnglobing = ((NodeTagInformations)o1).getFirstEnglobingTagName() != null && ((NodeTagInformations)o1).getLastEnglobingTagName() != null;
                    boolean bl = o2HasEnglobing = ((NodeTagInformations)o2).getFirstEnglobingTagName() != null && ((NodeTagInformations)o2).getLastEnglobingTagName() != null;
                    if (o1HasEnglobing && !o2HasEnglobing) {
                        return -1;
                    }
                    if (!o1HasEnglobing && o2HasEnglobing) {
                        return 1;
                    }
                }
                return EBCDICCompare.stringCompare((String)o1Name, (String)o2Name);
            }
        };
    }
}

