/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.generator;

import com.ibm.pdp.engine.IGeneratedInfo;
import com.ibm.pdp.engine.IGeneratedInfoFactory;
import com.ibm.pdp.engine.IGeneratedTag;
import com.ibm.pdp.engine.turbo.EngineFactory;
import com.ibm.pdp.framework.PdpTool;
import com.ibm.pdp.framework.Trace;
import com.ibm.pdp.pacbase.PacTool;
import java.util.Iterator;

public class PacFunctionTitleExtractor {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String CR = PdpTool.EOL;
    private static final String PROC_DIV = "PROCEDURE";
    private static final String FUNCTION_N05 = "N05";
    private static final String FUNCTION_F05 = "F05";
    private static final String SIX_BLANKS = "      ";
    private IGeneratedInfo _generatedInfo;
    private String _patternName;

    public PacFunctionTitleExtractor(IGeneratedInfo generatedInfo, String patternName) {
        this._generatedInfo = generatedInfo;
        this._patternName = patternName;
    }

    private IGeneratedTag findFirstTag() {
        IGeneratedTag rootTag = this._generatedInfo.getRootTag();
        Iterator sons = rootTag.sons();
        while (sons.hasNext()) {
            IGeneratedTag aTag = (IGeneratedTag)sons.next();
            if (!PROC_DIV.equalsIgnoreCase(aTag.getName())) continue;
            return aTag;
        }
        return null;
    }

    private void processF05FunctionComment(IGeneratedTag tag) {
        CharSequence text = this._generatedInfo.getText().subSequence(tag.getBeginIndex(), tag.getEndIndex());
        Iterator sons = tag.sons();
        sons.next();
        String nextTagName = "*N" + ((IGeneratedTag)sons.next()).getName().substring(1);
        int nbOfLinesStepped = 0;
        int idx = PdpTool.getLineEndOffset((CharSequence)text, (int)0);
        if (idx + 12 >= text.length()) {
            return;
        }
        int begin = idx = PdpTool.getLineEndOffset((CharSequence)text, (int)idx);
        while (idx + 12 < text.length() && text.charAt(idx + 6) == '*' && !text.subSequence(idx + 6, idx + 12).equals(nextTagName)) {
            ++nbOfLinesStepped;
            idx = PdpTool.getLineEndOffset((CharSequence)text, (int)idx);
        }
        if (nbOfLinesStepped == 0) {
            return;
        }
        String s = text.subSequence(begin, idx).toString();
        String comments = PacTool.formatForGSVNodeTitle(s, FUNCTION_F05, true);
        if (!"".equals(comments)) {
            tag.setProperty("GSV_NODE_LABEL_SUPPLEMENT", " : " + comments);
        }
    }

    private boolean isMacro(IGeneratedTag tag) {
        if (tag == null) {
            return false;
        }
        String macroName = tag.getProperty("msp");
        return macroName != null;
    }

    private void processClassicFunctionComment(IGeneratedTag currentTag) {
        int beginIdx = currentTag.getBeginIndex();
        int endIdx = currentTag.getEndIndex();
        String currentTagName = currentTag.getName();
        IGeneratedTag parent = currentTag.getParent();
        StringBuilder txt = new StringBuilder();
        if (this.isMacro(currentTag)) {
            if (currentTagName.length() == 6) {
                currentTagName = currentTagName.substring(0, 3);
            } else if (currentTagName.length() == 8) {
                currentTagName = currentTagName.substring(0, 5);
            }
            txt.append(SIX_BLANKS);
            txt.append(this._generatedInfo.getText().subSequence(beginIdx + 6, endIdx).toString());
        } else {
            txt.append(this._generatedInfo.getText().subSequence(beginIdx, endIdx).toString());
        }
        String comments = PacTool.formatForGSVNodeTitle(txt, currentTagName, true);
        if (!"".equals(comments)) {
            parent.setProperty("GSV_NODE_LABEL_SUPPLEMENT", " : " + comments);
        }
    }

    private void processExtraction(IGeneratedTag currentTag) {
        if (currentTag == null) {
            return;
        }
        String currentTagName = currentTag.getName();
        if (FUNCTION_F05.equals(currentTagName) && this._patternName.equalsIgnoreCase("com.ibm.pdp.pacbase.batch") && currentTag.nbOfSons() > 1) {
            this.processF05FunctionComment(currentTag);
        }
        if (currentTagName.charAt(0) == 'N') {
            if (!FUNCTION_N05.equals(currentTagName)) {
                this.processClassicFunctionComment(currentTag);
            } else if (!this._patternName.equalsIgnoreCase("com.ibm.pdp.pacbase.batch")) {
                this.processClassicFunctionComment(currentTag);
            } else if (currentTag.getParent().nbOfSons() == 1) {
                this.processClassicFunctionComment(currentTag);
            }
        }
        Iterator sons = currentTag.sons();
        while (sons.hasNext()) {
            this.processExtraction((IGeneratedTag)sons.next());
        }
    }

    public void buildGeneratedTagPropertyWithTitle() {
        long a = System.currentTimeMillis();
        IGeneratedTag firstTag = this.findFirstTag();
        if (firstTag == null) {
            return;
        }
        Iterator sons = firstTag.sons();
        while (sons.hasNext()) {
            IGeneratedTag aSon = (IGeneratedTag)sons.next();
            this.processExtraction(aSon);
        }
        long b = System.currentTimeMillis();
        if (Trace.traceOn) {
            Trace.outPrintln((String)("PacFuntionTitleExtractor elapsed = " + (b - a)));
        }
    }

    private void displayTagProperties(IGeneratedTag aTag) {
        if (aTag == null) {
            return;
        }
        String s = aTag.getProperty("GSV_NODE_LABEL_SUPPLEMENT");
        System.out.print("(" + aTag.getName());
        if (s != null && !"".equals(s)) {
            System.out.println(" = " + s);
        } else {
            System.out.println();
        }
        Iterator sons = aTag.sons();
        while (sons.hasNext()) {
            this.displayTagProperties((IGeneratedTag)sons.next());
        }
        System.out.println(String.valueOf(aTag.getName()) + "/)");
    }

    private void displayResult() {
        System.out.println("Debut affichage resultats");
        Iterator sons = this._generatedInfo.getRootTag().sons();
        while (sons.hasNext()) {
            IGeneratedTag tag = (IGeneratedTag)sons.next();
            if (!PROC_DIV.equals(tag.getName())) continue;
            this.displayTagProperties(tag);
        }
        System.out.println("Fin affichage resultats");
    }

    public static void main(String[] args) {
        IGeneratedInfo generatedInfo = Util.makeGeneratedInfo();
        PacFunctionTitleExtractor x = new PacFunctionTitleExtractor(generatedInfo, "com.ibm.pdp.pacbase.batch");
        System.out.println("Texte=[" + generatedInfo.getText() + "]");
        x.buildGeneratedTagPropertyWithTitle();
        x.displayResult();
    }

    private static class Util {
        private static String SHORT_COMMENT = ".    NOTE *CALCUL DE SUR FICHIER   MV-FICHIER *." + PacFunctionTitleExtractor.access$0();
        private static String LONG_COMMENT1 = "        NOTE *************************************." + PacFunctionTitleExtractor.access$0() + "      *               *                                   *" + PacFunctionTitleExtractor.access$0() + "      *               *             ";
        private static String LONG_COMMENT2 = "            *" + PacFunctionTitleExtractor.access$0() + "      *               *                                   *" + PacFunctionTitleExtractor.access$0() + "      *               *************************************." + PacFunctionTitleExtractor.access$0();
        private static String FUNCTION_START = "F";
        private static String COMMENT_START = "N";

        private Util() {
        }

        public static IGeneratedInfo makeGeneratedInfo() {
            EngineFactory engine = new EngineFactory();
            IGeneratedInfoFactory factory = engine.newGeneratedInfoFactory();
            factory.beginTag("Root");
            factory.beginTag("IDENTIFICATION_DIV");
            factory.appendText((CharSequence)("Coucou" + CR));
            factory.endTag();
            factory.beginTag(PacFunctionTitleExtractor.PROC_DIV);
            factory.appendText((CharSequence)("PROCEDURE DIVISION." + CR));
            factory.beginTag(PacFunctionTitleExtractor.FUNCTION_F05);
            factory.beginTag(PacFunctionTitleExtractor.FUNCTION_N05);
            factory.appendText((CharSequence)("      *          NOTE *  DEBUT ITERATION DU PROGRAMME     *." + CR));
            factory.endTag();
            factory.appendText((CharSequence)("       F05." + CR));
            factory.appendText((CharSequence)("      *N05.      NOTE *************************************." + CR));
            factory.appendText((CharSequence)("      *               *                                   *" + CR));
            factory.appendText((CharSequence)("      *               *LECTURE FICHIERS ACCES SEQ. SANS DE*" + CR));
            factory.appendText((CharSequence)("      *               *                                   *" + CR));
            factory.appendText((CharSequence)("      *               *************************************." + CR));
            factory.beginTag("F05CU");
            factory.beginTag("N05CU");
            factory.appendText((CharSequence)("      *N05CU.    NOTE *LECTURE FICHIER         CU  SANS DE*." + CR));
            factory.endTag();
            factory.appendText((CharSequence)("       F05CU.   EXIT." + CR));
            factory.appendText((CharSequence)("            DISPLAY 'F05CU'." + CR));
            factory.appendText((CharSequence)("       F05-FN.   EXIT." + CR));
            factory.endTag();
            factory.appendText((CharSequence)("       F05-FN.   EXIT." + CR));
            factory.endTag();
            int i = 10;
            while (i < 15) {
                factory.beginTag(String.valueOf(FUNCTION_START) + i);
                factory.beginTag(String.valueOf(COMMENT_START) + i);
                factory.appendText((CharSequence)("      *" + COMMENT_START + i + LONG_COMMENT1 + "Function " + i + LONG_COMMENT2));
                factory.endTag();
                factory.appendText((CharSequence)("       " + FUNCTION_START + i + ".      EXIT." + CR));
                Util.makeSubTags(factory, i, "BB");
                Util.makeSubTags(factory, i, "CC");
                Util.makeSubTags(factory, i, "DD");
                factory.appendText((CharSequence)("       " + FUNCTION_START + i + "-FN.      EXIT." + CR));
                factory.endTag();
                ++i;
            }
            factory.endTag();
            factory.endTag();
            return factory.createGeneratedInfo();
        }

        protected static int makeSubTags(IGeneratedInfoFactory factory, int tagCount, String subFunctionName) {
            factory.beginTag(String.valueOf(FUNCTION_START) + tagCount + subFunctionName);
            factory.beginTag(String.valueOf(COMMENT_START) + tagCount + subFunctionName);
            factory.appendText((CharSequence)("      *" + COMMENT_START + tagCount + subFunctionName + SHORT_COMMENT));
            factory.endTag();
            factory.appendText((CharSequence)("       " + FUNCTION_START + tagCount + subFunctionName + ".         EXIT." + CR));
            factory.appendText((CharSequence)("       " + FUNCTION_START + tagCount + subFunctionName + "-FN.      EXIT." + CR));
            factory.endTag();
            return tagCount;
        }
    }
}

