/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.generator;

import com.ibm.pdp.engine.IBuilderTag;
import com.ibm.pdp.engine.IEngineFactory;
import com.ibm.pdp.engine.IGenInfoBuilder;
import com.ibm.pdp.engine.IGeneratedInfo;
import com.ibm.pdp.engine.internal.IGenericProblem;
import com.ibm.pdp.engine.internal.ITextProcessor;
import com.ibm.pdp.engine.turbo.core.SyntacticMark;
import com.ibm.pdp.engine.turbo.core.SyntacticTagBegin;
import com.ibm.pdp.engine.turbo.impl.GenericProblem;
import com.ibm.pdp.engine.turbo.impl.TextProcessor;
import com.ibm.pdp.explorer.model.PTModelManager;
import com.ibm.pdp.explorer.model.marker.PTMarkerManager;
import com.ibm.pdp.explorer.model.service.PTModelService;
import com.ibm.pdp.explorer.nature.PTNature;
import com.ibm.pdp.framework.Controller;
import com.ibm.pdp.framework.ControllerFactory;
import com.ibm.pdp.framework.GenResult;
import com.ibm.pdp.framework.GenStatus;
import com.ibm.pdp.framework.GeneratedElement;
import com.ibm.pdp.framework.PdpTool;
import com.ibm.pdp.framework.ResourceReference;
import com.ibm.pdp.framework.StatusMessage;
import com.ibm.pdp.framework.interfaces.IController;
import com.ibm.pdp.framework.interfaces.IGenResult;
import com.ibm.pdp.framework.interfaces.IGenStatus;
import com.ibm.pdp.framework.interfaces.IGenerationContext;
import com.ibm.pdp.framework.interfaces.IGeneratorLauncher;
import com.ibm.pdp.framework.interfaces.IPattern;
import com.ibm.pdp.framework.interfaces.IReference;
import com.ibm.pdp.framework.interfaces.IResourceReference;
import com.ibm.pdp.framework.interfaces.IStatusMessage;
import com.ibm.pdp.framework.pattern.PdpPatternGenStatesExceptions;
import com.ibm.pdp.framework.pattern.PdpPatternManager;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.pacbase.PacGenerationHeader;
import com.ibm.pdp.mdl.pacbase.PacProgram;
import com.ibm.pdp.mdl.pacbase.PacProgramStructureValues;
import com.ibm.pdp.mdl.pacbase.PacProgramVariantValues;
import com.ibm.pdp.mdl.pacbase.impl.PacScreenImpl;
import com.ibm.pdp.pacbase.PacTool;
import com.ibm.pdp.pacbase.PacbaseGenInfoConverter;
import com.ibm.pdp.pacbase.PdpPacbasePlugin;
import com.ibm.pdp.pacbase.design.ModelUtil;
import com.ibm.pdp.pacbase.extension.PacTransformGiFromV0ToV1;
import com.ibm.pdp.pacbase.extension.organize.CobolModification;
import com.ibm.pdp.pacbase.extension.organize.FunctionUtilities;
import com.ibm.pdp.pacbase.extension.organize.GenInfoModification;
import com.ibm.pdp.pacbase.extension.organize.IVirtualFunction;
import com.ibm.pdp.pacbase.extension.organize.Location;
import com.ibm.pdp.pacbase.extension.organize.MicroPatternExtraction;
import com.ibm.pdp.pacbase.extension.organize.PdpFunction;
import com.ibm.pdp.pacbase.extension.organize.SpecialMacroAnalyzer;
import com.ibm.pdp.pacbase.extension.organize.SyntacticInfoUtilities;
import com.ibm.pdp.pacbase.generate.util.IPacbaseGeneration;
import com.ibm.pdp.pacbase.generate.util.InterruptedGeneratorException;
import com.ibm.pdp.pacbase.generate.util.PacbaseGeneratorLabels;
import com.ibm.pdp.pacbase.generate.util.PacbaseLinksEntitiesService;
import com.ibm.pdp.pacbase.generator.PacFunctionTitleExtractor;
import com.ibm.pdp.pacbase.generator.PacGeneratorLabels;
import com.ibm.pdp.pacbase.generator.PacSourceDerivationDesign;
import com.ibm.pdp.pacbase.generator.VirtualMacroCleaner;
import com.ibm.pdp.pacbase.util.GenerationProblem;
import com.ibm.pdp.pacbase.util.OverrideProblem;
import com.ibm.pdp.pacbase.util.PositioningErroneousSuspicion;
import com.ibm.pdp.util.ExceptionWrapper;
import com.ibm.pdp.util.Util;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.PlatformUI;

public abstract class CommonPacGeneratorLauncher
implements IGeneratorLauncher {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2024.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected String _patternName;
    protected String _pacReportName;
    private String virtualMacroSource = null;
    private String macroSP_name = null;
    private static String twoPoints = " : ";
    private static String threePoints = "...";
    public static final String JUNIT_IN_PROGRESS = "JUNIT_TEST_IN_PROGRESS";

    public CommonPacGeneratorLauncher(String patternName) {
        this._patternName = patternName;
    }

    public IGenResult generate2(Object design, String designFilePath, IProgressMonitor monitor) {
        return this.generate2(null, design, designFilePath, monitor, null);
    }

    public IGenResult generate2(List<IController> controllers, Object design, String designFilePath, IProgressMonitor monitor, IGenerationContext context) {
        IGenResult result = null;
        if (PlatformUI.isWorkbenchRunning() && !PTModelManager.checkLicense()) {
            throw new RuntimeException("No Valid License");
        }
        try {
            result = this._generate2(controllers, design, designFilePath, monitor, context);
        }
        catch (Exception e) {
            StringBuilder message2;
            ArrayList<StatusMessage> messages = new ArrayList<StatusMessage>();
            int genstatusValue = 1;
            String mess = e.getMessage();
            if (mess == null || "".equals(mess)) {
                mess = PacGeneratorLabels.DEFAULT_MESS;
            }
            StatusMessage message = null;
            if (e.getCause() instanceof InterruptedGeneratorException || e instanceof ExceptionWrapper && ((ExceptionWrapper)e).getRealThrowable() instanceof InterruptedGeneratorException) {
                message2 = new StringBuilder();
                message2.append(PacbaseGeneratorLabels.EXTRACTION_FAILED_FOR);
                message2.append(designFilePath.toString());
                message2.append(".\r\n");
                message2.append(mess);
                message = new StatusMessage(1, message2.toString());
            } else if (e instanceof OperationCanceledException) {
                message = new StatusMessage(0, mess);
                genstatusValue = 2;
            } else {
                PdpTool.logErr((Plugin)PdpPacbasePlugin.getDefault(), (String)"com.ibm.pdp.pacbase", (String)mess, (Throwable)e);
                message2 = new StringBuilder();
                message2.append(PacGeneratorLabels.GENERATION_FAILED_FOR);
                message2.append(designFilePath.toString());
                message2.append(".\r\n");
                message2.append(PacGeneratorLabels.SEE_ERROR_LOG_FOR_DETAILS);
                String pacReportName = this.getPacReportName();
                if (pacReportName != null) {
                    File reportFile = new File(pacReportName);
                    if (reportFile.exists() && reportFile.isFile()) {
                        message2.append(PacGeneratorLabels.PAC_GENERATION_REPORT_BELOW);
                        message2.append("\r\n");
                        message2.append(pacReportName);
                        String pacReport = PdpTool.readFileContents((String)pacReportName);
                        message2.append("\r\n");
                        message2.append(pacReport);
                    } else {
                        message2.append(PacGeneratorLabels.PAC_REPORT_WAS_NOT_CREATED);
                    }
                } else {
                    message2.append(PacGeneratorLabels.PAC_REPORT_WAS_NOT_CREATED);
                }
                message = new StatusMessage(0, message2.toString());
            }
            messages.add(message);
            GenStatus status = new GenStatus(genstatusValue, messages);
            return new GenResult((IGenStatus)status, this._patternName);
        }
        return result;
    }

    public VirtualMacroProcess isVirtualMacroProcess() {
        if (!PacTool.isMacroVirtualEnabled() || "true".equals(System.getProperty(JUNIT_IN_PROGRESS))) {
            return VirtualMacroProcess.NONE;
        }
        return VirtualMacroProcess.VIRT_AND_SP;
    }

    private IGenResult _generate2(List<IController> controllers, Object design, String designFilePath, IProgressMonitor monitor, IGenerationContext context) {
        String contents;
        PacTransformGiFromV0ToV1 transform;
        ITextProcessor textProcessor;
        IGeneratedInfo gi;
        IController controller;
        RadicalEntity re = (RadicalEntity)design;
        boolean isEntryPoint = true;
        if (monitor != null) {
            Object[] params = new String[]{re.getName()};
            String nl1String = NLS.bind((String)PacGeneratorLabels.GENERATION_PROCESS, (Object[])params);
            monitor.beginTask(String.valueOf(nl1String) + twoPoints + PacGeneratorLabels.MODEL_ANALYSIS + threePoints, 100);
            monitor.worked(10);
            monitor.setTaskName(String.valueOf(nl1String) + twoPoints + PacGeneratorLabels.CODE_GENERATION + threePoints);
        }
        if (monitor.isCanceled()) {
            throw new OperationCanceledException(PacGeneratorLabels.OPER_CANCELED_AT_BEGINNING);
        }
        String programCblFile = this.getLogicalCobolFileNameFromDesign(re);
        IFile file1 = re.getFile(null);
        String designFileName = file1.getFullPath().toString();
        IPattern pattern = PdpPatternManager.getPdpPattern((String)this._patternName);
        String fullCblFileName1 = PacTool.getFullGeneratedFileName(re, pattern, designFileName);
        IController iController = controller = fullCblFileName1 == null ? null : CommonPacGeneratorLauncher.getController(controllers, fullCblFileName1);
        if (controller != null && controller.getTextProcessor() instanceof ITextProcessor && (gi = (textProcessor = (ITextProcessor)controller.getTextProcessor()).getGeneratedInfo()) != null && (gi = (transform = new PacTransformGiFromV0ToV1()).transformGeneratedInfo(gi)) != null) {
            textProcessor.initialize(gi);
        }
        FunctionUtilities functionUtilities = null;
        SpecialMacroAnalyzer sma = null;
        GenInfoModification gim = null;
        List<IVirtualFunction> allFunctions = null;
        if (this.isCurrentGenerationWithVirtualMacro(context, controller)) {
            if (controller != null) {
                if (!PacTool.isGenerationPossibleWithVirtualMacro(controller)) {
                    throw new OperationCanceledException(PacGeneratorLabels.GENERATION_PROHIBITED_WITH_VIRTUAL_MACRO);
                }
                sma = new SpecialMacroAnalyzer(re);
                ITextProcessor textProcessor2 = (ITextProcessor)controller.getTextProcessor();
                gim = new GenInfoModification((com.ibm.pdp.engine.ITextProcessor)textProcessor2, this._patternName);
                if (sma.isSpecialMacroExist() && textProcessor2.getGeneratedInfo().getProperty("MV") == null) {
                    boolean genInfoUpdated = false;
                    if (!sma.getAllRelativeFunctions().isEmpty() || !sma.getAllStarC().isEmpty()) {
                        CobolModification cm = new CobolModification(this._patternName, (com.ibm.pdp.engine.ITextProcessor)textProcessor2);
                        textProcessor2.setText((CharSequence)cm.getNewCobol(sma.getAllRelativeFunctions(), sma.getAllSupFunctions(), sma.getAllStarC()));
                        genInfoUpdated = true;
                    }
                    if (!sma.getAllRelativeFunctions().isEmpty() || !sma.getAllIndexes().isEmpty()) {
                        textProcessor2.initialize(gim.getGenInfoAfterDeletedInfosMacroSP(sma));
                        genInfoUpdated = true;
                    }
                    if (context != null && Boolean.parseBoolean((String)context.getGenerationProperties().get("SAVE_FILE_DURING_GENERATION")) || context == null && "true".equals(System.getProperty("enableVirtualMacroRegen"))) {
                        this.saveResources(controller, sma, re, monitor, genInfoUpdated);
                    }
                }
                MicroPatternExtraction mpe = new MicroPatternExtraction();
                gim.setAllMPsInSubFunction(mpe.getAllMPs(controller.getTextProcessor().getEditTree()));
                functionUtilities = new FunctionUtilities(this._patternName);
                if (sma != null && sma.isSpecialMacroExist()) {
                    functionUtilities.setAllFunctionsFromSPmacro(sma.getAllRelativeFunctions());
                }
                allFunctions = this.identifySpecificFunctions(controller, functionUtilities);
                gim.setAllFunctionsFromSPmacro(this.compareDetectedFunctionsWithSPfunctions(allFunctions, sma));
                gim.cleanAllSubFunctionsToReplaceAfterMerge();
                this.handleSpecialFunctions(controller, allFunctions);
                if (!allFunctions.isEmpty()) {
                    if (sma != null && sma.isSpecialMacroExist()) {
                        allFunctions.addAll(sma.getAllSupFunctions());
                    }
                    this.virtualMacroSource = this.transformFunctionsToSource(allFunctions, functionUtilities.getNewLineDelimiter());
                }
            } else if (controller == null && (System.getProperty(JUNIT_IN_PROGRESS) == null || "false".equals(System.getProperty(JUNIT_IN_PROGRESS))) && (sma = new SpecialMacroAnalyzer(re)).isSpecialMacroExist()) {
                this.saveResources(controller, sma, re, monitor, false);
            }
        }
        String destination = ModelUtil.getProjectFromRadicalObject(designFilePath);
        if (monitor.isCanceled()) {
            throw new OperationCanceledException(PacGeneratorLabels.OPER_CANCELED_AT_BEGINNING);
        }
        this.setPacReportName(designFilePath);
        if (this.isCurrentGenerationWithVirtualMacro(context, controller) && context != null && context.getGenerationProperties().get("DO_NOT_TAKE_INTO_ACCOUNT_SP_MACRO_DURING_MERGE") != null) {
            this.macroSP_name = (String)context.getGenerationProperties().get("DO_NOT_TAKE_INTO_ACCOUNT_SP_MACRO_DURING_MERGE");
        }
        IPacbaseGeneration pbw3g = this.getNewPacbaseGenerator(re, destination);
        List<IGenericProblem> alip = this.updateGenericProblems(pbw3g.getGenericProblems());
        String secondGeneratedFileName = null;
        if (re instanceof PacScreenImpl) {
            boolean optionForGeneratedMap = pbw3g.getOptionForGeneratedMap();
            if (this.isMapGenerable(re) && !optionForGeneratedMap) {
                secondGeneratedFileName = pbw3g.getSecondGeneratedFileName();
            }
        } else {
            secondGeneratedFileName = pbw3g.getSecondGeneratedFileName();
        }
        if (monitor.isCanceled()) {
            throw new OperationCanceledException(PacGeneratorLabels.OPER_CANCELED_BEFORE_RECONCILIATION);
        }
        monitor.worked(70);
        Object[] params = new String[]{re.getName()};
        String nl1String = NLS.bind((String)PacGeneratorLabels.GENERATION_PROCESS, (Object[])params);
        monitor.setTaskName(String.valueOf(nl1String) + twoPoints + PacGeneratorLabels.CONSOLIDATION + threePoints);
        IGeneratedInfo genInfo = pbw3g.getGeneratedInfo();
        if (this.isCurrentGenerationWithVirtualMacro(context, controller)) {
            if (functionUtilities != null) {
                VirtualMacroCleaner vmc = new VirtualMacroCleaner(re.getName(), this._patternName);
                vmc.setInformations(pbw3g.getNodeTagsInformations());
                vmc.setDash900List(functionUtilities.getSpecificDash900());
                vmc.setAllFunctions(allFunctions);
                genInfo = vmc.clean(genInfo);
                ITextProcessor textProcessor3 = (ITextProcessor)controller.getTextProcessor();
                boolean isMVAlreadyDone = "true".equals(textProcessor3.getGeneratedInfo().getProperty("MV"));
                if (!isMVAlreadyDone) {
                    textProcessor3.getGeneratedInfo().setProperty("MV", "true");
                    genInfo.setProperty("MVPROGRESS", "true");
                    if (gim == null && controller != null) {
                        gim = new GenInfoModification(controller.getTextProcessor(), this._patternName);
                    }
                    if (gim != null) {
                        gim.setAllSubFunctionsWith_N_lineNumberDifferentFromZero(vmc.getAllSubFunctionsWithArtificialCreateToRestore());
                        gim.setDash900Torestore(vmc.getDash900toReplaceInOld());
                        gim.setAllFunctionsOverridenInSpeific(vmc.getAllFunctionsOverridenInSpecific());
                        gim.setAllArtificalCreateSubFunctionsToClean(vmc.getAllArtificalCreateSubfunctionsToClean());
                        gim.setAllSUPfunctions(vmc.getAllSUPfunctions());
                        gim.setTextProcessor(controller.getTextProcessor());
                    }
                    if (sma != null && sma.needToRestoreFunctionsAndSUPfunctions() || gim != null && gim.needToRestoreOldGeneratedInfo()) {
                        textProcessor3.initialize(gim.getGenInfoAfterRestoreSupFunctions(sma, re.getName(), genInfo));
                        genInfo = genInfo.toGeneratedInfoBuilder().toGeneratedInfo();
                        if (context != null && Boolean.parseBoolean((String)context.getGenerationProperties().get("SAVE_FILE_DURING_GENERATION")) || context == null && "true".equals(System.getProperty("enableVirtualMacroRegen"))) {
                            controller.getResourceLink().saveResource();
                        }
                    }
                } else if (PacTool.isEntityWithMigrationWarnings(controller)) {
                    genInfo.setProperty("MVPROGRESS", "true");
                } else {
                    if (gim == null && controller != null) {
                        gim = new GenInfoModification(controller.getTextProcessor(), this._patternName);
                    }
                    if (gim != null && !vmc.getAllSUPfunctions().isEmpty()) {
                        gim.setAllSUPfunctions(vmc.getAllSUPfunctions());
                        IGenInfoBuilder oldGib = textProcessor3.getGeneratedInfo().toGeneratedInfoBuilder();
                        gim.synchronizeSUPfunctions(oldGib, genInfo);
                        IGeneratedInfo genInfoDup = oldGib.toGeneratedInfo();
                        IGenInfoBuilder gibDup = genInfo.toGeneratedInfoBuilder();
                        gim.synchronizeSUPfunctions(gibDup, genInfoDup);
                        genInfo = gibDup.toGeneratedInfo();
                        textProcessor3.initialize(genInfoDup);
                    }
                }
            }
            genInfo.setProperty("MV", "true");
        }
        genInfo = this.handleSpecificUserTags(genInfo, re, controllers, fullCblFileName1);
        PacFunctionTitleExtractor pfte = new PacFunctionTitleExtractor(genInfo, this._patternName);
        pfte.buildGeneratedTagPropertyWithTitle();
        PacbaseGenInfoConverter pacConverter = this.newPacbaseGenInfoConverter();
        if (pacConverter != null) {
            this.initPacConverter(pacConverter);
            genInfo = pacConverter.convert(genInfo);
        }
        if (monitor.isCanceled()) {
            throw new OperationCanceledException(PacGeneratorLabels.OPER_CANCELED_BEFORE_RECONCILIATION);
        }
        genInfo.setProperty("pattern", this._patternName);
        genInfo.setProperty("DoNotAnalyze", "true");
        if (design instanceof PacProgram) {
            PacProgram pgm = (PacProgram)design;
            PacProgramVariantValues ppvv = pgm.getVariante();
            genInfo.setProperty("variant", ppvv.getName());
            PacProgramStructureValues ppsv = pgm.getProgramStructure();
            genInfo.setProperty("nature", ppsv.getName());
        }
        genInfo.setProperty("TranscientDesignFilePath", designFilePath);
        genInfo.setProperty("TranscientCobolFilePath", programCblFile);
        IGeneratedInfo secondGeneratedFileGenInfo = null;
        String secondGeneratedFile = null;
        if (secondGeneratedFileName != null && (contents = PdpTool.readFileContents((String)secondGeneratedFileName)).length() > 0) {
            secondGeneratedFile = re instanceof PacScreenImpl ? PacTool.getMapFileNameFromDesign(re) : PacTool.getServerManagerCobolFileNameFromDesign(re);
            if (!(re instanceof PacScreenImpl) && secondGeneratedFile.equals(programCblFile)) {
                throw new RuntimeException(PacGeneratorLabels.SERVER_MANAGER_NAME_KO);
            }
            secondGeneratedFileGenInfo = this.createGeneratedInfoForSecondGeneratedFile(contents, re);
            secondGeneratedFileGenInfo.setProperty("pattern", this._patternName);
            secondGeneratedFileGenInfo.setProperty("DoNotAnalyze", "true");
            secondGeneratedFileGenInfo.setProperty("ReconcileMode", "NoReconcile");
        }
        monitor.worked(10);
        if (controller != null) {
            String attachProperty = this.constructAttachPropertyFromSyntacticInfo((TextProcessor)controller.getTextProcessor());
            ((ITextProcessor)controller.getTextProcessor()).getGlobalContext().put("PLES", pbw3g.getReferencedEntities());
            ((ITextProcessor)controller.getTextProcessor()).getGlobalContext().put("ATTACH_IN_SPECIFIC", attachProperty);
            if (context != null && context.getGenerationProperties().get("DOUBLE_ON_MICRO_PATTERN") != null) {
                ((ITextProcessor)controller.getTextProcessor()).getGlobalContext().put("DOUBLE_ON_MICRO_PATTERN", context.getGenerationProperties().get("DOUBLE_ON_MICRO_PATTERN"));
            }
        }
        IGenResult genResult = this.createGenResult(re, isEntryPoint, programCblFile, secondGeneratedFile, null, null, null, genInfo, secondGeneratedFileGenInfo, pbw3g.getReferencedEntities(), null, null, alip);
        return genResult;
    }

    private List<IVirtualFunction> compareDetectedFunctionsWithSPfunctions(List<IVirtualFunction> allDetectedFunctions, SpecialMacroAnalyzer sma) {
        ArrayList<IVirtualFunction> toRemove = new ArrayList<IVirtualFunction>();
        List<IVirtualFunction> allSPsubFunctions = sma.getAllRelativeFunctions();
        for (IVirtualFunction vf : allSPsubFunctions) {
            Iterator<IVirtualFunction> itd = allDetectedFunctions.iterator();
            boolean continu = true;
            while (itd.hasNext() && continu) {
                IVirtualFunction fd = itd.next();
                if (!vf.getCobolName().equals(fd.getCobolName())) continue;
                continu = false;
            }
            if (!continu || sma.getAllSupFunctions().contains(vf)) continue;
            toRemove.add(vf);
        }
        allSPsubFunctions.removeAll(toRemove);
        return allSPsubFunctions;
    }

    private boolean isCurrentGenerationWithVirtualMacro(IGenerationContext context, IController controller) {
        if (!VirtualMacroProcess.NONE.equals((Object)this.isVirtualMacroProcess())) {
            if (context != null && Boolean.parseBoolean((String)context.getGenerationProperties().get("TRANSFORM_TO_VIRTUAL_MACRO"))) {
                return true;
            }
            if ("true".equals(System.getProperty("enableVirtualMacroRegen"))) {
                return true;
            }
            if (controller == null) {
                return true;
            }
            if (controller.getTextProcessor() instanceof ITextProcessor) {
                ITextProcessor textProcessor = (ITextProcessor)controller.getTextProcessor();
                return "true".equals(textProcessor.getGeneratedInfo().getProperty("MV"));
            }
        }
        return false;
    }

    private String constructAttachPropertyFromSyntacticInfo(TextProcessor textProcessor) {
        List<SyntacticMark> l = SyntacticInfoUtilities.GetAllMarksFrom(textProcessor, "ATTACH_CATEGORY");
        Iterator<SyntacticMark> marks = l.iterator();
        StringBuilder attachInSpe = new StringBuilder();
        while (marks.hasNext()) {
            SyntacticMark mark = marks.next();
            String fctS = mark.toTag().getProperty("ATTACH_FUNCTION");
            String ref = mark.toTag().getProperty("ATTACH_LOGICAL_VIEW");
            attachInSpe.append(fctS).append("=").append(ref).append(",");
        }
        return attachInSpe.toString();
    }

    private boolean isFromMigrationHelp() {
        return Arrays.toString(new Throwable().getStackTrace()).indexOf("com.ibm.pdp.pac.migration.help.MigrationHelp2") > 0;
    }

    private IGeneratedInfo handleSpecificUserTags(IGeneratedInfo genInfo, RadicalEntity radicalEntity, List<IController> controllers, String generatedFile) {
        Iterator marks;
        if (genInfo == null || radicalEntity == null || this.isFromMigrationHelp() || generatedFile == null) {
            return genInfo;
        }
        IFile file = radicalEntity.getFile(null);
        file.getFullPath().toString();
        String fullCblFileName = generatedFile;
        IController controller = CommonPacGeneratorLauncher.getController(controllers, fullCblFileName);
        if (controller == null || controller.getTextProcessor() == null) {
            return genInfo;
        }
        TextProcessor textProcessor = (TextProcessor)controller.getTextProcessor();
        if (textProcessor.getSyntacticInfo() != null && (marks = textProcessor.getSyntacticInfo().marks()) != null) {
            HashSet<String> tagNames = new HashSet<String>();
            IGenInfoBuilder _genInfoBuilder = null;
            while (marks.hasNext()) {
                IBuilderTag tag;
                SyntacticMark mark = (SyntacticMark)marks.next();
                if (!mark.isBeginMark() || !mark.isTag() || mark.toTag() == null || !mark.toTag().getProperty("category").equals("user_code_tag") || mark.getPeer() == null) continue;
                SyntacticTagBegin tagBegin = (SyntacticTagBegin)mark;
                String tagName = tagBegin.toTag().getName();
                tagNames.add(tagName);
                String pos = mark.toTag().getProperty("POS");
                if (pos == null) continue;
                String modelTag = tagName.replace("SPECIFIC_" + pos + '_', "");
                if (_genInfoBuilder == null) {
                    _genInfoBuilder = genInfo.toGeneratedInfoBuilder();
                }
                if ((tag = _genInfoBuilder.tagFromName(modelTag)) != null) {
                    if (pos.equals("BEFORE")) {
                        _genInfoBuilder.addTagBefore(tagName, modelTag);
                        continue;
                    }
                    if (!pos.equals("AFTER")) continue;
                    _genInfoBuilder.addTagAfter(tagName, modelTag);
                    continue;
                }
                System.err.println("FIXME JBY : " + tagName);
            }
            if (!tagNames.isEmpty()) {
                String prop = _genInfoBuilder.getProperty("MSPVIRT_DELETE_TAGS");
                if (prop == null) {
                    _genInfoBuilder.setProperty("MSPVIRT_DELETE_TAGS", VirtualMacroCleaner.FromListToString(tagNames, ' '));
                } else {
                    _genInfoBuilder.setProperty("MSPVIRT_DELETE_TAGS", String.valueOf(prop) + ' ' + VirtualMacroCleaner.FromListToString(tagNames, ' '));
                }
                return _genInfoBuilder.toGeneratedInfo();
            }
        }
        return genInfo;
    }

    private static IController getController(List<IController> controllers, String fullCblFileName) {
        IController result = null;
        if (controllers == null || controllers.size() == 0) {
            result = ControllerFactory.getInstance().getController(fullCblFileName);
        } else if (controllers.size() == 1) {
            result = controllers.get(0);
        } else {
            for (IController iController : controllers) {
                if (!iController.getResourceName().equals(fullCblFileName)) continue;
                result = iController;
                break;
            }
        }
        return result;
    }

    protected PacbaseGenInfoConverter newPacbaseGenInfoConverter() {
        IEngineFactory ief = PdpTool.getEngineFactory();
        return new PacbaseGenInfoConverter(ief.newGeneratedInfoFactory());
    }

    private List<IGenericProblem> updateGenericProblems(List<GenerationProblem> almp) {
        ArrayList<IGenericProblem> elip = new ArrayList<IGenericProblem>();
        ArrayList<String> als = new ArrayList<String>();
        if (almp != null) {
            GenericProblem mp;
            int i = 0;
            while (i < almp.size()) {
                if (almp.get(i) instanceof PositioningErroneousSuspicion) {
                    PositioningErroneousSuspicion pes = (PositioningErroneousSuspicion)almp.get(i);
                    StringBuilder sb = new StringBuilder(4);
                    sb.append(pes.getFunction());
                    sb.append(pes.getSubFunction());
                    if (als.indexOf(sb.toString().trim()) == -1) {
                        als.add(sb.toString());
                    }
                } else if (almp.get(i) instanceof OverrideProblem) {
                    OverrideProblem op = (OverrideProblem)almp.get(i);
                    ArrayList<String> params = new ArrayList<String>();
                    StringBuilder sb = new StringBuilder();
                    String sort = op.getSort();
                    String name = op.getName();
                    if (sort.charAt(0) == '9') {
                        if (sort.trim().length() > 6) {
                            sb.append("F");
                            sb.append(sort.substring(1, 3));
                            if (sort.substring(4, 6).trim().length() > 0) {
                                sb.append(sort.substring(4, 6));
                            }
                            params.add(sb.toString());
                        } else {
                            params.add(name);
                        }
                    } else {
                        params.add(name);
                    }
                    String msp1 = op.getMsp1().trim();
                    String msp2 = op.getMsp2().trim();
                    if (msp1.equals(msp2)) {
                        params.add(msp1);
                    } else {
                        params.add(msp1);
                        params.add(msp2);
                        params.add(op.getLabel1().trim());
                        params.add(op.getLabel2().trim());
                        if (sort.charAt(0) == '9' && sort.trim().length() > 8) {
                            params.add(sort.substring(6));
                        }
                    }
                    if (params.toString().length() > 0) {
                        GenericProblem mp2 = null;
                        mp2 = sort.charAt(0) == '9' ? new GenericProblem(100, 100, params, "com.ibm.pdp.macrooverlapping.marker", true) : new GenericProblem(0, 0, params, "com.ibm.pdp.macrooverlapping.marker", true);
                        elip.add((IGenericProblem)mp2);
                    }
                } else {
                    GenerationProblem gp = almp.get(i);
                    mp = null;
                    ArrayList<String> params = new ArrayList<String>();
                    StringTokenizer st = new StringTokenizer(gp.getText());
                    while (st.hasMoreElements()) {
                        params.add(st.nextToken());
                    }
                    mp = new GenericProblem(0, 0, params, "com.ibm.pdp.pacbase.generate.marker", true);
                    elip.add((IGenericProblem)mp);
                }
                ++i;
            }
            i = 0;
            while (i < als.size()) {
                StringBuilder sb = new StringBuilder();
                sb.append(PacGeneratorLabels.VERIFY_POSITION);
                sb.append((String)als.get(i));
                mp = null;
                mp = new GenericProblem(100, 100, sb.toString(), "com.ibm.pdp.merge.macro.positioningerroneoussuspicion.marker", true);
                elip.add((IGenericProblem)mp);
                ++i;
            }
        }
        return elip;
    }

    private IGenResult createGenResult(RadicalEntity designRe, boolean isEntryPoint, String programCblFile, String mapCblFile, IGenStatus status, String calledCobolProgramCblFile, String calledFullCobolProgramCblFile, IGeneratedInfo genInfo, IGeneratedInfo mapGenInfo, PacbaseLinksEntitiesService referencedEntities, List<IResourceReference> cascadedGenerationOutput, Iterator<IReference> referenceIterator, List<IGenericProblem> alip) {
        ArrayList<IStatusMessage> messages = new ArrayList<IStatusMessage>();
        if (status != null) {
            Iterator parentMessages = status.getMessages();
            while (parentMessages.hasNext()) {
                IStatusMessage statusMessage = (IStatusMessage)parentMessages.next();
                messages.add(statusMessage);
            }
        }
        GenStatus currentStatus = new GenStatus(0, messages);
        ArrayList<ResourceReference> references = new ArrayList<ResourceReference>();
        if (calledCobolProgramCblFile != null) {
            String stateIdOfCobolReferenced = PdpTool.computeStateIdOfFile((String)calledFullCobolProgramCblFile);
            references.add(new ResourceReference(calledCobolProgramCblFile, stateIdOfCobolReferenced));
        }
        String designId = designRe.getDesignId(designRe.getProject());
        ResourceReference entryPoint = null;
        if (referencedEntities != null && referencedEntities.getReferencesResult() != null) {
            for (String key : referencedEntities.getReferencesResult().keySet()) {
                String stateId = ((PacbaseLinksEntitiesService.States)referencedEntities.getReferencesResult().get(key)).getStateId();
                String genStateId = ((PacbaseLinksEntitiesService.States)referencedEntities.getReferencesResult().get(key)).getGenStateId();
                if (key.equals(designId)) {
                    entryPoint = new ResourceReference(designId, stateId, genStateId);
                    continue;
                }
                references.add(new ResourceReference(key, stateId, genStateId));
            }
        }
        if (referenceIterator != null) {
            while (referenceIterator.hasNext()) {
                String key;
                IReference iReference = referenceIterator.next();
                key = iReference.getLogicalFileName();
                if (iReference.getRelationName().endsWith("entrypoint")) {
                    references.add(new ResourceReference(key, iReference.getStateId()));
                    continue;
                }
                references.add(new ResourceReference(key, iReference.getStateId(), iReference.getGenStateId()));
            }
        }
        ArrayList<GeneratedElement> generatedElements = new ArrayList<GeneratedElement>(2);
        GeneratedElement generatedElement = new GeneratedElement(genInfo, references, (IResourceReference)new ResourceReference(programCblFile, ""));
        generatedElements.add(generatedElement);
        if (mapGenInfo != null && mapCblFile != null) {
            ArrayList<ResourceReference> references2 = new ArrayList<ResourceReference>();
            if (calledCobolProgramCblFile != null) {
                String stateIdOfCobolReferenced = PdpTool.computeStateIdOfFile((String)calledFullCobolProgramCblFile);
                references2.add(new ResourceReference(calledCobolProgramCblFile, stateIdOfCobolReferenced));
            }
            if (referencedEntities != null && referencedEntities.getReferencesResultForMap() != null) {
                for (String key : referencedEntities.getReferencesResultForMap().keySet()) {
                    String stateId = ((PacbaseLinksEntitiesService.States)referencedEntities.getReferencesResultForMap().get(key)).getStateId();
                    String genStateId = ((PacbaseLinksEntitiesService.States)referencedEntities.getReferencesResultForMap().get(key)).getGenStateId();
                    references2.add(new ResourceReference(key, stateId, genStateId));
                }
            }
            GeneratedElement mapGeneratedElement = new GeneratedElement(mapGenInfo, references2, (IResourceReference)new ResourceReference(mapCblFile, ""));
            generatedElements.add(mapGeneratedElement);
        }
        if (entryPoint == null) {
            String genStateId = PdpPatternGenStatesExceptions.getGenStateId((RadicalEntity)designRe, (String)this._patternName, (boolean)true, null, (String)"1");
            entryPoint = new ResourceReference(designId, designRe.getStateId(), genStateId);
        }
        GenResult genResult = new GenResult((IGenStatus)currentStatus, this._patternName, entryPoint, generatedElements, cascadedGenerationOutput, alip);
        return genResult;
    }

    public boolean isGenerationPossible(Object design) {
        List paths;
        RadicalEntity radicalEntity;
        int errorLevel;
        if (design instanceof PacSourceDerivationDesign) {
            design = ((PacSourceDerivationDesign)design).getDesign();
        }
        return !(design instanceof RadicalEntity) || (errorLevel = PTMarkerManager.checkMarkers((RadicalEntity)(radicalEntity = (RadicalEntity)design), (boolean)false, (List)(paths = PTNature.getPaths((String)radicalEntity.getProject())))) <= 1;
    }

    protected void initPacConverter(PacbaseGenInfoConverter pacConverter) {
        pacConverter.setMoveTagEndAfterEol(true);
        pacConverter.setSequenceNumberConvert(PacbaseGenInfoConverter.SequenceNumberConvert.Clear);
        pacConverter.setCutAtColumn72(false);
    }

    public abstract PacGenerationHeader getGenerationHeader(RadicalEntity var1);

    public abstract IPacbaseGeneration getNewPacbaseGenerator(RadicalEntity var1, String var2);

    public String getPacReportName() {
        return this._pacReportName;
    }

    protected void setPacReportName(String designFilePath) {
        String shortName = PdpTool.getShortFileNameOf((String)designFilePath);
        String s = PdpTool.removeExtension((String)shortName);
        this._pacReportName = String.valueOf(PdpTool.getJavaTmpDir()) + s + "." + "CR";
    }

    protected boolean isMapGenerable(RadicalEntity re) {
        return false;
    }

    protected IGeneratedInfo createGeneratedInfoForSecondGeneratedFile(String contents, RadicalEntity re) {
        return null;
    }

    protected String getLogicalCobolFileNameFromDesign(RadicalEntity re) {
        return PacTool.getLogicalCobolFileNameFromDesign(re);
    }

    protected String getVirtualMacroSource() {
        return this.virtualMacroSource;
    }

    protected String getMacroSPName() {
        return this.macroSP_name;
    }

    protected List<IVirtualFunction> identifySpecificFunctions(IController controller, FunctionUtilities fu) {
        ArrayList<IVirtualFunction> result = new ArrayList<IVirtualFunction>();
        if (controller == null) {
            return result;
        }
        return fu.searchSpecificFunction(controller.getTextProcessor().getEditTree());
    }

    protected String transformFunctionsToSource(List<IVirtualFunction> allFunctions, String newLine) {
        StringBuilder sb = new StringBuilder();
        for (IVirtualFunction iFunction : allFunctions) {
            sb.append((CharSequence)FunctionUtilities.WriteFunction(iFunction, newLine));
        }
        return sb.toString();
    }

    private void saveResources(IController controller, SpecialMacroAnalyzer sma, RadicalEntity re, IProgressMonitor monitor, boolean genInfoUpdated) {
        if (genInfoUpdated) {
            CommonPacGeneratorLauncher.saveSrcResource(controller);
            controller.getResourceLink().saveResource();
        }
        PacTool.getCPLines(re).remove((Object)sma.getCpLine());
        IFile resource = null;
        try {
            re.save();
            IPath pathMacro = PTModelService.getPath((String)sma.getCpLine().getMacro().getDesignId(re.getProject()));
            resource = ResourcesPlugin.getWorkspace().getRoot().getFile(pathMacro);
            if (!Util.isInRPPTestMode()) {
                resource.delete(true, monitor);
            }
        }
        catch (IOException ioe) {
            Util.rethrow((Throwable)ioe);
        }
        catch (CoreException e) {
            if (resource.exists()) {
                System.out.println("resource exists : " + resource);
            }
            if (resource.isAccessible()) {
                System.out.println("resource accessible : " + resource);
            }
            Util.rethrow((Throwable)e);
        }
    }

    private void handleSpecialFunctions(IController controller, List<IVirtualFunction> allFunctions) {
        if (controller == null || controller.getTextProcessor() == null) {
            return;
        }
        TextProcessor textProcessor = (TextProcessor)controller.getTextProcessor();
        List<SyntacticMark> l = SyntacticInfoUtilities.GetAllMarksFrom(textProcessor, "ATTACH_CATEGORY");
        Iterator<SyntacticMark> marks = l.iterator();
        ArrayList<IVirtualFunction> toDelete = new ArrayList<IVirtualFunction>();
        ArrayList<PdpFunction> toAdd = new ArrayList<PdpFunction>();
        while (marks.hasNext()) {
            SyntacticMark mark = marks.next();
            String fctS = mark.toTag().getProperty("ATTACH_FUNCTION");
            Iterator<IVirtualFunction> ref = mark.toTag().getProperty("ATTACH_LOGICAL_VIEW");
            for (IVirtualFunction fctV : allFunctions) {
                if (!fctV.getCobolName().equals(fctS)) continue;
                toDelete.add(fctV);
            }
            PdpFunction f = new PdpFunction("", fctS, 5.0f, 0, Location.ATTACH, (String)((Object)ref));
            if ("true".equals(mark.toTag().getProperty("ATTACH_TAG_TREATMENT_IN_STAR_FUNCTION"))) {
                f.getProperties().put("ATTACH_TAG_TREATMENT_IN_STAR_FUNCTION", "true");
            }
            toAdd.add(f);
        }
        allFunctions.removeAll(toDelete);
        allFunctions.addAll(toAdd);
        toDelete.clear();
        PdpFunction fct = (PdpFunction)((ITextProcessor)controller.getTextProcessor()).getGlobalContext().get("Mv_subfunction_to_modify");
        if (fct != null) {
            for (IVirtualFunction fctV : allFunctions) {
                if (!fctV.getCobolName().equals(fct.getCobolName())) continue;
                toDelete.add(fctV);
            }
            allFunctions.removeAll(toDelete);
            allFunctions.add(fct);
        }
        if ((fct = (PdpFunction)((ITextProcessor)controller.getTextProcessor()).getGlobalContext().get("Mv_subfunction_el")) != null) {
            for (IVirtualFunction fctV : allFunctions) {
                if (!fctV.getCobolName().equals(fct.getCobolName())) continue;
                toDelete.add(fctV);
            }
            allFunctions.removeAll(toDelete);
            allFunctions.add(fct);
        }
        toDelete.clear();
        List allFunctionsNotInSpecific = (List)((ITextProcessor)controller.getTextProcessor()).getGlobalContext().get("Mv_subfunctions_to_restore");
        if (allFunctionsNotInSpecific != null && !allFunctionsNotInSpecific.isEmpty()) {
            for (IVirtualFunction fctV : allFunctions) {
                if (!allFunctionsNotInSpecific.contains(fctV.getCobolName())) continue;
                toDelete.add(fctV);
            }
            allFunctions.removeAll(toDelete);
        }
    }

    public static void saveSrcResource(IController controler) {
        try {
            IFile file = PdpTool.getFile((String)((Controller)controler).getResourceName());
            byte[] texte = controler.getTextProcessor().getText().toString().getBytes(file.getCharset());
            ByteArrayInputStream is = new ByteArrayInputStream(texte);
            if (file.exists()) {
                file.setContents((InputStream)is, 256, null);
            } else {
                PdpTool.createParentFolders((IContainer)file.getParent());
                file.create((InputStream)is, 256, null);
            }
        }
        catch (Exception e) {
            Util.rethrow((Throwable)e);
        }
    }

    public static enum VirtualMacroProcess {
        NONE,
        VIRT_ONLY,
        VIRT_AND_SP;

    }
}

