/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.generator;

import com.ibm.pdp.framework.PdpTool;
import java.util.ArrayList;

public class CobolWithConstants {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014, 2020.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String DATE_COMPILED = "DATE-COMPILED";
    private String cobolContent;
    private int constantsStartIndex;
    private int constantsStopIndex;
    private int dateStartIndex = -1;
    private int dateStopIndex = -1;
    private int nuversStartIndex = -1;
    private int nuversStopIndex = -1;
    private ArrayList<int[]> nuversIndexs = new ArrayList();
    private String NEW_LINE;

    CobolWithConstants(String cobolContent) {
        this.cobolContent = cobolContent;
        this.NEW_LINE = PdpTool.determineDelimiterOfV2((CharSequence)cobolContent);
    }

    boolean findDate() {
        int date_CompiledIndex = this.cobolContent.indexOf(DATE_COMPILED);
        if (date_CompiledIndex < 0) {
            return false;
        }
        int startOfLineIndex = this.cobolContent.lastIndexOf(this.NEW_LINE, date_CompiledIndex);
        if (startOfLineIndex < 0) {
            return false;
        }
        int nextLineIndex = this.cobolContent.indexOf(this.NEW_LINE, startOfLineIndex += this.NEW_LINE.length());
        this.dateStartIndex = startOfLineIndex;
        this.dateStopIndex = nextLineIndex + this.NEW_LINE.length();
        return true;
    }

    boolean findNuvers() {
        int lastNuversIndex = 0;
        int i = 0;
        while (i < this.cobolContent.length()) {
            int nuversIndex = this.cobolContent.substring(i).indexOf("NUVERS");
            if (nuversIndex < 0) {
                return this.nuversIndexs.size() != 0;
            }
            lastNuversIndex = i + nuversIndex;
            int startOfLineIndex = this.cobolContent.lastIndexOf(this.NEW_LINE, lastNuversIndex);
            if (startOfLineIndex < 0) {
                return this.nuversIndexs.size() != 0;
            }
            int nextLineIndex = this.cobolContent.indexOf(this.NEW_LINE, startOfLineIndex += this.NEW_LINE.length());
            this.nuversStartIndex = startOfLineIndex;
            this.nuversStopIndex = nextLineIndex + this.NEW_LINE.length();
            if (this.cobolContent.substring(this.nuversStartIndex, this.nuversStopIndex).indexOf("VALUE") != -1) {
                int[] ni = new int[]{this.nuversStartIndex, this.nuversStopIndex};
                this.nuversIndexs.add(ni);
            }
            i = this.nuversStopIndex;
            ++i;
        }
        return true;
    }

    boolean findPacConstants(String constants) {
        if (this.cobolContent == null || this.cobolContent.length() == 0) {
            return false;
        }
        int const_pac_index = this.cobolContent.indexOf(constants);
        if (const_pac_index != -1) {
            int startOfLineIndex;
            boolean clientCobol = false;
            if (constants.equals("PACBASE-CONSTANTS")) {
                int endOfFisrtLineIndex = this.cobolContent.indexOf(this.NEW_LINE, const_pac_index);
                int endofSecondLineIndex = this.cobolContent.indexOf(this.NEW_LINE, endOfFisrtLineIndex + 1);
                if (endofSecondLineIndex == -1) {
                    return false;
                }
                String firstCommentLine = this.cobolContent.substring(endOfFisrtLineIndex + this.NEW_LINE.length(), endofSecondLineIndex);
                if ((firstCommentLine = firstCommentLine.trim()).startsWith("* CLSV")) {
                    clientCobol = true;
                }
            }
            if ((startOfLineIndex = this.cobolContent.lastIndexOf(this.NEW_LINE, const_pac_index)) < 0) {
                return false;
            }
            int previousStartOfLine = startOfLineIndex += this.NEW_LINE.length();
            boolean firstLine = true;
            while (true) {
                int nextLineIndex;
                if ((nextLineIndex = this.cobolContent.indexOf(this.NEW_LINE, previousStartOfLine)) < 0) {
                    return false;
                }
                String line = this.cobolContent.substring(previousStartOfLine, nextLineIndex);
                if (line.length() < 9) {
                    return false;
                }
                if (line.substring(7, 9).equals("01")) {
                    if (firstLine) {
                        firstLine = false;
                    } else {
                        this.constantsStartIndex = startOfLineIndex;
                        this.constantsStopIndex = previousStartOfLine;
                        break;
                    }
                }
                if (clientCobol && line.trim().startsWith("05 DATSQ")) {
                    this.constantsStartIndex = startOfLineIndex;
                    this.constantsStopIndex = nextLineIndex + this.NEW_LINE.length();
                    break;
                }
                previousStartOfLine = nextLineIndex + this.NEW_LINE.length();
            }
            return true;
        }
        return false;
    }

    String getPacConstants() {
        if (this.constantsStartIndex != 0 && this.constantsStopIndex != 0) {
            return this.cobolContent.substring(this.constantsStartIndex, this.constantsStopIndex);
        }
        return null;
    }

    String getDate() {
        if (this.dateStartIndex != -1 && this.dateStopIndex != -1) {
            return this.cobolContent.substring(this.dateStartIndex, this.dateStopIndex);
        }
        return "";
    }

    String getCobolWithoutNuversDataAndConstants() {
        if (this.constantsStartIndex == this.constantsStopIndex) {
            return this.cobolContent;
        }
        this.cobolContent = this.getCobolWithoutNuvers(this.cobolContent);
        StringBuilder sb = new StringBuilder();
        if (this.dateStartIndex != -1 && this.dateStopIndex != -1 && this.dateStartIndex != this.dateStopIndex) {
            sb.append(this.cobolContent.substring(0, this.dateStartIndex));
            sb.append(this.cobolContent.substring(this.dateStopIndex, this.constantsStartIndex));
        } else {
            sb.append(this.cobolContent.substring(0, this.constantsStartIndex));
        }
        sb.append(this.cobolContent.substring(this.constantsStopIndex));
        return sb.toString();
    }

    String getCobolWithoutNuvers(String s) {
        if (this.nuversIndexs.size() == 0) {
            return s;
        }
        StringBuilder sb = new StringBuilder();
        int begin = 0;
        int i = 0;
        while (i < this.nuversIndexs.size()) {
            int[] ni = this.nuversIndexs.get(i);
            sb.append(s.substring(begin, ni[0]));
            begin = ni[1];
            ++i;
        }
        sb.append(s.substring(begin));
        return sb.toString();
    }
}

