/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.generator;

import com.ibm.pdp.engine.IBuilderTag;
import com.ibm.pdp.engine.IGeneratedInfo;
import com.ibm.pdp.engine.IGeneratedTag;
import com.ibm.pdp.engine.extension.ITextProcessorExtension;
import com.ibm.pdp.engine.internal.ITextProcessor;
import com.ibm.pdp.engine.turbo.impl.GenInfoBuilder;
import com.ibm.pdp.framework.ConsistencyCheckException;
import com.ibm.pdp.framework.Controller;
import com.ibm.pdp.framework.ControllerFactory;
import com.ibm.pdp.framework.PdpTool;
import com.ibm.pdp.framework.Trace;
import com.ibm.pdp.framework.interfaces.IController;
import com.ibm.pdp.framework.interfaces.IPattern;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.pacbase.PacTool;
import com.ibm.pdp.pacbase.PdpPacbasePlugin;
import com.ibm.pdp.pacbase.extension.organize.CobolAnalyzerDialog;
import com.ibm.pdp.pacbase.extension.organize.CobolAnalyzerGeneric;
import com.ibm.pdp.pacbase.extension.organize.CobolAnalyzerServer;
import com.ibm.pdp.pacbase.generator.AbstractPacbasePattern;
import com.ibm.pdp.pacbase.generator.CommonPacGeneratorLauncher;
import com.ibm.pdp.pacbase.generator.Messages;
import com.ibm.pdp.pacbase.generator.compare.ComparatorForGeneration;
import com.ibm.pdp.pacbase.pattern.PacDefaultTextProcessorExtension;
import com.ibm.pdp.trace.PTTraceManager;
import com.ibm.pdp.util.Strings;
import com.ibm.pdp.util.Util;
import com.ibm.pdp.util.strings.search.SearchCursor;
import com.ibm.pdp.util.strings.search.SubSequenceFinder;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.preference.IPreferenceStore;

public abstract class CobolPacbasePattern
extends AbstractPacbasePattern {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2016, 2018.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String START_PACBASE_CONSTANTS = "START_PACBASE_CONSTANTS";
    private static final String FILLER_X87_VALUE = "PICTURE X(87)";
    private static String[] labels = new String[2];
    public static final String PACBASE_REDEFINES_CONSTANTS_FR = " PAC-CONSTANTES REDEFINES";
    public static final String PACBASE_REDEFINES_CONSTANTS_EN = " CONSTANTS-PACBASE REDEFINES";
    public static final String PACBASE_CONSTANTS_FR = " CONSTANTES-PAC.";
    public static final String PACBASE_CONSTANTS_EN = " PACBASE-CONSTANTS.";
    public static final String DATE_COMPILED_TAG = "DATE-COMPILED";
    public static final String DATE_COMPILED = "DATE-COMPILED";
    public static final String CONSTANTS_TAG = "CONSTANTS";

    static {
        CobolPacbasePattern.labels[0] = PACBASE_CONSTANTS_FR;
        CobolPacbasePattern.labels[1] = PACBASE_CONSTANTS_EN;
    }

    @Override
    public ITextProcessorExtension getTextProcessorExtension() {
        return new PacDefaultTextProcessorExtension(this.getName());
    }

    @Override
    public boolean isDesignValidForGeneration(Object design, List<IController> controllers) {
        boolean result = super.isDesignValidForGeneration(design, controllers);
        if (!result) {
            return result;
        }
        return this.isCobolValidForGeneration(design, controllers);
    }

    protected IController getCOBOLController(String designPath) {
        List l = PdpTool.getControllersFromDesignPath((String)designPath, (IPattern)this);
        if (l != null && !l.isEmpty()) {
            for (IController iController : l) {
                if (!iController.getResourceName().endsWith("cbl")) continue;
                return iController;
            }
        }
        return null;
    }

    protected boolean isCobolValidForGeneration(Object design, List<IController> controllers) {
        block13: {
            if (design instanceof RadicalEntity) {
                IController controler;
                int structureChecking;
                block12: {
                    block11: {
                        RadicalEntity radicalEntity = (RadicalEntity)design;
                        IPreferenceStore store = PdpPacbasePlugin.getDefault().getPreferenceStore();
                        structureChecking = 0;
                        if (store.contains("com.ibm.pdp.pacbase.preferences.structurecontrol")) {
                            structureChecking = store.getInt("com.ibm.pdp.pacbase.preferences.structurecontrol");
                        }
                        controler = null;
                        if (controllers == null || controllers.size() == 0) {
                            controllers = PdpTool.getControllersFromDesignPath((String)radicalEntity.getDesignId(radicalEntity.getProject()), (IPattern)this);
                        }
                        for (IController iController : controllers) {
                            if (!iController.getResourceName().endsWith("cbl")) continue;
                            controler = iController;
                            break;
                        }
                        if (controler != null && (!(controler instanceof Controller) || ((Controller)controler).getMigrationWarnings() == null)) break block11;
                        return true;
                    }
                    String generationMode = (String)((ITextProcessor)controler.getTextProcessor()).getGlobalContext().get("generation_mode");
                    if (generationMode == null || !generationMode.equals("from_wizard")) break block12;
                    return true;
                }
                try {
                    if ("true".equals(System.getProperty("enableVirtualMacroRegen"))) {
                        PacTool.CorrectC9FileIfNeeded(controler);
                        CommonPacGeneratorLauncher.saveSrcResource(controler);
                    }
                    this.message = "";
                    CobolAnalyzerGeneric cag = null;
                    String pattern = controler.getPattern().getName();
                    cag = "com.ibm.pdp.pacbase.csclient".equals(pattern) || "com.ibm.pdp.pacbase.dialog".equals(pattern) ? new CobolAnalyzerDialog() : ("com.ibm.pdp.pacbase.csserver".equals(pattern) ? new CobolAnalyzerServer() : new CobolAnalyzerGeneric());
                    cag.analyze(controler.getTextProcessor(), controler);
                }
                catch (ConsistencyCheckException cce) {
                    this.message = cce.getMessage();
                    if (this.message == null || this.message.trim().length() <= 0) break block13;
                    ControllerFactory.getInstance().dispose(controler);
                    if (structureChecking != 2) {
                        if (structureChecking == 1) {
                            this.writeLog(cce.getMessage(), controler);
                        }
                        return false;
                    }
                    this.writeLog(cce.getMessage(), controler);
                    return true;
                }
            }
        }
        return true;
    }

    public static IGeneratedInfo allignConstantsAndDate(IGeneratedInfo refGenInfo, String specificCobolFile, String constants) {
        String NEW_LINE = PdpTool.determineDelimiterOfV2((CharSequence)specificCobolFile);
        String NEW_LINE_MIA = PdpTool.determineDelimiterOfV2((CharSequence)refGenInfo.getText());
        StringBuilder constantBloc = new StringBuilder();
        int const_pac_index = specificCobolFile.indexOf(constants);
        if (const_pac_index != -1) {
            int startOfLineIndex = specificCobolFile.lastIndexOf(NEW_LINE, const_pac_index);
            if (startOfLineIndex < 0) {
                return refGenInfo;
            }
            int previousStartOfLine = startOfLineIndex += NEW_LINE.length();
            boolean firstLine = true;
            while (true) {
                int nextLineIndex;
                if ((nextLineIndex = specificCobolFile.indexOf(NEW_LINE, previousStartOfLine)) < 0) {
                    return refGenInfo;
                }
                String line = specificCobolFile.substring(previousStartOfLine, nextLineIndex);
                if (line.substring(7, 9).equals("01")) {
                    if (!firstLine) break;
                    firstLine = false;
                }
                constantBloc.append(line);
                constantBloc.append(NEW_LINE_MIA);
                previousStartOfLine = nextLineIndex + NEW_LINE.length();
            }
        }
        if (constantBloc.length() == 0) {
            return refGenInfo;
        }
        int date_CompiledIndex = specificCobolFile.indexOf("DATE-COMPILED");
        if (date_CompiledIndex < 0) {
            return refGenInfo;
        }
        int startOfLineIndex = specificCobolFile.lastIndexOf(NEW_LINE, date_CompiledIndex);
        if (startOfLineIndex < 0) {
            return refGenInfo;
        }
        int nextLineIndex = specificCobolFile.indexOf(NEW_LINE, startOfLineIndex += NEW_LINE.length());
        String date = String.valueOf(specificCobolFile.substring(startOfLineIndex, nextLineIndex)) + NEW_LINE_MIA;
        GenInfoBuilder gibuild = new GenInfoBuilder(refGenInfo);
        IBuilderTag tag = gibuild.tagFromName(CONSTANTS_TAG);
        if (tag != null) {
            tag.setText((CharSequence)constantBloc);
        }
        if ((tag = gibuild.tagFromName("DATE-COMPILED")) != null) {
            tag.setText((CharSequence)date);
        }
        return gibuild.toGeneratedInfo();
    }

    private void writeLog(String message, IController controler) {
        String newLine = System.getProperty("line.separator");
        StringBuffer buffer = new StringBuffer();
        buffer.append("Error : " + message + newLine);
        buffer.append(String.valueOf(newLine) + "###################" + newLine);
        buffer.append("##### COBOL   #####" + newLine);
        buffer.append("###################" + newLine);
        buffer.append(controler.getTextProcessor().getText());
        buffer.append(String.valueOf(newLine) + "############################" + newLine);
        buffer.append("##### GENERATED INFO   #####" + newLine);
        buffer.append("############################" + newLine);
        buffer.append(controler.getTextProcessor().getGeneratedInfo());
        File log = new File(CobolPacbasePattern.GetFileFromPath("PdpEditorLog", ".txt").getAbsolutePath());
        try {
            FileWriter fw = new FileWriter(log);
            PrintWriter pw = new PrintWriter(fw);
            pw.write(buffer.toString());
            fw.close();
        }
        catch (IOException ioe) {
            Util.rethrow((Throwable)ioe);
        }
    }

    private static File GetFileFromPath(String fileName, String suffix) {
        File temp = null;
        try {
            temp = File.createTempFile(fileName, suffix, new File(System.getProperty("java.io.tmpdir")));
        }
        catch (IOException ioex) {
            Util.rethrow((Throwable)ioex);
        }
        return temp;
    }

    @Override
    public String getGeneratedInfoIdentifier(CharSequence completeSourceCode) {
        long debut = System.currentTimeMillis();
        SubSequenceFinder ssf = Strings.newSubSequenceFinder();
        boolean found = false;
        int i = 0;
        int[][] idx = new int[2][2];
        while (i < 2 && !found) {
            idx = this.searchPacbaseConstantsStartAndEndPoint((SubSequenceFinder<String>)ssf, labels[i], completeSourceCode);
            if (idx != null) {
                if (this.isControlOf1stOccurrenceOK(completeSourceCode, idx[0][0]) && this.isControlOf2ndOccurrenceOK(completeSourceCode, idx[1][0], labels[i])) {
                    found = true;
                    break;
                }
                found = false;
                break;
            }
            ++i;
        }
        if (!found) {
            return "";
        }
        boolean englishGenerationLanguage = i == 1;
        String pacConstantsCompleteBlock = completeSourceCode.subSequence(idx[0][1], idx[1][0]).toString();
        String result = this.getGeneratedInfoIdentifier(pacConstantsCompleteBlock, englishGenerationLanguage);
        long fin = System.currentTimeMillis();
        if (Trace.traceOn) {
            Trace.outPrintln((String)("AbstractPacbasePattern.getGeneratedInfoIdentifier(CharSequence) elapsed = " + (fin - debut)));
        }
        return result;
    }

    private String getGeneratedInfoIdentifier(CharSequence pacConstantsCompleteBlock, boolean englishGenerationLanguage) {
        char ch;
        int j;
        String CR = "\r\n";
        PTTraceManager traceManager = PTTraceManager.getInstance();
        int engineTraceLevel = traceManager.getTraceLevel("com.ibm.pdp.pac");
        if (engineTraceLevel > 0) {
            String message = "---------------------------------Enter getGeneratedInfoIdentifier(CharSequence, boolean) : " + CR + "\tpacConstantsCompleteBlock = " + pacConstantsCompleteBlock + CR + "\tenglishGenerationLanguage = " + englishGenerationLanguage + CR;
            traceManager.trace(this.getClass(), "com.ibm.pdp.framework", 1, message);
        }
        if ((j = pacConstantsCompleteBlock.toString().indexOf(FILLER_X87_VALUE)) == -1) {
            return "";
        }
        CharSequence pacCstAfterFiller = pacConstantsCompleteBlock.subSequence(j + FILLER_X87_VALUE.length(), pacConstantsCompleteBlock.length());
        if (pacCstAfterFiller.length() < 121) {
            return "";
        }
        int pacCstAfterFillerLength = pacCstAfterFiller.length();
        int startIndexOfLine = -1;
        int k = 0;
        while (k < pacCstAfterFillerLength) {
            ch = pacCstAfterFiller.charAt(k);
            if (ch == '\n') {
                startIndexOfLine = k + 1;
                break;
            }
            ++k;
        }
        if (startIndexOfLine == -1) {
            return "";
        }
        CharSequence linesContainingData = pacCstAfterFiller.subSequence(startIndexOfLine, pacCstAfterFillerLength);
        String lheure = linesContainingData.subSequence(52, 60).toString();
        startIndexOfLine = -1;
        int k2 = 0;
        while (k2 < linesContainingData.length()) {
            ch = linesContainingData.charAt(k2);
            if (ch == '\n') {
                startIndexOfLine = k2 + 1;
                break;
            }
            ++k2;
        }
        if (startIndexOfLine == -1) {
            return "";
        }
        String line2OfData = linesContainingData.subSequence(startIndexOfLine, linesContainingData.length()).toString();
        int apostrophIdx = line2OfData.indexOf(39);
        if (apostrophIdx == -1) {
            return "";
        }
        String laDate = line2OfData.subSequence(apostrophIdx + 1, apostrophIdx + 11).toString();
        String result = this.convertDateTimeIntoTimeStamp(laDate, lheure, englishGenerationLanguage);
        if (engineTraceLevel > 0) {
            String message = "getGeneratedInfoIdentifier returns : " + result + CR + "---------------------------------" + CR;
            traceManager.trace(this.getClass(), "com.ibm.pdp.framework", 1, message);
        }
        return result;
    }

    @Override
    public String getGeneratedInfoIdentifier(IGeneratedInfo genInfo) {
        IGeneratedTag dataDivisionTag = this.getDataDivisionTag(genInfo.getRootTag());
        if (dataDivisionTag != null) {
            CharSequence pacConstants = genInfo.getText().subSequence(dataDivisionTag.getBeginIndex(), dataDivisionTag.getEndIndex());
            boolean englishGenerationLanguage = true;
            int i = pacConstants.toString().indexOf(PACBASE_CONSTANTS_FR);
            if (i > -1) {
                englishGenerationLanguage = false;
            }
            String result = this.getGeneratedInfoIdentifier(pacConstants, englishGenerationLanguage);
            return result;
        }
        return "";
    }

    private String convertDateTimeIntoTimeStamp(String laDate, String lHeure, boolean englishGenerationLanguage) {
        String year = null;
        String month = null;
        String day = null;
        year = laDate.substring(6);
        month = laDate.substring(3, 5);
        day = laDate.substring(0, 2);
        StringBuilder timestampResult = new StringBuilder(year);
        timestampResult.append(month);
        timestampResult.append(day);
        timestampResult.append('-');
        timestampResult.append(lHeure);
        return timestampResult.toString();
    }

    private IGeneratedTag getDataDivisionTag(IGeneratedTag tag) {
        if (tag == null) {
            return null;
        }
        if (CONSTANTS_TAG.equals(tag.getName())) {
            return tag;
        }
        Iterator sons = tag.sons();
        while (sons.hasNext()) {
            IGeneratedTag sontag = this.getDataDivisionTag((IGeneratedTag)sons.next());
            if (sontag == null) continue;
            return sontag;
        }
        return null;
    }

    private boolean isControlOf1stOccurrenceOK(CharSequence completeSourceCode, int idx) {
        CharSequence cs;
        String level;
        int lineStartIndex = this.returnLineStartIndex(completeSourceCode, idx);
        int k = lineStartIndex;
        return k > 0 && k + 8 < idx && completeSourceCode.charAt(k + 6) == ' ' && (level = (cs = completeSourceCode.subSequence(k + 7, idx)).toString().trim()).length() == 2 && Character.isDigit(level.charAt(0)) && Character.isDigit(level.charAt(1));
    }

    private boolean isControlOf2ndOccurrenceOK(CharSequence completeSourceCode, int idx, String label) {
        int lineStartIndex = this.returnLineStartIndex(completeSourceCode, idx);
        int k = lineStartIndex;
        if (k > 0 && k + 8 < idx && completeSourceCode.charAt(k + 6) == ' ') {
            CharSequence cs = completeSourceCode.subSequence(k + 7, idx);
            String str = cs.toString();
            int j = -1;
            j = label.equals(PACBASE_CONSTANTS_FR) ? str.indexOf(PACBASE_REDEFINES_CONSTANTS_FR) : str.indexOf(PACBASE_REDEFINES_CONSTANTS_EN);
            if (j == -1) {
                return false;
            }
            String level = cs.subSequence(0, j).toString().trim();
            if (level.length() == 2 && Character.isDigit(level.charAt(0)) && Character.isDigit(level.charAt(1))) {
                return true;
            }
        }
        return false;
    }

    private int returnLineStartIndex(CharSequence completeSourceCode, int k) {
        int c = 32;
        while (k >= 0) {
            c = completeSourceCode.charAt(k);
            if (c == 10) {
                return k + 1;
            }
            --k;
        }
        return -1;
    }

    private int[][] searchPacbaseConstantsStartAndEndPoint(SubSequenceFinder<String> ssf, String label, CharSequence completeSourceCode) {
        int[][] idx = new int[2][2];
        ssf.removeAllSubSequenceToFind();
        ssf.addSubSequenceToFind((CharSequence)label, (Object)START_PACBASE_CONSTANTS);
        SearchCursor searchCursor = ssf.newSearchCursor(completeSourceCode);
        int i = 0;
        while (i < 2 && searchCursor.search()) {
            idx[i][0] = searchCursor.getSubSequenceBeginIndex();
            idx[i][1] = searchCursor.getSubSequenceEndIndex();
            ++i;
        }
        if (i != 2 || idx[0][0] >= idx[0][1] || idx[0][1] >= idx[1][0] || idx[0][1] >= idx[1][1] || idx[0][0] < 0 || idx[1][1] > completeSourceCode.length()) {
            return null;
        }
        return idx;
    }

    @Override
    public boolean isPreviewPossible(String designPath) {
        IController cont = this.getCOBOLController(designPath);
        if (cont == null) {
            return false;
        }
        if (cont instanceof Controller) {
            Controller c = (Controller)cont;
            return c.getMigrationWarnings() == null || c.getMigrationWarnings().getWarningsList().isEmpty();
        }
        return false;
    }

    @Override
    public boolean showPreview(IController cblDuplicatedController, IController cblSourceController) {
        ComparatorForGeneration cfg = new ComparatorForGeneration(true, false);
        if (!cfg.showCompareTool(cblSourceController, cblDuplicatedController)) {
            throw new OperationCanceledException(Messages.PacGeneratorLabels_OPER_CANCELED_DURING_PREVIEW);
        }
        return true;
    }
}

