/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.generator;

import com.ibm.pdp.framework.PdpTool;
import com.ibm.pdp.pacbase.generator.CobolWithConstants;

public class CobolCompare {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014-2020.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String CONSTANTES_PAC = "CONSTANTES-PAC";
    public static final String PACBASE_CONSTANTS = "PACBASE-CONSTANTS";

    public static boolean compareFile(String cobolFileName1, String cobolFileName2) {
        String cobolContent1 = PdpTool.readFileContents((String)cobolFileName1);
        String cobolContent2 = PdpTool.readFileContents((String)cobolFileName2);
        return CobolCompare.compare(cobolContent1, cobolContent2);
    }

    public static boolean compare(String cobol1, String cobol2) {
        return CobolCompare.compare(cobol1, cobol2, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean compare(String cobol1, String cobol2, boolean compareConstants) {
        boolean found2;
        String cobolContent1 = cobol1;
        String cobolContent2 = cobol2;
        CobolWithConstants cob1 = new CobolWithConstants(cobolContent1);
        CobolWithConstants cob2 = new CobolWithConstants(cobolContent2);
        boolean found1 = cob1.findPacConstants(CONSTANTES_PAC);
        if (found1) {
            found2 = cob2.findPacConstants(CONSTANTES_PAC);
            if (!found2) return cobolContent1.equals(cobolContent2);
            cob1.findDate();
            cob2.findDate();
            cob1.findNuvers();
            cob2.findNuvers();
        } else {
            found1 = cob1.findPacConstants(PACBASE_CONSTANTS);
            if (!found1) return cobolContent1.equals(cobolContent2);
            found2 = cob2.findPacConstants(PACBASE_CONSTANTS);
            if (found2) {
                cob1.findDate();
                cob2.findDate();
                cob1.findNuvers();
                cob2.findNuvers();
            }
        }
        String cobol1WithoutConstants = compareConstants ? cobolContent1 : cob1.getCobolWithoutNuversDataAndConstants();
        String cobol2WithoutConstants = compareConstants ? cobolContent2 : cob2.getCobolWithoutNuversDataAndConstants();
        return cobol1WithoutConstants.equals(cobol2WithoutConstants);
    }
}

