/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.generator;

import com.ibm.pdp.engine.IGeneratedInfo;
import com.ibm.pdp.engine.ITextProcessor;
import com.ibm.pdp.engine.TextStatus;
import com.ibm.pdp.engine.extension.ITextProcessorExtension;
import com.ibm.pdp.engine.tree.ITextNode;
import com.ibm.pdp.explorer.editor.service.PTEditorService;
import com.ibm.pdp.framework.PdpConstants;
import com.ibm.pdp.framework.editor.design.designview.EmptyDesignModelManager;
import com.ibm.pdp.framework.interfaces.IController;
import com.ibm.pdp.framework.interfaces.IDesignLink;
import com.ibm.pdp.framework.interfaces.IDesignModelManager;
import com.ibm.pdp.framework.interfaces.IEditorContextualMenuBuilder;
import com.ibm.pdp.framework.interfaces.IGSVContextualMenuBuilder;
import com.ibm.pdp.framework.interfaces.IGenResult;
import com.ibm.pdp.framework.interfaces.IGenerationContext;
import com.ibm.pdp.framework.interfaces.IGeneratorLauncher;
import com.ibm.pdp.framework.interfaces.IModelComparator;
import com.ibm.pdp.framework.interfaces.internal.IPacPattern;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.link.design.MicroPatternsAndDEUsagesResults;
import com.ibm.pdp.pacbase.design.ModelUtil;
import com.ibm.pdp.pacbase.generator.PacSourceDerivationDesign;
import com.ibm.pdp.pacbase.xrefs.CobolMicroPatternsAndDEUsagesParser;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;

public abstract class AbstractPacbasePattern
implements IPacPattern {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2022.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected String message;

    public String getDesignViewID() {
        return null;
    }

    public IModelComparator getModelComparator() {
        return null;
    }

    public abstract IGeneratorLauncher getGeneratorLauncher();

    public Object getDesign(String entryPoint) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFile file = root.getFile((IPath)new Path(entryPoint));
        RadicalEntity obj = ModelUtil.getSharedRadicalEntity(file);
        return obj;
    }

    public String getDesignName(Object design) {
        if (design instanceof PacSourceDerivationDesign) {
            return ((PacSourceDerivationDesign)design).getDesign().getName();
        }
        if (design instanceof RadicalEntity) {
            return ((RadicalEntity)design).getName();
        }
        return design.toString();
    }

    public boolean isDesignValidForGeneration(Object design) {
        return this.isDesignValidForGeneration(design, null);
    }

    public boolean isDesignValidForGeneration(Object design, List<IController> controllers) {
        int resolvingMode = PTEditorService.getResolvingMode();
        PTEditorService.setResolvingMode((int)3);
        try {
            boolean bl = this.getGeneratorLauncher().isGenerationPossible(design);
            return bl;
        }
        finally {
            PTEditorService.setResolvingMode((int)resolvingMode);
        }
    }

    public String getDetailedMessageForInvalidDesign() {
        return this.message;
    }

    public IGenResult generate(List<IController> controllers, Object design, IProgressMonitor monitor, IGenerationContext context) {
        int resolvingMode = PTEditorService.getResolvingMode();
        PTEditorService.setResolvingMode((int)3);
        try {
            RadicalEntity re = null;
            if (design instanceof RadicalEntity) {
                re = (RadicalEntity)design;
            } else if (design instanceof PacSourceDerivationDesign) {
                re = ((PacSourceDerivationDesign)design).getDesign();
            }
            String designFilePath = re.getPath(re.getProject()).toString();
            IGenResult iGenResult = this.getGeneratorLauncher().generate2(controllers, design, designFilePath, monitor, context);
            return iGenResult;
        }
        finally {
            PTEditorService.setResolvingMode((int)resolvingMode);
        }
    }

    public IGenResult generate(Object design, IProgressMonitor monitor) {
        return this.generate(null, design, monitor, null);
    }

    public String getGeneratedInfoIdentifier(CharSequence completeSourceCode) {
        return "";
    }

    public String getGeneratedInfoIdentifier(IGeneratedInfo genInfo) {
        return "";
    }

    public boolean isTextProcessorValidForBackup(ITextProcessor textProcessor) {
        TextStatus textStatus;
        ITextNode node = textProcessor.getEditTree().nodeFromTagName("CONSTANTS");
        return node != null && (textStatus = node.getTextStatus()) == TextStatus.Unchanged;
    }

    private void dealWithCrossReferences(IController controler) {
        CobolMicroPatternsAndDEUsagesParser drf = new CobolMicroPatternsAndDEUsagesParser();
        MicroPatternsAndDEUsagesResults drr = null;
        String logicalFileName = null;
        try {
            logicalFileName = controler.getGenerationLink().getGenerationOutput().getLogicalFileName();
            drr = drf.parse(logicalFileName, controler);
        }
        catch (Exception e) {
            e.printStackTrace();
            String mess = "AbstractPacbasePattern.dealWithCrossReferences. Processing of " + logicalFileName + ". Error : " + e.getMessage();
            Status status = new Status(4, "com.ibm.pdp.pacbase", mess, (Throwable)e);
            Bundle bundle = Platform.getBundle((String)"com.ibm.pdp.pacbase");
            ILog log = Platform.getLog((Bundle)bundle);
            log.log((IStatus)status);
        }
        if (drr != null) {
            controler.getDesignLink().setMicroPatternReferences(drr.getMicroPatternRefs());
            controler.getDesignLink().setRubriquesUsagesReferences(drr.getDetailedUsages());
        }
    }

    public void hookJustBeforeSave(IController controler) {
        IGeneratedInfo genInfo = controler.getTextProcessor().getGeneratedInfo();
        String prop = genInfo.getProperty("Reconcile");
        if (prop != null && prop.equals("false")) {
            return;
        }
        this.dealWithCrossReferences(controler);
    }

    protected boolean isOsSupported() {
        return PdpConstants.IS_SUPPORTED_OS;
    }

    public String getVersion() {
        return "1.0.0";
    }

    public IGeneratedInfo getNewGeneratedInfoForSpecialEquality(IGeneratedInfo genInfoAfterGeneration, String contentBeforeGeneration, String contentAfterGeneration) {
        return null;
    }

    public IDesignModelManager getDesignModelManager(IDesignLink designLink, String designFileId) {
        return new EmptyDesignModelManager(designLink, designFileId);
    }

    public IGSVContextualMenuBuilder getGSVContextualMenuBuilder() {
        return null;
    }

    public IEditorContextualMenuBuilder getEditorContextualMenuBuilder() {
        return null;
    }

    public ITextProcessorExtension getTextProcessorExtension() {
        return null;
    }

    public boolean canOverwriteGeneratedFileFromOtherDesign() {
        return false;
    }

    public boolean isPreviewPossible(String designPath) {
        return false;
    }

    public boolean showPreview(IController cblDuplicatedController, IController cblSourceController) {
        return false;
    }
}

