/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.filters;

import com.ibm.pdp.engine.ITextProcessor;
import com.ibm.pdp.engine.extension.IEditTreeExtension;
import com.ibm.pdp.engine.extension.ITextAnalyzer;
import com.ibm.pdp.engine.extension.ITextScanner;
import com.ibm.pdp.framework.ControllerFactory;
import com.ibm.pdp.framework.PdpTool;
import com.ibm.pdp.framework.interfaces.IController;
import com.ibm.pdp.framework.interfaces.IGeneratedCodeStructureTreeView;
import com.ibm.pdp.pacbase.filters.CommonPacFoldingAction;
import com.ibm.pdp.pacbase.filters.Messages;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.Position;

public class ShowTitlesOfPacFunctionsAction
extends CommonPacFoldingAction {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2011, 2014.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static String TITLES_OF_FUNCTIONS = Messages.ShowTitlesOfPacFunctionsAction_TITLES_OF_FUNCTIONS;

    public ShowTitlesOfPacFunctionsAction(IGeneratedCodeStructureTreeView gsv) {
        super(gsv);
    }

    protected List<Integer> findIndexes() {
        ArrayList<Integer> hiddenBlocksOffsets = new ArrayList<Integer>();
        ITextProcessor textProcessor = this._gsv.getController().getTextProcessor();
        CharSequence cs = textProcessor.getText();
        int index = 0;
        List lines = PdpTool.splitsInLine((CharSequence)cs);
        int linesSize = lines.size();
        int i = 0;
        boolean finished = false;
        while (i < linesSize && !finished) {
            String aLine = (String)lines.get(i);
            if (aLine.indexOf(" IDENTIFICATION DIVISION.") != -1) {
                hiddenBlocksOffsets.add(new Integer(index));
            } else if (aLine.indexOf(" ENVIRONMENT DIVISION.") != -1) {
                hiddenBlocksOffsets.add(new Integer(index));
                hiddenBlocksOffsets.add(new Integer(index));
            } else if (aLine.indexOf(" DATA DIVISION.") != -1) {
                hiddenBlocksOffsets.add(new Integer(index));
                hiddenBlocksOffsets.add(new Integer(index));
            } else if (aLine.indexOf(" PROCEDURE DIVISION") != -1) {
                hiddenBlocksOffsets.add(new Integer(index));
                hiddenBlocksOffsets.add(new Integer(index));
                finished = true;
            }
            index += aLine.length();
            ++i;
        }
        String fileName = this._gsv.getController().getResourceName();
        IController controler = ControllerFactory.getInstance().getController(fileName);
        IEditTreeExtension iete = controler.getPattern().getTextProcessorExtension().getEditTreeExtension();
        ITextAnalyzer psta = iete.newTextAnalyzer();
        psta.setEditTree(textProcessor.getEditTree());
        psta.setText(textProcessor.getText());
        ITextScanner scanner = psta.newScanner(index, textProcessor.getTextLength());
        while (scanner.scan()) {
            boolean b;
            String tagName;
            String value;
            Map properties = scanner.getTagProperties();
            if (properties == null || (value = (String)properties.get("category")) == null || !value.equals("pac_function") || (tagName = scanner.getTagName()).length() != 3 || !(b = scanner.isBeginIndex())) continue;
            int idx = scanner.index();
            String value2 = (String)properties.get("StartingOffsetWithoutComment");
            if (value2 != null) {
                idx = Integer.parseInt(value2);
            }
            hiddenBlocksOffsets.add(new Integer(idx));
            hiddenBlocksOffsets.add(new Integer(idx));
        }
        hiddenBlocksOffsets.add(textProcessor.getTextLength());
        return hiddenBlocksOffsets;
    }

    protected List<Position> computeIndexes() {
        List<Integer> values = this.findIndexes();
        List positions = this.convertList(values);
        return positions;
    }

    public String getText() {
        return TITLES_OF_FUNCTIONS;
    }

    public String getToolTipText() {
        return TITLES_OF_FUNCTIONS;
    }

    public boolean isEnabled() {
        return true;
    }
}

