/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.extension.reconciler;

import com.ibm.pdp.engine.IGeneratedInfo;
import com.ibm.pdp.engine.IGeneratedTag;
import com.ibm.pdp.engine.IProblem;
import com.ibm.pdp.engine.extension.IReconcileLocation;
import com.ibm.pdp.engine.extension.IReconcileLocationInterval;
import com.ibm.pdp.engine.extension.IReconcileTextInterval;
import com.ibm.pdp.engine.extension.ITextAnalyzer;
import com.ibm.pdp.engine.extension.ITextScanner;
import com.ibm.pdp.engine.extension.ITracerDelegate;
import com.ibm.pdp.engine.internal.IReconcileExtension;
import com.ibm.pdp.engine.turbo.core.AtomicPartSegment;
import com.ibm.pdp.engine.turbo.core.AtomicTagSegment;
import com.ibm.pdp.engine.turbo.core.ChangeNature;
import com.ibm.pdp.engine.turbo.core.HierarchicSegment;
import com.ibm.pdp.engine.turbo.core.Segment;
import com.ibm.pdp.engine.turbo.core.SyntacticTagSegment;
import com.ibm.pdp.engine.turbo.core.UserChangeSet;
import com.ibm.pdp.engine.turbo.reconcile.IReconcilerState;
import com.ibm.pdp.engine.turbo.reconcile.ReconcileConstants;
import com.ibm.pdp.engine.turbo.reconcile.ReconcileLocation;
import com.ibm.pdp.engine.turbo.reconcile.ReconcileProblem;
import com.ibm.pdp.engine.turbo.reconcile.ReconcileUtil;
import com.ibm.pdp.engine.turbo.reconcile.ReconcilerState;
import com.ibm.pdp.pacbase.PacConstants;
import com.ibm.pdp.pacbase.PacTool;
import com.ibm.pdp.pacbase.extension.Ebcdic;
import com.ibm.pdp.pacbase.extension.reconciler.Messages;
import com.ibm.pdp.pacbase.extension.reconciler.PacbaseReconcileTextInterval;
import com.ibm.pdp.pacbase.util.EBCDICCompare;
import com.ibm.pdp.trace.PTTraceManager;
import com.ibm.pdp.util.Util;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.Differencer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.graphics.Image;

public class PacbaseReconcileExtension
implements IReconcileExtension,
PacConstants {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2011, 2019.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String _currentFunctionName = null;
    private List<HierarchicSegment> _artificialCreateSegments = new ArrayList<HierarchicSegment>();
    private List<String> _mvTagsNames = new ArrayList<String>();
    private List<PendingReconcileItem> _pendingReconcileItems = new ArrayList<PendingReconcileItem>();
    private List<TextRemovedPendingReconcileItem> _textRemovedPendingReconcileItems = new ArrayList<TextRemovedPendingReconcileItem>();
    private ITracerDelegate tracer = null;
    private List<IGeneratedTag> _artificialCreateTags = new ArrayList<IGeneratedTag>();

    public PacbaseReconcileExtension() {
        this.reset();
    }

    private void reset() {
        this._artificialCreateTags.clear();
        this._artificialCreateSegments.clear();
        this._mvTagsNames.clear();
        this._pendingReconcileItems.clear();
        this._textRemovedPendingReconcileItems.clear();
    }

    private void reconcileExtensionStartHook() {
        if (this.getTracerDelegate().isDebugModeEnabled()) {
            this.getTracerDelegate().debug((Object)this, "reconcileExtensionStartHook", "Reconcile extension start hook");
        }
    }

    private void reconcileExtensionEndHook() {
        if (this.getTracerDelegate().isDebugModeEnabled()) {
            this.getTracerDelegate().debug((Object)this, "reconcileExtensionStartHook", "Reconcile extension end hook");
        }
    }

    public Iterator<IProblem.IQuickFixAction> actions(IProblem problem) {
        ArrayList<ShowDifferenceQuickFixAction> actions = new ArrayList<ShowDifferenceQuickFixAction>();
        if (this.getTracerDelegate().isDebugModeEnabled()) {
            ShowDifferenceQuickFixAction quickFixAction = new ShowDifferenceQuickFixAction(problem);
            actions.add(quickFixAction);
        }
        return actions.iterator();
    }

    private ITracerDelegate getTracerDelegate() {
        if (this.tracer == null) {
            this.tracer = new ITracerDelegate(){

                public boolean isDebugModeEnabled() {
                    return PTTraceManager.getInstance().getTraceLevel("com.ibm.pdp.framework.reconciler") > 0;
                }

                public void info(Object sourceObject, String methodName, String message) {
                    PTTraceManager.getInstance().trace(sourceObject == null ? PacbaseReconcileExtension.this.getClass() : sourceObject.getClass(), "com.ibm.pdp.framework.reconciler", 1, String.valueOf(methodName) + "() " + message);
                }

                public void debug(Object sourceObject, String methodName, String message) {
                    PTTraceManager.getInstance().trace(sourceObject == null ? PacbaseReconcileExtension.this.getClass() : sourceObject.getClass(), "com.ibm.pdp.framework.reconciler", 3, String.valueOf(methodName) + "() " + message);
                }
            };
        }
        return this.tracer;
    }

    public List<IReconcileTextInterval> dispatchReconcileTextIntervals(List<IReconcileLocationInterval> reconcileLocationAreas, List<IReconcileTextInterval> reconcileAreas, List<IProblem> problems, ITextAnalyzer textAnalyzer) {
        Util.rethrow((Throwable)new Exception("MUST NOT BE CALLED"));
        return null;
    }

    public List<IReconcileTextInterval> dispatchReconcileTextIntervals(List<IReconcileLocationInterval> reconcileLocationAreas, List<IReconcileTextInterval> reconcileAreas, List<IProblem> problems, ITextAnalyzer textAnalyzer, Object userChangeSet) {
        if (this.isMacroVirtualEnabled(((UserChangeSet)userChangeSet).getGeneratedInfo())) {
            return reconcileAreas;
        }
        ArrayList<IReconcileTextInterval> rejectedReconcileIntervals = new ArrayList<IReconcileTextInterval>();
        this.reconcileExtensionStartHook();
        String text = "";
        for (IReconcileTextInterval reconcileTextInterval : reconcileAreas) {
            if (reconcileTextInterval.isNewGeneratedText()) continue;
            text = String.valueOf(text) + reconcileTextInterval.getText();
        }
        if (text.length() == 0) {
            text = null;
        } else {
            ArrayList<IReconcileLocationInterval> otherIntervals = new ArrayList<IReconcileLocationInterval>();
            otherIntervals.addAll(reconcileLocationAreas);
            for (IReconcileLocationInterval reconcileLocationArea : reconcileLocationAreas) {
                otherIntervals.remove(reconcileLocationArea);
                text = this.dispatchReconcileArea(reconcileLocationArea, otherIntervals, text, textAnalyzer);
                if (text == null) break;
            }
        }
        if (text != null) {
            rejectedReconcileIntervals.add(new PacbaseReconcileTextInterval(null, text));
        }
        this.reconcileExtensionEndHook();
        return rejectedReconcileIntervals;
    }

    private String dispatchReconcileArea(IReconcileLocationInterval reconcileLocationArea, List<IReconcileLocationInterval> otherIntervals, String text, ITextAnalyzer textAnalyzer) {
        StringBuilder builder;
        block12: {
            List<PacFonction> pacFonctions;
            ArrayList<PacBlock> pacBlocks;
            int currentIndex;
            String ttName;
            String ftName;
            block11: {
                reconcileLocationArea.getReconcileAreas().clear();
                if (textAnalyzer == null) {
                    return text;
                }
                ftName = reconcileLocationArea.getStartReconcileLocation().fromTagName();
                ttName = reconcileLocationArea.getEndReconcileLocation().toTagName();
                currentIndex = 0;
                pacBlocks = new ArrayList<PacBlock>();
                pacFonctions = this.getPacFonctions(textAnalyzer, text);
                if (!pacFonctions.isEmpty()) break block11;
                PacBlock pacBlock = new PacBlock();
                pacBlock.beginIndex = 0;
                pacBlock.endIndex = text.length();
                reconcileLocationArea.getReconcileAreas().add(new PacbaseReconcileTextInterval(pacBlock, text));
                return null;
            }
            try {
                int nbFunctionAdded = 0;
                for (PacFonction pacFonction : pacFonctions) {
                    if (ttName == null || ftName == null) continue;
                    String currentPacFunctionName = pacFonction.name;
                    if (pacFonction.tagName != null || !this.isFunctionOrdered()) continue;
                    int ftComp = Ebcdic.stringCompare(ftName, currentPacFunctionName);
                    int ttComp = Ebcdic.stringCompare(currentPacFunctionName, ttName);
                    if (ftComp >= 0 || ttComp >= 0) continue;
                    if (pacFonction.beginIndex != currentIndex) {
                        PacBlock pacBlock = new PacBlock();
                        pacBlock.beginIndex = currentIndex;
                        pacBlock.endIndex = pacFonction.beginIndex;
                        reconcileLocationArea.getReconcileAreas().add(new PacbaseReconcileTextInterval(pacBlock, text));
                        pacBlocks.add(pacBlock);
                    }
                    reconcileLocationArea.getReconcileAreas().add(new PacbaseReconcileTextInterval(pacFonction, text));
                    currentIndex = pacFonction.endIndex;
                    pacBlocks.add(pacFonction);
                    ++nbFunctionAdded;
                }
                if (nbFunctionAdded == pacFonctions.size() && this._currentFunctionName != null) {
                    int ftComp = Ebcdic.stringCompare(ftName, this._currentFunctionName);
                    int ttComp = Ebcdic.stringCompare(this._currentFunctionName, ttName);
                    if (ftComp < 0 && ttComp < 0) {
                        PacBlock pacBlock = new PacBlock();
                        pacBlock.beginIndex = pacFonctions.get((int)(nbFunctionAdded - 1)).endIndex;
                        pacBlock.endIndex = text.length();
                        reconcileLocationArea.getReconcileAreas().add(new PacbaseReconcileTextInterval(pacBlock, text));
                        this._currentFunctionName = null;
                        pacBlocks.add(pacBlock);
                    }
                }
                builder = new StringBuilder();
                int index = 0;
                for (PacBlock pacBlock : pacBlocks) {
                    builder.append(text.subSequence(index, pacBlock.beginIndex));
                    builder.append(text.subSequence(pacBlock.endIndex, pacBlock.endIndex));
                    index = pacBlock.endIndex;
                }
                if (index != text.length()) {
                    builder.append(text.subSequence(index, text.length()));
                }
                if (builder.length() != 0) break block12;
                return null;
            }
            catch (Exception e) {
                Util.rethrow((Throwable)e);
                return text;
            }
        }
        return builder.toString();
    }

    private List<PacFonction> getPacFonctions(ITextAnalyzer textAnalyzer, String text) {
        textAnalyzer.setText((CharSequence)text);
        ITextScanner scanner = textAnalyzer.newScanner(0, text.length());
        String curName = null;
        String curPos = null;
        String curTagName = null;
        String curLevel = null;
        int beginIndex = -1;
        int endIndex = -1;
        ArrayList<PacFonction> pacFonctions = new ArrayList<PacFonction>();
        while (scanner.scan()) {
            Map properties;
            String category;
            if (!scanner.foundTag() || (category = (String)(properties = scanner.getTagProperties()).get("category")) == null || !"pac_function".equals(category)) continue;
            if (curName == null && scanner.isBeginIndex()) {
                curName = scanner.getTagName();
                beginIndex = scanner.index();
                curPos = (String)properties.get("TagPosition");
                curTagName = (String)properties.get("TagName");
                curLevel = (String)properties.get("level");
                continue;
            }
            if (curName != null && curName.equals(scanner.getTagName()) && !scanner.isBeginIndex()) {
                endIndex = scanner.index();
                PacFonction pacFonction = new PacFonction();
                pacFonction.name = curName;
                pacFonction.tagPosition = curPos;
                pacFonction.tagName = curTagName;
                pacFonction.beginIndex = beginIndex;
                pacFonction.endIndex = endIndex;
                pacFonction.level = curLevel;
                if (!"15".equals(pacFonction.level)) {
                    pacFonctions.add(pacFonction);
                }
                curName = null;
                curPos = null;
                curName = null;
                curLevel = null;
                beginIndex = -1;
                endIndex = -1;
                continue;
            }
            if (curName == null || !scanner.getTagName().startsWith(curName) || !scanner.isBeginIndex()) continue;
            this._currentFunctionName = String.valueOf(curName) + "ZZ";
            curName = scanner.getTagName();
            beginIndex = scanner.index();
            curPos = (String)properties.get("TagPosition");
            curTagName = (String)properties.get("TagName");
            curLevel = (String)properties.get("level");
        }
        if (pacFonctions.isEmpty() && curName != null) {
            PacFonction pacFonction = new PacFonction();
            pacFonction.name = curName;
            pacFonction.tagPosition = curPos;
            pacFonction.tagName = curTagName;
            pacFonction.beginIndex = beginIndex;
            pacFonction.endIndex = text.length();
            pacFonction.level = curLevel;
            pacFonctions.add(pacFonction);
        }
        return pacFonctions;
    }

    public List<IProblem> validateReconcileProblems(List<IProblem> problems) {
        ArrayList<IProblem> result = new ArrayList<IProblem>();
        for (IProblem problem : problems) {
            ReconcileProblem reconcileProblem = (ReconcileProblem)problem;
            if ("CONSTANTS".equals(reconcileProblem.getEnclosingTagName())) continue;
            result.add(problem);
        }
        return result;
    }

    protected boolean isFunctionOrdered() {
        return true;
    }

    public boolean reconcileCommonParents(Object newCommonParentSegment, Object oldCommonParentSegment, Object reconcilerState, boolean isExactReconcileLocation, int reconcileStep) {
        return this._reconcileCommonParents((Segment)newCommonParentSegment, (Segment)oldCommonParentSegment, (ReconcilerState)reconcilerState, isExactReconcileLocation, reconcileStep);
    }

    private boolean _reconcileCommonParents(Segment newCommonParentSegment, Segment oldCommonParentSegment, ReconcilerState reconcilerState, boolean isExactReconcileLocation, int reconcileStep) {
        if (reconcileStep != 1) {
            return false;
        }
        if (newCommonParentSegment instanceof HierarchicSegment && oldCommonParentSegment instanceof SyntacticTagSegment) {
            HierarchicSegment hierarchicSegment = (HierarchicSegment)newCommonParentSegment;
            SyntacticTagSegment syntacticTagSegment = (SyntacticTagSegment)oldCommonParentSegment;
            if (hierarchicSegment.getTagProperties() != null && hierarchicSegment.getTagProperties().getProperty("msp") != null && (syntacticTagSegment.getTagProperties() == null || syntacticTagSegment.getTagProperties().getProperty("msp") == null)) {
                Segment anchor = null;
                Segment[] segmentArray = newCommonParentSegment.sons();
                int n = segmentArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Segment segment = segmentArray[n2];
                    if (segment.getText().toString().contains("INSERT_SPECIFIC_HERE")) {
                        anchor = segment;
                        break;
                    }
                    ++n2;
                }
                boolean isArtificialCreate = "artificialCreate".equals(hierarchicSegment.getTagProperties().getProperty("msp"));
                if (isArtificialCreate) {
                    this._artificialCreateSegments.add(hierarchicSegment);
                    return false;
                }
                CharSequence newGeneratedText = null;
                String specificText = null;
                if (anchor == null) {
                    anchor = newCommonParentSegment.sons()[0];
                    if (hierarchicSegment.nbOfSons() > 2) {
                        anchor = newCommonParentSegment.sons()[2];
                    }
                }
                specificText = oldCommonParentSegment.getText().toString().replace("*!", "**!");
                newGeneratedText = anchor.getText();
                anchor.setText((CharSequence)specificText);
                ReconcileLocation startLocation = new ReconcileLocation(anchor.getChangeSet(), anchor.enclosingTagName(), anchor.fromTagName(), anchor.toTagName());
                ReconcileLocation endLocation = new ReconcileLocation(anchor.nextAtom().getChangeSet(), anchor.nextAtom().enclosingTagName(), anchor.nextAtom().fromTagName(), anchor.nextAtom().toTagName());
                ReconcileProblem problem = new ReconcileProblem((IReconcilerState)reconcilerState, (CharSequence)"", (CharSequence)specificText, newGeneratedText, null, null, (IReconcileLocation)startLocation, (IReconcileLocation)endLocation, null, null, ReconcileConstants.ProblemType.EXTENSION, ReconcileConstants.Severity.WARNING, null, Messages.RECONCILER_MACRO_SPECIFIC_ERROR, "RECONCILER_MACRO_SPECIFIC_ERROR", false);
                reconcilerState.addProblem(problem, false);
                return true;
            }
        } else if (newCommonParentSegment instanceof AtomicTagSegment && oldCommonParentSegment instanceof HierarchicSegment && this.isMacroVirtualEnabled(newCommonParentSegment.getChangeSet().getGeneratedInfo())) {
            HierarchicSegment oldSegment = (HierarchicSegment)oldCommonParentSegment;
            AtomicTagSegment newSegment = (AtomicTagSegment)newCommonParentSegment;
            boolean isOldArtificialCreate = "artificialCreate".equals(oldSegment.getTagProperties().getProperty("msp"));
            boolean isNewArtificialCreate = "artificialCreate".equals(newSegment.getTagProperties().getProperty("msp"));
            if (isOldArtificialCreate && !isNewArtificialCreate) {
                StringBuilder userText = new StringBuilder();
                Segment[] segmentArray = oldSegment.sons();
                int n = segmentArray.length;
                int n3 = 0;
                while (n3 < n) {
                    Segment son = segmentArray[n3];
                    if (son.getChangeNature() == ChangeNature.Modified || son.getChangeNature() == ChangeNature.Inserted) {
                        userText.append(son.getText());
                    } else if (son.getText().length() > 7 && son.getText().charAt(7) == 'F') {
                        userText.append(son.getText());
                    }
                    ++n3;
                }
                newCommonParentSegment.setText((CharSequence)userText.toString());
                return true;
            }
        }
        return false;
    }

    private boolean isMacroVirtualEnabled(IGeneratedInfo genInfo) {
        return PacTool.isGenerationWithVirtualMacroAlreadyDone(genInfo);
    }

    public boolean filterSyntacticTagsBeforeReconciliation(Object changeSet, IGeneratedTag tag, int reconcileStep) {
        Segment segment;
        if (this.isMacroVirtualEnabled(((UserChangeSet)changeSet).getGeneratedInfo())) {
            return false;
        }
        if (reconcileStep == 1 && "artificialCreate".equals(tag.getProperty("msp")) && (segment = ((UserChangeSet)changeSet).findSegmentFromTagName(tag.getName(), 0)) instanceof SyntacticTagSegment) {
            this._artificialCreateTags.add(tag);
            return true;
        }
        return false;
    }

    public void start(Object newChangeSet, Object oldChangeSet, int reconcileStep) {
        String _mvTags;
        if (reconcileStep != 1) {
            return;
        }
        UserChangeSet newUCS = (UserChangeSet)newChangeSet;
        if (newUCS != null && this.isMacroVirtualEnabled(newUCS.getGeneratedInfo()) && (_mvTags = newUCS.getGeneratedProperties().getProperty("MSPVIRT_DELETE_TAGS")) != null) {
            this._mvTagsNames.addAll(Arrays.asList(_mvTags.split(" ")));
        }
    }

    public void end(Object reconcilerState, Object newChangeSet, Object oldChangeSet, int reconcileStep) {
        if (reconcileStep == 1) {
            for (TextRemovedPendingReconcileItem item : this._textRemovedPendingReconcileItems) {
                ((UserChangeSet)newChangeSet).replaceText(item.startSegment.beginIndex(), item.startSegment.beginIndex(), item.reconcileText);
            }
            ArrayList<IProblem> toRemove = new ArrayList<IProblem>();
            ArrayList<IProblem> oldToRemove = new ArrayList<IProblem>();
            if (this.isMacroVirtualEnabled(((UserChangeSet)newChangeSet).getGeneratedInfo())) {
                ReconcileProblem reconcileProblem;
                Object textAfter22;
                Segment parent;
                Segment newSegment;
                for (PendingReconcileItem item : this._pendingReconcileItems) {
                    if (item.isParent) continue;
                    newSegment = item.startSegment;
                    parent = newSegment.parent();
                    if (parent != null && newSegment.endIndex() == parent.endIndex() && parent.beginIndex() != parent.endIndex()) {
                        this.dispatchTextAroundParent(parent, newSegment);
                        newSegment.setText(item.reconcileText);
                        continue;
                    }
                    newSegment.setText(item.reconcileText);
                }
                for (PendingReconcileItem item : this._pendingReconcileItems) {
                    CharSequence textBefore;
                    int[] indexes;
                    if (!item.isParent) continue;
                    newSegment = item.startSegment;
                    parent = newSegment.parent();
                    if (!item.hasChange) {
                        indexes = PacTool.getFunctionIndexes(item.reconcileText.toString());
                        if (indexes[0] != -1 && indexes[1] != -1 && indexes[1] != 0) {
                            newSegment.setText((CharSequence)"");
                            textBefore = item.reconcileText.subSequence(0, indexes[1]);
                            parent.firstAtom().setText(textBefore);
                            textAfter22 = item.reconcileText.subSequence(indexes[1], item.reconcileText.length());
                            parent.lastAtom().setText((CharSequence)textAfter22);
                            if (item.conflicProblems != null) {
                                toRemove.addAll(item.conflicProblems);
                            }
                        } else {
                            newSegment.setText(item.reconcileText);
                        }
                    }
                    if (parent.lastAtom() == newSegment) continue;
                    indexes = PacTool.getFunctionIndexes(item.reconcileText.toString());
                    if (indexes[0] != -1 && indexes[1] != -1 && indexes[1] != 0) {
                        newSegment.setText((CharSequence)"");
                        textBefore = item.reconcileText.subSequence(0, indexes[1]);
                        parent.firstAtom().setText(textBefore);
                        textAfter22 = item.reconcileText.subSequence(indexes[1], item.reconcileText.length());
                        parent.lastAtom().setText((CharSequence)textAfter22);
                        if (item.conflicProblems == null) continue;
                        toRemove.addAll(item.conflicProblems);
                        continue;
                    }
                    if (newSegment.getText().length() != 0) {
                        parent.lastAtom().setText(newSegment.getText());
                        newSegment.setText((CharSequence)"");
                    }
                    if (item.conflicProblems == null) continue;
                    toRemove.addAll(item.conflicProblems);
                }
                if (this.getTracerDelegate().isDebugModeEnabled()) {
                    this.getTracerDelegate().debug((Object)this, "reconcile", "New Text before artificial create");
                    this.getTracerDelegate().debug((Object)this, "reconcile", "\n" + ReconcileUtil.dumpToTmpFile((String)((UserChangeSet)newChangeSet).getText().toString(), (String)"new.before.artificialcreate.txt", (reconcileStep == 1 ? 1 : 0) != 0));
                }
                for (HierarchicSegment newSegment2 : this._artificialCreateSegments) {
                    if (newSegment2.enclosingTagName().length() > 5) continue;
                    HashMap specificTagSegments = new HashMap();
                    textAfter22 = newSegment2.sons();
                    int textBefore = ((Segment[])textAfter22).length;
                    int indexes = 0;
                    while (indexes < textBefore) {
                        String enclosingTagName;
                        int idx;
                        Segment son = textAfter22[indexes];
                        if (son instanceof AtomicTagSegment && (idx = (enclosingTagName = son.enclosingTagName()).indexOf("SPECIFIC_")) == 0) {
                            List<Segment> allSegments;
                            String functionTag = enclosingTagName.substring("SPECIFIC_".length());
                            idx = functionTag.indexOf(95);
                            if (specificTagSegments.containsKey(functionTag = functionTag.substring(idx + 1))) {
                                allSegments = (List)specificTagSegments.get(functionTag);
                            } else {
                                allSegments = new ArrayList();
                                specificTagSegments.put(functionTag, allSegments);
                            }
                            allSegments.add(son);
                        }
                        ++indexes;
                    }
                    StringBuilder generatedTextBuilder = new StringBuilder();
                    StringBuilder userTextBuilder = new StringBuilder();
                    Segment[] idx = newSegment2.sons();
                    int enclosingTagName = idx.length;
                    int textAfter22 = 0;
                    while (textAfter22 < enclosingTagName) {
                        Segment son = idx[textAfter22];
                        if (!(son instanceof HierarchicSegment)) {
                            if (son.isTagged() && son.getTagProperties().getProperty("msp") != null) {
                                List specificSegments = (List)specificTagSegments.get(son.enclosingTagName());
                                if (specificSegments != null) {
                                    boolean generatedWrote = false;
                                    Comparator<Segment> sort_before_after = new Comparator<Segment>(){

                                        @Override
                                        public int compare(Segment object1, Segment object2) {
                                            return -EBCDICCompare.stringCompare((String)object1.toString().substring(0, 14), (String)object2.toString().substring(0, 14));
                                        }
                                    };
                                    if (specificSegments.size() > 1) {
                                        Collections.sort(specificSegments, sort_before_after);
                                    }
                                    for (Segment currentSegment : specificSegments) {
                                        String tagName = currentSegment.enclosingTagName();
                                        if (tagName.contains("BEFORE")) {
                                            generatedTextBuilder.append(currentSegment.getText());
                                            if (son.generatedText().length() > 7 && son.generatedText().charAt(7) != 'F' && !generatedWrote) {
                                                generatedTextBuilder.append(son.generatedText());
                                                generatedWrote = true;
                                            }
                                            currentSegment.setText((CharSequence)"");
                                            continue;
                                        }
                                        if (tagName.contains("AFTER")) {
                                            if (son.generatedText().length() > 7 && son.generatedText().charAt(7) != 'F' && !generatedWrote) {
                                                generatedTextBuilder.append(son.generatedText());
                                                generatedWrote = true;
                                            }
                                            generatedTextBuilder.append(currentSegment.getText());
                                            currentSegment.setText((CharSequence)"");
                                            continue;
                                        }
                                        if (son.generatedText().length() > 7 && son.generatedText().charAt(7) != 'F') {
                                            generatedTextBuilder.append(currentSegment.getText());
                                        }
                                        currentSegment.setText((CharSequence)"");
                                    }
                                } else if (son.generatedText().length() > 7 && son.generatedText().charAt(7) != 'F') {
                                    generatedTextBuilder.append(son.generatedText());
                                }
                                son.setText((CharSequence)"");
                            }
                            userTextBuilder.append(son.getText());
                        }
                        ++textAfter22;
                    }
                    String generatedText = generatedTextBuilder.toString();
                    String userText = userTextBuilder.toString();
                    int[] indexes2 = PacTool.getFunctionIndexes(userText);
                    if (indexes2[0] == -1 || indexes2[1] == -1 || indexes2[1] == 0) continue;
                    int insertIndex = newSegment2.beginIndex() + indexes2[0];
                    newSegment2.getChangeSet().replaceText(insertIndex, insertIndex, (CharSequence)generatedText);
                }
                for (IProblem problem : ((ReconcilerState)reconcilerState).getProblems()) {
                    IGeneratedTag toTag;
                    IGeneratedTag fromTag;
                    if (!"KEY_1002".equals(problem.code()) || (reconcileProblem = (ReconcileProblem)problem).getNewGeneratedText() == null || reconcileProblem.getNewGeneratedText().length() != 0) continue;
                    Segment _startSegment = reconcileProblem.getNewStartSegment();
                    Segment _endSegment = reconcileProblem.getNewStartSegment();
                    IGeneratedTag iGeneratedTag = fromTag = _startSegment == null ? null : _startSegment.toTag();
                    Object object = _startSegment == _endSegment ? fromTag : (toTag = _endSegment == null ? null : _endSegment.fromTag());
                    if (fromTag != toTag || !this._artificialCreateSegments.contains(fromTag)) continue;
                    toRemove.add(problem);
                }
                if (((ReconcilerState)reconcilerState).getOldProblems() != null) {
                    for (IProblem problem : ((ReconcilerState)reconcilerState).getOldProblems()) {
                        if (!"KEY_1005".equals(problem.code()) || (reconcileProblem = (ReconcileProblem)problem).getNewStartSegment() != null && "artificialCreate".equals(reconcileProblem.getNewStartSegment().getTagProperties().getProperty("msp"))) continue;
                        oldToRemove.add(problem);
                    }
                    if (!oldToRemove.isEmpty()) {
                        ((ReconcilerState)reconcilerState).getOldProblems().removeAll(oldToRemove);
                    }
                }
                if (!toRemove.isEmpty()) {
                    ((ReconcilerState)reconcilerState).getProblems().removeAll(toRemove);
                }
            } else {
                UserChangeSet newUCS = (UserChangeSet)newChangeSet;
                for (IGeneratedTag tag : this._artificialCreateTags) {
                    HierarchicSegment segment;
                    Segment newSegment;
                    String tagName = tag.getName();
                    if (tagName.length() > 5 || !((newSegment = newUCS.findSegmentFromTagName(tagName, 0)) instanceof HierarchicSegment) || (segment = (HierarchicSegment)newSegment).sons().length <= 3) continue;
                    Segment startSegment = segment.sons()[2];
                    Segment endSegment = segment.sons()[segment.sons().length - 2];
                    ReconcileLocation startLocation = new ReconcileLocation(startSegment.getChangeSet(), startSegment.enclosingTagName(), startSegment.fromTagName(), startSegment.toTagName());
                    ReconcileLocation endLocation = new ReconcileLocation(endSegment.getChangeSet(), endSegment.enclosingTagName(), endSegment.fromTagName(), endSegment.toTagName());
                    String generatedText = "";
                    int i = 2;
                    while (i <= segment.sons().length - 2) {
                        generatedText = String.valueOf(generatedText) + segment.sons()[i].generatedText();
                        ++i;
                    }
                    newSegment.setText((CharSequence)"");
                    String text = newUCS.getText().toString();
                    int idx = text.indexOf("      " + tagName + ".");
                    if (idx > 0) {
                        idx = text.indexOf("\n", idx);
                        newUCS.replaceText(idx + 1, idx + 1, (CharSequence)generatedText);
                    } else {
                        System.err.println("Cannot find function  -> " + tagName);
                    }
                    ReconcileProblem problem = new ReconcileProblem((IReconcilerState)((ReconcilerState)reconcilerState), (CharSequence)"", (CharSequence)generatedText, (CharSequence)generatedText, null, null, (IReconcileLocation)startLocation, (IReconcileLocation)endLocation, null, null, ReconcileConstants.ProblemType.EXTENSION, ReconcileConstants.Severity.WARNING, null, Messages.RECONCILER_MACRO_ORPHAN_ERROR, "RECONCILER_MACRO_ORPHAN_ERROR", true);
                    ((ReconcilerState)reconcilerState).addProblem(problem, false);
                }
                for (IProblem problem : ((ReconcilerState)reconcilerState).getProblems()) {
                    IGeneratedTag toTag;
                    IGeneratedTag fromTag;
                    ReconcileProblem reconcileProblem;
                    if (!"KEY_1002".equals(problem.code()) || (reconcileProblem = (ReconcileProblem)problem).getNewGeneratedText() == null || reconcileProblem.getNewGeneratedText().length() != 0) continue;
                    Segment startSegment = reconcileProblem.getNewStartSegment();
                    Segment endSegment = reconcileProblem.getNewStartSegment();
                    IGeneratedTag iGeneratedTag = fromTag = startSegment == null ? null : startSegment.toTag();
                    Object object = startSegment == endSegment ? fromTag : (toTag = endSegment == null ? null : endSegment.fromTag());
                    if (fromTag != toTag || !this._artificialCreateTags.contains(fromTag)) continue;
                    toRemove.add(problem);
                }
                if (!toRemove.isEmpty()) {
                    ((ReconcilerState)reconcilerState).getProblems().removeAll(toRemove);
                }
            }
        }
        this.reset();
    }

    public boolean canModifyNewSegment(Object newSegment, Object oldChangeSet) {
        return false;
    }

    public boolean canModifyOldSegment(Object oldSegment, Object newChangeSet) {
        return false;
    }

    public boolean replaceText(Object start, Object stop, Object ucs, StringBuilder reconcileTextBuilder, boolean hasChanges, List<IProblem> textualProblems, List<IProblem> conflicProblems, int reconcileStep) {
        String newLine;
        if (reconcileStep != 1) {
            return false;
        }
        Segment startSegment = (Segment)start;
        Segment stopSegment = (Segment)stop;
        UserChangeSet changeSet = (UserChangeSet)ucs;
        String reconcileText = reconcileTextBuilder.toString();
        if (reconcileText.startsWith("       F") && startSegment == stopSegment && reconcileText.length() > 16 && reconcileText.substring(12, 17).equals("-FN. ") && reconcileText.endsWith("COA" + (newLine = Util.determineDelimiterOfV2((CharSequence)reconcileText))) && stopSegment instanceof AtomicPartSegment && stopSegment.nextAtom().getChangeNature() == ChangeNature.Unchanged && reconcileText.equals(stopSegment.nextAtom().generatedText())) {
            return true;
        }
        if (this.isMacroVirtualEnabled(changeSet.getGeneratedInfo()) && startSegment != null && stopSegment != null) {
            String enclosingTagName = startSegment.enclosingTagName();
            if (enclosingTagName == null) {
                return false;
            }
            if (this._mvTagsNames.contains(enclosingTagName)) {
                Segment segment = changeSet.findSegmentFromTagName(enclosingTagName, 0);
                if (!(segment instanceof SyntacticTagSegment)) {
                    int[] indexes;
                    HierarchicSegment hierarchicSegment;
                    if (segment instanceof HierarchicSegment && "artificialCreate".equals((hierarchicSegment = (HierarchicSegment)segment).getTagProperties().getProperty("msp")) && !hierarchicSegment.isLeaf() && startSegment.beginIndex() == stopSegment.endIndex() && (indexes = PacTool.getFunctionIndexes(reconcileText))[0] != -1 && indexes[1] != -1) {
                        PendingReconcileItem item = new PendingReconcileItem();
                        item.startSegment = startSegment;
                        item.stopSegment = stopSegment;
                        item.oldSegment = hierarchicSegment;
                        item.reconcileText = reconcileText;
                        item.isParent = true;
                        item.conflicProblems = conflicProblems;
                        item.textualProblems = textualProblems;
                        item.hasChange = hasChanges;
                        this._pendingReconcileItems.add(item);
                        return true;
                    }
                    return false;
                }
                SyntacticTagSegment syntacticTagSegment = (SyntacticTagSegment)segment;
                if (startSegment == stopSegment && startSegment.beginIndex() == startSegment.endIndex()) {
                    if (start instanceof AtomicTagSegment) {
                        PendingReconcileItem item = new PendingReconcileItem();
                        item.startSegment = startSegment;
                        item.oldSegment = syntacticTagSegment;
                        item.reconcileText = reconcileText;
                        item.conflicProblems = conflicProblems;
                        item.textualProblems = textualProblems;
                        item.hasChange = hasChanges;
                        this._pendingReconcileItems.add(item);
                        return true;
                    }
                    if (startSegment.parent() != null && startSegment.parent().enclosingTagName().equals(enclosingTagName)) {
                        String endFunction = "       " + enclosingTagName + "-FN";
                        if (!this.isBeginningLineContaining(reconcileText, endFunction)) {
                            return false;
                        }
                        PendingReconcileItem item = new PendingReconcileItem();
                        item.startSegment = startSegment;
                        item.stopSegment = stopSegment;
                        item.oldSegment = syntacticTagSegment;
                        item.reconcileText = reconcileText;
                        item.isParent = true;
                        item.conflicProblems = conflicProblems;
                        item.textualProblems = textualProblems;
                        item.hasChange = hasChanges;
                        this._pendingReconcileItems.add(item);
                        return false;
                    }
                } else {
                    if (!syntacticTagSegment.isLeaf() && startSegment.beginIndex() == stopSegment.endIndex()) {
                        int[] indexes = PacTool.getFunctionIndexes(reconcileText);
                        if (indexes[0] != -1 && indexes[1] != -1) {
                            PendingReconcileItem item = new PendingReconcileItem();
                            item.startSegment = startSegment;
                            item.stopSegment = stopSegment;
                            item.oldSegment = syntacticTagSegment;
                            item.reconcileText = reconcileText;
                            item.isParent = true;
                            item.conflicProblems = conflicProblems;
                            item.textualProblems = textualProblems;
                            item.hasChange = hasChanges;
                            this._pendingReconcileItems.add(item);
                            return true;
                        }
                        String endFunction = "       " + enclosingTagName + "-FN";
                        if (!this.isBeginningLineContaining(reconcileText, endFunction)) {
                            return false;
                        }
                        PendingReconcileItem item = new PendingReconcileItem();
                        item.startSegment = startSegment;
                        item.stopSegment = stopSegment;
                        item.oldSegment = syntacticTagSegment;
                        item.reconcileText = reconcileText;
                        item.isParent = true;
                        item.conflicProblems = conflicProblems;
                        item.textualProblems = textualProblems;
                        item.hasChange = hasChanges;
                        this._pendingReconcileItems.add(item);
                        return false;
                    }
                    UserChangeSet newUCS = startSegment.getChangeSet();
                    Segment seg = newUCS.segmentFromTagName(enclosingTagName, 0);
                    if (!seg.isLeaf() && startSegment.beginIndex() == stopSegment.endIndex()) {
                        int[] indexes = PacTool.getFunctionIndexes(reconcileText);
                        if (indexes[0] != -1 && indexes[1] != -1) {
                            PendingReconcileItem item = new PendingReconcileItem();
                            item.startSegment = startSegment;
                            item.stopSegment = stopSegment;
                            item.oldSegment = syntacticTagSegment;
                            item.reconcileText = reconcileText;
                            item.isParent = true;
                            item.conflicProblems = conflicProblems;
                            item.textualProblems = textualProblems;
                            item.hasChange = hasChanges;
                            this._pendingReconcileItems.add(item);
                            return true;
                        }
                        String endFunction = "       " + enclosingTagName + "-FN";
                        if (!this.isBeginningLineContaining(reconcileText, endFunction)) {
                            return false;
                        }
                        PendingReconcileItem item = new PendingReconcileItem();
                        item.startSegment = startSegment;
                        item.stopSegment = stopSegment;
                        item.oldSegment = syntacticTagSegment;
                        item.reconcileText = reconcileText;
                        item.isParent = true;
                        item.conflicProblems = conflicProblems;
                        item.textualProblems = textualProblems;
                        item.hasChange = hasChanges;
                        this._pendingReconcileItems.add(item);
                        return false;
                    }
                }
            } else if (start == stop && startSegment.beginIndex() == stopSegment.beginIndex() && conflicProblems != null) {
                conflicProblems.clear();
            }
        }
        return false;
    }

    private boolean dispatchTextAroundParent(Segment parent, Segment newSegment) {
        String enclosingTagName;
        String startFunction;
        if (newSegment.nextAtom() != parent.lastAtom()) {
            return false;
        }
        String text = parent.getText().toString();
        if (!text.contains(startFunction = "       " + (enclosingTagName = parent.enclosingTagName()) + ".")) {
            return false;
        }
        int[] indexes = PacTool.getFunctionIndexes(text);
        if (indexes[0] != -1 && indexes[1] != -1 && indexes[1] != 0) {
            if (newSegment.previousAtom() == parent.firstAtom()) {
                CharSequence textBefore = text.subSequence(0, indexes[1]);
                parent.firstAtom().setText(textBefore);
                CharSequence textAfter = text.subSequence(indexes[1], text.length());
                parent.lastAtom().setText(textAfter);
                return true;
            }
            Segment current = newSegment;
            String endFunction = "       " + enclosingTagName + "-FN";
            boolean found = false;
            while (current.beginIndex() == newSegment.beginIndex()) {
                if (this.isBeginningLineContaining((current = current.previousAtom()).getText().toString(), endFunction)) {
                    found = true;
                    break;
                }
                if (current.beginIndex() > parent.beginIndex()) continue;
                return true;
            }
            if (found) {
                CharSequence textAfter = current.getText();
                current.setText((CharSequence)"");
                parent.lastAtom().setText(textAfter);
                return true;
            }
        }
        return false;
    }

    private boolean isBeginningLineContaining(String allText, String textToFind) {
        String newLine = Util.determineDelimiterOfV2((CharSequence)allText);
        if (allText.indexOf(newLine) == -1) {
            return allText.startsWith(textToFind);
        }
        StringTokenizer st = new StringTokenizer(allText, newLine);
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (!s.startsWith(textToFind)) continue;
            return true;
        }
        return false;
    }

    public boolean textRemoved(CharSequence oldGeneratedText, CharSequence oldModifiedText, CharSequence newGeneratedText, IReconcileLocation startLocation, List<IReconcileLocation> modifiedLocations, CharSequence removedTagName, int reconcileStep) {
        AtomicTagSegment ats;
        ReconcileLocation loc;
        Segment seg;
        IReconcileLocation iloc;
        if (reconcileStep != 1) {
            return false;
        }
        if (oldGeneratedText.length() > 72 && oldGeneratedText.subSequence(0, 72).toString().trim().length() == 0 && newGeneratedText.length() == 0 && (iloc = modifiedLocations.get(0)) != null && iloc.enclosingTagName().equals(iloc.fromTagName()) && iloc.toTagName().equals(iloc.enclosingTagName()) && iloc instanceof ReconcileLocation && startLocation instanceof ReconcileLocation && (seg = (loc = (ReconcileLocation)iloc).changeSet().findSegmentFromTagName(loc.enclosingTagName(), 0)) instanceof AtomicTagSegment && (ats = (AtomicTagSegment)seg).previousAtom() != null && ats.previousAtom().previousAtom() != null) {
            Segment previousOld = ats.previousAtom().previousAtom();
            if (ats.nextAtom() != null && ats.nextAtom().nextAtom() != null) {
                Segment nextOld = ats.nextAtom().nextAtom();
                if (previousOld.enclosingTagName().equals(startLocation.fromTagName()) && nextOld.enclosingTagName().equals(startLocation.toTagName())) {
                    Segment previousNew = ((ReconcileLocation)startLocation).changeSet().findSegmentFromTagName(startLocation.fromTagName(), 0);
                    Segment nextNew = ((ReconcileLocation)startLocation).changeSet().findSegmentFromTagName(startLocation.toTagName(), 0);
                    if (previousNew.endIndex() == nextNew.beginIndex()) {
                        TextRemovedPendingReconcileItem item = new TextRemovedPendingReconcileItem();
                        item.startSegment = nextNew;
                        item.reconcileText = oldModifiedText;
                        this._textRemovedPendingReconcileItems.add(item);
                        return true;
                    }
                }
            }
        }
        return false;
    }

    protected static class PacBlock {
        int beginIndex;
        int endIndex;

        protected PacBlock() {
        }
    }

    protected static class PacFonction
    extends PacBlock {
        String name;
        String tagName;
        String tagPosition;
        String level;

        protected PacFonction() {
        }
    }

    protected static class PendingReconcileItem {
        Segment startSegment;
        Segment oldSegment;
        CharSequence reconcileText;
        public Segment stopSegment;
        public boolean isParent;
        List<IProblem> textualProblems;
        List<IProblem> conflicProblems;
        boolean hasChange;

        protected PendingReconcileItem() {
        }

        public String toString() {
            return this.reconcileText.toString();
        }
    }

    private static class ShowDifferenceQuickFixAction
    implements IProblem.IQuickFixAction {
        private IProblem problem;

        public ShowDifferenceQuickFixAction(IProblem problem) {
            this.problem = problem;
        }

        public String code() {
            return "";
        }

        public String[] parameters() {
            return new String[0];
        }

        public String message() {
            return "Shows reconciler differences.";
        }

        public boolean doIt() {
            CompareConfiguration compConf = new CompareConfiguration(){

                public String getLeftLabel(Object element) {
                    return "User Code";
                }

                public String getRightLabel(Object element) {
                    return "New Generated code";
                }

                public boolean isRightEditable() {
                    return false;
                }

                public boolean isLeftEditable() {
                    return false;
                }

                public String getAncestorLabel(Object element) {
                    return "Old Generated Code";
                }
            };
            CompareUI.openCompareDialog((CompareEditorInput)new CompareEditorInput(compConf){

                protected Object prepareInput(IProgressMonitor arg0) throws InvocationTargetException, InterruptedException {
                    Differencer d = new Differencer(){

                        protected boolean contentsEqual(Object o1, Object o2) {
                            String s1 = ((StringInput)o1).getString();
                            String s2 = ((StringInput)o2).getString();
                            return s1.equals(s2);
                        }
                    };
                    ReconcileProblem reconcileProblem = (ReconcileProblem)ShowDifferenceQuickFixAction.this.problem;
                    CharSequence oldGeneratedCode = null;
                    CharSequence newGeneratedCode = null;
                    CharSequence modifiedCode = null;
                    if (reconcileProblem.getProblemType() == ReconcileConstants.ProblemType.CONFLICT) {
                        oldGeneratedCode = reconcileProblem.getOldGeneratedText();
                        newGeneratedCode = reconcileProblem.getNewGeneratedText();
                        modifiedCode = reconcileProblem.getOldModifiedText();
                    } else if (reconcileProblem.getProblemType() == ReconcileConstants.ProblemType.CHOICE) {
                        oldGeneratedCode = reconcileProblem.getOldGeneratedText();
                        newGeneratedCode = reconcileProblem.getNewGeneratedText();
                        modifiedCode = reconcileProblem.getOldModifiedText();
                    } else if (reconcileProblem.getProblemType() == ReconcileConstants.ProblemType.REMOVED) {
                        oldGeneratedCode = reconcileProblem.getOldGeneratedText();
                        newGeneratedCode = reconcileProblem.getNewGeneratedText();
                        modifiedCode = reconcileProblem.getOldModifiedText();
                    } else if (reconcileProblem.getProblemType() == ReconcileConstants.ProblemType.EXTENSION) {
                        oldGeneratedCode = reconcileProblem.getOldGeneratedText();
                        newGeneratedCode = reconcileProblem.getNewGeneratedText();
                        modifiedCode = reconcileProblem.getOldModifiedText();
                    }
                    StringInput s1 = new StringInput(oldGeneratedCode == null ? "" : oldGeneratedCode);
                    StringInput s2 = new StringInput(modifiedCode == null ? "" : modifiedCode);
                    StringInput s3 = new StringInput(newGeneratedCode == null ? "" : newGeneratedCode);
                    Object diff = d.findDifferences(true, (IProgressMonitor)new NullProgressMonitor(), null, (Object)s1, (Object)s2, (Object)s3);
                    return diff;
                }
            });
            return false;
        }
    }

    public static class StringInput
    implements ITypedElement,
    IStreamContentAccessor {
        private CharSequence contents = null;

        public StringInput(CharSequence contents) {
            this.contents = contents;
        }

        public Image getImage() {
            return null;
        }

        public String getName() {
            return "";
        }

        public String getType() {
            return "txt";
        }

        public String getString() {
            return this.contents.toString();
        }

        public InputStream getContents() throws CoreException {
            return new ByteArrayInputStream(this.getString().getBytes());
        }
    }

    protected static class TextRemovedPendingReconcileItem {
        Segment startSegment;
        CharSequence reconcileText;

        protected TextRemovedPendingReconcileItem() {
        }
    }
}

