/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.extension.organize;

import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.pacbase.PacCPLine;
import com.ibm.pdp.mdl.pacbase.PacFolderView;
import com.ibm.pdp.mdl.pacbase.PacProgram;
import com.ibm.pdp.mdl.pacbase.impl.PacMacroImpl;
import com.ibm.pdp.pacbase.PacTool;
import com.ibm.pdp.pacbase.extension.organize.DefaultFunction;
import com.ibm.pdp.pacbase.extension.organize.IVirtualFunction;
import com.ibm.pdp.pacbase.extension.organize.Location;
import com.ibm.pdp.pacbase.extension.organize.PdpFunction;
import com.ibm.pdp.util.Util;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SpecialMacroAnalyzer {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2016, 2020.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    boolean isSpecialMacroExist = false;
    PacMacroImpl macroSP = null;
    PacCPLine cpLine = null;
    private List<IVirtualFunction> allRelativeFunctions = null;
    private List<IVirtualFunction> allSupFunctions = null;
    private List<String> allIndexes = null;
    private List<String> allFunctions = null;
    private List<String> allStarC = null;

    public SpecialMacroAnalyzer(RadicalEntity re) {
        this.initializeFromEntity(re);
    }

    private void initializeFromEntity(RadicalEntity re) {
        if (re instanceof PacProgram || re instanceof PacFolderView) {
            return;
        }
        Iterator cpList = null;
        cpList = PacTool.getCPLines(re).iterator();
        String entityName = re.getName();
        while (cpList.hasNext()) {
            String name;
            Object obj = cpList.next();
            if (!(obj instanceof PacCPLine) || !(name = ((PacCPLine)obj).getMacro().getName()).startsWith(entityName) || !name.endsWith("SP")) continue;
            this.cpLine = (PacCPLine)obj;
            break;
        }
        if (this.cpLine != null) {
            this.macroSP = (PacMacroImpl)this.cpLine.getMacro();
            this.isSpecialMacroExist = true;
            this.loadFunctionsLists();
        }
    }

    public boolean isSpecialMacroExist() {
        return this.isSpecialMacroExist;
    }

    public PacCPLine getCpLine() {
        return this.cpLine;
    }

    private void loadFunctionsLists() {
        this.allRelativeFunctions = new ArrayList<IVirtualFunction>();
        this.allSupFunctions = new ArrayList<IVirtualFunction>();
        this.allIndexes = new ArrayList<String>();
        this.allFunctions = new ArrayList<String>();
        this.allStarC = new ArrayList<String>();
        String source = this.macroSP.getSource();
        this.macroSP = null;
        StringReader sr = new StringReader(source);
        BufferedReader br = new BufferedReader(sr);
        try {
            try {
                String fName = "";
                String line = br.readLine();
                block11: do {
                    if (line == null || line.equals("")) continue;
                    if (line.charAt(0) == 'F') {
                        int index = Math.min(line.length(), 6);
                        fName = line.substring(0, index).trim();
                        continue;
                    }
                    if (line.charAt(0) == 'B' || line.charAt(0) == 'I' || line.charAt(0) == 'J' || line.charAt(0) == 'W') {
                        fName = "";
                        if (line.charAt(0) == 'J') {
                            this.allIndexes.add(String.valueOf(line.trim()) + "R");
                        }
                    }
                    if (fName.trim().length() <= 0) continue;
                    String code = line.substring(6);
                    if (code.contains("LV=")) {
                        boolean realStarC = false;
                        if (fName.length() == 3 && !code.contains("ACTION=*C")) {
                            this.allFunctions.add(fName);
                        }
                        String firstPartOfRef = "";
                        String secondPartOfRef = "";
                        if (code.contains("ACTION=*C")) {
                            realStarC = true;
                            StringBuilder sb = new StringBuilder();
                            sb.append(fName);
                            sb.append("=");
                            int begin = line.indexOf("REF=") + 4;
                            String ref = line.substring(begin).trim();
                            int index = ref.indexOf(" ");
                            firstPartOfRef = ref;
                            secondPartOfRef = "";
                            if (index != -1) {
                                firstPartOfRef = ref.substring(0, index);
                                secondPartOfRef = ref.substring(index).trim();
                            }
                            if ("BS".equals(firstPartOfRef) || "ES".equals(firstPartOfRef)) {
                                realStarC = false;
                            } else if ("SQ".equals(firstPartOfRef) && secondPartOfRef.length() != 0) {
                                realStarC = false;
                            }
                            if (realStarC) {
                                sb.append(ref);
                                this.allStarC.add(sb.toString());
                            }
                        }
                        PdpFunction function = new PdpFunction();
                        function.cobolName = fName;
                        int indexAction = code.indexOf("ACTION=");
                        if (indexAction > 0) {
                            int indexRef = code.indexOf("REF=");
                            String ref = code.substring(indexRef + 4).trim();
                            String action = code.substring(indexAction + 7, indexAction + 9);
                            if (action.equals("*C") && !realStarC) {
                                ref = firstPartOfRef;
                                action = "*" + (secondPartOfRef.length() == 0 ? "A" : secondPartOfRef);
                            }
                            function.setReference(ref);
                            Location loc = null;
                            Location[] values = Location.values();
                            int i = 0;
                            while (i < values.length) {
                                if (values[i].getInsertMspName().equals(action)) {
                                    loc = values[i];
                                    break;
                                }
                                ++i;
                            }
                            function.setlocation(loc);
                        }
                        if (realStarC) continue;
                        this.allRelativeFunctions.add(function);
                        continue;
                    }
                    if (code.startsWith("*!SUP")) {
                        IVirtualFunction function2;
                        boolean found = false;
                        for (IVirtualFunction function2 : this.allRelativeFunctions) {
                            if (!function2.getCobolName().equals(fName)) continue;
                            found = true;
                            if (this.allFunctions.contains(fName)) {
                                function2.setLevel(5.0f);
                            } else {
                                function2.setLevel(99.0f);
                            }
                            ((PdpFunction)function2).setCondition("SUP");
                            if (((PdpFunction)function2).getLocation() != Location.REPLACE) {
                                ((PdpFunction)function2).setReference(null);
                                ((PdpFunction)function2).setlocation(null);
                            }
                            this.allSupFunctions.add(function2);
                            break;
                        }
                        if (found) continue;
                        function2 = new PdpFunction();
                        ((PdpFunction)function2).cobolName = fName;
                        ((DefaultFunction)((Object)function2)).setLevel(99.0f);
                        ((PdpFunction)function2).setCondition("SUP");
                        this.allSupFunctions.add(function2);
                        continue;
                    }
                    for (String stringFCT : this.allStarC) {
                        if (!stringFCT.startsWith(fName)) continue;
                        this.allStarC.remove(stringFCT);
                        stringFCT = String.valueOf(stringFCT) + " functionNotEmpty";
                        this.allStarC.add(stringFCT);
                        continue block11;
                    }
                } while ((line = br.readLine()) != null);
            }
            catch (IOException ioe) {
                Util.rethrow((Throwable)ioe);
                sr.close();
                try {
                    br.close();
                }
                catch (IOException e) {
                    Util.rethrow((Throwable)e);
                }
            }
        }
        finally {
            sr.close();
            try {
                br.close();
            }
            catch (IOException e) {
                Util.rethrow((Throwable)e);
            }
        }
    }

    public List<IVirtualFunction> getAllRelativeFunctions() {
        if (this.allRelativeFunctions == null) {
            this.allRelativeFunctions = new ArrayList<IVirtualFunction>();
        }
        return this.allRelativeFunctions;
    }

    public boolean needToRestoreFunctionsAndSUPfunctions() {
        return !this.getAllSupFunctions().isEmpty() || !this.getAllFunctions().isEmpty();
    }

    public List<IVirtualFunction> getAllSupFunctions() {
        if (this.allSupFunctions == null) {
            this.allSupFunctions = new ArrayList<IVirtualFunction>();
        }
        return this.allSupFunctions;
    }

    public List<String> getAllFunctions() {
        if (this.allFunctions == null) {
            this.allFunctions = new ArrayList<String>();
        }
        return this.allFunctions;
    }

    public List<String> getAllIndexes() {
        if (this.allIndexes == null) {
            this.allIndexes = new ArrayList<String>();
        }
        return this.allIndexes;
    }

    public List<String> getAllStarC() {
        if (this.allStarC == null) {
            this.allStarC = new ArrayList<String>();
        }
        return this.allStarC;
    }
}

