/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.extension.organize;

import com.ibm.pdp.engine.IBuilderTag;
import com.ibm.pdp.engine.IGeneratedInfo;
import com.ibm.pdp.pacbase.extension.organize.DefaultTreeHandler;
import com.ibm.pdp.pacbase.extension.organize.DialogTreeHandler;
import com.ibm.pdp.pacbase.extension.organize.IFunction;
import com.ibm.pdp.pacbase.util.EBCDICCompare;
import java.util.Hashtable;
import java.util.List;

public class ServerTreeHandler
extends DialogTreeHandler {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014, 2015.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String PROCEDURE_NAME = "PROCEDURE";
    private static final String FCT_LOGICALVIEW_PROPERTY = "functions";
    int endIndexForEndBlock = -1;
    private Hashtable<String, FunctionWithLv> lvFunctions = new Hashtable();

    public ServerTreeHandler() {
    }

    public ServerTreeHandler(IGeneratedInfo genInfo) {
        this.searchFunctionsWithLv(genInfo);
    }

    protected void searchFunctionsWithLv(IGeneratedInfo genInfo) {
        IBuilderTag tag = genInfo.toGeneratedInfoBuilder().tagFromName(PROCEDURE_NAME);
        String param = tag.getProperty(FCT_LOGICALVIEW_PROPERTY);
        if (param != null && param.length() > 0) {
            param = param.replaceAll(",,", ",  ,");
            String[] params = param.split(",");
            int i = 0;
            while (i < params.length) {
                this.lvFunctions.put(params[i], new FunctionWithLv(params[i + 1], params[i + 2]));
                i += 2;
                ++i;
            }
        }
    }

    @Override
    protected int getIndexForFunction(IFunction f, List<IFunction> tree, String name) {
        int ind;
        String functionName;
        String string = functionName = f == null ? this.getFunctionName(name) : this.getFunctionName(f.getCobolName());
        if (f == null) {
            f = new DefaultTreeHandler.PrivateDefaultFunction(name, name);
        }
        this.initIndexesForSpecificPattern(f, tree, functionName);
        if (this.indexForf > 0) {
            return this.indexForf;
        }
        if (this.indexForStartOfFct == 0 && this.lvFunctions.containsKey(functionName) && (ind = this.searchIndexForLvLocation(f, tree, functionName)) > 0) {
            return ind;
        }
        if (this.compareFloatLevel(f.getLevel(), 5.0f) || this.indexForStartOfFct == 0) {
            if (this.endIndexForEndBlock == tree.size() - 1) {
                return this.endIndexForEndBlock + 1;
            }
            return this.endIndexForEndBlock + 1 + super.getIndexForFunctionToUpdate(f, tree.subList(this.endIndexForEndBlock + 1, tree.size()), name);
        }
        List<IFunction> nonGeneratedFctTree = this.getNonGeneratedFunctionsList(tree.subList(this.indexForStartOfFct, this.indexForEndOfFct + 1));
        if (f.getReference() == null || f.getReference().trim().length() == 0) {
            int index = this.searchIndexForAbsoluteLocation(f, tree, nonGeneratedFctTree);
            if (index > 0) {
                return index;
            }
            this.indexForGeneratedTagName = -1;
        }
        if (this.indexForGeneratedTagName < 0) {
            return this.getIndexForFunctionToUpdate(f, tree.subList(this.endIndexForEndBlock, tree.size()), name);
        }
        return super.getIndexForFunction(f, tree, name);
    }

    @Override
    protected int getIndexForFunctionToUpdate(IFunction f, List<IFunction> tree, String name) {
        if (f == null) {
            f = new DefaultTreeHandler.PrivateDefaultFunction(name, name);
        }
        int i = 0;
        i = 0;
        while (i < tree.size()) {
            if (tree.get(i).getCobolName().startsWith(f.getCobolName())) {
                return i;
            }
            ++i;
        }
        return i - 1;
    }

    @Override
    protected void initIndexes() {
        super.initIndexes();
        this.endIndexForEndBlock = 0;
    }

    @Override
    protected void initIndexesForSpecificPattern(IFunction f, List<IFunction> tree, String functionName) {
        this.initIndexes();
        int i = 0;
        while (i < tree.size()) {
            if (f.getTagName().equals(tree.get(i).getTagName()) || f.getCobolName().equals(tree.get(i).getCobolName())) {
                this.indexForf = i;
            }
            if ((tree.get(i).getCobolName().startsWith(f.getCobolName()) || tree.get(i).getCobolName().startsWith(functionName)) && this.indexForStartOfFct == 0) {
                this.indexForStartOfFct = i;
            }
            if (this.indexForStartOfFct > 0) {
                this.indexForEndOfFct = i;
            }
            if (tree.get(i).getCobolName().startsWith("F81")) {
                this.endIndexForEndBlock = i;
            }
            ++i;
        }
    }

    @Override
    protected boolean isFunctionForRelativeLocation(String name, List<IFunction> tree) {
        if (tree != null) {
            int i = this.endIndexForEndBlock;
            while (i < tree.size()) {
                if (this.getFunctionName(tree.get(i).getCobolName()).startsWith(name)) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    @Override
    protected int searchIndexForAbsoluteLocation(IFunction f, List<IFunction> tree, List<IFunction> nonGeneratedFctsTree) {
        int ind = this.getIndexForFunction(f, nonGeneratedFctsTree, "", this.getDefaultComparator());
        if (ind >= 0) {
            String function = this.getFunctionName(f.getCobolName());
            if (ind > 0 && function.equals(this.getFunctionName(nonGeneratedFctsTree.get(ind - 1).getCobolName()))) {
                return tree.indexOf(nonGeneratedFctsTree.get(--ind)) + 1;
            }
            return tree.indexOf(nonGeneratedFctsTree.get(ind));
        }
        if (ind == -1) {
            ind = this.endIndexForEndBlock + 1 + this.getIndexForFunctionToUpdate(f, tree.subList(this.endIndexForEndBlock + 1, tree.size()), null);
        }
        return ind;
    }

    @Override
    protected boolean isEndForPattern(IFunction fct) {
        if (this.getFunctionName(fct.getCobolName()).startsWith("F81")) {
            return true;
        }
        return super.isEndForPattern(fct);
    }

    protected boolean isEndForServerFunctions(IFunction fct) {
        return this.getFunctionName(fct.getCobolName()).startsWith("F80") || fct.getCobolName().startsWith("F81CA") || fct.getCobolName().startsWith("F81ER") || fct.getCobolName().startsWith("F81HC") || fct.getCobolName().startsWith("F81RE");
    }

    private int searchIndexForLvLocation(IFunction f, List<IFunction> tree, String functionName) {
        FunctionWithLv lvFct = this.lvFunctions.get(functionName);
        if (lvFct.getLocation().trim().length() == 0) {
            return -1;
        }
        int ind = this.getIndexForFunctionToUpdate(null, tree, "F" + lvFct.getLogicalView());
        if (ind > 0) {
            if ("A".equals(lvFct.getLocation())) {
                return ind - 1;
            }
            if ("P".equals(lvFct.getLocation())) {
                String ref = String.valueOf(lvFct.getLogicalView()) + " " + lvFct.getLocation().trim();
                int i = ind;
                i = ind;
                while (i < tree.size()) {
                    String currentRef;
                    FunctionWithLv currentFct;
                    IFunction fct = tree.get(i);
                    if (!fct.getCobolName().startsWith("F" + lvFct.getLogicalView()) && ((currentFct = this.lvFunctions.get(this.getFunctionName(fct.getCobolName()))) == null || !currentFct.getLogicalView().equals(lvFct.getLogicalView()) || ((currentRef = fct.getReference()) == null || ref.equals(currentRef.trim()) || functionName.equals(this.getFunctionName(fct.getCobolName()))) && EBCDICCompare.stringCompare((String)f.getCobolName(), (String)fct.getCobolName()) < 0) || "FSERVER-END".equals(fct.getCobolName()) || "FEND-PGM".equals(fct.getCobolName())) break;
                    ++i;
                }
                ind = i;
            }
        }
        return ind;
    }

    @Override
    protected void updateNbOfDependents(List<IFunction> tree, String functionName) {
        if (!this.isFunctionForRelativeLocation(functionName, tree)) {
            super.updateNbOfDependents(tree, functionName);
        } else if (functionName.startsWith("F80")) {
            super.updateNbOfDependents(tree, functionName);
        } else {
            int i = 0;
            while (i < tree.size()) {
                IFunction fct = tree.get(i);
                int nbDpts = 0;
                if (this.isEndForServerFunctions(fct)) break;
                int j = i + 1;
                while (j < tree.size()) {
                    IFunction fctNext = tree.get(j);
                    if (this.isEndForServerFunctions(fctNext) || !(fctNext.getLevel() > fct.getLevel()) || fct.getCobolName().equals("FEND-PGM") && (fctNext.getCobolName().contains("-") || fctNext.getReference().contains("-"))) break;
                    ++nbDpts;
                    ++j;
                }
                fct.setNbOfDependents(nbDpts);
                ++i;
            }
        }
    }

    private class FunctionWithLv {
        String logicalView;
        String location;

        public FunctionWithLv(String logicalView, String location) {
            this.logicalView = logicalView;
            this.location = location.trim();
        }

        public String getLogicalView() {
            return this.logicalView;
        }

        public String getLocation() {
            return this.location;
        }
    }
}

