/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.extension.organize;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class ServerFunctionUtilities {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static List<String> AllReservedWords = new ArrayList<String>();
    static List<String> ReservedWordsForDataAggregate;

    static {
        AllReservedWords.add("ALIM");
        AllReservedWords.add("BEGV");
        AllReservedWords.add("CALL");
        AllReservedWords.add("CATA");
        AllReservedWords.add("CATR");
        AllReservedWords.add("CATT");
        AllReservedWords.add("CATZ");
        AllReservedWords.add("CCNX");
        AllReservedWords.add("CHCK");
        AllReservedWords.add("CHKD");
        AllReservedWords.add("CHUP");
        AllReservedWords.add("CLOS");
        AllReservedWords.add("DCNX");
        AllReservedWords.add("DONE");
        AllReservedWords.add("ENDV");
        AllReservedWords.add("ERRS");
        AllReservedWords.add("ERRV");
        AllReservedWords.add("INIT");
        AllReservedWords.add("LOCK");
        AllReservedWords.add("OPEN");
        AllReservedWords.add("RETC");
        AllReservedWords.add("SELC");
        AllReservedWords.add("SLCT");
        AllReservedWords.add("SRVA");
        AllReservedWords.add("SRVE");
        AllReservedWords.add("SRVL");
        AllReservedWords.add("SRVM");
        AllReservedWords.add("SRVT");
        AllReservedWords.add("SRVX");
        AllReservedWords.add("TRAN");
        AllReservedWords.add("TRDT");
        AllReservedWords.add("TRER");
        AllReservedWords.add("TRVW");
        AllReservedWords.add("UNLK");
        AllReservedWords.add("UPDT");
        AllReservedWords.add("USER");
        ReservedWordsForDataAggregate = new ArrayList<String>();
        ReservedWordsForDataAggregate.add("CHCK");
        ReservedWordsForDataAggregate.add("UPDT");
        ReservedWordsForDataAggregate.add("SLCT");
        ReservedWordsForDataAggregate.add("USRS");
    }

    public static String FromEtiquetteToFunctionName(String etiquettes, String logicalView) {
        StringTokenizer st = new StringTokenizer(etiquettes);
        String word = st.nextToken();
        if (logicalView != null && word.equals(logicalView)) {
            return logicalView;
        }
        StringBuilder result = new StringBuilder();
        String dataAggregate = null;
        etiquettes = new String();
        boolean isLogicalView = true;
        isLogicalView = !ReservedWordsForDataAggregate.contains(word);
        boolean isUSER = "USER".equals(word);
        etiquettes = String.valueOf(etiquettes) + word;
        etiquettes = String.valueOf(etiquettes) + "-";
        if (!isUSER) {
            while (st.hasMoreTokens()) {
                word = st.nextToken();
                if (!AllReservedWords.contains(word) && !isLogicalView) {
                    dataAggregate = word;
                    continue;
                }
                etiquettes = String.valueOf(etiquettes) + word;
                etiquettes = String.valueOf(etiquettes) + "-";
            }
        }
        if (etiquettes.endsWith("-")) {
            etiquettes = etiquettes.substring(0, etiquettes.length() - 1);
        }
        if (!isLogicalView && dataAggregate != null) {
            result.append(dataAggregate);
        } else {
            result.append(logicalView);
        }
        result.append("-").append(etiquettes);
        return result.toString();
    }
}

