/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.extension.organize;

import com.ibm.pdp.framework.interfaces.IController;
import com.ibm.pdp.framework.interfaces.IEditor;
import com.ibm.pdp.pacbase.extension.organize.Messages;
import com.ibm.pdp.util.Util;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeMap;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IMarkerResolution;

public class PacRightMarginQuickFix
implements IMarkerResolution {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2021.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final int _REMOVE_EMPTY_LINES = 0;
    private int _kind;
    private IController _controller;
    private String _label;

    public PacRightMarginQuickFix(int kind, IController controller) {
        this._kind = kind;
        this._controller = controller;
        this._label = this._kind == 0 ? Messages.REMOVE_EMPTY_LINES : "Unknown fix";
    }

    public String getLabel() {
        return this._label;
    }

    public void run(IMarker marker) {
        try {
            IResource resource = marker.getResource();
            IMarker[] markers = resource.findMarkers("com.ibm.pdp.pacbase.extension.organize.right_margin_problem_marker", false, 0);
            HashSet<Integer> markerLines = new HashSet<Integer>();
            IMarker[] iMarkerArray = markers;
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker mark = iMarkerArray[n2];
                markerLines.add((Integer)mark.getAttribute("lineNumber"));
                ++n2;
            }
            Iterator iterator = this._controller.getEditorLink().editors();
            if (iterator.hasNext()) {
                IEditor editor = (IEditor)iterator.next();
                String text = editor.getDocument().get();
                TreeMap<Integer, Integer[]> markerIndexes = new TreeMap<Integer, Integer[]>();
                int lineEnd = 0;
                int lineStart = 0;
                int line = 0;
                int idx = 0;
                while (idx < text.length()) {
                    if (text.charAt(idx) == '\n') {
                        lineEnd = idx;
                        if (markerLines.contains(++line)) {
                            Integer[] indexes = new Integer[]{lineStart, lineEnd};
                            markerIndexes.put(line, indexes);
                        }
                        lineStart = lineEnd;
                    }
                    ++idx;
                }
                for (Integer markerLine : markerIndexes.descendingKeySet()) {
                    Integer[] indexes = (Integer[])markerIndexes.get(markerLine);
                    this.fixLine(editor, text, indexes[0], indexes[1]);
                }
            }
        }
        catch (CoreException e) {
            Util.rethrow((Throwable)e);
        }
    }

    private void fixLine(IEditor editor, String text, int lineStart, int lineEnd) {
        String toRemove = "";
        int index = -1;
        String line = text.substring(lineStart, lineStart + 73).trim();
        if (line.length() == 0 && this._kind == 0) {
            toRemove = text.substring(lineStart, lineEnd);
            index = lineStart;
        }
        if (index != -1) {
            try {
                editor.replace(index, toRemove.length(), "");
            }
            catch (Exception e) {
                Util.rethrow((Throwable)e);
            }
        }
    }
}

