/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.extension.organize;

import com.ibm.pdp.engine.ITextSegment;
import com.ibm.pdp.engine.tree.IEditTree;
import com.ibm.pdp.engine.tree.ITextNode;
import com.ibm.pdp.framework.Controller;
import com.ibm.pdp.framework.EditorLink;
import com.ibm.pdp.framework.PdpTool;
import com.ibm.pdp.framework.interfaces.IController;
import com.ibm.pdp.framework.interfaces.IMarkerUpdateExtension;
import com.ibm.pdp.framework.interfaces.IPattern;
import com.ibm.pdp.pacbase.PacTool;
import com.ibm.pdp.pacbase.extension.matching.BasicPacLabelRecognizer;
import com.ibm.pdp.pacbase.extension.matching.CobolLabel;
import com.ibm.pdp.pacbase.extension.matching.PacLabel;
import com.ibm.pdp.pacbase.extension.organize.Messages;
import com.ibm.pdp.pacbase.extension.organize.UserCodeProblem;
import com.ibm.pdp.pacbase.generator.AbstractPacbasePattern;
import com.ibm.pdp.util.Util;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class PacRightMarginMarkerUpdateExtension
implements IMarkerUpdateExtension {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2015, 2022.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String RIGHT_MARGIN_PROBLEM_MARKER = "com.ibm.pdp.pacbase.extension.organize.right_margin_problem_marker";
    public static final String LEVEL_PROPERTY = "LEVEL";
    public static final String LEVEL_PROPERTY_WARNING = "LEVEL_WARNING";
    public static final String COA_VALUE = "COA";
    private static final String coa_VALUE = "coa";
    private static final String DOT_VALUE = "dot";
    private static final String LV_VALUE = "lv";
    private static final String PROCEDURE_NAME = "PROCEDURE";
    private static final String[] reservedEndLabelForDoDu = new String[]{"-A", "-B"};

    public void updateMarkers(IController controler, IFile resourceFile) {
        IDocument document = ((EditorLink)controler.getEditorLink()).getDocument();
        if (document == null) {
            return;
        }
        if (controler == null || controler instanceof Controller && ((Controller)controler).getMigrationWarnings() != null) {
            return;
        }
        if (!PacTool.isStruturedCobol(controler)) {
            return;
        }
        this.updateMarkersOnly(controler, document, resourceFile);
    }

    public void updateMarkersOnly(IController controler, IDocument document, IFile resourceFile) {
        if (controler == null || controler instanceof Controller && ((Controller)controler).getMigrationWarnings() != null) {
            return;
        }
        ArrayList<UserCodeProblem> rightMarginProblems = this.sourceChecking(controler);
        if (rightMarginProblems == null) {
            return;
        }
        try {
            IMarker[] existingMarkers = resourceFile.findMarkers(RIGHT_MARGIN_PROBLEM_MARKER, false, 2);
            if (existingMarkers.length > 0) {
                resourceFile.deleteMarkers(RIGHT_MARGIN_PROBLEM_MARKER, false, 2);
            }
        }
        catch (CoreException ce) {
            Util.rethrow((Throwable)ce);
        }
        int i = 0;
        while (i < rightMarginProblems.size()) {
            this.createMarker(resourceFile, document, rightMarginProblems.get(i));
            ++i;
        }
    }

    private ArrayList<UserCodeProblem> sourceChecking(IController controler) {
        IEditTree editTree = controler.getTextProcessor().getEditTree();
        editTree.rootNodes();
        ITextNode node = editTree.nodeFromTagName(PROCEDURE_NAME);
        if (node == null) {
            return null;
        }
        int beginIndex = node.beginIndex();
        int endIndex = node.endIndex();
        ArrayList<UserCodeProblem> rightMarginProblems = new ArrayList<UserCodeProblem>();
        Iterator segments = controler.getTextProcessor().segments(beginIndex, endIndex);
        while (segments.hasNext()) {
            ITextSegment ts = (ITextSegment)segments.next();
            if (ts.isGenerated() || !ts.isInserted() && !ts.isModified()) continue;
            this.scanText(ts.toString(), ts.beginIndex(), rightMarginProblems, editTree);
        }
        return rightMarginProblems;
    }

    private void createMarker(IFile file, IDocument document, UserCodeProblem problem) {
        int severity = problem.isWarning() ? 1 : 2;
        try {
            IMarker marker = file.createMarker(RIGHT_MARGIN_PROBLEM_MARKER);
            marker.setAttribute("severity", severity);
            marker.setAttribute("message", (Object)problem.message());
            marker.setAttribute("charStart", problem.beginIndex());
            marker.setAttribute("charEnd", problem.endIndex());
            if (document != null) {
                marker.setAttribute("lineNumber", document.getLineOfOffset(problem.beginIndex()) + 1);
            }
            if (problem.getType() != null) {
                if (problem.getType().equals(LEVEL_PROPERTY)) {
                    marker.setAttribute(LEVEL_PROPERTY, (Object)problem.getLabel());
                } else if (problem.getType().equals(COA_VALUE)) {
                    marker.setAttribute(COA_VALUE, (Object)problem.getLabel());
                }
            }
            String junit = System.getProperty("junitInvariantTest");
            String globalAnalysis = System.getProperty("globalAnalyzisCobols");
            if (junit != null || globalAnalysis != null) {
                marker.setAttribute("RIGHT_MARGIN_PROBLEM", (Object)problem.getLabel());
            }
        }
        catch (CoreException ce) {
            Util.rethrow((Throwable)ce);
        }
        catch (BadLocationException blex) {
            Util.rethrow((Throwable)blex);
        }
    }

    private void scanText(String text, int index, ArrayList<UserCodeProblem> rightMarginProblems, IEditTree editTree) {
        String newLine = PdpTool.determineDelimiterOfV2((CharSequence)text);
        String[] lines = PdpTool.splitTextIntoArrayLines((String)text);
        String currentLabel = "";
        int i = 0;
        while (i < lines.length) {
            UserCodeProblem ucp;
            PacLabel pacLabel;
            String line = lines[i];
            String margin = "";
            if (line.length() > 71) {
                margin = PacRightMarginMarkerUpdateExtension.trimRight(line.substring(72));
            }
            if ((pacLabel = BasicPacLabelRecognizer.findPacbaseLabelInLine(line)) != null) {
                if (pacLabel.isBeginningLabel()) {
                    String message = this.levelChecking(pacLabel, margin);
                    if (message.length() > 0) {
                        String lv;
                        ucp = new UserCodeProblem(index, index, message, true);
                        ucp.setLabel(pacLabel.getPacLabel());
                        ucp.setType(LEVEL_PROPERTY);
                        if (margin.length() > 0 && ("00".equals(lv = margin.substring(2)) || "99".equals(lv))) {
                            ucp.setType(LEVEL_PROPERTY_WARNING);
                            ucp.setLabel(line);
                        }
                        rightMarginProblems.add(ucp);
                    }
                    currentLabel = pacLabel.getPacLabel();
                } else if (margin.length() > 0 && !COA_VALUE.equals(margin.toUpperCase().trim())) {
                    rightMarginProblems.add(new UserCodeProblem(index, index, Messages.WRONG_VALUE_IN_MARGIN, true));
                }
            } else {
                CobolLabel label = BasicPacLabelRecognizer.findLabelInLine(line);
                if (label != null && line.substring(7, 11).trim().length() > 0) {
                    boolean isFound = false;
                    String[] stringArray = reservedEndLabelForDoDu;
                    int n = reservedEndLabelForDoDu.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String reservedLabel = stringArray[n2];
                        if (label.getPacLabel().endsWith(reservedLabel)) {
                            String cond;
                            ITextNode tn;
                            if (currentLabel.length() == 0) {
                                currentLabel = label.getPacLabel().substring(0, label.getPacLabel().indexOf("-"));
                            }
                            if ((tn = this.searchParentNode(editTree.includingNode(index, index), currentLabel)) != null && ("DO".equals(cond = PacTool.getFunctionCondition(tn.getLabel().toString(), tn, true)) || "DU".equals(cond))) {
                                isFound = true;
                                break;
                            }
                        }
                        ++n2;
                    }
                    if (label.getPacLabel().endsWith("-900")) {
                        isFound = true;
                    }
                    if (!(isFound || COA_VALUE.equals(margin) || coa_VALUE.equals(margin))) {
                        UserCodeProblem ucp2 = new UserCodeProblem(index, index, Messages.MANDATORY_COA, true);
                        ucp2.setLabel(label.getPacLabel());
                        ucp2.setType(COA_VALUE);
                        rightMarginProblems.add(ucp2);
                    }
                } else if (margin.length() > 0 && !DOT_VALUE.equals(margin)) {
                    ucp = new UserCodeProblem(index, index, Messages.WRONG_VALUE_IN_MARGIN, true);
                    if (line.substring(7, 72).trim().length() != 0) {
                        ucp.setLabel(line);
                    } else {
                        ucp.setLabel("Empty line in COBOL with right margin ???");
                    }
                    rightMarginProblems.add(ucp);
                }
            }
            index = index + line.length() + newLine.length();
            ++i;
        }
    }

    private ITextNode searchParentNode(ITextNode tn, String label) {
        if (tn.getLabel().toString().startsWith(PROCEDURE_NAME)) {
            return null;
        }
        if (!label.equals(tn.getLabel())) {
            tn = this.searchParentNode(tn.parentNode(), label);
        }
        return tn;
    }

    private static String trimRight(String name) {
        int end = name.length() - 1;
        char[] value = name.toCharArray();
        while (end >= 0 && value[end] <= ' ') {
            --end;
        }
        return new String(value, 0, end + 1);
    }

    private String levelChecking(PacLabel pacLabel, String margin) {
        String label = pacLabel.getPacLabel();
        String message = "";
        if (margin.length() == 0) {
            message = Messages.MANDATORY_LEVEL;
        } else {
            if (COA_VALUE.equals(margin.trim().toUpperCase())) {
                return message;
            }
            int ind = margin.indexOf(LV_VALUE);
            if (ind < 0) {
                message = Messages.MANDATORY_LEVEL;
            } else if (ind > 0) {
                message = Messages.WRONG_LEVEL;
            } else if (margin.length() != 4) {
                message = Messages.WRONG_LEVEL;
            } else {
                String lv = margin.substring(2);
                int lev = 0;
                try {
                    lev = Integer.parseInt(lv);
                    if (label.length() > 3 && lev < 6 || label.length() == 3 && lev > 5) {
                        message = Messages.WRONG_LEVEL;
                    }
                    if (lev == 99) {
                        message = Messages.WRONG_LEVEL;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    message = Messages.WRONG_LEVEL;
                }
            }
        }
        return message;
    }

    public boolean canUpdateMarkers(IPattern pattern, IFile resourceFile) {
        boolean result = pattern instanceof AbstractPacbasePattern;
        if (!result) {
            try {
                IMarker[] existingMarkers = resourceFile.findMarkers(RIGHT_MARGIN_PROBLEM_MARKER, false, 2);
                if (existingMarkers.length > 0) {
                    resourceFile.deleteMarkers(RIGHT_MARGIN_PROBLEM_MARKER, false, 2);
                }
            }
            catch (CoreException ce) {
                Util.rethrow((Throwable)ce);
            }
        }
        return result;
    }
}

