/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.extension.organize;

import com.ibm.pdp.engine.tree.IEditTree;
import com.ibm.pdp.engine.tree.ITextNode;
import com.ibm.pdp.engine.util.tree.EditTreeFilter;
import com.ibm.pdp.engine.util.tree.ITextNodeFilter;
import com.ibm.pdp.framework.views.CompoundTextNodeFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MicroPatternExtraction {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2016.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Map<String, List<String>> allMPsInSubFunction = new HashMap<String, List<String>>();

    public Map<String, List<String>> getAllMPs(IEditTree editTree) {
        EditTreeFilter etf = new EditTreeFilter();
        etf.setNodeFilter((ITextNodeFilter)new CompoundTextNodeFilter(new ITextNodeFilter[]{new ShowMPsFilter()}));
        ITextNode tn = etf.nodeFromTagName(editTree, "PROCEDURE");
        this.navigate(tn, etf);
        return this.allMPsInSubFunction;
    }

    private void navigate(ITextNode textNode, EditTreeFilter editTreeFilter) {
        if (editTreeFilter == null || textNode == null) {
            return;
        }
        Iterator it = editTreeFilter.sons(textNode);
        while (it.hasNext()) {
            ITextNode current = (ITextNode)it.next();
            this.populate(current);
            this.navigate(current, editTreeFilter);
        }
    }

    private void populate(ITextNode textNode) {
        List<Object> l;
        String label = textNode.parentNode().getLabel().toString();
        String current = textNode.getLabel().toString();
        if (current.startsWith(label)) {
            return;
        }
        if (!this.allMPsInSubFunction.containsKey(label)) {
            l = new ArrayList();
            this.allMPsInSubFunction.put(label, l);
        }
        l = this.allMPsInSubFunction.get(label);
        l.add(current);
    }

    class ShowMPsFilter
    implements ITextNodeFilter {
        ShowMPsFilter() {
        }

        public boolean skipNode(ITextNode node) {
            if ("PROCEDURE".equals(node.getLabel())) {
                return false;
            }
            return node.getProperties().getProperty("mp") == null;
        }

        public boolean skipSubNodes(ITextNode node) {
            return false;
        }
    }
}

